package aws

import (
	"context"
	"encoding/json"
	"fmt"

	"code.justin.tv/amzn/StarfruitVault/key"

	"github.com/aws/aws-sdk-go/service/secretsmanager/secretsmanageriface"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/secretsmanager"
)

type client struct {
	secretsmanageriface.SecretsManagerAPI
}

func (c *client) Fetch(ctx context.Context, secretID string, keys *key.KeySet) error {
	input := &secretsmanager.GetSecretValueInput{
		SecretId:     aws.String(secretID),
		VersionId:    nil,
		VersionStage: aws.String(awsCurrent),
	}

	resp, err := c.GetSecretValueWithContext(ctx, input)
	if err != nil {
		return err
	}
	if resp == nil {
		return fmt.Errorf("failed to fetch keys: %w", err)
	}

	if resp.SecretString == nil {
		return fmt.Errorf("failed to fetch keys: %w", err)
	}

	err = json.Unmarshal([]byte(*resp.SecretString), keys)
	if err != nil {
		return fmt.Errorf("unable to unmarshal secret: %w", err)
	}
	return nil
}

func (c *client) Put(ctx context.Context, secretID string, keys *key.KeySet) error {
	blob, err := json.MarshalIndent(keys, "", "\t")
	if err != nil {
		return fmt.Errorf("unable to marshal secret: %w", err)
	}
	input := &secretsmanager.PutSecretValueInput{
		SecretString:  aws.String(string(blob)),
		SecretId:      aws.String(secretID),
		VersionStages: []*string{aws.String(awsCurrent)},
	}

	_, err = c.PutSecretValueWithContext(ctx, input)
	if err != nil {
		return fmt.Errorf("failed to put keys: %w", err)
	}
	return nil
}
