package aws_test

import (
	"context"
	"testing"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/secretsmanager"
	"github.com/golang/mock/gomock"
	"github.com/stretchr/testify/assert"

	"code.justin.tv/amzn/StarfruitVault/provider"
	awsProvider "code.justin.tv/amzn/StarfruitVault/provider/aws"
	"code.justin.tv/amzn/StarfruitVault/provider/aws/mock"
)

func TestFetch(t *testing.T) {
	ctrl := gomock.NewController(t)
	// Assert that Bar() is invoked.
	defer ctrl.Finish()

	m := mock.NewMockSecretsManagerAPI(ctrl)
	m.EXPECT().GetSecretValueWithContext(gomock.Any(), gomock.Eq(&secretsmanager.GetSecretValueInput{
		SecretId:     aws.String("consumer"),
		VersionStage: aws.String("AWSCURRENT"),
	})).Return(&secretsmanager.GetSecretValueOutput{
		SecretString: aws.String("{}"),
	}, nil)

	m.EXPECT().GetSecretValueWithContext(gomock.Any(), gomock.Eq(&secretsmanager.GetSecretValueInput{
		SecretId:     aws.String("producer"),
		VersionStage: aws.String("AWSCURRENT"),
	})).Return(&secretsmanager.GetSecretValueOutput{
		SecretString: aws.String("{}"),
	}, nil)

	hooks := provider.NewHooks()
	provider, err := awsProvider.NewAWSProvider(&awsProvider.Config{
		Session:        session.Must(session.NewSession()),
		SecretIDs:      map[string]string{"a": "consumer", "b": "producer"},
		SecretsManager: m,
		Hooks:          hooks,
	})
	assert.NoError(t, err)

	err = provider.Fetch(context.Background())
	assert.NoError(t, err)
}
