package provider

import (
	"context"
)

type Provider interface {
	// Fetch the keys manually, typically to gate startup.
	Fetch(ctx context.Context) (err error)

	// Automatically fetch the keys at a regular interval
	Run(ctx context.Context) (err error)
}
