// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitVaultToken/token.proto

package token

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Version indicates what schema of encryption is used.
type Token_Version int32

const (
	Token_V1 Token_Version = 0
	Token_V2 Token_Version = 1
)

var Token_Version_name = map[int32]string{
	0: "V1",
	1: "V2",
}

var Token_Version_value = map[string]int32{
	"V1": 0,
	"V2": 1,
}

func (x Token_Version) String() string {
	return proto.EnumName(Token_Version_name, int32(x))
}

func (Token_Version) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6005f8bb0af7f0ff, []int{0, 0}
}

// Token is a protobuf encoded message holding an signed/encrypted payload generated by the video system. It's
// main use is to be passable through untrusted parties. This version is compatible with the old weaver payload.
type Token struct {
	Version Token_Version `protobuf:"varint,4,opt,name=version,proto3,enum=code.justin.tv.amzn.StarfruitVaultToken.Token_Version" json:"version,omitempty"`
	// encrypted payload using the consumer key identified by KeyID
	CipherText []byte `protobuf:"bytes,1,opt,name=cipher_text,json=cipherText,proto3" json:"cipher_text,omitempty"`
	// previously used to contain the signature portion of the ciphertext.
	//
	// In V1: This field will be concatenated with the cipher_text for shared key encryption schemes
	// In V2: This field will be used for public key verification of the cipher_text
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	// Nonce/Initialization vector used.
	Nonce []byte `protobuf:"bytes,3,opt,name=nonce,proto3" json:"nonce,omitempty"`
	// SecretAlias is the unique identifier for a set of keys: For example this could be the origin
	SecretAlias string `protobuf:"bytes,5,opt,name=secret_alias,json=secretAlias,proto3" json:"secret_alias,omitempty"`
	// KeyEpoch is used to identify the exact version
	KeyEpoch uint32 `protobuf:"varint,6,opt,name=key_epoch,json=keyEpoch,proto3" json:"key_epoch,omitempty"`
}

func (m *Token) Reset()         { *m = Token{} }
func (m *Token) String() string { return proto.CompactTextString(m) }
func (*Token) ProtoMessage()    {}
func (*Token) Descriptor() ([]byte, []int) {
	return fileDescriptor_6005f8bb0af7f0ff, []int{0}
}
func (m *Token) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Token) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Token.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Token) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Token.Merge(m, src)
}
func (m *Token) XXX_Size() int {
	return m.Size()
}
func (m *Token) XXX_DiscardUnknown() {
	xxx_messageInfo_Token.DiscardUnknown(m)
}

var xxx_messageInfo_Token proto.InternalMessageInfo

func (m *Token) GetVersion() Token_Version {
	if m != nil {
		return m.Version
	}
	return Token_V1
}

func (m *Token) GetCipherText() []byte {
	if m != nil {
		return m.CipherText
	}
	return nil
}

func (m *Token) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *Token) GetNonce() []byte {
	if m != nil {
		return m.Nonce
	}
	return nil
}

func (m *Token) GetSecretAlias() string {
	if m != nil {
		return m.SecretAlias
	}
	return ""
}

func (m *Token) GetKeyEpoch() uint32 {
	if m != nil {
		return m.KeyEpoch
	}
	return 0
}

func init() {
	proto.RegisterEnum("code.justin.tv.amzn.StarfruitVaultToken.Token_Version", Token_Version_name, Token_Version_value)
	proto.RegisterType((*Token)(nil), "code.justin.tv.amzn.StarfruitVaultToken.Token")
}

func init() {
	proto.RegisterFile("code.justin.tv/amzn/StarfruitVaultToken/token.proto", fileDescriptor_6005f8bb0af7f0ff)
}

var fileDescriptor_6005f8bb0af7f0ff = []byte{
	// 295 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x90, 0x31, 0x4f, 0x02, 0x31,
	0x14, 0xc7, 0xaf, 0xe8, 0x81, 0x14, 0x34, 0xa4, 0x71, 0xa8, 0xd1, 0x94, 0x93, 0xc5, 0x9b, 0x4a,
	0x84, 0xc4, 0x5d, 0x13, 0x77, 0x73, 0x12, 0x06, 0x17, 0x52, 0xcf, 0xa7, 0x54, 0xb0, 0x25, 0xbd,
	0x77, 0x04, 0xfc, 0x06, 0x6e, 0x7e, 0x2c, 0x47, 0x46, 0x47, 0x03, 0x5f, 0xc4, 0x5c, 0x4f, 0x63,
	0x4c, 0x1c, 0x5c, 0x5e, 0xfb, 0x7e, 0x2f, 0xbf, 0x97, 0x97, 0x3f, 0xed, 0xa7, 0xf6, 0x0e, 0xe4,
	0x63, 0x9e, 0xa1, 0x36, 0x12, 0xe7, 0x5d, 0xf5, 0xf4, 0x6c, 0xba, 0xd7, 0xa8, 0xdc, 0xbd, 0xcb,
	0x35, 0x0e, 0x55, 0x3e, 0xc5, 0x81, 0x9d, 0x80, 0xe9, 0x62, 0x51, 0xe5, 0xcc, 0x59, 0xb4, 0xec,
	0xe4, 0xb7, 0x24, 0x0b, 0x49, 0xfe, 0x21, 0x75, 0x5e, 0x2a, 0x34, 0xf4, 0x3f, 0x76, 0x45, 0x6b,
	0x73, 0x70, 0x99, 0xb6, 0x86, 0x6f, 0x47, 0x24, 0xde, 0xeb, 0x9d, 0xc9, 0x7f, 0x2e, 0x91, 0x65,
	0x1d, 0x96, 0x76, 0xf2, 0xbd, 0x86, 0xb5, 0x69, 0x23, 0xd5, 0xb3, 0x31, 0xb8, 0x11, 0xc2, 0x02,
	0x39, 0x89, 0x48, 0xdc, 0x4c, 0x68, 0x89, 0x06, 0xb0, 0x40, 0x76, 0x44, 0xeb, 0x99, 0x7e, 0x30,
	0x0a, 0x73, 0x07, 0xbc, 0xe2, 0xc7, 0x3f, 0x80, 0xed, 0xd3, 0xd0, 0x58, 0x93, 0x02, 0xdf, 0xf2,
	0x93, 0xb2, 0x61, 0xc7, 0xb4, 0x99, 0x41, 0xea, 0x00, 0x47, 0x6a, 0xaa, 0x55, 0xc6, 0xc3, 0x88,
	0xc4, 0xf5, 0xa4, 0x51, 0xb2, 0xf3, 0x02, 0xb1, 0x43, 0x5a, 0x9f, 0xc0, 0x72, 0x04, 0x33, 0x9b,
	0x8e, 0x79, 0x35, 0x22, 0xf1, 0x6e, 0xb2, 0x33, 0x81, 0xe5, 0x65, 0xd1, 0x77, 0x0e, 0x68, 0xed,
	0xeb, 0x50, 0x56, 0xa5, 0x95, 0xe1, 0x69, 0x2b, 0xf0, 0x6f, 0xaf, 0x45, 0x2e, 0xda, 0x6f, 0x6b,
	0x41, 0x56, 0x6b, 0x41, 0x3e, 0xd6, 0x82, 0xbc, 0x6e, 0x44, 0xb0, 0xda, 0x88, 0xe0, 0x7d, 0x23,
	0x82, 0x9b, 0xd0, 0x67, 0x7b, 0x5b, 0xf5, 0xe1, 0xf6, 0x3f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x32,
	0xd2, 0x49, 0xe7, 0x93, 0x01, 0x00, 0x00,
}

func (m *Token) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Token) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Token) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.KeyEpoch != 0 {
		i = encodeVarintToken(dAtA, i, uint64(m.KeyEpoch))
		i--
		dAtA[i] = 0x30
	}
	if len(m.SecretAlias) > 0 {
		i -= len(m.SecretAlias)
		copy(dAtA[i:], m.SecretAlias)
		i = encodeVarintToken(dAtA, i, uint64(len(m.SecretAlias)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Version != 0 {
		i = encodeVarintToken(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Nonce) > 0 {
		i -= len(m.Nonce)
		copy(dAtA[i:], m.Nonce)
		i = encodeVarintToken(dAtA, i, uint64(len(m.Nonce)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Signature) > 0 {
		i -= len(m.Signature)
		copy(dAtA[i:], m.Signature)
		i = encodeVarintToken(dAtA, i, uint64(len(m.Signature)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.CipherText) > 0 {
		i -= len(m.CipherText)
		copy(dAtA[i:], m.CipherText)
		i = encodeVarintToken(dAtA, i, uint64(len(m.CipherText)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintToken(dAtA []byte, offset int, v uint64) int {
	offset -= sovToken(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Token) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CipherText)
	if l > 0 {
		n += 1 + l + sovToken(uint64(l))
	}
	l = len(m.Signature)
	if l > 0 {
		n += 1 + l + sovToken(uint64(l))
	}
	l = len(m.Nonce)
	if l > 0 {
		n += 1 + l + sovToken(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovToken(uint64(m.Version))
	}
	l = len(m.SecretAlias)
	if l > 0 {
		n += 1 + l + sovToken(uint64(l))
	}
	if m.KeyEpoch != 0 {
		n += 1 + sovToken(uint64(m.KeyEpoch))
	}
	return n
}

func sovToken(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozToken(x uint64) (n int) {
	return sovToken(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Token) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowToken
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Token: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Token: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CipherText", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowToken
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthToken
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthToken
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CipherText = append(m.CipherText[:0], dAtA[iNdEx:postIndex]...)
			if m.CipherText == nil {
				m.CipherText = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signature", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowToken
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthToken
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthToken
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Signature = append(m.Signature[:0], dAtA[iNdEx:postIndex]...)
			if m.Signature == nil {
				m.Signature = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowToken
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthToken
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthToken
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nonce = append(m.Nonce[:0], dAtA[iNdEx:postIndex]...)
			if m.Nonce == nil {
				m.Nonce = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowToken
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= Token_Version(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretAlias", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowToken
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthToken
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthToken
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretAlias = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyEpoch", wireType)
			}
			m.KeyEpoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowToken
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyEpoch |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipToken(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthToken
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipToken(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowToken
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowToken
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowToken
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthToken
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupToken
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthToken
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthToken        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowToken          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupToken = fmt.Errorf("proto: unexpected end of group")
)
