# `TwirpGoLangAWSTransports`

This package represents the implementation details of transports that sit in front of Twirp services and is used by
Fulton to enable both API Gateway and SQS functionality.

Note: requests are processed by this package prior to being processed by the actual Twirp mux, so it's possible for
malformed requests to get evicted prior to reaching the intended service. For more information on calling other services,
please see the [Calling Fulton Services Doc](https://docs.fulton.twitch.a2z.com/docs/calling_services.html)

## Running a local development Lambda server

`code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda.ListenAndServe`
is a drop-in replacement for `http.ListenAndServe` that serves HTTP
requests from AWS Lambda function. By default, this uses
[lambda.start](https://github.com/aws/aws-lambda-go/blob/master/lambda/entry.go#L39)
which only works from a Lambda environment.

If the `FULTON_LOCAL_SERVER` environment variable is present,
`ListenAndServe` starts a regular HTTP server listening on port 3000
by default. You can use this to start a local development server on
your laptop to test your changes locally before deploying to a SAM
stack. If `FULTON_LOCAL_SERVER`'s value is >1024, the variable's value
will set the port on which the development server listens. The local
server is only listening on the loopback interface (i.e. localhost),
it is not accessible from outside of your machine.

## Referring to this package
To refer to this dependency, refer to its alias of `code.justin.tv/amzn/TwirpGoLangAWSTransports`

## Help
For help using this package, please ping the [#fulton](https://twitch.slack.com/messages/C9BUPDUC8) Slack channel
