package lambda

import "testing"
import "github.com/stretchr/testify/require"

func TestExtractPort(t *testing.T) {
	p := extractPort("")
	require.Equal(t, defaultLocalPort, p)

	p = extractPort("y")
	require.Equal(t, defaultLocalPort, p)

	p = extractPort("80")
	require.Equal(t, defaultLocalPort, p)

	p = extractPort("8081")
	require.Equal(t, 8081, p)

	p = extractPort("localhost:8081")
	require.Equal(t, 8081, p)

	p = extractPort("127.0.0.1:8081")
	require.Equal(t, 8081, p)

	p = extractPort(":8081")
	require.Equal(t, 8081, p)

	p = extractPort(":")
	require.Equal(t, defaultLocalPort, p)
}
