package lambda_test

import (
	"context"
	"testing"

	"code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	"github.com/aws/aws-lambda-go/events"
	"github.com/stretchr/testify/assert"
)

func TestContextPassed(t *testing.T) {
	e := events.APIGatewayProxyRequest{
		RequestContext: events.APIGatewayProxyRequestContext{
			RequestID: "test-request-id",
		},
	}
	req, err := lambda.NewGatewayRequest(context.Background(), e)
	assert.NoError(t, err, "should not error")
	rc, ok := lambda.RequestContext(req.Context())
	assert.True(t, ok, "should have request context")
	assert.Equal(t, e.RequestContext.RequestID, rc.RequestID, "request id should be passed")
}
