package servicelog

import (
	"context"
	"encoding/json"
	"fmt"

	"go.uber.org/zap"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
)

// LocalLogger prints EMF formatted json to stdout, for use during development
type LocalLogger struct {
	logCreator
}

// NewLocalLogger creates a LocalLogger
func NewLocalLogger(pid identifier.ProcessIdentifier) *LocalLogger {
	return &LocalLogger{
		logCreator: logCreator{
			pid: pid,
		},
	}
}

func (l *LocalLogger) SetStdoutLogger(z *zap.Logger) {}

// Run blocks until the context is cancelled, doing nothing
func (l *LocalLogger) Run(ctx context.Context) error {
	<-ctx.Done()

	return ctx.Err()
}

// Send prints the struct as json to stdout
func (l *LocalLogger) Send(entry MetricLogger) error {
	err := parseMetrics(entry)
	if err != nil {
		return err
	}

	b, err := json.Marshal(entry)
	if err != nil {
		return err
	}

	fmt.Println(string(b))

	return nil
}
