package servicelog

import (
	"context"
	"testing"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
)

type stub struct {
	*LogEntry
	A string
}

func TestDuplicateMetric(t *testing.T) {
	logger := NewLocalLogger(identifier.ProcessIdentifier{})
	s := &stub{
		LogEntry: logger.NewLogEntry(""),
	}

	err := s.Metric("Foo", "Count")
	if err != nil {
		t.Errorf("unexpected error: %v", err)
	}

	err = s.Metric("Foo", "Count")
	if err == nil {
		t.Error("duplicate metric should have errored, but did not")
	}
}

func TestContext(t *testing.T) {
	logger := NewLocalLogger(identifier.ProcessIdentifier{})
	s := &stub{
		LogEntry: logger.NewLogEntry(""),
		A:        "foo",
	}

	ctx := Context(context.Background(), s)

	innerContext(ctx, t)

	if s.A != "bar" {
		t.Errorf("unexpected field value. expected:bar, found:%v", s.A)
	}
}

func innerContext(ctx context.Context, t *testing.T) {
	fetched, ok := FromContext(ctx).(*stub)
	if !ok {
		t.Error("value fetched from context does not match expected type")
	}
	fetched.A = "bar"
}
