package servicelog

import (
	"testing"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
)

type taggedStruct struct {
	*LogEntry

	A int
	B int `servicelog:"Count"`
	C int `servicelog:"Milliseconds,omitempty"`
}

func TestTags(t *testing.T) {
	logger := NewLocalLogger(identifier.ProcessIdentifier{})
	s := &taggedStruct{
		LogEntry: logger.NewLogEntry(""),
		A:        1,
		B:        2,
		C:        0,
	}

	err := parseMetrics(s)
	if err != nil {
		t.Errorf("unexpected error: %v", err)
	}

	metricTests := []struct {
		name   string
		unit   string
		exists bool
	}{
		{"A", "", false},
		{"B", "Count", true},
		{"C", "Milliseconds", false},
	}

	for _, test := range metricTests {
		found, unit := hasMetric(s, test.name)
		if found != test.exists {
			t.Errorf("unexpected metric existence for field %v: expected:%v, found:%v", test.name, test.exists, found)
		}
		if found {
			if unit != test.unit {
				t.Errorf("unexpected metric unit for field %v: expected:%v, found:%v", test.name, test.unit, unit)
			}
		}
	}
}

func hasMetric(s *taggedStruct, name string) (bool, string) {
	for _, metric := range s.Aws.CloudWatchMetrics[0].Metrics {
		if metric.Name == name {
			return true, metric.Unit
		}
	}
	return false, ""
}
