// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchAARPTwirp/twirp.proto

/*
Package TwitchAARPTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	code.justin.tv/amzn/TwitchAARPTwirp/twirp.proto
*/
package TwitchAARPTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ====================
// TwitchAARP Interface
// ====================

// Supported Endpoints
type TwitchAARP interface {
	// Creates a new attribution under the provided client ID
	CreateAttribution(context.Context, *CreateAttributionRequest) (*CreateAttributionResponse, error)

	// Internal endpoint used to fetch a transaction
	GetAttribution(context.Context, *GetAttributionRequest) (*GetAttributionResponse, error)

	// Internal endpoint used to list transactions with optional filters
	ListAttributions(context.Context, *ListAttributionsRequest) (*ListAttributionsResponse, error)

	// CreateClient creates and stores a client for use with AARP. See Client.
	CreateClient(context.Context, *CreateClientRequest) (*CreateClientResponse, error)

	// UpdateClient will replace all fields on the Client struct with ones provided.
	// Every field is updated and booleans default to true. Be careful when
	// using update that you specifically pass in every field to Client.
	// Returns a twirp.NotFound if the record does not exist.
	UpdateClient(context.Context, *UpdateClientRequest) (*UpdateClientResponse, error)

	// GetClient returns the Client for a given clientID.
	// Returns a twirp.NotFound if the record does not exist.
	GetClient(context.Context, *GetClientRequest) (*GetClientResponse, error)

	// Used to determine if this client ID is on the whitelist. This call
	// should be cached up to 1 second, to be used to reduce load from
	// helix to our service.
	IsWhitelisted(context.Context, *IsWhitelistedRequest) (*IsWhitelistedResponse, error)

	// CreateCatalogItem creates a catalog item for the specified clientID.
	// Returns NotFound if the clientID doesn't exist as a valid Client.
	CreateCatalogItem(context.Context, *CreateCatalogItemRequest) (*CreateCatalogItemResponse, error)

	// UpdateCatalogItem updates an existing CatalogItem.
	// Returns NotFound if the clientID doesn't exist as a valid client or
	// if the SKU doesn't exist in the catalog.
	UpdateCatalogItem(context.Context, *UpdateCatalogItemRequest) (*UpdateCatalogItemResponse, error)
}

// ==========================
// TwitchAARP Protobuf Client
// ==========================

type twitchAARPProtobufClient struct {
	client HTTPClient
	urls   [9]string
}

// NewTwitchAARPProtobufClient creates a Protobuf client that implements the TwitchAARP interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchAARPProtobufClient(addr string, client HTTPClient) TwitchAARP {
	prefix := urlBase(addr) + TwitchAARPPathPrefix
	urls := [9]string{
		prefix + "CreateAttribution",
		prefix + "GetAttribution",
		prefix + "ListAttributions",
		prefix + "CreateClient",
		prefix + "UpdateClient",
		prefix + "GetClient",
		prefix + "IsWhitelisted",
		prefix + "CreateCatalogItem",
		prefix + "UpdateCatalogItem",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &twitchAARPProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &twitchAARPProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *twitchAARPProtobufClient) CreateAttribution(ctx context.Context, in *CreateAttributionRequest) (*CreateAttributionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAttribution")
	out := new(CreateAttributionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *twitchAARPProtobufClient) GetAttribution(ctx context.Context, in *GetAttributionRequest) (*GetAttributionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "GetAttribution")
	out := new(GetAttributionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *twitchAARPProtobufClient) ListAttributions(ctx context.Context, in *ListAttributionsRequest) (*ListAttributionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "ListAttributions")
	out := new(ListAttributionsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *twitchAARPProtobufClient) CreateClient(ctx context.Context, in *CreateClientRequest) (*CreateClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateClient")
	out := new(CreateClientResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *twitchAARPProtobufClient) UpdateClient(ctx context.Context, in *UpdateClientRequest) (*UpdateClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateClient")
	out := new(UpdateClientResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *twitchAARPProtobufClient) GetClient(ctx context.Context, in *GetClientRequest) (*GetClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "GetClient")
	out := new(GetClientResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *twitchAARPProtobufClient) IsWhitelisted(ctx context.Context, in *IsWhitelistedRequest) (*IsWhitelistedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "IsWhitelisted")
	out := new(IsWhitelistedResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *twitchAARPProtobufClient) CreateCatalogItem(ctx context.Context, in *CreateCatalogItemRequest) (*CreateCatalogItemResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCatalogItem")
	out := new(CreateCatalogItemResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *twitchAARPProtobufClient) UpdateCatalogItem(ctx context.Context, in *UpdateCatalogItemRequest) (*UpdateCatalogItemResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCatalogItem")
	out := new(UpdateCatalogItemResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

// ======================
// TwitchAARP JSON Client
// ======================

type twitchAARPJSONClient struct {
	client HTTPClient
	urls   [9]string
}

// NewTwitchAARPJSONClient creates a JSON client that implements the TwitchAARP interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchAARPJSONClient(addr string, client HTTPClient) TwitchAARP {
	prefix := urlBase(addr) + TwitchAARPPathPrefix
	urls := [9]string{
		prefix + "CreateAttribution",
		prefix + "GetAttribution",
		prefix + "ListAttributions",
		prefix + "CreateClient",
		prefix + "UpdateClient",
		prefix + "GetClient",
		prefix + "IsWhitelisted",
		prefix + "CreateCatalogItem",
		prefix + "UpdateCatalogItem",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &twitchAARPJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &twitchAARPJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *twitchAARPJSONClient) CreateAttribution(ctx context.Context, in *CreateAttributionRequest) (*CreateAttributionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAttribution")
	out := new(CreateAttributionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *twitchAARPJSONClient) GetAttribution(ctx context.Context, in *GetAttributionRequest) (*GetAttributionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "GetAttribution")
	out := new(GetAttributionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *twitchAARPJSONClient) ListAttributions(ctx context.Context, in *ListAttributionsRequest) (*ListAttributionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "ListAttributions")
	out := new(ListAttributionsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *twitchAARPJSONClient) CreateClient(ctx context.Context, in *CreateClientRequest) (*CreateClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateClient")
	out := new(CreateClientResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *twitchAARPJSONClient) UpdateClient(ctx context.Context, in *UpdateClientRequest) (*UpdateClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateClient")
	out := new(UpdateClientResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *twitchAARPJSONClient) GetClient(ctx context.Context, in *GetClientRequest) (*GetClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "GetClient")
	out := new(GetClientResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *twitchAARPJSONClient) IsWhitelisted(ctx context.Context, in *IsWhitelistedRequest) (*IsWhitelistedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "IsWhitelisted")
	out := new(IsWhitelistedResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *twitchAARPJSONClient) CreateCatalogItem(ctx context.Context, in *CreateCatalogItemRequest) (*CreateCatalogItemResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCatalogItem")
	out := new(CreateCatalogItemResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *twitchAARPJSONClient) UpdateCatalogItem(ctx context.Context, in *UpdateCatalogItemRequest) (*UpdateCatalogItemResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCatalogItem")
	out := new(UpdateCatalogItemResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

// =========================
// TwitchAARP Server Handler
// =========================

type twitchAARPServer struct {
	TwitchAARP
	hooks *twirp.ServerHooks
}

func NewTwitchAARPServer(svc TwitchAARP, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchAARPServer{
		TwitchAARP: svc,
		hooks:      hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchAARPServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchAARPPathPrefix is used for all URL paths on a twirp TwitchAARP server.
// Requests are always: POST TwitchAARPPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchAARPPathPrefix = "/twirp/twitch.aarp.TwitchAARP/"

func (s *twitchAARPServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.aarp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchAARP")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.aarp.TwitchAARP/CreateAttribution":
		s.serveCreateAttribution(ctx, resp, req)
		return
	case "/twirp/twitch.aarp.TwitchAARP/GetAttribution":
		s.serveGetAttribution(ctx, resp, req)
		return
	case "/twirp/twitch.aarp.TwitchAARP/ListAttributions":
		s.serveListAttributions(ctx, resp, req)
		return
	case "/twirp/twitch.aarp.TwitchAARP/CreateClient":
		s.serveCreateClient(ctx, resp, req)
		return
	case "/twirp/twitch.aarp.TwitchAARP/UpdateClient":
		s.serveUpdateClient(ctx, resp, req)
		return
	case "/twirp/twitch.aarp.TwitchAARP/GetClient":
		s.serveGetClient(ctx, resp, req)
		return
	case "/twirp/twitch.aarp.TwitchAARP/IsWhitelisted":
		s.serveIsWhitelisted(ctx, resp, req)
		return
	case "/twirp/twitch.aarp.TwitchAARP/CreateCatalogItem":
		s.serveCreateCatalogItem(ctx, resp, req)
		return
	case "/twirp/twitch.aarp.TwitchAARP/UpdateCatalogItem":
		s.serveUpdateCatalogItem(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchAARPServer) serveCreateAttribution(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateAttributionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateAttributionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchAARPServer) serveCreateAttributionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAttribution")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateAttributionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateAttributionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateAttribution(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAttributionResponse and nil error while calling CreateAttribution. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveCreateAttributionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAttribution")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateAttributionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateAttributionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateAttribution(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAttributionResponse and nil error while calling CreateAttribution. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveGetAttribution(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAttributionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAttributionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchAARPServer) serveGetAttributionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAttribution")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAttributionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAttributionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAttribution(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAttributionResponse and nil error while calling GetAttribution. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveGetAttributionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAttribution")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAttributionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAttributionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAttribution(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAttributionResponse and nil error while calling GetAttribution. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveListAttributions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListAttributionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListAttributionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchAARPServer) serveListAttributionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAttributions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListAttributionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListAttributionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListAttributions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAttributionsResponse and nil error while calling ListAttributions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveListAttributionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAttributions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListAttributionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListAttributionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListAttributions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAttributionsResponse and nil error while calling ListAttributions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveCreateClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateClientProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchAARPServer) serveCreateClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateClientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateClientResponse and nil error while calling CreateClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveCreateClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateClientRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateClientResponse and nil error while calling CreateClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveUpdateClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateClientProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchAARPServer) serveUpdateClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateClientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateClientResponse and nil error while calling UpdateClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveUpdateClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateClientRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateClientResponse and nil error while calling UpdateClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveGetClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetClientProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchAARPServer) serveGetClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetClientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetClientResponse and nil error while calling GetClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveGetClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetClientRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetClientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetClient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetClientResponse and nil error while calling GetClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveIsWhitelisted(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsWhitelistedJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsWhitelistedProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchAARPServer) serveIsWhitelistedJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsWhitelisted")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsWhitelistedRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *IsWhitelistedResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsWhitelisted(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsWhitelistedResponse and nil error while calling IsWhitelisted. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveIsWhitelistedProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsWhitelisted")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(IsWhitelistedRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *IsWhitelistedResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.IsWhitelisted(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsWhitelistedResponse and nil error while calling IsWhitelisted. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveCreateCatalogItem(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCatalogItemJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCatalogItemProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchAARPServer) serveCreateCatalogItemJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCatalogItem")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCatalogItemRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCatalogItemResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateCatalogItem(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCatalogItemResponse and nil error while calling CreateCatalogItem. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveCreateCatalogItemProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCatalogItem")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateCatalogItemRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCatalogItemResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateCatalogItem(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCatalogItemResponse and nil error while calling CreateCatalogItem. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveUpdateCatalogItem(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCatalogItemJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCatalogItemProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchAARPServer) serveUpdateCatalogItemJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCatalogItem")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCatalogItemRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCatalogItemResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateCatalogItem(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCatalogItemResponse and nil error while calling UpdateCatalogItem. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) serveUpdateCatalogItemProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCatalogItem")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateCatalogItemRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCatalogItemResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateCatalogItem(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCatalogItemResponse and nil error while calling UpdateCatalogItem. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchAARPServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchAARPServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 852 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xdd, 0x4e, 0xe3, 0x46,
	0x14, 0x96, 0x09, 0x84, 0xe4, 0x04, 0x2a, 0x18, 0x20, 0x75, 0xd3, 0x1f, 0xa5, 0x03, 0x54, 0x48,
	0x95, 0x12, 0x29, 0xbd, 0x68, 0x55, 0xb5, 0x12, 0x01, 0x2a, 0x14, 0x44, 0x2b, 0xe4, 0xa6, 0xb4,
	0xf4, 0xa6, 0x9a, 0x38, 0x43, 0x99, 0xe2, 0xd8, 0xc6, 0x33, 0x86, 0xd2, 0xfb, 0xee, 0x2b, 0xac,
	0xf6, 0x75, 0xf6, 0xc9, 0x56, 0x1e, 0x4f, 0x92, 0x19, 0xc7, 0x36, 0xac, 0xd8, 0x9b, 0x28, 0x73,
	0xe6, 0x3b, 0xdf, 0x39, 0x9f, 0xcf, 0x8f, 0x0d, 0x5d, 0x37, 0x18, 0xd3, 0xce, 0x3f, 0x31, 0x17,
	0xcc, 0xef, 0x88, 0xfb, 0x2e, 0x99, 0xfc, 0xe7, 0x77, 0x87, 0x0f, 0x4c, 0xb8, 0x37, 0xfd, 0xbe,
	0x73, 0x31, 0x7c, 0x60, 0x51, 0xd8, 0x15, 0xc9, 0x6f, 0x27, 0x8c, 0x02, 0x11, 0xa0, 0x86, 0x90,
	0x97, 0x1d, 0x42, 0xa2, 0x10, 0x7f, 0x0b, 0x2b, 0x3f, 0x07, 0x3e, 0x7d, 0x44, 0x2d, 0xa8, 0xdd,
	0xc5, 0xc4, 0x17, 0x4c, 0x3c, 0xda, 0x56, 0xdb, 0x3a, 0xa8, 0x38, 0xb3, 0x33, 0x42, 0xb0, 0x9c,
	0x04, 0xb1, 0x97, 0xda, 0xd6, 0x41, 0xdd, 0x91, 0xff, 0xf1, 0xff, 0x15, 0x68, 0xf4, 0x85, 0x88,
	0xd8, 0x28, 0x16, 0x2c, 0xf0, 0x13, 0x7f, 0xd7, 0x63, 0xd4, 0x17, 0x83, 0x13, 0xe9, 0x5f, 0x77,
	0x66, 0x67, 0xb4, 0x07, 0xeb, 0x22, 0x22, 0x3e, 0x27, 0x6e, 0x02, 0x1d, 0x9c, 0x28, 0x22, 0xd3,
	0x98, 0xa0, 0x46, 0x51, 0x40, 0xc6, 0x2e, 0xe1, 0x82, 0x46, 0x83, 0x13, 0xbb, 0x92, 0xa2, 0x0c,
	0x23, 0x6a, 0x42, 0x35, 0xe6, 0xf2, 0x7a, 0x59, 0x5e, 0xab, 0x13, 0xfa, 0x0e, 0xd6, 0xc3, 0x38,
	0x72, 0x6f, 0x08, 0xa7, 0x17, 0x11, 0x73, 0xa9, 0xbd, 0xd2, 0xb6, 0x0e, 0x1a, 0x3d, 0xd4, 0xd1,
	0xd4, 0x76, 0xa4, 0x54, 0xc7, 0x04, 0xa2, 0x43, 0xd8, 0x4c, 0x31, 0x9a, 0x1c, 0xbb, 0x56, 0xe8,
	0xbd, 0x08, 0x46, 0x67, 0xd0, 0xd4, 0x92, 0xd4, 0x69, 0xea, 0x85, 0x34, 0x05, 0x1e, 0x68, 0x03,
	0x2a, 0xfc, 0x36, 0xb6, 0xab, 0x52, 0x5c, 0xf2, 0x17, 0x7d, 0x06, 0x75, 0xc1, 0x26, 0x94, 0x0b,
	0x32, 0x09, 0xed, 0x55, 0x59, 0x9a, 0xb9, 0x01, 0xf7, 0x60, 0x7b, 0xc0, 0x7f, 0xbf, 0x61, 0x82,
	0x7a, 0x8c, 0x0b, 0x3a, 0x76, 0xe8, 0x5d, 0x4c, 0xb9, 0x28, 0xab, 0x07, 0xfe, 0x11, 0x76, 0x32,
	0x3e, 0x3c, 0x0c, 0x7c, 0x4e, 0x93, 0x12, 0x30, 0xfd, 0x42, 0x7a, 0xd6, 0x1c, 0xd3, 0x88, 0x2f,
	0xc1, 0x3e, 0x8e, 0x28, 0x11, 0x54, 0xcb, 0x7b, 0x1a, 0xf6, 0x7b, 0x68, 0x10, 0x4d, 0xbf, 0x25,
	0xf5, 0xdb, 0x86, 0x7e, 0xdd, 0x4b, 0x07, 0xe3, 0x3e, 0x7c, 0x92, 0xc3, 0x3b, 0x4f, 0xcd, 0xec,
	0x21, 0x2b, 0xa7, 0x87, 0xf0, 0x15, 0xec, 0x9c, 0x52, 0x91, 0x93, 0xd7, 0x8b, 0xdb, 0x13, 0x0f,
	0xa1, 0x99, 0xa5, 0x56, 0xa9, 0xbd, 0x44, 0xf3, 0x6b, 0x0b, 0x3e, 0x3e, 0x67, 0x5c, 0xe7, 0xe5,
	0xcf, 0xc9, 0xb9, 0x07, 0xab, 0xd7, 0xcc, 0x13, 0x34, 0xe2, 0xf6, 0x52, 0xbb, 0x52, 0x1a, 0x6f,
	0x0a, 0x44, 0xdb, 0xb0, 0xe2, 0xb1, 0x09, 0x13, 0x72, 0xb0, 0x2a, 0x4e, 0x7a, 0x48, 0x06, 0x6a,
	0x44, 0xaf, 0x83, 0x88, 0xca, 0x81, 0xaa, 0x38, 0xea, 0x84, 0xff, 0x00, 0x7b, 0x31, 0x31, 0xa5,
	0xf8, 0x07, 0x58, 0xd3, 0x44, 0x70, 0xdb, 0x7a, 0x22, 0x05, 0x03, 0x8d, 0x5f, 0x59, 0x50, 0x3d,
	0x96, 0x42, 0x4a, 0x25, 0x62, 0x58, 0xbb, 0x8e, 0x18, 0xf5, 0xc7, 0xde, 0xe3, 0x2f, 0x64, 0x32,
	0xdd, 0x3e, 0x86, 0x2d, 0x29, 0x1d, 0x71, 0x5d, 0xca, 0xf9, 0x4f, 0x3e, 0x19, 0x79, 0x74, 0x2c,
	0xa5, 0xd5, 0x1c, 0xd3, 0x98, 0x48, 0x64, 0x7c, 0x48, 0xb9, 0x90, 0x12, 0x6b, 0x8e, 0x3a, 0xe1,
	0x23, 0xd8, 0x4a, 0x1b, 0x2e, 0xcd, 0x66, 0xfa, 0xdc, 0xbf, 0x86, 0x6a, 0x9a, 0x84, 0x2a, 0xe5,
	0x96, 0xa1, 0x4b, 0x61, 0x15, 0x04, 0x37, 0x61, 0xdb, 0xe4, 0x48, 0x1f, 0x51, 0xc2, 0xfd, 0x5b,
	0x38, 0x7e, 0x31, 0xb7, 0xc9, 0xa1, 0xb8, 0x3b, 0xb0, 0x71, 0x4a, 0x85, 0x49, 0x5c, 0x36, 0xef,
	0x87, 0xb0, 0xa9, 0xe1, 0x55, 0x0d, 0xdf, 0x2b, 0x93, 0x37, 0x16, 0x34, 0x8e, 0x89, 0x20, 0x5e,
	0xf0, 0xf7, 0x40, 0xd0, 0x49, 0x69, 0xdd, 0xd4, 0x06, 0x5b, 0x9a, 0x6f, 0xb0, 0x36, 0x34, 0xc2,
	0x28, 0x18, 0xc7, 0xae, 0x90, 0x85, 0x4c, 0xf7, 0xba, 0x6e, 0x4a, 0x6a, 0x4d, 0xff, 0x15, 0x34,
	0xf2, 0x89, 0x77, 0xce, 0xfc, 0x5b, 0xb5, 0xdb, 0x0d, 0x5b, 0x52, 0xc5, 0xbe, 0x2b, 0xd8, 0x7d,
	0xba, 0xda, 0x6b, 0x8e, 0x3a, 0xcd, 0xd7, 0x91, 0x96, 0xa0, 0xb6, 0x8e, 0xdc, 0xb9, 0x35, 0x77,
	0x34, 0x75, 0x2f, 0x1d, 0x8c, 0x3f, 0x9d, 0xae, 0x23, 0x83, 0x57, 0x95, 0xe0, 0x12, 0x6c, 0x55,
	0x9a, 0x0f, 0x1e, 0x34, 0x87, 0x37, 0x0d, 0xda, 0x7b, 0x5b, 0x05, 0x98, 0xbf, 0xd9, 0xd1, 0x08,
	0x36, 0x17, 0xf6, 0x25, 0xda, 0x37, 0xe3, 0x14, 0xec, 0xe9, 0xd6, 0x57, 0x4f, 0xc1, 0x54, 0x97,
	0x5c, 0xc1, 0x47, 0xe6, 0xd6, 0x43, 0xd8, 0xf0, 0xcc, 0xdd, 0xb6, 0xad, 0xdd, 0x52, 0x8c, 0xa2,
	0xfe, 0x0b, 0x36, 0xb2, 0x0b, 0x06, 0xed, 0x19, 0x8e, 0x05, 0x8b, 0xb1, 0xb5, 0xff, 0x04, 0x4a,
	0x05, 0xf8, 0x15, 0xd6, 0xf4, 0xd1, 0x44, 0xed, 0x1c, 0xcd, 0xc6, 0x10, 0xb5, 0xbe, 0x2c, 0x41,
	0xcc, 0x49, 0xf5, 0x99, 0xcc, 0x90, 0xe6, 0x8c, 0x7c, 0x86, 0x34, 0x6f, 0xa0, 0xd1, 0x19, 0xd4,
	0x67, 0x03, 0x8a, 0x3e, 0xcf, 0x3e, 0x3c, 0x93, 0xee, 0x8b, 0xa2, 0x6b, 0xc5, 0x75, 0x09, 0xeb,
	0xc6, 0xcb, 0x1d, 0x99, 0xf1, 0xf3, 0x3e, 0x16, 0x5a, 0xb8, 0x0c, 0xa2, 0x78, 0x67, 0xdd, 0xa6,
	0xef, 0x81, 0xbc, 0x6e, 0x5b, 0x9c, 0x88, 0xdc, 0x6e, 0xcb, 0x69, 0xf0, 0x24, 0xc6, 0x42, 0xf7,
	0x67, 0x62, 0x14, 0x4d, 0x5d, 0x26, 0x46, 0xe1, 0x10, 0x1d, 0xed, 0xff, 0xb9, 0xfb, 0x8c, 0x2f,
	0xe6, 0x51, 0x55, 0x7e, 0x2c, 0x7f, 0xf3, 0x2e, 0x00, 0x00, 0xff, 0xff, 0x68, 0xa0, 0xb1, 0x6b,
	0x5f, 0x0b, 0x00, 0x00,
}
