// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchAPIControlCenterTwirp/twirp.proto

/*
Package TwitchAPIControlCenterTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchAPIControlCenterTwirp/twirp.proto
*/
package TwitchAPIControlCenterTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ==========================
// APIControlCenter Interface
// ==========================

type APIControlCenter interface {
	VerifyV2(context.Context, *VerifyInputV2) (*VerifyOutputV2, error)

	// Control APIs for ACC V2 Data Model
	SetAccessControlRule(context.Context, *SetAccessControlRuleInput) (*Empty, error)

	BulkSetAccessControlRule(context.Context, *BulkSetAccessControlRuleInput) (*BulkSetAccessControlRuleOutput, error)

	RemoveAccessControlRule(context.Context, *RemoveAccessControlRuleInput) (*Empty, error)

	BulkRemoveAccessControlRule(context.Context, *BulkRemoveAccessControlRuleInput) (*BulkRemoveAccessControlRuleOutput, error)

	GetAccessControlRule(context.Context, *GetAccessControlRuleInput) (*GetAccessControlRuleOutput, error)

	SetRateLimitRule(context.Context, *SetRateLimitRuleInput) (*Empty, error)

	RemoveRateLimitRule(context.Context, *RemoveRateLimitRuleInput) (*Empty, error)

	GetRateLimitRule(context.Context, *GetRateLimitRuleInput) (*GetRateLimitRuleOutput, error)

	GetEffectiveSettings(context.Context, *GetEffectiveSettingsInput) (*GetEffectiveSettingsOutput, error)

	// Allowlist GET, CREATE and Remove
	GetAllowlist(context.Context, *GetAllowlistInput) (*GetAllowlistOutput, error)

	CreateAllowlist(context.Context, *CreateAllowlistInput) (*Empty, error)

	RemoveAllowlist(context.Context, *RemoveAllowlistInput) (*Empty, error)

	AddAllowlistMember(context.Context, *AddAllowlistMemberInput) (*Empty, error)

	RemoveAllowlistMember(context.Context, *RemoveAllowlistMemberInput) (*Empty, error)

	AddAllowlistResource(context.Context, *AddAllowlistResourceInput) (*Empty, error)

	RemoveAllowlistResource(context.Context, *RemoveAllowlistResourceInput) (*Empty, error)

	ListAllowlists(context.Context, *Empty) (*ListAllowlistsOutput, error)
}

// ================================
// APIControlCenter Protobuf Client
// ================================

type aPIControlCenterProtobufClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewAPIControlCenterProtobufClient creates a Protobuf client that implements the APIControlCenter interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewAPIControlCenterProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) APIControlCenter {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + APIControlCenterPathPrefix
	urls := [18]string{
		prefix + "VerifyV2",
		prefix + "SetAccessControlRule",
		prefix + "BulkSetAccessControlRule",
		prefix + "RemoveAccessControlRule",
		prefix + "BulkRemoveAccessControlRule",
		prefix + "GetAccessControlRule",
		prefix + "SetRateLimitRule",
		prefix + "RemoveRateLimitRule",
		prefix + "GetRateLimitRule",
		prefix + "GetEffectiveSettings",
		prefix + "GetAllowlist",
		prefix + "CreateAllowlist",
		prefix + "RemoveAllowlist",
		prefix + "AddAllowlistMember",
		prefix + "RemoveAllowlistMember",
		prefix + "AddAllowlistResource",
		prefix + "RemoveAllowlistResource",
		prefix + "ListAllowlists",
	}

	return &aPIControlCenterProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *aPIControlCenterProtobufClient) VerifyV2(ctx context.Context, in *VerifyInputV2) (*VerifyOutputV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "VerifyV2")
	out := new(VerifyOutputV2)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) SetAccessControlRule(ctx context.Context, in *SetAccessControlRuleInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "SetAccessControlRule")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) BulkSetAccessControlRule(ctx context.Context, in *BulkSetAccessControlRuleInput) (*BulkSetAccessControlRuleOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "BulkSetAccessControlRule")
	out := new(BulkSetAccessControlRuleOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) RemoveAccessControlRule(ctx context.Context, in *RemoveAccessControlRuleInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAccessControlRule")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) BulkRemoveAccessControlRule(ctx context.Context, in *BulkRemoveAccessControlRuleInput) (*BulkRemoveAccessControlRuleOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "BulkRemoveAccessControlRule")
	out := new(BulkRemoveAccessControlRuleOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) GetAccessControlRule(ctx context.Context, in *GetAccessControlRuleInput) (*GetAccessControlRuleOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "GetAccessControlRule")
	out := new(GetAccessControlRuleOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) SetRateLimitRule(ctx context.Context, in *SetRateLimitRuleInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "SetRateLimitRule")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) RemoveRateLimitRule(ctx context.Context, in *RemoveRateLimitRuleInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRateLimitRule")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) GetRateLimitRule(ctx context.Context, in *GetRateLimitRuleInput) (*GetRateLimitRuleOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "GetRateLimitRule")
	out := new(GetRateLimitRuleOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) GetEffectiveSettings(ctx context.Context, in *GetEffectiveSettingsInput) (*GetEffectiveSettingsOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "GetEffectiveSettings")
	out := new(GetEffectiveSettingsOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) GetAllowlist(ctx context.Context, in *GetAllowlistInput) (*GetAllowlistOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllowlist")
	out := new(GetAllowlistOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) CreateAllowlist(ctx context.Context, in *CreateAllowlistInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAllowlist")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) RemoveAllowlist(ctx context.Context, in *RemoveAllowlistInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlist")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) AddAllowlistMember(ctx context.Context, in *AddAllowlistMemberInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "AddAllowlistMember")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) RemoveAllowlistMember(ctx context.Context, in *RemoveAllowlistMemberInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlistMember")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) AddAllowlistResource(ctx context.Context, in *AddAllowlistResourceInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "AddAllowlistResource")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) RemoveAllowlistResource(ctx context.Context, in *RemoveAllowlistResourceInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlistResource")
	out := new(Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterProtobufClient) ListAllowlists(ctx context.Context, in *Empty) (*ListAllowlistsOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "ListAllowlists")
	out := new(ListAllowlistsOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================
// APIControlCenter JSON Client
// ============================

type aPIControlCenterJSONClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewAPIControlCenterJSONClient creates a JSON client that implements the APIControlCenter interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewAPIControlCenterJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) APIControlCenter {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + APIControlCenterPathPrefix
	urls := [18]string{
		prefix + "VerifyV2",
		prefix + "SetAccessControlRule",
		prefix + "BulkSetAccessControlRule",
		prefix + "RemoveAccessControlRule",
		prefix + "BulkRemoveAccessControlRule",
		prefix + "GetAccessControlRule",
		prefix + "SetRateLimitRule",
		prefix + "RemoveRateLimitRule",
		prefix + "GetRateLimitRule",
		prefix + "GetEffectiveSettings",
		prefix + "GetAllowlist",
		prefix + "CreateAllowlist",
		prefix + "RemoveAllowlist",
		prefix + "AddAllowlistMember",
		prefix + "RemoveAllowlistMember",
		prefix + "AddAllowlistResource",
		prefix + "RemoveAllowlistResource",
		prefix + "ListAllowlists",
	}

	return &aPIControlCenterJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *aPIControlCenterJSONClient) VerifyV2(ctx context.Context, in *VerifyInputV2) (*VerifyOutputV2, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "VerifyV2")
	out := new(VerifyOutputV2)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) SetAccessControlRule(ctx context.Context, in *SetAccessControlRuleInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "SetAccessControlRule")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) BulkSetAccessControlRule(ctx context.Context, in *BulkSetAccessControlRuleInput) (*BulkSetAccessControlRuleOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "BulkSetAccessControlRule")
	out := new(BulkSetAccessControlRuleOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) RemoveAccessControlRule(ctx context.Context, in *RemoveAccessControlRuleInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAccessControlRule")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) BulkRemoveAccessControlRule(ctx context.Context, in *BulkRemoveAccessControlRuleInput) (*BulkRemoveAccessControlRuleOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "BulkRemoveAccessControlRule")
	out := new(BulkRemoveAccessControlRuleOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) GetAccessControlRule(ctx context.Context, in *GetAccessControlRuleInput) (*GetAccessControlRuleOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "GetAccessControlRule")
	out := new(GetAccessControlRuleOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) SetRateLimitRule(ctx context.Context, in *SetRateLimitRuleInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "SetRateLimitRule")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) RemoveRateLimitRule(ctx context.Context, in *RemoveRateLimitRuleInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRateLimitRule")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) GetRateLimitRule(ctx context.Context, in *GetRateLimitRuleInput) (*GetRateLimitRuleOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "GetRateLimitRule")
	out := new(GetRateLimitRuleOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) GetEffectiveSettings(ctx context.Context, in *GetEffectiveSettingsInput) (*GetEffectiveSettingsOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "GetEffectiveSettings")
	out := new(GetEffectiveSettingsOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) GetAllowlist(ctx context.Context, in *GetAllowlistInput) (*GetAllowlistOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "GetAllowlist")
	out := new(GetAllowlistOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) CreateAllowlist(ctx context.Context, in *CreateAllowlistInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAllowlist")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) RemoveAllowlist(ctx context.Context, in *RemoveAllowlistInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlist")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) AddAllowlistMember(ctx context.Context, in *AddAllowlistMemberInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "AddAllowlistMember")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) RemoveAllowlistMember(ctx context.Context, in *RemoveAllowlistMemberInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlistMember")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) AddAllowlistResource(ctx context.Context, in *AddAllowlistResourceInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "AddAllowlistResource")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) RemoveAllowlistResource(ctx context.Context, in *RemoveAllowlistResourceInput) (*Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlistResource")
	out := new(Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *aPIControlCenterJSONClient) ListAllowlists(ctx context.Context, in *Empty) (*ListAllowlistsOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithMethodName(ctx, "ListAllowlists")
	out := new(ListAllowlistsOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===============================
// APIControlCenter Server Handler
// ===============================

type aPIControlCenterServer struct {
	APIControlCenter
	hooks *twirp.ServerHooks
}

func NewAPIControlCenterServer(svc APIControlCenter, hooks *twirp.ServerHooks) TwirpServer {
	return &aPIControlCenterServer{
		APIControlCenter: svc,
		hooks:            hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *aPIControlCenterServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// APIControlCenterPathPrefix is used for all URL paths on a twirp APIControlCenter server.
// Requests are always: POST APIControlCenterPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const APIControlCenterPathPrefix = "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/"

func (s *aPIControlCenterServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.edge.apicontrolcenter")
	ctx = ctxsetters.WithServiceName(ctx, "APIControlCenter")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/VerifyV2":
		s.serveVerifyV2(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/SetAccessControlRule":
		s.serveSetAccessControlRule(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/BulkSetAccessControlRule":
		s.serveBulkSetAccessControlRule(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/RemoveAccessControlRule":
		s.serveRemoveAccessControlRule(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/BulkRemoveAccessControlRule":
		s.serveBulkRemoveAccessControlRule(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/GetAccessControlRule":
		s.serveGetAccessControlRule(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/SetRateLimitRule":
		s.serveSetRateLimitRule(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/RemoveRateLimitRule":
		s.serveRemoveRateLimitRule(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/GetRateLimitRule":
		s.serveGetRateLimitRule(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/GetEffectiveSettings":
		s.serveGetEffectiveSettings(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/GetAllowlist":
		s.serveGetAllowlist(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/CreateAllowlist":
		s.serveCreateAllowlist(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/RemoveAllowlist":
		s.serveRemoveAllowlist(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/AddAllowlistMember":
		s.serveAddAllowlistMember(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/RemoveAllowlistMember":
		s.serveRemoveAllowlistMember(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/AddAllowlistResource":
		s.serveAddAllowlistResource(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/RemoveAllowlistResource":
		s.serveRemoveAllowlistResource(ctx, resp, req)
		return
	case "/twirp/twitch.edge.apicontrolcenter.APIControlCenter/ListAllowlists":
		s.serveListAllowlists(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *aPIControlCenterServer) serveVerifyV2(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveVerifyV2JSON(ctx, resp, req)
	case "application/protobuf":
		s.serveVerifyV2Protobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveVerifyV2JSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "VerifyV2")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(VerifyInputV2)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *VerifyOutputV2
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.VerifyV2(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VerifyOutputV2 and nil error while calling VerifyV2. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveVerifyV2Protobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "VerifyV2")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(VerifyInputV2)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *VerifyOutputV2
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.VerifyV2(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VerifyOutputV2 and nil error while calling VerifyV2. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveSetAccessControlRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetAccessControlRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetAccessControlRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveSetAccessControlRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetAccessControlRuleInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.SetAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveSetAccessControlRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetAccessControlRuleInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.SetAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveBulkSetAccessControlRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkSetAccessControlRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkSetAccessControlRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveBulkSetAccessControlRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkSetAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkSetAccessControlRuleInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkSetAccessControlRuleOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.BulkSetAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkSetAccessControlRuleOutput and nil error while calling BulkSetAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveBulkSetAccessControlRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkSetAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BulkSetAccessControlRuleInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkSetAccessControlRuleOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.BulkSetAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkSetAccessControlRuleOutput and nil error while calling BulkSetAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveAccessControlRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveAccessControlRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveAccessControlRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveRemoveAccessControlRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveAccessControlRuleInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveAccessControlRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveAccessControlRuleInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveBulkRemoveAccessControlRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkRemoveAccessControlRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkRemoveAccessControlRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveBulkRemoveAccessControlRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkRemoveAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkRemoveAccessControlRuleInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkRemoveAccessControlRuleOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.BulkRemoveAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkRemoveAccessControlRuleOutput and nil error while calling BulkRemoveAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveBulkRemoveAccessControlRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkRemoveAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BulkRemoveAccessControlRuleInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkRemoveAccessControlRuleOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.BulkRemoveAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkRemoveAccessControlRuleOutput and nil error while calling BulkRemoveAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveGetAccessControlRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAccessControlRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAccessControlRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveGetAccessControlRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAccessControlRuleInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAccessControlRuleOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.GetAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAccessControlRuleOutput and nil error while calling GetAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveGetAccessControlRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAccessControlRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAccessControlRuleInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAccessControlRuleOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.GetAccessControlRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAccessControlRuleOutput and nil error while calling GetAccessControlRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveSetRateLimitRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetRateLimitRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetRateLimitRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveSetRateLimitRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetRateLimitRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetRateLimitRuleInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.SetRateLimitRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetRateLimitRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveSetRateLimitRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetRateLimitRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetRateLimitRuleInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.SetRateLimitRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling SetRateLimitRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveRateLimitRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveRateLimitRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveRateLimitRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveRemoveRateLimitRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRateLimitRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveRateLimitRuleInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveRateLimitRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveRateLimitRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveRateLimitRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRateLimitRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveRateLimitRuleInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveRateLimitRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveRateLimitRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveGetRateLimitRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRateLimitRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRateLimitRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveGetRateLimitRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRateLimitRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRateLimitRuleInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRateLimitRuleOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.GetRateLimitRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRateLimitRuleOutput and nil error while calling GetRateLimitRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveGetRateLimitRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRateLimitRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRateLimitRuleInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRateLimitRuleOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.GetRateLimitRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRateLimitRuleOutput and nil error while calling GetRateLimitRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveGetEffectiveSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEffectiveSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEffectiveSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveGetEffectiveSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEffectiveSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEffectiveSettingsInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEffectiveSettingsOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.GetEffectiveSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEffectiveSettingsOutput and nil error while calling GetEffectiveSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveGetEffectiveSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEffectiveSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetEffectiveSettingsInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEffectiveSettingsOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.GetEffectiveSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEffectiveSettingsOutput and nil error while calling GetEffectiveSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveGetAllowlist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAllowlistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllowlistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveGetAllowlistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllowlist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAllowlistInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAllowlistOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.GetAllowlist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllowlistOutput and nil error while calling GetAllowlist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveGetAllowlistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAllowlist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAllowlistInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAllowlistOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.GetAllowlist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllowlistOutput and nil error while calling GetAllowlist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveCreateAllowlist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateAllowlistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateAllowlistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveCreateAllowlistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAllowlist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateAllowlistInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.CreateAllowlist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling CreateAllowlist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveCreateAllowlistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAllowlist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateAllowlistInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.CreateAllowlist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling CreateAllowlist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveAllowlist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveAllowlistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveAllowlistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveRemoveAllowlistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveAllowlistInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveAllowlist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveAllowlist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveAllowlistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveAllowlistInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveAllowlist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveAllowlist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveAddAllowlistMember(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddAllowlistMemberJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddAllowlistMemberProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveAddAllowlistMemberJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddAllowlistMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddAllowlistMemberInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.AddAllowlistMember(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling AddAllowlistMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveAddAllowlistMemberProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddAllowlistMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddAllowlistMemberInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.AddAllowlistMember(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling AddAllowlistMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveAllowlistMember(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveAllowlistMemberJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveAllowlistMemberProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveRemoveAllowlistMemberJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlistMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveAllowlistMemberInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveAllowlistMember(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveAllowlistMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveAllowlistMemberProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlistMember")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveAllowlistMemberInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveAllowlistMember(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveAllowlistMember. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveAddAllowlistResource(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddAllowlistResourceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddAllowlistResourceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveAddAllowlistResourceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddAllowlistResource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddAllowlistResourceInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.AddAllowlistResource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling AddAllowlistResource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveAddAllowlistResourceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddAllowlistResource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddAllowlistResourceInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.AddAllowlistResource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling AddAllowlistResource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveAllowlistResource(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveAllowlistResourceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveAllowlistResourceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveRemoveAllowlistResourceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlistResource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveAllowlistResourceInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveAllowlistResource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveAllowlistResource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveRemoveAllowlistResourceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAllowlistResource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveAllowlistResourceInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.RemoveAllowlistResource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Empty and nil error while calling RemoveAllowlistResource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveListAllowlists(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListAllowlistsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListAllowlistsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *aPIControlCenterServer) serveListAllowlistsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAllowlists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListAllowlistsOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.ListAllowlists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAllowlistsOutput and nil error while calling ListAllowlists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) serveListAllowlistsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAllowlists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListAllowlistsOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.APIControlCenter.ListAllowlists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAllowlistsOutput and nil error while calling ListAllowlists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *aPIControlCenterServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *aPIControlCenterServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *aPIControlCenterServer) PathPrefix() string {
	return APIControlCenterPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1211 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xdf, 0x6f, 0xdb, 0xd4,
	0x17, 0x97, 0xfb, 0x3b, 0x27, 0xfd, 0xae, 0xdd, 0xfd, 0xa6, 0x6d, 0x9a, 0x15, 0xc8, 0x2e, 0x0f,
	0x14, 0x81, 0x12, 0xc8, 0x4a, 0xe9, 0x36, 0x04, 0xca, 0xca, 0x14, 0x45, 0x6c, 0x62, 0x72, 0x4b,
	0x25, 0x26, 0x50, 0xe7, 0xda, 0x27, 0xe1, 0x76, 0x8e, 0x9d, 0xd9, 0xd7, 0x2d, 0x9d, 0x34, 0x9e,
	0x78, 0xe1, 0x81, 0x27, 0xc4, 0x03, 0x2f, 0x48, 0x20, 0xf1, 0xbc, 0x3f, 0x83, 0x7f, 0x0b, 0xf9,
	0xfa, 0x47, 0x62, 0xc7, 0x76, 0x9c, 0x8c, 0x45, 0xbc, 0x54, 0xf5, 0xbd, 0xe7, 0xe7, 0xe7, 0x7c,
	0xee, 0xcd, 0xb9, 0x07, 0xee, 0xaa, 0xa6, 0x86, 0xb5, 0x73, 0xc7, 0xe6, 0xcc, 0xa8, 0xf1, 0x8b,
	0xba, 0xd2, 0x7b, 0x6e, 0xd4, 0x8f, 0x2f, 0x19, 0x57, 0xbf, 0x6b, 0x3e, 0x6a, 0x1f, 0x9a, 0x06,
	0xb7, 0x4c, 0xfd, 0x10, 0x0d, 0x8e, 0xd6, 0xf1, 0x25, 0xb3, 0xfa, 0x75, 0xee, 0xfe, 0xad, 0xf5,
	0x2d, 0x93, 0x9b, 0x64, 0x87, 0x0b, 0xc1, 0x1a, 0x6a, 0x5d, 0xac, 0x29, 0x7d, 0xa6, 0x7a, 0xe2,
	0xaa, 0x10, 0xaf, 0xbc, 0xd5, 0x35, 0xcd, 0xae, 0x8e, 0x75, 0x21, 0x7b, 0xe6, 0x74, 0xea, 0x9c,
	0xf5, 0xd0, 0xe6, 0x4a, 0xcf, 0x57, 0xa7, 0xa7, 0x50, 0x7a, 0xc0, 0x6c, 0xde, 0xd4, 0x75, 0xf3,
	0x52, 0x67, 0x36, 0xb7, 0xbf, 0x74, 0x78, 0xdf, 0xe1, 0xa4, 0x05, 0xa0, 0x84, 0x6b, 0x65, 0xa9,
	0x3a, 0xbf, 0x5b, 0x6c, 0xbc, 0x53, 0xcb, 0xf2, 0x55, 0x0b, 0x6d, 0xc8, 0x43, 0xaa, 0xf4, 0x05,
	0x14, 0xc2, 0x0d, 0x72, 0x13, 0x56, 0xc3, 0xad, 0x53, 0xa6, 0x95, 0xa5, 0xaa, 0xb4, 0x5b, 0x90,
	0x8b, 0xe1, 0x5a, 0x5b, 0x23, 0x04, 0x16, 0x0c, 0xa5, 0x87, 0xe5, 0x39, 0xb1, 0x25, 0xfe, 0x27,
	0xb7, 0x01, 0x54, 0x0b, 0x15, 0x8e, 0xda, 0xa9, 0xc2, 0xcb, 0xf3, 0x55, 0x69, 0xb7, 0xd8, 0xa8,
	0xd4, 0xbc, 0xd4, 0x6a, 0x41, 0x6a, 0xb5, 0xe3, 0x20, 0x35, 0xb9, 0xe0, 0x4b, 0x37, 0x39, 0x7d,
	0x02, 0xdb, 0x4d, 0x4d, 0x1b, 0x84, 0x86, 0xb6, 0xe9, 0x58, 0x2a, 0xb6, 0x0d, 0x37, 0xc9, 0x1c,
	0xe1, 0x54, 0xa1, 0x68, 0xf9, 0x3a, 0x5f, 0xe0, 0x95, 0x1f, 0xd5, 0xf0, 0x12, 0x55, 0x61, 0x47,
	0xc6, 0x9e, 0x79, 0x81, 0xaf, 0xd3, 0xc9, 0xd7, 0xb0, 0x35, 0x9c, 0xc6, 0x43, 0xec, 0x9d, 0xa1,
	0x95, 0xdb, 0xfe, 0x0d, 0x28, 0xa8, 0x3a, 0x43, 0x43, 0xec, 0x7b, 0xd6, 0x57, 0xbc, 0x85, 0xb6,
	0x46, 0xbf, 0x81, 0x4a, 0x2c, 0xfe, 0x7f, 0xd3, 0xfa, 0x8f, 0x12, 0x94, 0x0e, 0x45, 0x35, 0x42,
	0xf3, 0x9e, 0xe1, 0xa0, 0xce, 0xd2, 0x50, 0x9d, 0xab, 0x50, 0xd4, 0xd0, 0x56, 0x2d, 0xd6, 0xe7,
	0xcc, 0x34, 0x02, 0x1c, 0x86, 0x96, 0x48, 0x19, 0x96, 0x7b, 0x22, 0x3a, 0xbb, 0x3c, 0x5f, 0x9d,
	0xdf, 0x2d, 0xc8, 0xc1, 0x27, 0xd9, 0x81, 0x42, 0x00, 0x98, 0x5d, 0x5e, 0x10, 0x7b, 0x83, 0x05,
	0xfa, 0x97, 0x04, 0xa4, 0x85, 0x03, 0x9a, 0xfb, 0x2c, 0x9f, 0x69, 0x10, 0x23, 0x58, 0x2e, 0x8e,
	0x60, 0x49, 0xf7, 0xe1, 0xfa, 0x70, 0x98, 0x79, 0x6b, 0x40, 0x6f, 0x43, 0x29, 0x56, 0xc4, 0x09,
	0x54, 0x97, 0x0e, 0x45, 0xb5, 0xa2, 0x85, 0x94, 0xa2, 0x85, 0x4c, 0x3a, 0x97, 0xf4, 0x17, 0x09,
	0xb6, 0x8f, 0x90, 0x37, 0x55, 0x15, 0x6d, 0xdb, 0xbf, 0xa7, 0x64, 0x47, 0xf7, 0x89, 0xbf, 0x0f,
	0x9b, 0x9e, 0x76, 0x70, 0x1e, 0x0e, 0x4d, 0xa3, 0xc3, 0xba, 0xed, 0xc0, 0x76, 0xca, 0xee, 0xf8,
	0xd3, 0xe0, 0xc2, 0xcc, 0x6c, 0x91, 0x29, 0x6a, 0xe2, 0x3a, 0x58, 0x91, 0x07, 0x0b, 0xf4, 0x37,
	0x09, 0xde, 0xb8, 0xe7, 0xe8, 0x4f, 0xd3, 0x23, 0x3b, 0x80, 0xad, 0x64, 0xdf, 0xde, 0x4d, 0x57,
	0x90, 0xd3, 0xb6, 0x5f, 0x39, 0xb6, 0xc7, 0xf0, 0x66, 0x5a, 0x68, 0x3e, 0x25, 0xa7, 0x8e, 0x8d,
	0x7e, 0x1f, 0x5e, 0x44, 0x33, 0xae, 0x07, 0xfd, 0x01, 0xaa, 0x6e, 0x56, 0x99, 0xde, 0x5f, 0x23,
	0xe6, 0xf4, 0x5b, 0xb8, 0x99, 0xe1, 0xff, 0x95, 0x81, 0x75, 0x60, 0xbb, 0x35, 0x7b, 0x96, 0xbb,
	0x17, 0x73, 0x2b, 0x9d, 0x27, 0x31, 0x7d, 0x69, 0x0c, 0x13, 0xe7, 0xe2, 0x4c, 0xfc, 0x59, 0x82,
	0x8d, 0x23, 0xe4, 0xb2, 0xc2, 0xf1, 0x01, 0xeb, 0x31, 0x3e, 0x8b, 0x73, 0x5b, 0x81, 0x15, 0x55,
	0xe9, 0x2b, 0x2a, 0xe3, 0x57, 0xe2, 0x68, 0x2c, 0xca, 0xe1, 0x37, 0xe5, 0x50, 0xf6, 0xea, 0x37,
	0xcb, 0x88, 0xe8, 0x33, 0xd8, 0x68, 0xcd, 0x16, 0x04, 0xba, 0x07, 0x9b, 0x71, 0x97, 0x7e, 0x49,
	0xb3, 0xe0, 0x79, 0x29, 0x09, 0x12, 0xde, 0xef, 0x74, 0x50, 0xe5, 0xec, 0x02, 0x8f, 0x90, 0x73,
	0x66, 0x74, 0xed, 0xf0, 0x70, 0x69, 0xd8, 0x51, 0x1c, 0x3d, 0x2d, 0xdc, 0xb4, 0xed, 0x8c, 0x3c,
	0xe7, 0x26, 0xc9, 0x73, 0x7e, 0x34, 0xcf, 0x13, 0x41, 0xdf, 0x91, 0x80, 0xfd, 0x5c, 0x23, 0xe4,
	0x94, 0x62, 0xe4, 0x8c, 0x20, 0x31, 0x17, 0x43, 0xe2, 0x08, 0x8a, 0x2e, 0x78, 0xba, 0x0b, 0x1e,
	0x5a, 0x11, 0x51, 0x29, 0x2a, 0x4a, 0x76, 0x61, 0xcd, 0xc2, 0x0e, 0xd3, 0xf5, 0x47, 0x68, 0x3d,
	0x64, 0x86, 0xc3, 0xd1, 0xb7, 0x16, 0x5f, 0xa6, 0x7f, 0x4b, 0xf0, 0xbf, 0x13, 0xb4, 0x58, 0xe7,
	0x4a, 0x00, 0x7a, 0xd2, 0xf8, 0x2f, 0x42, 0x4a, 0x28, 0xac, 0x5a, 0x41, 0xea, 0xae, 0xc8, 0x82,
	0x10, 0x89, 0xac, 0xd1, 0x3f, 0x25, 0xb8, 0xe6, 0x65, 0xe2, 0x21, 0x7d, 0xd2, 0x70, 0xfb, 0x15,
	0x25, 0x82, 0x74, 0xf0, 0x49, 0x4a, 0xb0, 0xa8, 0x2a, 0x8e, 0x1d, 0xfc, 0xaa, 0x7b, 0x1f, 0xe4,
	0x09, 0xac, 0x87, 0x26, 0x3f, 0x47, 0xae, 0x30, 0xdd, 0xf6, 0x9b, 0xee, 0xbd, 0xec, 0x17, 0x80,
	0xe7, 0x57, 0x8e, 0xe9, 0xca, 0x23, 0xd6, 0xe8, 0x1f, 0x73, 0xb0, 0x99, 0x2c, 0x2c, 0x6a, 0x36,
	0x28, 0xef, 0x57, 0x36, 0x06, 0x78, 0xc7, 0x97, 0x49, 0x1b, 0xa0, 0x6f, 0x99, 0x7d, 0xb4, 0x38,
	0x43, 0x5b, 0x64, 0x50, 0x6c, 0xbc, 0x9b, 0x1d, 0xe0, 0x10, 0x71, 0xe4, 0x21, 0x65, 0x17, 0xa1,
	0x8e, 0xa3, 0xeb, 0x03, 0xd8, 0x83, 0x4f, 0x8f, 0x42, 0x3d, 0x85, 0x19, 0xcc, 0xe8, 0x1e, 0x9b,
	0x4f, 0xd1, 0xb0, 0x05, 0xea, 0x82, 0x42, 0x91, 0x65, 0xb2, 0x07, 0xcb, 0x16, 0xda, 0xc8, 0x9b,
	0x5c, 0x34, 0x76, 0xd9, 0x2f, 0x94, 0x40, 0xd4, 0xf5, 0x6c, 0x21, 0xb7, 0xdc, 0x0c, 0x96, 0x84,
	0xdd, 0xe0, 0x93, 0x2e, 0xc3, 0xe2, 0xfd, 0x5e, 0x9f, 0x5f, 0x35, 0x5e, 0x5e, 0x87, 0xf5, 0xf8,
	0x3b, 0x90, 0x20, 0xac, 0x78, 0x00, 0x9e, 0x34, 0xc8, 0x7b, 0x79, 0xaa, 0xe2, 0xf3, 0xba, 0xf2,
	0x7e, 0x1e, 0xe1, 0x90, 0x3a, 0x1c, 0x4a, 0x49, 0xbd, 0x0a, 0xf9, 0x38, 0xdb, 0x4a, 0x6a, 0xeb,
	0x55, 0x79, 0x3b, 0x5b, 0x51, 0x64, 0x4c, 0x7e, 0x95, 0xa0, 0x9c, 0xd6, 0x26, 0x91, 0xbb, 0xd9,
	0x16, 0x32, 0x3b, 0xbf, 0xca, 0x27, 0xd3, 0x29, 0xfb, 0x97, 0xd6, 0x73, 0xd8, 0x4a, 0xe9, 0x31,
	0xc8, 0x9d, 0x31, 0xc4, 0xcb, 0x68, 0x8d, 0xf2, 0x61, 0xf2, 0xbb, 0x04, 0x37, 0x32, 0x9a, 0x1c,
	0xf2, 0xe9, 0xf8, 0xcc, 0x32, 0x83, 0xf8, 0x6c, 0x6a, 0x7d, 0x1f, 0x9c, 0x9f, 0x24, 0x28, 0xb5,
	0xa6, 0xe0, 0x4a, 0x6a, 0x6b, 0x55, 0x39, 0x98, 0x5c, 0xd1, 0x8f, 0x45, 0x87, 0xf5, 0x78, 0x6f,
	0x43, 0x6e, 0x8d, 0xa5, 0xec, 0x68, 0x1b, 0x90, 0xaf, 0x34, 0x16, 0xfc, 0x3f, 0xa1, 0x75, 0x21,
	0xfb, 0x79, 0x28, 0x31, 0xad, 0xcf, 0x17, 0xb0, 0xde, 0x9a, 0x30, 0xc3, 0xc4, 0x46, 0xa7, 0xb2,
	0x37, 0x99, 0x52, 0xb4, 0xd8, 0x23, 0xbf, 0xee, 0x39, 0x8a, 0x9d, 0xdc, 0xc2, 0xe4, 0x28, 0x76,
	0x5a, 0x2b, 0xf1, 0x0c, 0x56, 0x87, 0xdf, 0xcc, 0xa4, 0x3e, 0x9e, 0x36, 0x91, 0x47, 0x72, 0xe5,
	0x83, 0xfc, 0x0a, 0xbe, 0xcb, 0x73, 0x58, 0x8b, 0x0d, 0x35, 0x48, 0x23, 0xdb, 0x48, 0xd2, 0x0c,
	0x24, 0x5f, 0xa5, 0xcf, 0x61, 0x2d, 0xf6, 0xb4, 0x1f, 0xe7, 0x2b, 0x69, 0x12, 0x90, 0xcf, 0x57,
	0x1f, 0xc8, 0xe8, 0x98, 0x89, 0x7c, 0x34, 0x66, 0xee, 0x97, 0x3c, 0x98, 0xca, 0xe7, 0xf1, 0x02,
	0x36, 0x12, 0xa7, 0x4f, 0xe4, 0x60, 0xa2, 0x1c, 0x27, 0xf6, 0xcb, 0xa1, 0x94, 0x34, 0x17, 0x1c,
	0xc7, 0xdf, 0xd4, 0x59, 0x62, 0x3e, 0xaf, 0x83, 0x1f, 0x90, 0x11, 0xc7, 0x77, 0x26, 0xca, 0x77,
	0x0a, 0xdf, 0x0c, 0xae, 0x45, 0x27, 0xbd, 0x24, 0x8f, 0x5a, 0x65, 0x0c, 0xd7, 0x92, 0x86, 0xc7,
	0xf7, 0x3e, 0x7c, 0x5c, 0x9f, 0x70, 0xa4, 0x7d, 0xb6, 0x24, 0x9a, 0xa4, 0x5b, 0xff, 0x04, 0x00,
	0x00, 0xff, 0xff, 0xff, 0x92, 0x2f, 0xd7, 0x0c, 0x17, 0x00, 0x00,
}
