// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: main.proto

/*
Package TwitchAutoprofLambdaTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	main.proto
*/
package TwitchAutoprofLambdaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import google_protobuf "github.com/golang/protobuf/ptypes/empty"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// =========================
// AppRegistration Interface
// =========================

// Manages the set of S3 buckets that are checked for Autoprof data.
type AppRegistration interface {
	// Looks up a bucket registration.
	GetRegistration(context.Context, *GetRegistrationRequest) (*Registration, error)

	// Registers an S3 bucket for ingest to Autoprof.
	Register(context.Context, *RegisterRequest) (*Registration, error)

	// Deregisters an S3 bucket from ingest to Autoprof.
	Deregister(context.Context, *DeregisterRequest) (*google_protobuf.Empty, error)
}

// ===============================
// AppRegistration Protobuf Client
// ===============================

type appRegistrationProtobufClient struct {
	client HTTPClient
	urls   [3]string
}

// NewAppRegistrationProtobufClient creates a Protobuf client that implements the AppRegistration interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewAppRegistrationProtobufClient(addr string, client HTTPClient) AppRegistration {
	prefix := urlBase(addr) + AppRegistrationPathPrefix
	urls := [3]string{
		prefix + "GetRegistration",
		prefix + "Register",
		prefix + "Deregister",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &appRegistrationProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &appRegistrationProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *appRegistrationProtobufClient) GetRegistration(ctx context.Context, in *GetRegistrationRequest) (*Registration, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "AppRegistration")
	ctx = ctxsetters.WithMethodName(ctx, "GetRegistration")
	out := new(Registration)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *appRegistrationProtobufClient) Register(ctx context.Context, in *RegisterRequest) (*Registration, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "AppRegistration")
	ctx = ctxsetters.WithMethodName(ctx, "Register")
	out := new(Registration)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *appRegistrationProtobufClient) Deregister(ctx context.Context, in *DeregisterRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "AppRegistration")
	ctx = ctxsetters.WithMethodName(ctx, "Deregister")
	out := new(google_protobuf.Empty)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

// ===========================
// AppRegistration JSON Client
// ===========================

type appRegistrationJSONClient struct {
	client HTTPClient
	urls   [3]string
}

// NewAppRegistrationJSONClient creates a JSON client that implements the AppRegistration interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewAppRegistrationJSONClient(addr string, client HTTPClient) AppRegistration {
	prefix := urlBase(addr) + AppRegistrationPathPrefix
	urls := [3]string{
		prefix + "GetRegistration",
		prefix + "Register",
		prefix + "Deregister",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &appRegistrationJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &appRegistrationJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *appRegistrationJSONClient) GetRegistration(ctx context.Context, in *GetRegistrationRequest) (*Registration, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "AppRegistration")
	ctx = ctxsetters.WithMethodName(ctx, "GetRegistration")
	out := new(Registration)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *appRegistrationJSONClient) Register(ctx context.Context, in *RegisterRequest) (*Registration, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "AppRegistration")
	ctx = ctxsetters.WithMethodName(ctx, "Register")
	out := new(Registration)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *appRegistrationJSONClient) Deregister(ctx context.Context, in *DeregisterRequest) (*google_protobuf.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "AppRegistration")
	ctx = ctxsetters.WithMethodName(ctx, "Deregister")
	out := new(google_protobuf.Empty)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

// ==============================
// AppRegistration Server Handler
// ==============================

type appRegistrationServer struct {
	AppRegistration
	hooks *twirp.ServerHooks
}

func NewAppRegistrationServer(svc AppRegistration, hooks *twirp.ServerHooks) TwirpServer {
	return &appRegistrationServer{
		AppRegistration: svc,
		hooks:           hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *appRegistrationServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// AppRegistrationPathPrefix is used for all URL paths on a twirp AppRegistration server.
// Requests are always: POST AppRegistrationPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const AppRegistrationPathPrefix = "/twirp/twitch.video.autoprof.AppRegistration/"

func (s *appRegistrationServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "AppRegistration")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.autoprof.AppRegistration/GetRegistration":
		s.serveGetRegistration(ctx, resp, req)
		return
	case "/twirp/twitch.video.autoprof.AppRegistration/Register":
		s.serveRegister(ctx, resp, req)
		return
	case "/twirp/twitch.video.autoprof.AppRegistration/Deregister":
		s.serveDeregister(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *appRegistrationServer) serveGetRegistration(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRegistrationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRegistrationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *appRegistrationServer) serveGetRegistrationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRegistration")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRegistrationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Registration
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRegistration(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Registration and nil error while calling GetRegistration. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *appRegistrationServer) serveGetRegistrationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRegistration")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRegistrationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Registration
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRegistration(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Registration and nil error while calling GetRegistration. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *appRegistrationServer) serveRegister(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *appRegistrationServer) serveRegisterJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Register")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RegisterRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Registration
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Register(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Registration and nil error while calling Register. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *appRegistrationServer) serveRegisterProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Register")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RegisterRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Registration
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Register(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Registration and nil error while calling Register. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *appRegistrationServer) serveDeregister(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeregisterJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeregisterProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *appRegistrationServer) serveDeregisterJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Deregister")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeregisterRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Deregister(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling Deregister. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *appRegistrationServer) serveDeregisterProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Deregister")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeregisterRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *google_protobuf.Empty
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Deregister(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf.Empty and nil error while calling Deregister. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *appRegistrationServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *appRegistrationServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// ==========================
// BundleCollection Interface
// ==========================

// Provides an interface to list and fetch the bundles that Autoprof has collected from its onboarded services.
// Very recent data may take up to 20 minutes to be available.
type BundleCollection interface {
	// ListApplications fetches a list of applications for which there are bundles
	// for the application around the specified time window. This RPC will not return duplicate
	// applications within a single response, but may return the same applications again on subsequent
	// pages.
	ListApplications(context.Context, *ListApplicationsRequest) (*ListApplicationsResponse, error)

	// ListBundles fetches a list of bundles for an application around the specified time window.
	ListBundles(context.Context, *ListBundlesRequest) (*ListBundlesResponse, error)

	// GetBundle returns an Autoprof data bundle. The data is presented as a zip archive describing the source process and including
	// a number of profiles and other diagnostic information from a single point in its lifetime.
	// See the FAQ portion of https://wiki.twitch.com/display/ENG/Autoprof for detail about what data is included in a bundle.
	GetBundle(context.Context, *GetBundleRequest) (*Bundle, error)
}

// ================================
// BundleCollection Protobuf Client
// ================================

type bundleCollectionProtobufClient struct {
	client HTTPClient
	urls   [3]string
}

// NewBundleCollectionProtobufClient creates a Protobuf client that implements the BundleCollection interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewBundleCollectionProtobufClient(addr string, client HTTPClient) BundleCollection {
	prefix := urlBase(addr) + BundleCollectionPathPrefix
	urls := [3]string{
		prefix + "ListApplications",
		prefix + "ListBundles",
		prefix + "GetBundle",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &bundleCollectionProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &bundleCollectionProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *bundleCollectionProtobufClient) ListApplications(ctx context.Context, in *ListApplicationsRequest) (*ListApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "BundleCollection")
	ctx = ctxsetters.WithMethodName(ctx, "ListApplications")
	out := new(ListApplicationsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *bundleCollectionProtobufClient) ListBundles(ctx context.Context, in *ListBundlesRequest) (*ListBundlesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "BundleCollection")
	ctx = ctxsetters.WithMethodName(ctx, "ListBundles")
	out := new(ListBundlesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *bundleCollectionProtobufClient) GetBundle(ctx context.Context, in *GetBundleRequest) (*Bundle, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "BundleCollection")
	ctx = ctxsetters.WithMethodName(ctx, "GetBundle")
	out := new(Bundle)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

// ============================
// BundleCollection JSON Client
// ============================

type bundleCollectionJSONClient struct {
	client HTTPClient
	urls   [3]string
}

// NewBundleCollectionJSONClient creates a JSON client that implements the BundleCollection interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewBundleCollectionJSONClient(addr string, client HTTPClient) BundleCollection {
	prefix := urlBase(addr) + BundleCollectionPathPrefix
	urls := [3]string{
		prefix + "ListApplications",
		prefix + "ListBundles",
		prefix + "GetBundle",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &bundleCollectionJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &bundleCollectionJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *bundleCollectionJSONClient) ListApplications(ctx context.Context, in *ListApplicationsRequest) (*ListApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "BundleCollection")
	ctx = ctxsetters.WithMethodName(ctx, "ListApplications")
	out := new(ListApplicationsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *bundleCollectionJSONClient) ListBundles(ctx context.Context, in *ListBundlesRequest) (*ListBundlesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "BundleCollection")
	ctx = ctxsetters.WithMethodName(ctx, "ListBundles")
	out := new(ListBundlesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *bundleCollectionJSONClient) GetBundle(ctx context.Context, in *GetBundleRequest) (*Bundle, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "BundleCollection")
	ctx = ctxsetters.WithMethodName(ctx, "GetBundle")
	out := new(Bundle)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

// ===============================
// BundleCollection Server Handler
// ===============================

type bundleCollectionServer struct {
	BundleCollection
	hooks *twirp.ServerHooks
}

func NewBundleCollectionServer(svc BundleCollection, hooks *twirp.ServerHooks) TwirpServer {
	return &bundleCollectionServer{
		BundleCollection: svc,
		hooks:            hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *bundleCollectionServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// BundleCollectionPathPrefix is used for all URL paths on a twirp BundleCollection server.
// Requests are always: POST BundleCollectionPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const BundleCollectionPathPrefix = "/twirp/twitch.video.autoprof.BundleCollection/"

func (s *bundleCollectionServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.autoprof")
	ctx = ctxsetters.WithServiceName(ctx, "BundleCollection")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.autoprof.BundleCollection/ListApplications":
		s.serveListApplications(ctx, resp, req)
		return
	case "/twirp/twitch.video.autoprof.BundleCollection/ListBundles":
		s.serveListBundles(ctx, resp, req)
		return
	case "/twirp/twitch.video.autoprof.BundleCollection/GetBundle":
		s.serveGetBundle(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *bundleCollectionServer) serveListApplications(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListApplicationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListApplicationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *bundleCollectionServer) serveListApplicationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListApplicationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListApplicationsResponse and nil error while calling ListApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *bundleCollectionServer) serveListApplicationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListApplicationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListApplicationsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListApplicationsResponse and nil error while calling ListApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *bundleCollectionServer) serveListBundles(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListBundlesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListBundlesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *bundleCollectionServer) serveListBundlesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListBundles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListBundlesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListBundlesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListBundles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListBundlesResponse and nil error while calling ListBundles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *bundleCollectionServer) serveListBundlesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListBundles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListBundlesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListBundlesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListBundles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListBundlesResponse and nil error while calling ListBundles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *bundleCollectionServer) serveGetBundle(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBundleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBundleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *bundleCollectionServer) serveGetBundleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBundle")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBundleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Bundle
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetBundle(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Bundle and nil error while calling GetBundle. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *bundleCollectionServer) serveGetBundleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBundle")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetBundleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Bundle
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetBundle(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Bundle and nil error while calling GetBundle. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *bundleCollectionServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *bundleCollectionServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 868 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xee, 0xae, 0xf3, 0xe7, 0xb3, 0x2e, 0x31, 0x03, 0x2d, 0x66, 0xab, 0xa8, 0x66, 0x41, 0x21,
	0x20, 0x75, 0x2d, 0xd9, 0x42, 0xa5, 0x14, 0x2e, 0x92, 0xb6, 0xb4, 0x48, 0x15, 0x8a, 0x36, 0x41,
	0x08, 0x6e, 0x56, 0x63, 0xef, 0x89, 0x3b, 0x64, 0x7f, 0x86, 0x99, 0xd9, 0x94, 0xe4, 0x11, 0x78,
	0x11, 0xde, 0x83, 0x1b, 0x6e, 0x11, 0xf7, 0xbc, 0x01, 0x0f, 0x81, 0x76, 0x66, 0xd7, 0x5d, 0x3b,
	0xb6, 0xe3, 0x44, 0xbd, 0x5b, 0x9f, 0xfd, 0xbe, 0xb3, 0xe7, 0x7c, 0xdf, 0x99, 0x39, 0x06, 0x48,
	0x28, 0x4b, 0x7d, 0x2e, 0x32, 0x95, 0x91, 0x3b, 0xea, 0x35, 0x53, 0xa3, 0x57, 0xfe, 0x19, 0x8b,
	0x30, 0xf3, 0x69, 0xae, 0x32, 0x2e, 0xb2, 0x13, 0xf7, 0xde, 0x38, 0xcb, 0xc6, 0x31, 0xf6, 0x34,
	0x68, 0x98, 0x9f, 0xf4, 0x30, 0xe1, 0xea, 0xdc, 0x70, 0xdc, 0xfb, 0xb3, 0x2f, 0x15, 0x4b, 0x50,
	0x2a, 0x9a, 0x70, 0x03, 0xf0, 0xbe, 0x86, 0xbb, 0xcf, 0x51, 0x05, 0x38, 0x66, 0x52, 0x09, 0xaa,
	0x58, 0x96, 0x06, 0xf8, 0x6b, 0x8e, 0x52, 0x11, 0x0f, 0x6e, 0xcb, 0x41, 0x38, 0xcc, 0x47, 0xa7,
	0xa8, 0x42, 0x2a, 0xd2, 0x8e, 0xd5, 0xb5, 0xf6, 0x9a, 0x81, 0x23, 0x07, 0x07, 0x3a, 0xb6, 0x2f,
	0x52, 0xef, 0x47, 0xd8, 0x36, 0x54, 0x14, 0xd7, 0xa0, 0x91, 0x2e, 0xb4, 0x18, 0x4d, 0x42, 0x91,
	0xc5, 0xa8, 0x21, 0xb6, 0x86, 0x00, 0xa3, 0x49, 0x90, 0xc5, 0x58, 0x24, 0x7e, 0x08, 0xef, 0x3e,
	0x45, 0x71, 0xfd, 0xd4, 0xde, 0xdf, 0x16, 0xb4, 0xea, 0xdd, 0xbc, 0x9d, 0x7a, 0xc8, 0x63, 0x70,
	0x46, 0x02, 0xa9, 0xc2, 0xb0, 0x10, 0xb0, 0xd3, 0xe8, 0x5a, 0x7b, 0x4e, 0xdf, 0xf5, 0x8d, 0xba,
	0x7e, 0xa5, 0xae, 0x7f, 0x5c, 0xa9, 0x1b, 0x80, 0x81, 0x17, 0x01, 0xf2, 0x0d, 0xb4, 0x46, 0x59,
	0x7a, 0xc2, 0x44, 0x62, 0xd8, 0x6b, 0x57, 0xb2, 0x9d, 0x12, 0x5f, 0x44, 0xbc, 0xbf, 0x2c, 0xf8,
	0xe0, 0x25, 0x93, 0x6a, 0x9f, 0xf3, 0x98, 0x8d, 0x74, 0x57, 0xb2, 0x92, 0xe4, 0x11, 0x80, 0x54,
	0x54, 0x28, 0x93, 0xd8, 0xba, 0x32, 0x71, 0x53, 0xa3, 0x75, 0x55, 0x5f, 0xc0, 0x16, 0xa6, 0x91,
	0x21, 0xda, 0x57, 0x12, 0x37, 0x31, 0x8d, 0x34, 0xed, 0x1e, 0x34, 0x39, 0x1d, 0x63, 0x28, 0xd9,
	0x85, 0xd1, 0x61, 0x3d, 0xd8, 0x2a, 0x02, 0x47, 0xec, 0x02, 0xc9, 0x0e, 0x80, 0x7e, 0xa9, 0xb2,
	0x53, 0x4c, 0x75, 0x9f, 0xcd, 0x40, 0xc3, 0x8f, 0x8b, 0x80, 0xf7, 0xbb, 0x05, 0x9d, 0xcb, 0x9d,
	0x48, 0x9e, 0xa5, 0x12, 0xc9, 0xb7, 0xd0, 0xa2, 0xb5, 0x78, 0xc7, 0xea, 0x36, 0xf6, 0x9c, 0xbe,
	0xe7, 0xcf, 0x9d, 0x7a, 0xbf, 0x96, 0x22, 0x98, 0xe2, 0x91, 0x5d, 0xd8, 0x4e, 0xf1, 0x37, 0x15,
	0xd6, 0x0a, 0x31, 0x7e, 0xde, 0x2e, 0xc2, 0x87, 0x93, 0x62, 0x3e, 0x02, 0xa7, 0x96, 0x84, 0x10,
	0x58, 0x4b, 0x69, 0xa9, 0x61, 0x33, 0xd0, 0xcf, 0xde, 0xbf, 0x16, 0x90, 0xa2, 0xde, 0x83, 0x3c,
	0x8d, 0x62, 0x9c, 0x88, 0xfe, 0x21, 0x6c, 0x51, 0xce, 0xc3, 0x1a, 0x7c, 0x93, 0x72, 0xfe, 0x3d,
	0x4d, 0x70, 0xc6, 0x0f, 0xfb, 0xa6, 0x7e, 0x34, 0x6e, 0xe8, 0xc7, 0xda, 0x52, 0x3f, 0xd6, 0x67,
	0xfd, 0x38, 0x83, 0xf7, 0xa6, 0xda, 0x2b, 0x9d, 0x78, 0x08, 0x9b, 0x43, 0x13, 0x2a, 0x4d, 0xd8,
	0x59, 0x60, 0x82, 0x21, 0x06, 0x15, 0x7a, 0x65, 0xe9, 0xff, 0xb1, 0x60, 0xc3, 0x70, 0xe7, 0xc9,
	0x3e, 0xa5, 0xaf, 0x3d, 0xad, 0x6f, 0x71, 0x94, 0x28, 0x57, 0xb9, 0x58, 0xf9, 0x20, 0x3a, 0x25,
	0x5e, 0x8b, 0x55, 0xe8, 0x21, 0xb2, 0x11, 0x4a, 0x19, 0xb2, 0x68, 0x32, 0x9f, 0x26, 0xf2, 0x5d,
	0x44, 0x1e, 0xc3, 0x46, 0x84, 0x8a, 0xb2, 0x58, 0x4b, 0xe5, 0xf4, 0x3f, 0x5e, 0xda, 0xf7, 0x53,
	0x0d, 0x0d, 0x4a, 0x8a, 0xb7, 0x0b, 0xed, 0xe7, 0x58, 0x6a, 0x59, 0x4d, 0xca, 0xbc, 0xa1, 0xfa,
	0xcf, 0x86, 0x56, 0x3d, 0x01, 0x79, 0x01, 0xa4, 0x2a, 0xea, 0x5a, 0x67, 0xb9, 0x5d, 0xb2, 0x8e,
	0x26, 0x23, 0xb4, 0x03, 0x70, 0xc2, 0x62, 0xd4, 0xca, 0xc9, 0x8e, 0xdd, 0x6d, 0x14, 0xed, 0x15,
	0x91, 0x42, 0x3b, 0x49, 0xee, 0x83, 0xc3, 0x05, 0x4a, 0x36, 0x4e, 0xc3, 0x5c, 0x30, 0xad, 0x5d,
	0x33, 0x80, 0x32, 0xf4, 0x83, 0x60, 0xe4, 0x13, 0x78, 0x47, 0x0e, 0xc2, 0x3a, 0xc6, 0x48, 0xd4,
	0x92, 0x83, 0xc3, 0x37, 0xa8, 0x31, 0x90, 0x1a, 0xea, 0x15, 0xd2, 0x08, 0x85, 0xec, 0xac, 0xeb,
	0x49, 0x79, 0xb4, 0x82, 0x62, 0xfe, 0x51, 0x95, 0xed, 0x85, 0xe1, 0x3e, 0x4b, 0x95, 0x38, 0x0f,
	0xda, 0x72, 0x26, 0xec, 0x3e, 0x81, 0x3b, 0x73, 0xa1, 0xa4, 0x0d, 0x8d, 0x53, 0x3c, 0x2f, 0x55,
	0x2d, 0x1e, 0xc9, 0xfb, 0xb0, 0x7e, 0x46, 0xe3, 0xbc, 0x9a, 0x17, 0xf3, 0xe3, 0x2b, 0xfb, 0x4b,
	0xab, 0xff, 0x87, 0x0d, 0xdb, 0xfb, 0x9c, 0x4f, 0xed, 0x84, 0x31, 0x6c, 0xcf, 0x2c, 0x3d, 0xf2,
	0x60, 0x41, 0xe1, 0xf3, 0x97, 0xa3, 0xbb, 0x68, 0x32, 0xea, 0x58, 0xef, 0x16, 0xf9, 0x09, 0xb6,
	0xaa, 0xfd, 0x48, 0x76, 0x97, 0x52, 0x26, 0x5b, 0x6e, 0xd5, 0xd4, 0x87, 0x00, 0x6f, 0x36, 0x24,
	0xd9, 0x5b, 0x40, 0xba, 0xb4, 0x44, 0xdd, 0xbb, 0x97, 0x26, 0xea, 0x59, 0xf1, 0x7f, 0xc1, 0xbb,
	0xd5, 0xff, 0xd3, 0x86, 0xb6, 0xf1, 0xe9, 0x49, 0x16, 0xc7, 0x38, 0xd2, 0xba, 0x48, 0x68, 0xcf,
	0xde, 0xd8, 0xc4, 0x5f, 0xf0, 0xb1, 0x05, 0x4b, 0xca, 0xed, 0xad, 0x8c, 0x2f, 0x2f, 0xa0, 0x08,
	0x9c, 0xda, 0xbd, 0x44, 0x3e, 0x5b, 0xc2, 0x9f, 0xbe, 0x9a, 0xdd, 0xcf, 0x57, 0x81, 0x96, 0x5f,
	0x39, 0x82, 0xe6, 0xe4, 0xc0, 0x92, 0x4f, 0x17, 0xfb, 0x3f, 0x75, 0xa4, 0xdd, 0xe5, 0x77, 0xe1,
	0x41, 0xef, 0xe7, 0x07, 0xa3, 0x2c, 0x42, 0xff, 0x97, 0x5c, 0x2a, 0x96, 0xfa, 0xea, 0xac, 0x47,
	0x93, 0x8b, 0xb4, 0x77, 0xac, 0x39, 0xfb, 0x25, 0xf8, 0x25, 0x4d, 0x86, 0x11, 0x3d, 0x7e, 0xcd,
	0x04, 0x1f, 0x6e, 0x68, 0x1f, 0x06, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0x06, 0x10, 0x49, 0xd4,
	0xea, 0x09, 0x00, 0x00,
}
