// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: main.proto

/*
Package TwitchBeefcakeTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	main.proto
*/
package TwitchBeefcakeTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ========================
// TwitchBeefcake Interface
// ========================

type TwitchBeefcake interface {
	// GetRoles gets all role
	GetRoles(context.Context, *GetRolesRequest) (*GetRolesResponse, error)

	// CreateRole creates a role
	CreateRole(context.Context, *CreateRoleRequest) (*CreateRoleResponse, error)

	// GetRole gets a role
	GetRole(context.Context, *GetRoleRequest) (*Role, error)

	// UpdateRole updates an existing role
	UpdateRole(context.Context, *UpdateRoleRequest) (*UpdateRoleResponse, error)

	// OverrideRole overrides all permissions for a role
	OverrideRole(context.Context, *OverrideRoleRequest) (*OverrideRoleResponse, error)

	// DeleteRole deletes a role
	DeleteRole(context.Context, *DeleteRoleRequest) (*DeleteRoleResponse, error)

	// AddRolePermission adds a permission for a role
	AddRolePermission(context.Context, *AddRolePermissionRequest) (*AddRolePermissionResponse, error)

	// RemoveRolePermission removes a permission for a role
	RemoveRolePermission(context.Context, *RemoveRolePermissionRequest) (*RemoveRolePermissionResponse, error)

	// UpdateRolePermissionScope updates the scope of a permission for a role.
	// Permissions by default apply to all objects but this will scope a permission
	// to a list of beefcake.PermissionScope.
	//
	// An example would be the Support role with the tos_ban permission. They will
	// be able to tos_ban anyone. If the scope were limited to
	// PermissionScope_ChannelPayoutType_NO_PAYOUT_TYPE, they would only be able
	// to tos_ban on users that have no payout type (i.e. non-partner,
	// non-affiliate, non-developer).
	UpdateRolePermissionScope(context.Context, *UpdateRolePermissionScopeRequest) (*UpdateRolePermissionScopeResponse, error)

	// Add a legacy string permission to a role
	AddLegacyPermissionToRole(context.Context, *AddLegacyPermissionToRoleRequest) (*AddLegacyPermissionToRoleResponse, error)

	// Remove a legacy string permission to a role
	RemoveLegacyPermissionFromRole(context.Context, *RemoveLegacyPermissionFromRoleRequest) (*RemoveLegacyPermissionFromRoleResponse, error)

	// AddUserToRole adds a user to a role
	AddUserToRole(context.Context, *AddUserToRoleRequest) (*AddUserToRoleResponse, error)

	// RemoveUserFromRole removes a user to a role
	RemoveUserFromRole(context.Context, *RemoveUserFromRoleRequest) (*RemoveUserFromRoleResponse, error)

	// User returns a user
	GetUser(context.Context, *GetUserRequest) (*User, error)

	// ReactiveUser - activates an inactive user.
	ReactivateUser(context.Context, *ReactivateUserRequest) (*ReactivateUserResponse, error)

	// GetLegacyPermissions returns a single legacy permission
	GetLegacyPermissions(context.Context, *GetLegacyPermissionsRequest) (*GetLegacyPermissionsResponse, error)

	// CreateLegacyPermission creates a legacy permission
	CreateLegacyPermission(context.Context, *CreateLegacyPermissionRequest) (*CreateLegacyPermissionResponse, error)

	// GetLegacyPermission returns a single legacy permission
	GetLegacyPermission(context.Context, *GetLegacyPermissionRequest) (*LegacyPermission, error)

	// UpdateLegacyPermission updates a legacy permission
	UpdateLegacyPermission(context.Context, *UpdateLegacyPermissionRequest) (*UpdateLegacyPermissionResponse, error)

	// DeleteLegacyPermission deletes a legacy permission
	DeleteLegacyPermission(context.Context, *DeleteLegacyPermissionRequest) (*DeleteLegacyPermissionResponse, error)
}

// ==============================
// TwitchBeefcake Protobuf Client
// ==============================

type twitchBeefcakeProtobufClient struct {
	client HTTPClient
	urls   [20]string
	opts   twirp.ClientOptions
}

// NewTwitchBeefcakeProtobufClient creates a Protobuf client that implements the TwitchBeefcake interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchBeefcakeProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchBeefcake {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchBeefcakePathPrefix
	urls := [20]string{
		prefix + "GetRoles",
		prefix + "CreateRole",
		prefix + "GetRole",
		prefix + "UpdateRole",
		prefix + "OverrideRole",
		prefix + "DeleteRole",
		prefix + "AddRolePermission",
		prefix + "RemoveRolePermission",
		prefix + "UpdateRolePermissionScope",
		prefix + "AddLegacyPermissionToRole",
		prefix + "RemoveLegacyPermissionFromRole",
		prefix + "AddUserToRole",
		prefix + "RemoveUserFromRole",
		prefix + "GetUser",
		prefix + "ReactivateUser",
		prefix + "GetLegacyPermissions",
		prefix + "CreateLegacyPermission",
		prefix + "GetLegacyPermission",
		prefix + "UpdateLegacyPermission",
		prefix + "DeleteLegacyPermission",
	}

	return &twitchBeefcakeProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchBeefcakeProtobufClient) GetRoles(ctx context.Context, in *GetRolesRequest) (*GetRolesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	out := new(GetRolesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) CreateRole(ctx context.Context, in *CreateRoleRequest) (*CreateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	out := new(CreateRoleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) GetRole(ctx context.Context, in *GetRoleRequest) (*Role, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	out := new(Role)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) UpdateRole(ctx context.Context, in *UpdateRoleRequest) (*UpdateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	out := new(UpdateRoleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) OverrideRole(ctx context.Context, in *OverrideRoleRequest) (*OverrideRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	out := new(OverrideRoleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest) (*DeleteRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	out := new(DeleteRoleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) AddRolePermission(ctx context.Context, in *AddRolePermissionRequest) (*AddRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	out := new(AddRolePermissionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) RemoveRolePermission(ctx context.Context, in *RemoveRolePermissionRequest) (*RemoveRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	out := new(RemoveRolePermissionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) UpdateRolePermissionScope(ctx context.Context, in *UpdateRolePermissionScopeRequest) (*UpdateRolePermissionScopeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRolePermissionScope")
	out := new(UpdateRolePermissionScopeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) AddLegacyPermissionToRole(ctx context.Context, in *AddLegacyPermissionToRoleRequest) (*AddLegacyPermissionToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	out := new(AddLegacyPermissionToRoleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) RemoveLegacyPermissionFromRole(ctx context.Context, in *RemoveLegacyPermissionFromRoleRequest) (*RemoveLegacyPermissionFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	out := new(RemoveLegacyPermissionFromRoleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) AddUserToRole(ctx context.Context, in *AddUserToRoleRequest) (*AddUserToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	out := new(AddUserToRoleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) RemoveUserFromRole(ctx context.Context, in *RemoveUserFromRoleRequest) (*RemoveUserFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	out := new(RemoveUserFromRoleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) GetUser(ctx context.Context, in *GetUserRequest) (*User, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(User)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) ReactivateUser(ctx context.Context, in *ReactivateUserRequest) (*ReactivateUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "ReactivateUser")
	out := new(ReactivateUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) GetLegacyPermissions(ctx context.Context, in *GetLegacyPermissionsRequest) (*GetLegacyPermissionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	out := new(GetLegacyPermissionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) CreateLegacyPermission(ctx context.Context, in *CreateLegacyPermissionRequest) (*CreateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	out := new(CreateLegacyPermissionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) GetLegacyPermission(ctx context.Context, in *GetLegacyPermissionRequest) (*LegacyPermission, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	out := new(LegacyPermission)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) UpdateLegacyPermission(ctx context.Context, in *UpdateLegacyPermissionRequest) (*UpdateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	out := new(UpdateLegacyPermissionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeProtobufClient) DeleteLegacyPermission(ctx context.Context, in *DeleteLegacyPermissionRequest) (*DeleteLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	out := new(DeleteLegacyPermissionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================
// TwitchBeefcake JSON Client
// ==========================

type twitchBeefcakeJSONClient struct {
	client HTTPClient
	urls   [20]string
	opts   twirp.ClientOptions
}

// NewTwitchBeefcakeJSONClient creates a JSON client that implements the TwitchBeefcake interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchBeefcakeJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchBeefcake {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchBeefcakePathPrefix
	urls := [20]string{
		prefix + "GetRoles",
		prefix + "CreateRole",
		prefix + "GetRole",
		prefix + "UpdateRole",
		prefix + "OverrideRole",
		prefix + "DeleteRole",
		prefix + "AddRolePermission",
		prefix + "RemoveRolePermission",
		prefix + "UpdateRolePermissionScope",
		prefix + "AddLegacyPermissionToRole",
		prefix + "RemoveLegacyPermissionFromRole",
		prefix + "AddUserToRole",
		prefix + "RemoveUserFromRole",
		prefix + "GetUser",
		prefix + "ReactivateUser",
		prefix + "GetLegacyPermissions",
		prefix + "CreateLegacyPermission",
		prefix + "GetLegacyPermission",
		prefix + "UpdateLegacyPermission",
		prefix + "DeleteLegacyPermission",
	}

	return &twitchBeefcakeJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchBeefcakeJSONClient) GetRoles(ctx context.Context, in *GetRolesRequest) (*GetRolesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	out := new(GetRolesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) CreateRole(ctx context.Context, in *CreateRoleRequest) (*CreateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	out := new(CreateRoleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) GetRole(ctx context.Context, in *GetRoleRequest) (*Role, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	out := new(Role)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) UpdateRole(ctx context.Context, in *UpdateRoleRequest) (*UpdateRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	out := new(UpdateRoleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) OverrideRole(ctx context.Context, in *OverrideRoleRequest) (*OverrideRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	out := new(OverrideRoleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest) (*DeleteRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	out := new(DeleteRoleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) AddRolePermission(ctx context.Context, in *AddRolePermissionRequest) (*AddRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	out := new(AddRolePermissionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) RemoveRolePermission(ctx context.Context, in *RemoveRolePermissionRequest) (*RemoveRolePermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	out := new(RemoveRolePermissionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) UpdateRolePermissionScope(ctx context.Context, in *UpdateRolePermissionScopeRequest) (*UpdateRolePermissionScopeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRolePermissionScope")
	out := new(UpdateRolePermissionScopeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) AddLegacyPermissionToRole(ctx context.Context, in *AddLegacyPermissionToRoleRequest) (*AddLegacyPermissionToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	out := new(AddLegacyPermissionToRoleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) RemoveLegacyPermissionFromRole(ctx context.Context, in *RemoveLegacyPermissionFromRoleRequest) (*RemoveLegacyPermissionFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	out := new(RemoveLegacyPermissionFromRoleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) AddUserToRole(ctx context.Context, in *AddUserToRoleRequest) (*AddUserToRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	out := new(AddUserToRoleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) RemoveUserFromRole(ctx context.Context, in *RemoveUserFromRoleRequest) (*RemoveUserFromRoleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	out := new(RemoveUserFromRoleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) GetUser(ctx context.Context, in *GetUserRequest) (*User, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(User)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) ReactivateUser(ctx context.Context, in *ReactivateUserRequest) (*ReactivateUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "ReactivateUser")
	out := new(ReactivateUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) GetLegacyPermissions(ctx context.Context, in *GetLegacyPermissionsRequest) (*GetLegacyPermissionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	out := new(GetLegacyPermissionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) CreateLegacyPermission(ctx context.Context, in *CreateLegacyPermissionRequest) (*CreateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	out := new(CreateLegacyPermissionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) GetLegacyPermission(ctx context.Context, in *GetLegacyPermissionRequest) (*LegacyPermission, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	out := new(LegacyPermission)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) UpdateLegacyPermission(ctx context.Context, in *UpdateLegacyPermissionRequest) (*UpdateLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	out := new(UpdateLegacyPermissionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchBeefcakeJSONClient) DeleteLegacyPermission(ctx context.Context, in *DeleteLegacyPermissionRequest) (*DeleteLegacyPermissionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	out := new(DeleteLegacyPermissionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =============================
// TwitchBeefcake Server Handler
// =============================

type twitchBeefcakeServer struct {
	TwitchBeefcake
	hooks *twirp.ServerHooks
}

func NewTwitchBeefcakeServer(svc TwitchBeefcake, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchBeefcakeServer{
		TwitchBeefcake: svc,
		hooks:          hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchBeefcakeServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchBeefcakePathPrefix is used for all URL paths on a twirp TwitchBeefcake server.
// Requests are always: POST TwitchBeefcakePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchBeefcakePathPrefix = "/twirp/twitch.fulton.beefcake.TwitchBeefcake/"

func (s *twitchBeefcakeServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.beefcake")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchBeefcake")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetRoles":
		s.serveGetRoles(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/CreateRole":
		s.serveCreateRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetRole":
		s.serveGetRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/UpdateRole":
		s.serveUpdateRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/OverrideRole":
		s.serveOverrideRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/DeleteRole":
		s.serveDeleteRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/AddRolePermission":
		s.serveAddRolePermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/RemoveRolePermission":
		s.serveRemoveRolePermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/UpdateRolePermissionScope":
		s.serveUpdateRolePermissionScope(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/AddLegacyPermissionToRole":
		s.serveAddLegacyPermissionToRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/RemoveLegacyPermissionFromRole":
		s.serveRemoveLegacyPermissionFromRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/AddUserToRole":
		s.serveAddUserToRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/RemoveUserFromRole":
		s.serveRemoveUserFromRole(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetUser":
		s.serveGetUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/ReactivateUser":
		s.serveReactivateUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetLegacyPermissions":
		s.serveGetLegacyPermissions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/CreateLegacyPermission":
		s.serveCreateLegacyPermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/GetLegacyPermission":
		s.serveGetLegacyPermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/UpdateLegacyPermission":
		s.serveUpdateLegacyPermission(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.beefcake.TwitchBeefcake/DeleteLegacyPermission":
		s.serveDeleteLegacyPermission(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchBeefcakeServer) serveGetRoles(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRolesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRolesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetRolesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRolesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRolesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetRoles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRolesResponse and nil error while calling GetRoles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetRolesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRoles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRolesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRolesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetRoles(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRolesResponse and nil error while calling GetRoles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveCreateRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveCreateRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.CreateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRoleResponse and nil error while calling CreateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveCreateRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.CreateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRoleResponse and nil error while calling CreateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Role
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Role and nil error while calling GetRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Role
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Role and nil error while calling GetRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveUpdateRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.UpdateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoleResponse and nil error while calling UpdateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.UpdateRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRoleResponse and nil error while calling UpdateRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveOverrideRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOverrideRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOverrideRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveOverrideRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OverrideRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OverrideRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.OverrideRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OverrideRoleResponse and nil error while calling OverrideRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveOverrideRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OverrideRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(OverrideRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OverrideRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.OverrideRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OverrideRoleResponse and nil error while calling OverrideRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveDeleteRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveDeleteRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.DeleteRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRoleResponse and nil error while calling DeleteRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveDeleteRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.DeleteRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRoleResponse and nil error while calling DeleteRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddRolePermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddRolePermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddRolePermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveAddRolePermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddRolePermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddRolePermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.AddRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddRolePermissionResponse and nil error while calling AddRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddRolePermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddRolePermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddRolePermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.AddRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddRolePermissionResponse and nil error while calling AddRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveRolePermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveRolePermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveRolePermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveRemoveRolePermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveRolePermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveRolePermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.RemoveRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveRolePermissionResponse and nil error while calling RemoveRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveRolePermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveRolePermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveRolePermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveRolePermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.RemoveRolePermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveRolePermissionResponse and nil error while calling RemoveRolePermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateRolePermissionScope(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRolePermissionScopeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRolePermissionScopeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveUpdateRolePermissionScopeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRolePermissionScope")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRolePermissionScopeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRolePermissionScopeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.UpdateRolePermissionScope(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRolePermissionScopeResponse and nil error while calling UpdateRolePermissionScope. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateRolePermissionScopeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRolePermissionScope")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateRolePermissionScopeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRolePermissionScopeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.UpdateRolePermissionScope(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRolePermissionScopeResponse and nil error while calling UpdateRolePermissionScope. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddLegacyPermissionToRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddLegacyPermissionToRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddLegacyPermissionToRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveAddLegacyPermissionToRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddLegacyPermissionToRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddLegacyPermissionToRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.AddLegacyPermissionToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddLegacyPermissionToRoleResponse and nil error while calling AddLegacyPermissionToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddLegacyPermissionToRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddLegacyPermissionToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddLegacyPermissionToRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddLegacyPermissionToRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.AddLegacyPermissionToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddLegacyPermissionToRoleResponse and nil error while calling AddLegacyPermissionToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveLegacyPermissionFromRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveLegacyPermissionFromRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveLegacyPermissionFromRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveRemoveLegacyPermissionFromRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveLegacyPermissionFromRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveLegacyPermissionFromRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.RemoveLegacyPermissionFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveLegacyPermissionFromRoleResponse and nil error while calling RemoveLegacyPermissionFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveLegacyPermissionFromRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveLegacyPermissionFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveLegacyPermissionFromRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveLegacyPermissionFromRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.RemoveLegacyPermissionFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveLegacyPermissionFromRoleResponse and nil error while calling RemoveLegacyPermissionFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddUserToRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddUserToRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddUserToRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveAddUserToRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddUserToRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddUserToRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.AddUserToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddUserToRoleResponse and nil error while calling AddUserToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveAddUserToRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUserToRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddUserToRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddUserToRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.AddUserToRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddUserToRoleResponse and nil error while calling AddUserToRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveUserFromRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveUserFromRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveUserFromRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveRemoveUserFromRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveUserFromRoleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveUserFromRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.RemoveUserFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveUserFromRoleResponse and nil error while calling RemoveUserFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveRemoveUserFromRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUserFromRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveUserFromRoleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveUserFromRoleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.RemoveUserFromRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveUserFromRoleResponse and nil error while calling RemoveUserFromRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *User
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *User and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *User
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *User and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveReactivateUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveReactivateUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveReactivateUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveReactivateUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ReactivateUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ReactivateUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ReactivateUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.ReactivateUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReactivateUserResponse and nil error while calling ReactivateUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveReactivateUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ReactivateUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ReactivateUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ReactivateUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.ReactivateUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReactivateUserResponse and nil error while calling ReactivateUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLegacyPermissionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyPermissionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLegacyPermissionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLegacyPermissionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetLegacyPermissions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyPermissionsResponse and nil error while calling GetLegacyPermissions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermissions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetLegacyPermissionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLegacyPermissionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetLegacyPermissions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLegacyPermissionsResponse and nil error while calling GetLegacyPermissions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveCreateLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveCreateLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateLegacyPermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.CreateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateLegacyPermissionResponse and nil error while calling CreateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveCreateLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateLegacyPermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.CreateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateLegacyPermissionResponse and nil error while calling CreateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *LegacyPermission
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LegacyPermission and nil error while calling GetLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveGetLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *LegacyPermission
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.GetLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *LegacyPermission and nil error while calling GetLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveUpdateLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateLegacyPermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.UpdateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateLegacyPermissionResponse and nil error while calling UpdateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveUpdateLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateLegacyPermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.UpdateLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateLegacyPermissionResponse and nil error while calling UpdateLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveDeleteLegacyPermission(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteLegacyPermissionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteLegacyPermissionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchBeefcakeServer) serveDeleteLegacyPermissionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteLegacyPermissionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteLegacyPermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.DeleteLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteLegacyPermissionResponse and nil error while calling DeleteLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) serveDeleteLegacyPermissionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLegacyPermission")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteLegacyPermissionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteLegacyPermissionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchBeefcake.DeleteLegacyPermission(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteLegacyPermissionResponse and nil error while calling DeleteLegacyPermission. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchBeefcakeServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchBeefcakeServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchBeefcakeServer) PathPrefix() string {
	return TwitchBeefcakePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1702 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0x4f, 0x73, 0xdb, 0x54,
	0x10, 0x8f, 0x6c, 0x27, 0x69, 0xd6, 0x8d, 0xeb, 0xbc, 0x3a, 0xa9, 0xab, 0x26, 0xc1, 0xa8, 0x43,
	0x93, 0x96, 0x54, 0x69, 0x53, 0x28, 0x2d, 0x43, 0x3b, 0xe3, 0xa4, 0x6e, 0xe3, 0x99, 0xb4, 0xc9,
	0xa8, 0x6e, 0xa0, 0x1d, 0x18, 0x8f, 0x62, 0xbd, 0x26, 0x02, 0xdb, 0x32, 0x92, 0x9c, 0x34, 0x70,
	0x62, 0x38, 0x70, 0x63, 0xb8, 0x72, 0x02, 0x4e, 0x70, 0xe1, 0x42, 0x67, 0xf8, 0x20, 0x5c, 0xf8,
	0x02, 0x70, 0xe5, 0xc2, 0x17, 0x60, 0xde, 0xd3, 0x8b, 0xf5, 0xf7, 0x49, 0x72, 0x9a, 0x1e, 0xb8,
	0x59, 0x7e, 0xfb, 0xe7, 0xb7, 0xfb, 0x76, 0xf7, 0xed, 0x2e, 0x40, 0x47, 0xd5, 0xbb, 0x72, 0xcf,
	0x34, 0x6c, 0x03, 0xcd, 0xd8, 0x07, 0xba, 0xdd, 0xda, 0x93, 0x9f, 0xf7, 0xdb, 0xb6, 0xd1, 0x95,
	0x77, 0x30, 0x7e, 0xde, 0x52, 0x3f, 0xc3, 0xe2, 0x1b, 0xbb, 0x86, 0xb1, 0xdb, 0xc6, 0xcb, 0x94,
	0x6a, 0xa7, 0xff, 0x7c, 0xd9, 0xd6, 0x3b, 0xd8, 0xb2, 0xd5, 0x4e, 0xcf, 0x61, 0x14, 0xe7, 0x83,
	0x04, 0x07, 0xa6, 0xda, 0xeb, 0x61, 0xd3, 0x72, 0xce, 0xa5, 0x05, 0x98, 0x5a, 0x33, 0xb1, 0x6a,
	0x63, 0xc5, 0x68, 0x63, 0x05, 0x7f, 0xde, 0xc7, 0x96, 0x8d, 0x10, 0xe4, 0xba, 0x6a, 0x07, 0x97,
	0x85, 0x8a, 0xb0, 0x38, 0xa1, 0xd0, 0xdf, 0xd2, 0x2d, 0x40, 0x5e, 0x42, 0xab, 0x67, 0x74, 0x2d,
	0x8c, 0x0a, 0x90, 0xd1, 0x35, 0x46, 0x97, 0xd1, 0xb5, 0x01, 0x67, 0xc6, 0xc3, 0x79, 0x00, 0xe5,
	0xaa, 0xa6, 0x11, 0xb6, 0x2d, 0x6c, 0x76, 0x74, 0xcb, 0xd2, 0x8d, 0xee, 0x91, 0xa6, 0x73, 0x30,
	0x6e, 0x1a, 0x6d, 0xdc, 0x1c, 0x08, 0x19, 0x23, 0x9f, 0x75, 0x0d, 0xad, 0x02, 0xf4, 0x06, 0xd4,
	0x54, 0x5c, 0x7e, 0x45, 0x92, 0xa3, 0xbd, 0x20, 0x7b, 0xe4, 0x7a, 0xb8, 0xa4, 0x0b, 0x70, 0x3e,
	0x42, 0xb1, 0x83, 0x5c, 0xea, 0x40, 0xa5, 0xaa, 0x69, 0x1b, 0x78, 0x57, 0x6d, 0x1d, 0xba, 0xc7,
	0x0d, 0xc3, 0xeb, 0x07, 0x2e, 0xba, 0x6b, 0x50, 0x6a, 0x53, 0xce, 0xa6, 0xab, 0x8e, 0x50, 0x39,
	0x66, 0xa3, 0x76, 0x40, 0x6a, 0x5d, 0x93, 0x2e, 0xc2, 0x9b, 0x31, 0xea, 0x18, 0x26, 0x13, 0xde,
	0x52, 0x70, 0xc7, 0xd8, 0xc7, 0x41, 0xba, 0xfb, 0xa6, 0xd1, 0x79, 0x4d, 0xc0, 0x16, 0xe1, 0x52,
	0x92, 0x4e, 0x86, 0xee, 0x4f, 0x01, 0xce, 0x6e, 0xee, 0x63, 0xd3, 0xd4, 0x35, 0x5f, 0xb4, 0xa4,
	0x88, 0x01, 0x74, 0x0f, 0xf2, 0x2e, 0x20, 0xab, 0x9c, 0xad, 0x64, 0x53, 0xde, 0xa7, 0x97, 0x0d,
	0x6d, 0x43, 0xb1, 0x6f, 0x61, 0xb3, 0xd9, 0xc1, 0x9d, 0x1d, 0x6c, 0x5a, 0x7b, 0x7a, 0xcf, 0x2a,
	0xe7, 0xa8, 0xa8, 0xb7, 0x79, 0xa2, 0x08, 0x50, 0xf9, 0x89, 0x85, 0xcd, 0x87, 0x03, 0x1e, 0xe5,
	0x4c, 0xdf, 0xf7, 0x6d, 0x49, 0x33, 0x50, 0xf2, 0x1b, 0xc6, 0x2c, 0x9e, 0x82, 0x33, 0x0f, 0xb0,
	0x4d, 0xfe, 0xb2, 0x98, 0xb1, 0xd2, 0xd7, 0x02, 0x14, 0xdd, 0xff, 0x58, 0x16, 0xac, 0xc1, 0x28,
	0xf1, 0xbf, 0x55, 0x16, 0x28, 0x98, 0xab, 0x3c, 0x30, 0x41, 0x46, 0x8a, 0x4e, 0x71, 0x78, 0xc5,
	0x2b, 0x90, 0x23, 0x9f, 0xa9, 0x52, 0xaa, 0x02, 0x05, 0x26, 0x8b, 0x73, 0x09, 0xd2, 0xbf, 0x99,
	0xf4, 0xe2, 0x22, 0xfd, 0x9a, 0x7d, 0x75, 0xbf, 0xa2, 0x0d, 0xff, 0xad, 0x3b, 0x57, 0x75, 0x85,
	0x27, 0xb2, 0x6a, 0xdb, 0x6a, 0x6b, 0x0f, 0x6b, 0x9c, 0xdb, 0x17, 0x7f, 0x14, 0xa0, 0xe0, 0xd7,
	0x48, 0xf2, 0x80, 0x02, 0x77, 0xf3, 0x80, 0x7c, 0xd6, 0x35, 0xf4, 0x3e, 0x00, 0x7e, 0xd1, 0xd3,
	0x4d, 0xd5, 0x76, 0xcb, 0x87, 0x28, 0x3b, 0xb5, 0x50, 0x3e, 0xaa, 0x85, 0x72, 0xe3, 0xa8, 0x58,
	0x2a, 0x1e, 0x6a, 0x74, 0x1b, 0x40, 0x53, 0x6d, 0xdc, 0x54, 0x35, 0x0d, 0x6b, 0xe5, 0x6c, 0x22,
	0xef, 0x04, 0xa1, 0xae, 0x12, 0x62, 0x69, 0x11, 0x8a, 0x8f, 0x6d, 0x53, 0xef, 0xee, 0x56, 0x4d,
	0x53, 0x3d, 0xdc, 0x56, 0xdb, 0x7d, 0x8c, 0x4a, 0x30, 0xba, 0x4f, 0x7e, 0xd0, 0xe0, 0x98, 0x50,
	0x9c, 0x0f, 0xe9, 0xa5, 0x00, 0x53, 0x4f, 0x7a, 0x5a, 0xa0, 0xf0, 0x06, 0x2f, 0xeb, 0x9a, 0xe7,
	0xb2, 0xf2, 0x2b, 0xb3, 0x21, 0x10, 0x8e, 0x32, 0xaa, 0x87, 0x5d, 0xe5, 0xc7, 0x30, 0x1d, 0x55,
	0x00, 0x2c, 0x66, 0xc7, 0x22, 0xcf, 0xf9, 0x41, 0xd8, 0xca, 0xd9, 0x70, 0xad, 0xb0, 0xa4, 0x12,
	0x20, 0x2f, 0x68, 0x96, 0x26, 0x1a, 0x5c, 0x70, 0x4a, 0xc8, 0x90, 0x35, 0x7e, 0x09, 0x10, 0x3d,
	0x88, 0x2a, 0x55, 0x45, 0xd3, 0x27, 0xab, 0xae, 0x49, 0xf3, 0x30, 0x1b, 0xad, 0x85, 0xa1, 0xf8,
	0x45, 0x80, 0x8a, 0x0b, 0xce, 0x25, 0x78, 0xdc, 0x32, 0x7a, 0xf8, 0x64, 0xb1, 0xa0, 0x3b, 0x30,
	0x6a, 0x11, 0xb1, 0x2c, 0x4b, 0x16, 0x92, 0x0b, 0x99, 0x83, 0xc2, 0xe1, 0x22, 0x8f, 0x41, 0x0c,
	0x52, 0x66, 0xcf, 0xf7, 0x02, 0x94, 0xaa, 0x9a, 0x46, 0x22, 0x3e, 0xe5, 0xab, 0xe4, 0xc9, 0x86,
	0x8c, 0x2f, 0x1b, 0x36, 0x61, 0xda, 0x4d, 0xed, 0xa6, 0x27, 0x31, 0x92, 0x83, 0xbb, 0xe4, 0x32,
	0xd6, 0x06, 0x7c, 0xd2, 0x39, 0x98, 0x0e, 0x40, 0x63, 0xa0, 0x1f, 0xc2, 0x79, 0xe7, 0x92, 0xc8,
	0x59, 0xea, 0x57, 0x8b, 0x07, 0x5c, 0x9a, 0x05, 0x31, 0x4a, 0x1c, 0x53, 0x76, 0x11, 0xa6, 0xee,
	0xe1, 0x36, 0x8e, 0x4d, 0x21, 0x12, 0xb2, 0x5e, 0x22, 0xc6, 0x7a, 0x8b, 0x16, 0x50, 0x22, 0x95,
	0x97, 0x7a, 0x33, 0x30, 0xa6, 0x19, 0xa4, 0x03, 0x3b, 0x82, 0xe4, 0x7c, 0x49, 0x7f, 0x67, 0x21,
	0x47, 0xf8, 0x42, 0x0c, 0xdb, 0x40, 0xe3, 0xc4, 0x57, 0x44, 0x33, 0xf1, 0x45, 0x94, 0xc8, 0xa1,
	0x95, 0xd4, 0x5b, 0x44, 0x4d, 0xdf, 0x77, 0xa8, 0x88, 0x66, 0x5f, 0xa9, 0x88, 0x12, 0xb3, 0xd4,
	0x96, 0xad, 0xef, 0xe3, 0x72, 0xae, 0x22, 0x2c, 0x9e, 0x52, 0xd8, 0x97, 0xf8, 0x6d, 0x06, 0x0a,
	0x7e, 0x24, 0xa9, 0x5e, 0x8e, 0x93, 0x8e, 0xac, 0x93, 0x7d, 0x32, 0x02, 0xa5, 0x7c, 0x74, 0x98,
	0x52, 0xbe, 0x00, 0xd3, 0x0a, 0xa6, 0xce, 0x51, 0x6d, 0x1c, 0x13, 0x28, 0x52, 0x19, 0x66, 0x82,
	0x84, 0x2c, 0xc8, 0xe6, 0xe0, 0xc2, 0x03, 0x6c, 0x07, 0xfb, 0xaa, 0x41, 0x2b, 0xf1, 0x8f, 0x00,
	0xb3, 0xd1, 0xe7, 0xac, 0xad, 0xb0, 0x01, 0x85, 0x6a, 0xf9, 0x51, 0x8f, 0x51, 0x8b, 0xe9, 0x31,
	0xb8, 0x12, 0xe5, 0xe0, 0x89, 0x32, 0x15, 0xac, 0xf2, 0x96, 0xf8, 0x11, 0x14, 0x83, 0x64, 0xa9,
	0x42, 0xa1, 0x02, 0x79, 0x0d, 0x5b, 0x2d, 0x53, 0xef, 0x0d, 0x02, 0x60, 0x42, 0xf1, 0xfe, 0x25,
	0x61, 0x98, 0x73, 0x46, 0x88, 0x10, 0x8c, 0x21, 0x3a, 0xc9, 0x64, 0x35, 0x15, 0x98, 0xe7, 0xa9,
	0x61, 0x17, 0xb3, 0x04, 0x62, 0x84, 0x9b, 0x78, 0x17, 0xfc, 0x32, 0xf7, 0xba, 0x3c, 0xe2, 0x36,
	0x8e, 0xb9, 0xf8, 0xc6, 0x31, 0xa8, 0xde, 0xdb, 0x38, 0x12, 0x21, 0xa4, 0x5c, 0x5a, 0xe5, 0xd1,
	0x21, 0x85, 0xd0, 0x60, 0x75, 0x78, 0xc5, 0xdf, 0x87, 0xe9, 0x17, 0x77, 0xb9, 0xfd, 0xe2, 0x07,
	0x43, 0x59, 0x90, 0xd4, 0x40, 0xfe, 0x0f, 0x5a, 0x3e, 0x71, 0x26, 0xfa, 0x39, 0x90, 0x7e, 0x12,
	0x60, 0xce, 0x79, 0xe4, 0xd3, 0x46, 0xfb, 0xf0, 0xcd, 0xde, 0xdd, 0x70, 0x80, 0x25, 0x31, 0x06,
	0x33, 0x85, 0x07, 0x91, 0x65, 0xca, 0x32, 0xcc, 0x39, 0xaf, 0x67, 0xda, 0x64, 0xa9, 0xc0, 0x3c,
	0x8f, 0x81, 0x89, 0xfc, 0x35, 0x07, 0xe0, 0x49, 0xa4, 0x87, 0x30, 0xe6, 0xd4, 0x20, 0x2a, 0x24,
	0xbf, 0x72, 0x23, 0xb9, 0x97, 0x0a, 0x05, 0xd3, 0xfa, 0x88, 0xc2, 0x84, 0xa0, 0x67, 0x90, 0x77,
	0xf8, 0x9b, 0x24, 0x2c, 0x98, 0x2f, 0xdf, 0x4b, 0x21, 0xb3, 0x41, 0x29, 0xc8, 0x55, 0xfa, 0xe4,
	0x82, 0x3d, 0xf8, 0x5f, 0xbc, 0x79, 0xbc, 0x3a, 0x20, 0xfe, 0x96, 0x81, 0x52, 0x94, 0x78, 0xf4,
	0xcc, 0x79, 0x8c, 0x8d, 0x2e, 0x15, 0x50, 0x58, 0x59, 0x3d, 0x26, 0x4e, 0xb9, 0x4a, 0xa5, 0x34,
	0x0e, 0x7b, 0x58, 0x61, 0x12, 0xd1, 0x87, 0x90, 0x55, 0xbb, 0x87, 0xcc, 0x01, 0x6b, 0xc7, 0x16,
	0xdc, 0x3d, 0x54, 0xb0, 0x65, 0xf4, 0xcd, 0x16, 0x5e, 0x1f, 0x51, 0x88, 0x44, 0x74, 0x09, 0x0a,
	0x1e, 0x0f, 0x93, 0x3c, 0xa4, 0x85, 0x6d, 0x7d, 0x44, 0x39, 0xed, 0xfa, 0xaa, 0xae, 0x89, 0x93,
	0x90, 0xf7, 0x70, 0x4b, 0x12, 0x80, 0x8b, 0x12, 0x8d, 0x43, 0xb6, 0xfa, 0xe8, 0x69, 0x71, 0x04,
	0xe5, 0x61, 0xfc, 0x41, 0xad, 0xd1, 0xdc, 0xaa, 0xd7, 0x8b, 0xc2, 0x2a, 0xc0, 0x29, 0x93, 0xd1,
	0xaf, 0x8e, 0xb3, 0xb1, 0x49, 0xfa, 0x59, 0x00, 0x14, 0x7e, 0xe7, 0x43, 0x8e, 0x3f, 0x81, 0x85,
	0xd1, 0xab, 0xb6, 0xf5, 0x7f, 0x08, 0x70, 0x26, 0x70, 0x84, 0x76, 0xa0, 0xd0, 0xda, 0x53, 0xbb,
	0x5d, 0xdc, 0x6e, 0xf6, 0xd4, 0x43, 0xa3, 0x6f, 0xb3, 0xab, 0xbe, 0x9d, 0x52, 0xb6, 0xbc, 0xe6,
	0x70, 0x6f, 0x51, 0x66, 0xe2, 0xbb, 0xf5, 0x11, 0x65, 0xb2, 0xe5, 0xfd, 0x53, 0x52, 0x60, 0x2a,
	0x44, 0x85, 0x10, 0x14, 0x1e, 0x6d, 0x36, 0xb7, 0xaa, 0x4f, 0x37, 0x9f, 0x34, 0x9a, 0x8d, 0xa7,
	0x5b, 0xb5, 0xe2, 0x08, 0x9a, 0x84, 0x89, 0xea, 0xfd, 0xfb, 0xf5, 0x8d, 0x7a, 0xb5, 0x51, 0x2b,
	0x0a, 0xc4, 0xf7, 0x5b, 0x55, 0xa5, 0xf1, 0xa8, 0xa6, 0x14, 0x33, 0xe4, 0xec, 0x5e, 0x6d, 0xbb,
	0xb6, 0xb1, 0xb9, 0x55, 0x53, 0x8a, 0x59, 0xe2, 0x7e, 0x6a, 0xd4, 0xca, 0x5f, 0x08, 0x0a, 0x4e,
	0x68, 0xac, 0x32, 0x88, 0xe8, 0x13, 0x38, 0x75, 0xb4, 0xc9, 0x40, 0x0b, 0xc9, 0xbb, 0x0e, 0x5a,
	0x28, 0xc4, 0xc5, 0xb4, 0x4b, 0x11, 0xd4, 0x02, 0x70, 0x37, 0x8d, 0xe8, 0x32, 0x8f, 0x2f, 0xb4,
	0xb6, 0x14, 0xaf, 0xa4, 0x21, 0x65, 0x4a, 0x36, 0x61, 0x9c, 0x29, 0x46, 0x97, 0x12, 0x90, 0x1d,
	0x89, 0x9f, 0x8d, 0xdb, 0x85, 0x10, 0xd4, 0xee, 0x4c, 0xc7, 0x47, 0x1d, 0x9a, 0xf9, 0xf9, 0xa8,
	0xc3, 0x93, 0x36, 0xd2, 0xe1, 0xb4, 0x77, 0x51, 0x85, 0xb8, 0x93, 0x45, 0xc4, 0x9e, 0x4e, 0x5c,
	0x4a, 0x47, 0xec, 0xde, 0x82, 0x3b, 0x37, 0xf1, 0xed, 0x09, 0x0d, 0x60, 0x7c, 0x7b, 0xc2, 0x63,
	0x18, 0x7a, 0x01, 0x53, 0xa1, 0x0d, 0x2d, 0xba, 0xc6, 0xed, 0xf6, 0x39, 0x5b, 0x64, 0xf1, 0xfa,
	0x10, 0x1c, 0x4c, 0xf3, 0x57, 0x02, 0x94, 0xa2, 0xd6, 0x09, 0x88, 0xfb, 0xfe, 0xc4, 0xac, 0x38,
	0xc4, 0x77, 0x86, 0x63, 0x62, 0x18, 0xbe, 0x13, 0xe0, 0x3c, 0x77, 0x0f, 0x80, 0x6e, 0x25, 0xc7,
	0x45, 0xf4, 0x92, 0x43, 0xbc, 0x7d, 0x0c, 0x4e, 0x0f, 0x24, 0xee, 0x9e, 0x9a, 0x0f, 0x29, 0x69,
	0x93, 0xce, 0x87, 0x94, 0xb8, 0x14, 0x47, 0x3f, 0x08, 0x30, 0x1f, 0xbf, 0xa1, 0x46, 0x77, 0xe2,
	0xdd, 0x9f, 0xb0, 0x4d, 0x17, 0xef, 0x1e, 0x97, 0x9d, 0x21, 0x6c, 0xc3, 0xa4, 0x6f, 0x1b, 0x82,
	0x96, 0x62, 0xac, 0x0d, 0xed, 0x73, 0xc4, 0xab, 0x29, 0xa9, 0x99, 0xb6, 0x2f, 0x01, 0x85, 0x77,
	0x22, 0xe8, 0x7a, 0xbc, 0x0d, 0x11, 0xeb, 0x18, 0x71, 0x65, 0x18, 0x16, 0x5f, 0xd9, 0xa4, 0x0d,
	0x6f, 0x5c, 0xd9, 0xf4, 0xcc, 0xcb, 0xfc, 0xb2, 0x49, 0xa5, 0x18, 0x50, 0xf0, 0x4f, 0xcf, 0xe8,
	0x2a, 0x1f, 0x56, 0xc4, 0x38, 0x2e, 0xca, 0x69, 0xc9, 0x3d, 0x89, 0x1f, 0x35, 0x23, 0xf3, 0x13,
	0x3f, 0x66, 0x86, 0xe7, 0x27, 0x7e, 0xec, 0x60, 0xff, 0x8d, 0x00, 0x33, 0xd1, 0x23, 0x2a, 0x7a,
	0x37, 0xfe, 0x0d, 0xe3, 0xb4, 0xe1, 0xe2, 0xcd, 0x61, 0xd9, 0x18, 0x12, 0x0b, 0xce, 0x46, 0x20,
	0x45, 0x2b, 0x43, 0x98, 0x95, 0xf8, 0xc0, 0x87, 0xa4, 0x13, 0xf3, 0xa3, 0xe7, 0x0e, 0xbe, 0xf9,
	0xb1, 0xa3, 0x14, 0xdf, 0xfc, 0xf8, 0xf1, 0x86, 0x22, 0x89, 0x1e, 0x57, 0xf8, 0x48, 0x62, 0xe7,
	0x21, 0x3e, 0x92, 0xf8, 0xa9, 0x68, 0xf5, 0xf2, 0xb3, 0x85, 0x96, 0xa1, 0x61, 0xf9, 0xd3, 0xbe,
	0x65, 0xeb, 0x5d, 0xd9, 0xde, 0x5f, 0x56, 0x3b, 0x5f, 0x74, 0x97, 0xfd, 0x9d, 0x57, 0xe3, 0x40,
	0x37, 0x7b, 0x3b, 0x63, 0x74, 0xb0, 0xbb, 0xf1, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x46, 0xb6,
	0x85, 0x9a, 0x20, 0x1e, 0x00, 0x00,
}
