package cache_test

import (
	"testing"
	"time"

	cache "code.justin.tv/amzn/TwitchBoundedCache"
	"github.com/stretchr/testify/assert"
)

func TestCachedClock(t *testing.T) {
	clock := cache.NewCachedClock()
	for i := 0; i < 2; i++ {
		startTime := clock.GetCurrentTime()
		time.Sleep(2 * time.Second)
		currentTime := clock.GetCurrentTime()
		assert.Greater(t, currentTime, startTime)
	}

	clock.Stop()
	// sleep for 1 second to make sure the clock is stopped
	// to make the unit test more consistent
	time.Sleep(1 * time.Second)
	currentTime := clock.GetCurrentTime()
	time.Sleep(2 * time.Second)
	assert.Equal(t, currentTime, clock.GetCurrentTime())
}
