package cache

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
)

type Config struct {
	// the maximum number of items can be stored in the cache
	CacheSize int

	// allow to pass in a custom clock that implements the interface to be used to get current time
	// the default is using system clock, i.e time.Now().UnixNano()
	CustomClock Clock

	// an optional call back function when an item is evicted from the cache
	OnEvicted func(string, interface{})

	// the metrics reporter, if the repoter is nil, metrics is not reported
	// If you need to disambiguate between multiple cache instances in your metrics,
	// it is recommended to provide different reporters with different dimensions.
	// For example: `reporter.WithDimensions(map[string]string{"CacheID": "CacheABC"})`
	MetricReporter *telemetry.SampleReporter
}

var DefaultConfig = Config{
	CacheSize: 4096,
}

func FillInDefault(config Config) Config {
	if config.CacheSize == 0 {
		config.CacheSize = DefaultConfig.CacheSize
	}

	if config.CustomClock == nil {
		config.CustomClock = systemClock{}
	}

	return config
}
