// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchCategoryDBTwirp/twirp.proto

/*
Package TwitchCategoryDBTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchCategoryDBTwirp/twirp.proto
*/
package TwitchCategoryDBTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ==========================
// TwitchCategoryDB Interface
// ==========================

type TwitchCategoryDB interface {
	// GetCategoryByID fetches a category by its ID.
	// SLO@500ms
	GetCategoryByID(context.Context, *GetCategoryByIDRequest) (*GetCategoryByIDResponse, error)

	// GetCategoryByName fetches a category by its name.
	// SLO@500ms
	GetCategoryByName(context.Context, *GetCategoryByNameRequest) (*GetCategoryByNameResponse, error)

	// GetCategoryByIGDBID fetches a category by its IGDBD ID.
	// SLO@500ms
	GetCategoryByIGDBID(context.Context, *GetCategoryByIGDBIDRequest) (*GetCategoryByIGDBIDResponse, error)

	// GetCategoriesByIDs fetches a list of categories by ID.
	// Each category requested will be returned at most once; this means if the
	// same ID is passed multiple times, or if a category is not found, the result
	// list will be shorter than the argument list.
	// SLO@500ms
	GetCategoriesByIDs(context.Context, *GetCategoriesByIDsRequest) (*GetCategoriesByIDsResponse, error)

	// CreateCategoryFromName creates a new category with the given name.
	// SLO@500ms
	CreateCategoryFromName(context.Context, *CreateCategoryFromNameRequest) (*CreateCategoryFromNameResponse, error)

	// CreateIGDBCategory creates a new IGDB category. If a category exists with the same
	// IGDB ID, then the create fails.
	// SLO@500ms
	CreateIGDBCategory(context.Context, *CreateIGDBCategoryRequest) (*CreateIGDBCategoryResponse, error)

	// UpdateCategory updates a category.
	// SLO@500ms
	UpdateCategory(context.Context, *UpdateCategoryRequest) (*UpdateCategoryResponse, error)

	// UpdateCategoryName updates the name of a category.
	// SLO@500ms
	UpdateCategoryName(context.Context, *UpdateCategoryNameRequest) (*UpdateCategoryNameResponse, error)

	// DeleteCategory deletes a category.
	// SLO@500ms
	DeleteCategory(context.Context, *DeleteCategoryRequest) (*DeleteCategoryResponse, error)

	// CreateCategoryBanner creates a banner for the given category.
	// SLO@500ms
	CreateCategoryBanner(context.Context, *CreateCategoryBannerRequest) (*CreateCategoryBannerResponse, error)

	// CreateCategoryCoverArt creates a category cover art for the given category.
	// Cover art is automatically synced from IGDB. Uploading using this endpoint will
	// result in the IGDB cover art getting overwritten, and will prevent any future syncs.
	// SLO@500ms
	CreateCategoryCoverArt(context.Context, *CreateCategoryCoverArtRequest) (*CreateCategoryCoverArtResponse, error)

	// CreateAlias creates an alias to the given category.
	// SLO@500ms
	CreateAlias(context.Context, *CreateAliasRequest) (*CreateAliasResponse, error)

	// GetAliases fetches all aliases for the given category.
	// SLO@500ms
	GetAliases(context.Context, *GetAliasesRequest) (*GetAliasesResponse, error)

	// DeleteAlias deletes the alias for the given category and given alias.
	// SLO@500ms
	DeleteAlias(context.Context, *DeleteAliasRequest) (*DeleteAliasResponse, error)

	// CreateLocalizations creates localizations for the given category.
	// SLO@500ms
	CreateLocalizations(context.Context, *CreateLocalizationsRequest) (*CreateLocalizationsResponse, error)

	// GetLocalizations fetches all localizations for the given category.
	// SLO@500ms
	GetLocalizations(context.Context, *GetLocalizationsRequest) (*GetLocalizationsResponse, error)

	// DeleteLocalization deletes a localization for the given category.
	// SLO@500ms
	DeleteLocalization(context.Context, *DeleteLocalizationRequest) (*DeleteLocalizationResponse, error)

	// DeleteAllLocalizations deletes all localizations for the given category.
	// SLO@500ms
	DeleteAllLocalizations(context.Context, *DeleteAllLocalizationsRequest) (*DeleteAllLocalizationsResponse, error)
}

// ================================
// TwitchCategoryDB Protobuf Client
// ================================

type twitchCategoryDBProtobufClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewTwitchCategoryDBProtobufClient creates a Protobuf client that implements the TwitchCategoryDB interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchCategoryDBProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchCategoryDB {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchCategoryDBPathPrefix
	urls := [18]string{
		prefix + "GetCategoryByID",
		prefix + "GetCategoryByName",
		prefix + "GetCategoryByIGDBID",
		prefix + "GetCategoriesByIDs",
		prefix + "CreateCategoryFromName",
		prefix + "CreateIGDBCategory",
		prefix + "UpdateCategory",
		prefix + "UpdateCategoryName",
		prefix + "DeleteCategory",
		prefix + "CreateCategoryBanner",
		prefix + "CreateCategoryCoverArt",
		prefix + "CreateAlias",
		prefix + "GetAliases",
		prefix + "DeleteAlias",
		prefix + "CreateLocalizations",
		prefix + "GetLocalizations",
		prefix + "DeleteLocalization",
		prefix + "DeleteAllLocalizations",
	}

	return &twitchCategoryDBProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchCategoryDBProtobufClient) GetCategoryByID(ctx context.Context, in *GetCategoryByIDRequest) (*GetCategoryByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByID")
	out := new(GetCategoryByIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) GetCategoryByName(ctx context.Context, in *GetCategoryByNameRequest) (*GetCategoryByNameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByName")
	out := new(GetCategoryByNameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) GetCategoryByIGDBID(ctx context.Context, in *GetCategoryByIGDBIDRequest) (*GetCategoryByIGDBIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByIGDBID")
	out := new(GetCategoryByIGDBIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) GetCategoriesByIDs(ctx context.Context, in *GetCategoriesByIDsRequest) (*GetCategoriesByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoriesByIDs")
	out := new(GetCategoriesByIDsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) CreateCategoryFromName(ctx context.Context, in *CreateCategoryFromNameRequest) (*CreateCategoryFromNameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryFromName")
	out := new(CreateCategoryFromNameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) CreateIGDBCategory(ctx context.Context, in *CreateIGDBCategoryRequest) (*CreateIGDBCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateIGDBCategory")
	out := new(CreateIGDBCategoryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) UpdateCategory(ctx context.Context, in *UpdateCategoryRequest) (*UpdateCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategory")
	out := new(UpdateCategoryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) UpdateCategoryName(ctx context.Context, in *UpdateCategoryNameRequest) (*UpdateCategoryNameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategoryName")
	out := new(UpdateCategoryNameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) DeleteCategory(ctx context.Context, in *DeleteCategoryRequest) (*DeleteCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCategory")
	out := new(DeleteCategoryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) CreateCategoryBanner(ctx context.Context, in *CreateCategoryBannerRequest) (*CreateCategoryBannerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryBanner")
	out := new(CreateCategoryBannerResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) CreateCategoryCoverArt(ctx context.Context, in *CreateCategoryCoverArtRequest) (*CreateCategoryCoverArtResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryCoverArt")
	out := new(CreateCategoryCoverArtResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) CreateAlias(ctx context.Context, in *CreateAliasRequest) (*CreateAliasResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAlias")
	out := new(CreateAliasResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) GetAliases(ctx context.Context, in *GetAliasesRequest) (*GetAliasesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetAliases")
	out := new(GetAliasesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) DeleteAlias(ctx context.Context, in *DeleteAliasRequest) (*DeleteAliasResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAlias")
	out := new(DeleteAliasResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) CreateLocalizations(ctx context.Context, in *CreateLocalizationsRequest) (*CreateLocalizationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateLocalizations")
	out := new(CreateLocalizationsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) GetLocalizations(ctx context.Context, in *GetLocalizationsRequest) (*GetLocalizationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetLocalizations")
	out := new(GetLocalizationsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) DeleteLocalization(ctx context.Context, in *DeleteLocalizationRequest) (*DeleteLocalizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLocalization")
	out := new(DeleteLocalizationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBProtobufClient) DeleteAllLocalizations(ctx context.Context, in *DeleteAllLocalizationsRequest) (*DeleteAllLocalizationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllLocalizations")
	out := new(DeleteAllLocalizationsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================
// TwitchCategoryDB JSON Client
// ============================

type twitchCategoryDBJSONClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewTwitchCategoryDBJSONClient creates a JSON client that implements the TwitchCategoryDB interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchCategoryDBJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchCategoryDB {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchCategoryDBPathPrefix
	urls := [18]string{
		prefix + "GetCategoryByID",
		prefix + "GetCategoryByName",
		prefix + "GetCategoryByIGDBID",
		prefix + "GetCategoriesByIDs",
		prefix + "CreateCategoryFromName",
		prefix + "CreateIGDBCategory",
		prefix + "UpdateCategory",
		prefix + "UpdateCategoryName",
		prefix + "DeleteCategory",
		prefix + "CreateCategoryBanner",
		prefix + "CreateCategoryCoverArt",
		prefix + "CreateAlias",
		prefix + "GetAliases",
		prefix + "DeleteAlias",
		prefix + "CreateLocalizations",
		prefix + "GetLocalizations",
		prefix + "DeleteLocalization",
		prefix + "DeleteAllLocalizations",
	}

	return &twitchCategoryDBJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchCategoryDBJSONClient) GetCategoryByID(ctx context.Context, in *GetCategoryByIDRequest) (*GetCategoryByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByID")
	out := new(GetCategoryByIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) GetCategoryByName(ctx context.Context, in *GetCategoryByNameRequest) (*GetCategoryByNameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByName")
	out := new(GetCategoryByNameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) GetCategoryByIGDBID(ctx context.Context, in *GetCategoryByIGDBIDRequest) (*GetCategoryByIGDBIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByIGDBID")
	out := new(GetCategoryByIGDBIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) GetCategoriesByIDs(ctx context.Context, in *GetCategoriesByIDsRequest) (*GetCategoriesByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoriesByIDs")
	out := new(GetCategoriesByIDsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) CreateCategoryFromName(ctx context.Context, in *CreateCategoryFromNameRequest) (*CreateCategoryFromNameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryFromName")
	out := new(CreateCategoryFromNameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) CreateIGDBCategory(ctx context.Context, in *CreateIGDBCategoryRequest) (*CreateIGDBCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateIGDBCategory")
	out := new(CreateIGDBCategoryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) UpdateCategory(ctx context.Context, in *UpdateCategoryRequest) (*UpdateCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategory")
	out := new(UpdateCategoryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) UpdateCategoryName(ctx context.Context, in *UpdateCategoryNameRequest) (*UpdateCategoryNameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategoryName")
	out := new(UpdateCategoryNameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) DeleteCategory(ctx context.Context, in *DeleteCategoryRequest) (*DeleteCategoryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCategory")
	out := new(DeleteCategoryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) CreateCategoryBanner(ctx context.Context, in *CreateCategoryBannerRequest) (*CreateCategoryBannerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryBanner")
	out := new(CreateCategoryBannerResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) CreateCategoryCoverArt(ctx context.Context, in *CreateCategoryCoverArtRequest) (*CreateCategoryCoverArtResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryCoverArt")
	out := new(CreateCategoryCoverArtResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) CreateAlias(ctx context.Context, in *CreateAliasRequest) (*CreateAliasResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAlias")
	out := new(CreateAliasResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) GetAliases(ctx context.Context, in *GetAliasesRequest) (*GetAliasesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetAliases")
	out := new(GetAliasesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) DeleteAlias(ctx context.Context, in *DeleteAliasRequest) (*DeleteAliasResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAlias")
	out := new(DeleteAliasResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) CreateLocalizations(ctx context.Context, in *CreateLocalizationsRequest) (*CreateLocalizationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "CreateLocalizations")
	out := new(CreateLocalizationsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) GetLocalizations(ctx context.Context, in *GetLocalizationsRequest) (*GetLocalizationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "GetLocalizations")
	out := new(GetLocalizationsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) DeleteLocalization(ctx context.Context, in *DeleteLocalizationRequest) (*DeleteLocalizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLocalization")
	out := new(DeleteLocalizationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchCategoryDBJSONClient) DeleteAllLocalizations(ctx context.Context, in *DeleteAllLocalizationsRequest) (*DeleteAllLocalizationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllLocalizations")
	out := new(DeleteAllLocalizationsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===============================
// TwitchCategoryDB Server Handler
// ===============================

type twitchCategoryDBServer struct {
	TwitchCategoryDB
	hooks *twirp.ServerHooks
}

func NewTwitchCategoryDBServer(svc TwitchCategoryDB, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchCategoryDBServer{
		TwitchCategoryDB: svc,
		hooks:            hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchCategoryDBServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchCategoryDBPathPrefix is used for all URL paths on a twirp TwitchCategoryDB server.
// Requests are always: POST TwitchCategoryDBPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchCategoryDBPathPrefix = "/twirp/twitchcategorydb.TwitchCategoryDB/"

func (s *twitchCategoryDBServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitchcategorydb")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchCategoryDB")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitchcategorydb.TwitchCategoryDB/GetCategoryByID":
		s.serveGetCategoryByID(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/GetCategoryByName":
		s.serveGetCategoryByName(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/GetCategoryByIGDBID":
		s.serveGetCategoryByIGDBID(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/GetCategoriesByIDs":
		s.serveGetCategoriesByIDs(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/CreateCategoryFromName":
		s.serveCreateCategoryFromName(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/CreateIGDBCategory":
		s.serveCreateIGDBCategory(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/UpdateCategory":
		s.serveUpdateCategory(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/UpdateCategoryName":
		s.serveUpdateCategoryName(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/DeleteCategory":
		s.serveDeleteCategory(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/CreateCategoryBanner":
		s.serveCreateCategoryBanner(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/CreateCategoryCoverArt":
		s.serveCreateCategoryCoverArt(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/CreateAlias":
		s.serveCreateAlias(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/GetAliases":
		s.serveGetAliases(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/DeleteAlias":
		s.serveDeleteAlias(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/CreateLocalizations":
		s.serveCreateLocalizations(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/GetLocalizations":
		s.serveGetLocalizations(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/DeleteLocalization":
		s.serveDeleteLocalization(ctx, resp, req)
		return
	case "/twirp/twitchcategorydb.TwitchCategoryDB/DeleteAllLocalizations":
		s.serveDeleteAllLocalizations(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchCategoryDBServer) serveGetCategoryByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCategoryByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCategoryByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveGetCategoryByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCategoryByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCategoryByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetCategoryByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryByIDResponse and nil error while calling GetCategoryByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetCategoryByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCategoryByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCategoryByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetCategoryByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryByIDResponse and nil error while calling GetCategoryByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetCategoryByName(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCategoryByNameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCategoryByNameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveGetCategoryByNameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByName")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCategoryByNameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCategoryByNameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetCategoryByName(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryByNameResponse and nil error while calling GetCategoryByName. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetCategoryByNameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByName")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCategoryByNameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCategoryByNameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetCategoryByName(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryByNameResponse and nil error while calling GetCategoryByName. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetCategoryByIGDBID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCategoryByIGDBIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCategoryByIGDBIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveGetCategoryByIGDBIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByIGDBID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCategoryByIGDBIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCategoryByIGDBIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetCategoryByIGDBID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryByIGDBIDResponse and nil error while calling GetCategoryByIGDBID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetCategoryByIGDBIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoryByIGDBID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCategoryByIGDBIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCategoryByIGDBIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetCategoryByIGDBID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoryByIGDBIDResponse and nil error while calling GetCategoryByIGDBID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetCategoriesByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCategoriesByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCategoriesByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveGetCategoriesByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoriesByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCategoriesByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCategoriesByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetCategoriesByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoriesByIDsResponse and nil error while calling GetCategoriesByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetCategoriesByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCategoriesByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCategoriesByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCategoriesByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetCategoriesByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCategoriesByIDsResponse and nil error while calling GetCategoriesByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateCategoryFromName(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCategoryFromNameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCategoryFromNameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveCreateCategoryFromNameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryFromName")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCategoryFromNameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCategoryFromNameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateCategoryFromName(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCategoryFromNameResponse and nil error while calling CreateCategoryFromName. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateCategoryFromNameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryFromName")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateCategoryFromNameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCategoryFromNameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateCategoryFromName(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCategoryFromNameResponse and nil error while calling CreateCategoryFromName. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateIGDBCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateIGDBCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateIGDBCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveCreateIGDBCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateIGDBCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateIGDBCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateIGDBCategoryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateIGDBCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateIGDBCategoryResponse and nil error while calling CreateIGDBCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateIGDBCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateIGDBCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateIGDBCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateIGDBCategoryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateIGDBCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateIGDBCategoryResponse and nil error while calling CreateIGDBCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveUpdateCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveUpdateCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateCategoryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.UpdateCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCategoryResponse and nil error while calling UpdateCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveUpdateCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateCategoryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.UpdateCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCategoryResponse and nil error while calling UpdateCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveUpdateCategoryName(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCategoryNameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCategoryNameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveUpdateCategoryNameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategoryName")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCategoryNameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateCategoryNameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.UpdateCategoryName(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCategoryNameResponse and nil error while calling UpdateCategoryName. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveUpdateCategoryNameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCategoryName")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateCategoryNameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateCategoryNameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.UpdateCategoryName(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCategoryNameResponse and nil error while calling UpdateCategoryName. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveDeleteCategory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteCategoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteCategoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveDeleteCategoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteCategoryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteCategoryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.DeleteCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteCategoryResponse and nil error while calling DeleteCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveDeleteCategoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCategory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteCategoryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteCategoryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.DeleteCategory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteCategoryResponse and nil error while calling DeleteCategory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateCategoryBanner(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCategoryBannerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCategoryBannerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveCreateCategoryBannerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryBanner")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCategoryBannerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCategoryBannerResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateCategoryBanner(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCategoryBannerResponse and nil error while calling CreateCategoryBanner. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateCategoryBannerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryBanner")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateCategoryBannerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCategoryBannerResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateCategoryBanner(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCategoryBannerResponse and nil error while calling CreateCategoryBanner. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateCategoryCoverArt(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCategoryCoverArtJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCategoryCoverArtProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveCreateCategoryCoverArtJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryCoverArt")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCategoryCoverArtRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCategoryCoverArtResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateCategoryCoverArt(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCategoryCoverArtResponse and nil error while calling CreateCategoryCoverArt. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateCategoryCoverArtProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCategoryCoverArt")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateCategoryCoverArtRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCategoryCoverArtResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateCategoryCoverArt(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCategoryCoverArtResponse and nil error while calling CreateCategoryCoverArt. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateAlias(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateAliasJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateAliasProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveCreateAliasJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAlias")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateAliasRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateAliasResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateAlias(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAliasResponse and nil error while calling CreateAlias. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateAliasProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAlias")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateAliasRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateAliasResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateAlias(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAliasResponse and nil error while calling CreateAlias. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetAliases(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAliasesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAliasesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveGetAliasesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAliases")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAliasesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAliasesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetAliases(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAliasesResponse and nil error while calling GetAliases. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetAliasesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAliases")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAliasesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAliasesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetAliases(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAliasesResponse and nil error while calling GetAliases. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveDeleteAlias(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteAliasJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteAliasProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveDeleteAliasJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAlias")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteAliasRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteAliasResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.DeleteAlias(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAliasResponse and nil error while calling DeleteAlias. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveDeleteAliasProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAlias")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteAliasRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteAliasResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.DeleteAlias(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAliasResponse and nil error while calling DeleteAlias. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateLocalizations(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateLocalizationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateLocalizationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveCreateLocalizationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateLocalizations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateLocalizationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateLocalizationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateLocalizations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateLocalizationsResponse and nil error while calling CreateLocalizations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveCreateLocalizationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateLocalizations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateLocalizationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateLocalizationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.CreateLocalizations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateLocalizationsResponse and nil error while calling CreateLocalizations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetLocalizations(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLocalizationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLocalizationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveGetLocalizationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLocalizations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLocalizationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLocalizationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetLocalizations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLocalizationsResponse and nil error while calling GetLocalizations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveGetLocalizationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLocalizations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetLocalizationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLocalizationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.GetLocalizations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLocalizationsResponse and nil error while calling GetLocalizations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveDeleteLocalization(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteLocalizationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteLocalizationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveDeleteLocalizationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLocalization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteLocalizationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteLocalizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.DeleteLocalization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteLocalizationResponse and nil error while calling DeleteLocalization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveDeleteLocalizationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteLocalization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteLocalizationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteLocalizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.DeleteLocalization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteLocalizationResponse and nil error while calling DeleteLocalization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveDeleteAllLocalizations(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteAllLocalizationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteAllLocalizationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchCategoryDBServer) serveDeleteAllLocalizationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllLocalizations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteAllLocalizationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteAllLocalizationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.DeleteAllLocalizations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAllLocalizationsResponse and nil error while calling DeleteAllLocalizations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) serveDeleteAllLocalizationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllLocalizations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteAllLocalizationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteAllLocalizationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchCategoryDB.DeleteAllLocalizations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAllLocalizationsResponse and nil error while calling DeleteAllLocalizations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchCategoryDBServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchCategoryDBServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchCategoryDBServer) PathPrefix() string {
	return TwitchCategoryDBPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2666 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5a, 0xcd, 0x72, 0xdb, 0xc8,
	0x11, 0x36, 0x25, 0x92, 0x22, 0x9b, 0x14, 0x05, 0x8d, 0x7e, 0x0c, 0xd1, 0x96, 0xa2, 0xa2, 0xd7,
	0x6b, 0xf9, 0x8f, 0x72, 0x94, 0x5d, 0x57, 0xec, 0xaa, 0x5d, 0x2d, 0x29, 0xd2, 0x12, 0x1d, 0xc9,
	0x52, 0x20, 0x6a, 0x63, 0xbb, 0x2a, 0x61, 0x81, 0xc4, 0x88, 0x46, 0x0c, 0x12, 0x5c, 0x00, 0xb2,
	0xcd, 0x75, 0xa5, 0xf2, 0x18, 0x79, 0x85, 0x5c, 0xf2, 0x0e, 0x39, 0xe6, 0x9a, 0x43, 0x2a, 0xb7,
	0x3c, 0x45, 0x4e, 0x39, 0xa5, 0x66, 0x30, 0x03, 0x0e, 0x40, 0x40, 0x04, 0x6d, 0x95, 0x2f, 0x12,
	0x67, 0xa6, 0xfb, 0xeb, 0xee, 0x99, 0x9e, 0xbf, 0x6f, 0x00, 0xdf, 0x76, 0x4c, 0x0d, 0x97, 0xff,
	0x78, 0x61, 0x3b, 0x7a, 0xbf, 0xec, 0xbc, 0xdb, 0x56, 0x7b, 0x3f, 0xf7, 0xb7, 0x9b, 0xef, 0x75,
	0xa7, 0xf3, 0x66, 0x4f, 0x75, 0x70, 0xd7, 0xb4, 0x86, 0xb5, 0x6a, 0xf3, 0xbd, 0x6e, 0x0d, 0xb6,
	0x1d, 0xf2, 0xb7, 0x3c, 0xb0, 0x4c, 0xc7, 0x44, 0x92, 0x43, 0x45, 0x3a, 0x4c, 0x44, 0x6b, 0x17,
	0x37, 0xba, 0xa6, 0xd9, 0x35, 0xf0, 0x36, 0x6d, 0x6f, 0x5f, 0x9c, 0x6f, 0xbf, 0xb7, 0xd4, 0xc1,
	0x00, 0x5b, 0xb6, 0xab, 0x51, 0xfc, 0x45, 0xb0, 0xdd, 0xd1, 0x7b, 0xd8, 0x76, 0xd4, 0x1e, 0x83,
	0x2c, 0xbd, 0x85, 0xd5, 0x7d, 0xec, 0x70, 0xa3, 0xd5, 0x61, 0xa3, 0xa6, 0xe0, 0x9f, 0x2e, 0xb0,
	0xed, 0xa0, 0x02, 0xcc, 0xe8, 0x9a, 0x9c, 0xd8, 0x4c, 0x6c, 0xa5, 0x94, 0x19, 0x5d, 0x43, 0xab,
	0x90, 0x36, 0xcc, 0x8e, 0x6a, 0x60, 0x79, 0x66, 0x33, 0xb1, 0x95, 0x55, 0x58, 0x09, 0xdd, 0x05,
	0x49, 0xef, 0x77, 0x8c, 0x0b, 0x0d, 0xb7, 0xf0, 0x07, 0x07, 0xf7, 0x35, 0xac, 0xc9, 0xb3, 0x9b,
	0x89, 0xad, 0x8c, 0xb2, 0xc0, 0xea, 0xeb, 0xac, 0xba, 0xf4, 0x13, 0xc8, 0x3e, 0x63, 0x2f, 0xd4,
	0x1e, 0xe6, 0xe6, 0x10, 0x24, 0xfb, 0x6a, 0x0f, 0x53, 0x83, 0x59, 0x85, 0xfe, 0xbe, 0x0a, 0x93,
	0x1f, 0xa0, 0xe8, 0x8f, 0x6f, 0xbf, 0x56, 0x1d, 0xc5, 0x78, 0x1d, 0xe6, 0xf4, 0xae, 0xd6, 0x6e,
	0xb1, 0x40, 0xb3, 0x4a, 0x9a, 0x14, 0x1b, 0x57, 0x12, 0xec, 0x5f, 0x13, 0xb0, 0x36, 0x32, 0xad,
	0x63, 0x9b, 0x74, 0xae, 0xcd, 0x2d, 0x4b, 0x30, 0xab, 0x6b, 0xb6, 0x9c, 0xd8, 0x9c, 0xdd, 0x4a,
	0x29, 0xe4, 0xe7, 0x15, 0x98, 0x44, 0x8f, 0x21, 0x63, 0x5a, 0x1a, 0xb6, 0xf4, 0x7e, 0x57, 0x4e,
	0x6e, 0x26, 0xb6, 0x0a, 0x3b, 0xc5, 0x72, 0x30, 0x65, 0xca, 0xc7, 0x4c, 0x42, 0xf1, 0x64, 0x4b,
	0x0a, 0xac, 0xef, 0x59, 0x58, 0x75, 0x30, 0xef, 0xa7, 0x67, 0x96, 0xd9, 0x9b, 0x34, 0x38, 0xeb,
	0x00, 0x1d, 0xaa, 0xa4, 0xb5, 0xda, 0x43, 0xe6, 0x73, 0x96, 0xd5, 0x54, 0x87, 0xa5, 0x8f, 0xb0,
	0xe6, 0x62, 0x92, 0x1e, 0xe7, 0xb8, 0x1c, 0x6f, 0x17, 0xe6, 0x69, 0xbf, 0x73, 0xb7, 0x28, 0x70,
	0x2e, 0xcc, 0x5b, 0x4f, 0x33, 0x4f, 0x14, 0x78, 0x69, 0x92, 0xf1, 0xff, 0x2c, 0xc2, 0xca, 0xd9,
	0x40, 0x13, 0x22, 0xe2, 0x96, 0xd7, 0x21, 0xeb, 0xda, 0xe0, 0x63, 0x9e, 0x3a, 0xb8, 0xa6, 0x64,
	0xdc, 0xaa, 0x86, 0x86, 0xd6, 0x46, 0x09, 0x41, 0x41, 0x0f, 0xae, 0x79, 0x29, 0xb1, 0x0e, 0x70,
	0x41, 0x21, 0xa9, 0xc9, 0x59, 0xd7, 0x24, 0xab, 0xa9, 0x0e, 0xd1, 0x2e, 0xe4, 0x79, 0x33, 0xed,
	0xaa, 0x24, 0x8d, 0xe8, 0x66, 0xd9, 0x9d, 0x80, 0x65, 0x3e, 0x01, 0xcb, 0xa7, 0x0e, 0xe9, 0xf2,
	0x1f, 0x55, 0xe3, 0x02, 0x2b, 0x39, 0xa6, 0x41, 0xba, 0x5a, 0x04, 0x70, 0x86, 0x03, 0x2c, 0xa7,
	0xa7, 0x00, 0x68, 0x0e, 0x07, 0x18, 0x35, 0x01, 0x71, 0x00, 0x0d, 0xbf, 0xc3, 0x86, 0x49, 0xd6,
	0x01, 0x79, 0x8e, 0xc2, 0xdc, 0x0e, 0xc9, 0x83, 0x81, 0xa3, 0x9b, 0x7d, 0xd5, 0x70, 0xf1, 0x2a,
	0x96, 0xa5, 0x0e, 0x95, 0x45, 0x06, 0x50, 0xf3, 0xf4, 0x45, 0xd4, 0xc1, 0x45, 0xdb, 0xd0, 0xed,
	0x37, 0x04, 0x35, 0xf3, 0x29, 0xa8, 0x27, 0x9e, 0x3e, 0x3a, 0x84, 0x82, 0x17, 0xec, 0x1b, 0xdc,
	0xc3, 0xb6, 0x9c, 0x9d, 0x06, 0x71, 0x9e, 0xc7, 0x4d, 0x75, 0xd1, 0x09, 0x48, 0x1c, 0xad, 0x63,
	0xf6, 0x3b, 0x78, 0xe0, 0xd8, 0x32, 0x4c, 0x83, 0xb7, 0xc0, 0xd4, 0xf7, 0x98, 0xb6, 0x18, 0xf5,
	0xb9, 0xa5, 0xf6, 0x3b, 0x6f, 0x74, 0x1b, 0xdb, 0x72, 0xee, 0x53, 0xa2, 0x7e, 0xe6, 0xe9, 0xa3,
	0x57, 0xb0, 0xc2, 0x51, 0x6d, 0xbd, 0xa7, 0x1b, 0xaa, 0xd5, 0xea, 0xaa, 0x24, 0xf8, 0xfc, 0x34,
	0xc0, 0x4b, 0x0c, 0xe3, 0xd4, 0x85, 0xd8, 0x27, 0x08, 0x48, 0x81, 0x45, 0x6f, 0x98, 0x0c, 0xd5,
	0x39, 0x37, 0xad, 0x9e, 0x2d, 0xcf, 0x4f, 0x03, 0xcb, 0xbb, 0xf0, 0x84, 0xab, 0x8b, 0x83, 0xd4,
	0xc5, 0x7d, 0x0b, 0xdb, 0x72, 0xe1, 0x53, 0x06, 0x69, 0x9f, 0xea, 0x8a, 0x83, 0xf4, 0x16, 0x0f,
	0xdf, 0x9b, 0x96, 0x66, 0xcb, 0x0b, 0x9f, 0x32, 0x48, 0xbf, 0x61, 0xda, 0xe8, 0x39, 0x70, 0x13,
	0xad, 0x9e, 0xa9, 0x61, 0x5b, 0x96, 0xa6, 0x81, 0xe3, 0xb3, 0xed, 0x88, 0xa8, 0xa2, 0x97, 0xb0,
	0xec, 0xf5, 0x1f, 0xb6, 0xec, 0x01, 0xee, 0x38, 0xfa, 0x3b, 0x6c, 0xcb, 0x8b, 0x9f, 0x32, 0x32,
	0x27, 0x02, 0x02, 0x6a, 0xc1, 0x3a, 0x47, 0x36, 0x2d, 0xbd, 0xab, 0xf7, 0x55, 0xa3, 0x65, 0x61,
	0x03, 0xab, 0x36, 0x6e, 0x91, 0x6a, 0x19, 0xc5, 0x98, 0xe8, 0x45, 0x06, 0x71, 0xcc, 0x10, 0x14,
	0x17, 0xa0, 0xa6, 0x3a, 0x18, 0x1d, 0xc1, 0xd2, 0x68, 0xde, 0xdb, 0x1d, 0x4b, 0xa7, 0x9e, 0xc9,
	0x4b, 0x31, 0x60, 0x91, 0x37, 0xdf, 0x3d, 0x3d, 0xf4, 0x6c, 0x34, 0x4e, 0x74, 0x29, 0xbc, 0xb0,
	0x0c, 0x79, 0x39, 0x06, 0x16, 0xcf, 0x95, 0x46, 0x57, 0x6b, 0x9f, 0x59, 0x86, 0xb8, 0x9e, 0xd9,
	0xc6, 0x45, 0x57, 0x5e, 0x99, 0x62, 0x3d, 0x3b, 0x35, 0x2e, 0xba, 0xe8, 0x40, 0x48, 0x69, 0x0b,
	0xdb, 0x8e, 0x49, 0x56, 0xe5, 0xd5, 0x18, 0x28, 0x3c, 0x51, 0x4e, 0xa8, 0x56, 0x43, 0x43, 0xcf,
	0x47, 0x89, 0xac, 0xf7, 0xd4, 0x2e, 0xb6, 0xe5, 0xeb, 0x14, 0xe6, 0xd6, 0xa4, 0x61, 0x3d, 0x52,
	0x07, 0x5e, 0x1a, 0x37, 0xa8, 0x26, 0xaa, 0xc1, 0x82, 0xaf, 0x7b, 0x74, 0x4d, 0x96, 0x63, 0xf8,
	0x34, 0x2f, 0xf4, 0x4e, 0x43, 0x43, 0xcd, 0xd1, 0x98, 0x61, 0xdb, 0x6a, 0xb7, 0x2c, 0xd5, 0x21,
	0x9b, 0xf6, 0x1a, 0x45, 0xfa, 0x2a, 0xda, 0xad, 0xfa, 0xa9, 0x52, 0x55, 0xa8, 0xac, 0xb7, 0xbe,
	0xd4, 0x6d, 0xab, 0xed, 0x56, 0x21, 0x15, 0xd6, 0x7c, 0xa8, 0x42, 0x3a, 0xd8, 0x72, 0x71, 0x9a,
	0x4c, 0xbe, 0x2e, 0x80, 0x0b, 0xc9, 0x41, 0x16, 0x46, 0xde, 0xd4, 0x52, 0xfb, 0x9a, 0x65, 0xea,
	0x5a, 0x6b, 0xa0, 0x76, 0xde, 0xaa, 0x5d, 0x2c, 0xdf, 0x88, 0xd1, 0x0d, 0x7c, 0xfd, 0xab, 0xb8,
	0xba, 0x27, 0xae, 0x2a, 0x52, 0x46, 0xa8, 0xe7, 0xa6, 0xd5, 0xc1, 0x2d, 0xbd, 0xdf, 0xc5, 0x36,
	0x4d, 0xe3, 0x9b, 0xec, 0x64, 0x10, 0x44, 0xad, 0x9a, 0xa6, 0xe1, 0xc7, 0x7c, 0x46, 0x34, 0x1b,
	0x5c, 0x11, 0xfd, 0x5e, 0xf0, 0x54, 0xd3, 0x74, 0x37, 0xc6, 0x96, 0xa3, 0x76, 0x6d, 0x79, 0x7d,
	0x9a, 0xae, 0xf0, 0x5c, 0xf6, 0x40, 0x9a, 0x6a, 0xd7, 0x46, 0xaf, 0x47, 0x6b, 0xb9, 0x38, 0x9b,
	0x6d, 0x79, 0x83, 0x82, 0x7f, 0x1d, 0x0d, 0x2e, 0xcc, 0x5d, 0xdb, 0x5b, 0x32, 0xc4, 0xca, 0x6a,
	0x92, 0x1c, 0xbd, 0x9f, 0x27, 0x33, 0x29, 0x29, 0xad, 0x78, 0xcb, 0x52, 0x57, 0x57, 0xfb, 0x4e,
	0xdb, 0xec, 0x91, 0x94, 0x2b, 0x3d, 0x84, 0xa5, 0x10, 0x5f, 0xc9, 0x19, 0xf2, 0x1d, 0xe9, 0x13,
	0xf7, 0x60, 0x99, 0x55, 0x58, 0xa9, 0xf4, 0x97, 0x04, 0x2c, 0x8e, 0x65, 0x36, 0xda, 0xf7, 0x49,
	0xe7, 0x76, 0xb6, 0x63, 0x4c, 0x87, 0x32, 0xed, 0x73, 0xbb, 0xde, 0x77, 0xac, 0x21, 0x87, 0x2f,
	0x3e, 0x81, 0x9c, 0x50, 0x4d, 0xce, 0xb6, 0x6f, 0xf1, 0x90, 0x1d, 0x16, 0xc9, 0x4f, 0xb4, 0x0c,
	0x29, 0x2a, 0xca, 0x4e, 0x6a, 0x6e, 0xe1, 0xe9, 0xcc, 0xaf, 0x13, 0xa5, 0x03, 0x40, 0xe3, 0xb9,
	0x8d, 0x76, 0xb8, 0x7c, 0x82, 0x9e, 0x62, 0x6f, 0x8e, 0x3b, 0x26, 0x4c, 0x04, 0x57, 0xb4, 0x74,
	0x04, 0xcb, 0x61, 0x3d, 0x8c, 0xbe, 0x0d, 0x44, 0xb9, 0x3e, 0x0e, 0x26, 0xc8, 0x7b, 0x5d, 0xf6,
	0x07, 0x58, 0xf3, 0x9f, 0x20, 0xc5, 0xf3, 0x70, 0xf0, 0x6e, 0xc4, 0xcf, 0xc7, 0x33, 0xfe, 0xf3,
	0xf1, 0x25, 0xe7, 0xc5, 0xd2, 0x07, 0x58, 0xa9, 0x61, 0x03, 0x8f, 0x9f, 0x50, 0x83, 0xd8, 0x8f,
	0x20, 0x6d, 0x61, 0xd5, 0x36, 0xfb, 0x14, 0xbd, 0xb0, 0x23, 0x87, 0xf9, 0x4f, 0xda, 0x15, 0x26,
	0x47, 0x2c, 0x6b, 0x14, 0x5a, 0xb4, 0xcc, 0x6a, 0xe8, 0xc9, 0xfc, 0x86, 0xff, 0xb4, 0x5f, 0x55,
	0xfb, 0x7d, 0x6c, 0x45, 0xd9, 0x7f, 0x08, 0x4b, 0x74, 0xd1, 0x6c, 0xb5, 0x87, 0x0e, 0xb6, 0x5b,
	0x6d, 0x92, 0xe9, 0x8f, 0xbf, 0x61, 0xa1, 0x4a, 0xb4, 0xa9, 0x4a, 0x5a, 0xaa, 0xaa, 0x8d, 0x1f,
	0x7f, 0x33, 0x29, 0xec, 0x3f, 0x05, 0xaf, 0x1a, 0x7b, 0xe6, 0x3b, 0x6c, 0x55, 0x2c, 0xe7, 0xcb,
	0x98, 0x7f, 0x05, 0xc8, 0x35, 0x5f, 0x31, 0x74, 0xd5, 0x8e, 0xb2, 0xb9, 0x0c, 0x29, 0x95, 0xb4,
	0xf3, 0x74, 0xa5, 0x85, 0xc0, 0x9d, 0x63, 0x36, 0x78, 0xe7, 0xb8, 0x05, 0x8b, 0xfb, 0xd8, 0xa1,
	0xb8, 0x38, 0x0a, 0xb9, 0xf4, 0x14, 0x90, 0x3b, 0xea, 0xd3, 0xdb, 0x2f, 0xfd, 0x37, 0x01, 0x45,
	0xd7, 0xf9, 0x43, 0x72, 0x33, 0xd4, 0x7f, 0x56, 0xe9, 0x92, 0x1c, 0x05, 0x82, 0x61, 0xde, 0x10,
	0xe5, 0xe4, 0x19, 0x9a, 0xfe, 0xbb, 0x21, 0x77, 0xac, 0x48, 0xd0, 0xb2, 0xaf, 0xd2, 0x9d, 0xf4,
	0x7e, 0xd4, 0x09, 0x1d, 0x5e, 0xfc, 0x01, 0xd0, 0x38, 0xc6, 0x54, 0x2b, 0xc4, 0x5d, 0xb8, 0xbe,
	0x8f, 0x9d, 0x38, 0x21, 0x97, 0xf6, 0x60, 0xcd, 0xed, 0x5d, 0x51, 0x7a, 0x4a, 0x3e, 0xa3, 0xb4,
	0x0d, 0xeb, 0x7c, 0x88, 0x8c, 0x58, 0x56, 0x7f, 0x4b, 0x1d, 0xf4, 0x53, 0x28, 0xf6, 0xc0, 0xec,
	0xdb, 0x98, 0x5c, 0xc8, 0xa7, 0xb8, 0xe2, 0x7a, 0xb2, 0xa5, 0x53, 0x91, 0x3a, 0xf0, 0x88, 0x92,
	0xcf, 0x04, 0x3d, 0x83, 0x1b, 0xa1, 0x54, 0xc8, 0x67, 0xc2, 0xbe, 0x14, 0x19, 0x96, 0x11, 0xcd,
	0xc1, 0x50, 0x9f, 0x02, 0x74, 0xbc, 0x26, 0xb6, 0x02, 0x5f, 0x86, 0x2b, 0x48, 0x97, 0xba, 0xb0,
	0x11, 0x45, 0x4b, 0x30, 0xf4, 0x3a, 0x48, 0x7c, 0x4a, 0x4e, 0xe1, 0xfb, 0x02, 0xd3, 0xe1, 0x15,
	0xa5, 0x0e, 0x9f, 0x58, 0x7e, 0xae, 0xe2, 0x6a, 0x8d, 0xb4, 0x60, 0x35, 0x48, 0x49, 0x8c, 0x0c,
	0x78, 0xd7, 0xd7, 0x29, 0x0c, 0xf0, 0x3b, 0xab, 0x10, 0x45, 0xd8, 0x8e, 0x75, 0xb5, 0x46, 0x5a,
	0xb0, 0x1a, 0xdc, 0xb6, 0x46, 0x06, 0xf8, 0xae, 0x33, 0x8d, 0x01, 0xa6, 0xe3, 0x19, 0xf8, 0x11,
	0x6e, 0x86, 0xef, 0x4e, 0x9f, 0x9d, 0xa6, 0x1b, 0x51, 0x1b, 0xcf, 0x67, 0x22, 0xef, 0xc2, 0x92,
	0x6f, 0x4f, 0x61, 0x70, 0xc1, 0xf5, 0x46, 0x86, 0x39, 0xd5, 0xdd, 0x1c, 0xe8, 0x4a, 0x9c, 0x55,
	0x78, 0xb1, 0xf4, 0x3d, 0x20, 0x71, 0xe7, 0x98, 0x5a, 0x7f, 0x17, 0x96, 0x7c, 0x9b, 0xca, 0xd4,
	0x00, 0xff, 0x4e, 0xf0, 0x23, 0x41, 0x60, 0xc1, 0x8b, 0x40, 0x3a, 0x0f, 0xdf, 0x5a, 0x7e, 0x88,
	0xb9, 0xb5, 0xb8, 0xa8, 0x93, 0xf7, 0x96, 0x2b, 0xd8, 0x3c, 0xfe, 0x99, 0xa0, 0x94, 0x73, 0xbc,
	0xb0, 0x3a, 0xe1, 0x61, 0x7d, 0x37, 0x1e, 0x56, 0x14, 0xe4, 0x17, 0x89, 0xe9, 0x5f, 0x09, 0x28,
	0x86, 0x6d, 0x73, 0x11, 0x51, 0xc5, 0x3f, 0x07, 0x44, 0x83, 0x7e, 0x91, 0xb8, 0xfe, 0x97, 0x80,
	0x8d, 0xa8, 0x9d, 0x37, 0x22, 0xb6, 0x3f, 0xc3, 0x0a, 0x5f, 0x73, 0xc2, 0x62, 0x7c, 0x1e, 0x15,
	0x63, 0x94, 0x01, 0xd6, 0xac, 0x85, 0x84, 0xbb, 0xac, 0x85, 0x34, 0x15, 0xf7, 0xf9, 0x89, 0x43,
	0xfb, 0xcc, 0xe0, 0xff, 0x96, 0x86, 0x8c, 0xc7, 0x6e, 0xc7, 0xb9, 0x5e, 0x08, 0x4f, 0x17, 0x49,
	0xdf, 0xd3, 0x05, 0x82, 0x24, 0xe5, 0x8f, 0x53, 0xae, 0x30, 0xf9, 0x8d, 0xbe, 0x87, 0x34, 0x23,
	0x3e, 0xd2, 0xb4, 0x63, 0xbe, 0x8e, 0x5e, 0xd8, 0xca, 0x2e, 0xcf, 0xc1, 0x2e, 0x78, 0xae, 0x16,
	0xda, 0x85, 0xb9, 0xb6, 0xf9, 0xa1, 0xa5, 0x5a, 0x8e, 0x3c, 0x37, 0x11, 0xa0, 0x6a, 0x7e, 0xa8,
	0x58, 0x0e, 0x03, 0x68, 0xd3, 0x02, 0xaa, 0x42, 0xc6, 0x30, 0xbb, 0x26, 0x45, 0xc8, 0x50, 0x84,
	0x3b, 0x97, 0x20, 0x1c, 0x9a, 0x5d, 0xd3, 0x83, 0x98, 0x33, 0xdc, 0x12, 0x3a, 0x83, 0x25, 0xfe,
	0x00, 0xd2, 0x1a, 0x58, 0xe6, 0x00, 0x5b, 0x8e, 0xee, 0x11, 0xc7, 0x21, 0x9c, 0x09, 0x7f, 0x16,
	0x39, 0xf1, 0x64, 0x15, 0x84, 0xc7, 0xea, 0x84, 0x73, 0x20, 0xf8, 0xde, 0x5d, 0x6e, 0x43, 0x81,
	0xe5, 0x14, 0xa7, 0xf4, 0x73, 0xb4, 0x7d, 0xde, 0xab, 0xa5, 0xb4, 0xfd, 0x13, 0x58, 0x1b, 0x89,
	0x75, 0xd5, 0x1e, 0x6e, 0xb5, 0xe9, 0x86, 0x45, 0x79, 0xb3, 0x3c, 0xd5, 0x58, 0xf5, 0x04, 0xf6,
	0xd5, 0x1e, 0x76, 0xf7, 0xb3, 0x33, 0xcb, 0x40, 0x4f, 0x46, 0x17, 0x0a, 0xd5, 0x61, 0x64, 0xed,
	0x38, 0xd1, 0xd1, 0xe4, 0x2f, 0x76, 0xde, 0x65, 0xa3, 0xe2, 0x10, 0x55, 0x8f, 0xdc, 0x70, 0x18,
	0x2d, 0x7b, 0xa9, 0x2a, 0x27, 0x31, 0x1c, 0x72, 0x59, 0x17, 0x86, 0x78, 0x9a, 0x24, 0x25, 0xaa,
	0xc2, 0xe0, 0x4e, 0xa5, 0xfa, 0x14, 0xf2, 0xe2, 0xa8, 0x4e, 0xa3, 0xfb, 0x3c, 0x99, 0x99, 0x95,
	0x92, 0x4a, 0xde, 0x47, 0x80, 0xfc, 0x3d, 0x0d, 0x68, 0x7c, 0x80, 0xd1, 0x06, 0xb9, 0xfa, 0x7a,
	0x6f, 0x1f, 0x2e, 0x09, 0x22, 0xd4, 0x90, 0x76, 0xe1, 0x15, 0xc3, 0xdd, 0x06, 0x85, 0x1a, 0x92,
	0x0c, 0xec, 0x3d, 0x62, 0xd6, 0x25, 0x50, 0xdc, 0x12, 0x2a, 0x42, 0xc6, 0x7b, 0x59, 0x48, 0xd2,
	0x16, 0xaf, 0x4c, 0x30, 0x85, 0x37, 0x82, 0x94, 0x8b, 0x39, 0xaa, 0x41, 0xb7, 0x60, 0xde, 0xcf,
	0xf6, 0xa7, 0xa9, 0x48, 0xde, 0x16, 0xf9, 0xfb, 0x9b, 0x90, 0x1d, 0xf1, 0xf6, 0x73, 0x54, 0x60,
	0x54, 0x41, 0xdc, 0x62, 0x0c, 0x7c, 0xc6, 0x75, 0xcb, 0x2d, 0x89, 0x5b, 0x7a, 0xd6, 0xb7, 0xa5,
	0x13, 0x87, 0x3d, 0x96, 0x1d, 0x5c, 0x87, 0x79, 0x99, 0xf4, 0xb4, 0xcb, 0x97, 0xe7, 0x68, 0x83,
	0x5b, 0x40, 0x25, 0xc8, 0xfb, 0x98, 0xef, 0xbc, 0xeb, 0xa5, 0x58, 0x87, 0x76, 0x60, 0x25, 0x9c,
	0xc3, 0x9e, 0xa7, 0x63, 0xb6, 0x64, 0x86, 0xd0, 0xd3, 0x9b, 0x90, 0x13, 0x69, 0xe9, 0x02, 0x95,
	0x14, 0xab, 0xd0, 0x1a, 0x64, 0x3c, 0xa6, 0x79, 0x81, 0x36, 0xd3, 0xa5, 0x8d, 0x4c, 0x11, 0x04,
	0x49, 0x4a, 0x1e, 0x4b, 0xee, 0x62, 0x46, 0x7e, 0xa3, 0x1b, 0x90, 0x1d, 0xf1, 0xc1, 0x8b, 0xb4,
	0x21, 0x33, 0xe0, 0x54, 0xef, 0x77, 0x90, 0x13, 0x09, 0x55, 0x14, 0x83, 0x3f, 0x02, 0x3c, 0x62,
	0x50, 0xef, 0xc3, 0xe2, 0x38, 0x73, 0xba, 0x44, 0x7b, 0x42, 0xc2, 0x41, 0x2e, 0xf4, 0x0e, 0x2c,
	0x04, 0x39, 0xd0, 0x65, 0xea, 0x4e, 0x41, 0xf5, 0xd3, 0x9b, 0x77, 0x60, 0x21, 0x48, 0x6b, 0xae,
	0xd0, 0x17, 0xdc, 0xc2, 0xb9, 0x9f, 0xb3, 0x24, 0x88, 0x01, 0xae, 0x72, 0x95, 0x1a, 0x2f, 0xa8,
	0x7e, 0xf6, 0xb1, 0x0a, 0xf3, 0x7e, 0xd6, 0xf1, 0x7a, 0x1c, 0x6e, 0x2b, 0x6f, 0x09, 0xc4, 0x58,
	0xe9, 0x15, 0xe4, 0xc4, 0x71, 0x2a, 0x42, 0x86, 0x27, 0x1c, 0x9b, 0x96, 0x5e, 0x19, 0x95, 0x21,
	0x49, 0x87, 0x79, 0x66, 0xe2, 0x42, 0x43, 0xe5, 0xee, 0x95, 0x21, 0xc3, 0x9f, 0x99, 0xd1, 0x02,
	0xe4, 0x8e, 0x95, 0x5a, 0x5d, 0x69, 0xbc, 0xd8, 0x6f, 0x35, 0x6a, 0xd2, 0x35, 0xb4, 0x08, 0xf3,
	0x5e, 0xc5, 0x8b, 0xca, 0x51, 0x5d, 0x4a, 0xdc, 0x1b, 0x40, 0xda, 0xe5, 0xb0, 0x90, 0x04, 0x79,
	0xa5, 0x5e, 0x39, 0x3d, 0x7e, 0xd1, 0x3a, 0x7b, 0x71, 0x5a, 0x6f, 0x4a, 0xd7, 0x50, 0x1e, 0x32,
	0xf5, 0x97, 0x27, 0x87, 0x8d, 0xbd, 0x46, 0x53, 0x4a, 0xa0, 0x79, 0xc8, 0xd6, 0xce, 0x48, 0xa9,
	0xd2, 0xac, 0x4b, 0x33, 0x28, 0x07, 0x73, 0x07, 0x95, 0x66, 0xfd, 0xd9, 0xd9, 0xa1, 0x34, 0x4b,
	0x0a, 0xb5, 0xfa, 0x61, 0xbd, 0x59, 0xaf, 0x49, 0x49, 0x94, 0x85, 0xd4, 0x71, 0xf3, 0xa0, 0xae,
	0x48, 0x29, 0x84, 0xa0, 0xe0, 0xe9, 0xb8, 0x16, 0xd3, 0xf7, 0x5e, 0x02, 0x08, 0x7c, 0xe3, 0x32,
	0x48, 0xb4, 0x54, 0x69, 0x12, 0xa7, 0xb8, 0xe5, 0x34, 0xcc, 0x28, 0x27, 0x52, 0x82, 0xfc, 0xaf,
	0xef, 0x49, 0x33, 0x28, 0x05, 0x89, 0xba, 0x34, 0x8b, 0xe6, 0x60, 0xb6, 0xfe, 0xcb, 0x47, 0x52,
	0x92, 0x94, 0x9b, 0x52, 0x8a, 0xfc, 0x3b, 0x92, 0xd2, 0x44, 0xaa, 0x72, 0x2c, 0xcd, 0xed, 0xfc,
	0x63, 0x01, 0xa4, 0xe0, 0xa7, 0x1c, 0xe8, 0x1c, 0x16, 0x02, 0x1c, 0x01, 0xda, 0x0a, 0x3d, 0x56,
	0x86, 0x7c, 0x89, 0x51, 0xbc, 0x1b, 0x43, 0x92, 0x1d, 0x90, 0x0c, 0x4a, 0x42, 0xf9, 0x89, 0x03,
	0x74, 0x6f, 0x82, 0xbe, 0xc0, 0x6c, 0x16, 0xef, 0xc7, 0x92, 0x65, 0xd6, 0x2c, 0x58, 0x0a, 0x61,
	0x14, 0xd0, 0x83, 0x49, 0xfe, 0x8a, 0xdf, 0x60, 0x14, 0x1f, 0xc6, 0x94, 0x66, 0x36, 0x4d, 0x7a,
	0x59, 0x0a, 0xd0, 0x0d, 0xe8, 0x52, 0xb7, 0x03, 0xdf, 0x5e, 0x14, 0x1f, 0xc4, 0x13, 0x66, 0x06,
	0x3f, 0xc2, 0x6a, 0x38, 0x0b, 0x81, 0xb6, 0xa3, 0xee, 0x3b, 0x11, 0x9f, 0x51, 0x14, 0x1f, 0xc5,
	0x57, 0x18, 0x45, 0x3b, 0xce, 0x4c, 0x84, 0x45, 0x1b, 0xf9, 0xad, 0x45, 0x58, 0xb4, 0x97, 0x90,
	0x1d, 0x1d, 0x28, 0xf8, 0x49, 0x04, 0x14, 0x72, 0x50, 0x0b, 0xfd, 0xb4, 0xa2, 0xb8, 0x35, 0x59,
	0x70, 0x14, 0xd5, 0x38, 0x53, 0x11, 0x16, 0x55, 0x24, 0x03, 0x1f, 0x16, 0xd5, 0x25, 0xe4, 0x47,
	0x07, 0x0a, 0x7e, 0xd6, 0x22, 0x2c, 0xaa, 0x50, 0x3a, 0x3e, 0x2c, 0xaa, 0x08, 0x02, 0xe4, 0x02,
	0x96, 0xc3, 0x98, 0x0b, 0xf4, 0x70, 0xd2, 0xa8, 0xfb, 0xf8, 0xf7, 0x62, 0x39, 0xae, 0x78, 0x54,
	0x7e, 0x72, 0x62, 0x63, 0x72, 0x7e, 0x06, 0xb8, 0xf7, 0xc9, 0xf9, 0x39, 0xc6, 0x99, 0xbc, 0x86,
	0x9c, 0xc0, 0x7d, 0xa0, 0xaf, 0xa2, 0x00, 0x44, 0xba, 0xbb, 0x78, 0x7b, 0x82, 0x14, 0xc3, 0xfe,
	0x1d, 0xc0, 0x88, 0x16, 0x41, 0xb7, 0x42, 0x27, 0xad, 0x9f, 0x6e, 0x2f, 0x7e, 0x75, 0xb9, 0xd0,
	0xc8, 0x69, 0x81, 0x2f, 0x09, 0x73, 0x7a, 0x9c, 0xa3, 0x0f, 0x73, 0x3a, 0x8c, 0x74, 0xb1, 0x38,
	0x19, 0xe4, 0xbb, 0x0f, 0xa2, 0x07, 0xd3, 0xb0, 0xee, 0xc5, 0x87, 0x53, 0x11, 0x29, 0x48, 0x07,
	0x29, 0x48, 0x48, 0xa0, 0xbb, 0x71, 0x48, 0x0b, 0xd7, 0xda, 0xbd, 0xf8, 0xfc, 0x06, 0x99, 0xb9,
	0xe3, 0x2c, 0x41, 0xd8, 0xcc, 0x8d, 0xe4, 0xe1, 0xc3, 0x66, 0xee, 0x25, 0x6c, 0xc6, 0x47, 0xce,
	0x37, 0x06, 0xaf, 0xec, 0x61, 0xd9, 0x7d, 0x29, 0x6f, 0x1f, 0x96, 0xdd, 0x97, 0xb3, 0x01, 0xd5,
	0xfb, 0xaf, 0xef, 0xc6, 0xfe, 0x50, 0xb3, 0x9d, 0xa6, 0xa7, 0xa1, 0x5f, 0xfd, 0x3f, 0x00, 0x00,
	0xff, 0xff, 0x51, 0x28, 0xd8, 0x2b, 0xdc, 0x29, 0x00, 0x00,
}
