// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchDMCATwirp/twirp.proto

/*
Package TwitchDMCATwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchDMCATwirp/twirp.proto
*/
package TwitchDMCATwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ====================
// TwitchDMCA Interface
// ====================

type TwitchDMCA interface {
	// CreateCopyrightClaim creates a copyright claim with info filled out by a claimant via the Copyright Claim Form
	CreateCopyrightClaim(context.Context, *CreateCopyrightClaimRequest) (*CreateCopyrightClaimResponse, error)

	// SetNoticeContentStatus changes the current status of the intended notice content
	SetNoticeContentStatus(context.Context, *SetNoticeContentStatusRequest) (*SetNoticeContentStatusResponse, error)

	// AssignToPrimaryNotice sets the AssignedTo of the specified primary notice id and its underlying secondary notices
	AssignToPrimaryNotice(context.Context, *AssignToPrimaryNoticeRequest) (*AssignToPrimaryNoticeResponse, error)

	// SubmitClaimActions finalizes a claim and performs the necessary takedowns/strikes/suspensions/notifications required.
	SubmitClaimActions(context.Context, *SubmitClaimActionsRequest) (*SubmitClaimActionsResponse, error)

	// GetPrimaryNoticesByIssueTime fetches primary copyright claims between a time range
	GetPrimaryNoticesByIssueTime(context.Context, *GetPrimaryNoticesByIssueTimeRequest) (*GetCopyrightNoticesResponse, error)

	// GetNoticeContentsByPrimaryNoticeID fetches notice contents for a particular primary notice id
	GetNoticeContentsByPrimaryNoticeID(context.Context, *GetNoticeContentsByPrimaryNoticeIDRequest) (*GetNoticeContentsResponse, error)

	// ListStrikesByUserID gets all the strikes against a user.
	ListStrikesByUserID(context.Context, *ListStrikesByUserIDRequest) (*ListStrikesByUserIDResponse, error)

	// RemoveStrike deletes a strike from a user.
	RemoveStrike(context.Context, *RemoveStrikeRequest) (*Strike, error)

	// AddUser grants a user access to the DMCA tool.
	AddUser(context.Context, *AddUserRequest) (*AddUserResponse, error)

	// RemoveUser revokes a user's access to the DMCA tool.
	RemoveUser(context.Context, *RemoveUserRequest) (*RemoveUserResponse, error)

	// GetUser returns the user data for a user of the DMCA tool.
	GetUser(context.Context, *GetUserRequest) (*GetUserResponse, error)

	// IsUserAuthorized returns whether a user has access to the DMCA tool.
	IsUserAuthorized(context.Context, *IsUserAuthorizedRequest) (*IsUserAuthorizedResponse, error)

	// TakedownContent removes content for DMCA and issues a strike against the owning user.
	TakedownContent(context.Context, *TakedownContentRequest) (*TakedownContentResponse, error)

	// StruckContent gets the content struck for a given user.
	StruckContent(context.Context, *StruckContentRequest) (*StruckContentResponse, error)

	// StruckBy gets the content struck by a given user.
	StruckBy(context.Context, *StruckByRequest) (*StruckByResponse, error)

	// StruckByPaginated gets the paginated struck content by a given issuer
	StruckByPaginated(context.Context, *StruckByPaginatedRequest) (*StruckByPaginatedResponse, error)

	// StruckContentPaginated gets the paginated struck content for a given user
	StruckContentPaginated(context.Context, *StruckContentPaginatedRequest) (*StruckContentPaginatedResponse, error)

	// GetUserNoticesByUserID gets user level notice records (secondary notices) for a given user
	GetUserNoticesByUserID(context.Context, *GetUserNoticesByUserIDRequest) (*GetUserNoticesByUserIDResponse, error)

	// GetUserNoticeByID gets a user level notice record by the notice id
	GetUserNoticeByID(context.Context, *GetUserNoticeByIDRequest) (*GetUserNoticeByIDResponse, error)
}

// ==========================
// TwitchDMCA Protobuf Client
// ==========================

type twitchDMCAProtobufClient struct {
	client HTTPClient
	urls   [19]string
	opts   twirp.ClientOptions
}

// NewTwitchDMCAProtobufClient creates a Protobuf client that implements the TwitchDMCA interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchDMCAProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchDMCA {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchDMCAPathPrefix
	urls := [19]string{
		prefix + "CreateCopyrightClaim",
		prefix + "SetNoticeContentStatus",
		prefix + "AssignToPrimaryNotice",
		prefix + "SubmitClaimActions",
		prefix + "GetPrimaryNoticesByIssueTime",
		prefix + "GetNoticeContentsByPrimaryNoticeID",
		prefix + "ListStrikesByUserID",
		prefix + "RemoveStrike",
		prefix + "AddUser",
		prefix + "RemoveUser",
		prefix + "GetUser",
		prefix + "IsUserAuthorized",
		prefix + "TakedownContent",
		prefix + "StruckContent",
		prefix + "StruckBy",
		prefix + "StruckByPaginated",
		prefix + "StruckContentPaginated",
		prefix + "GetUserNoticesByUserID",
		prefix + "GetUserNoticeByID",
	}

	return &twitchDMCAProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchDMCAProtobufClient) CreateCopyrightClaim(ctx context.Context, in *CreateCopyrightClaimRequest) (*CreateCopyrightClaimResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCopyrightClaim")
	out := new(CreateCopyrightClaimResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) SetNoticeContentStatus(ctx context.Context, in *SetNoticeContentStatusRequest) (*SetNoticeContentStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "SetNoticeContentStatus")
	out := new(SetNoticeContentStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) AssignToPrimaryNotice(ctx context.Context, in *AssignToPrimaryNoticeRequest) (*AssignToPrimaryNoticeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "AssignToPrimaryNotice")
	out := new(AssignToPrimaryNoticeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) SubmitClaimActions(ctx context.Context, in *SubmitClaimActionsRequest) (*SubmitClaimActionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "SubmitClaimActions")
	out := new(SubmitClaimActionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) GetPrimaryNoticesByIssueTime(ctx context.Context, in *GetPrimaryNoticesByIssueTimeRequest) (*GetCopyrightNoticesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetPrimaryNoticesByIssueTime")
	out := new(GetCopyrightNoticesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) GetNoticeContentsByPrimaryNoticeID(ctx context.Context, in *GetNoticeContentsByPrimaryNoticeIDRequest) (*GetNoticeContentsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetNoticeContentsByPrimaryNoticeID")
	out := new(GetNoticeContentsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) ListStrikesByUserID(ctx context.Context, in *ListStrikesByUserIDRequest) (*ListStrikesByUserIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "ListStrikesByUserID")
	out := new(ListStrikesByUserIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) RemoveStrike(ctx context.Context, in *RemoveStrikeRequest) (*Strike, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveStrike")
	out := new(Strike)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) AddUser(ctx context.Context, in *AddUserRequest) (*AddUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "AddUser")
	out := new(AddUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) RemoveUser(ctx context.Context, in *RemoveUserRequest) (*RemoveUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUser")
	out := new(RemoveUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) GetUser(ctx context.Context, in *GetUserRequest) (*GetUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(GetUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) IsUserAuthorized(ctx context.Context, in *IsUserAuthorizedRequest) (*IsUserAuthorizedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "IsUserAuthorized")
	out := new(IsUserAuthorizedResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) TakedownContent(ctx context.Context, in *TakedownContentRequest) (*TakedownContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "TakedownContent")
	out := new(TakedownContentResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) StruckContent(ctx context.Context, in *StruckContentRequest) (*StruckContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "StruckContent")
	out := new(StruckContentResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) StruckBy(ctx context.Context, in *StruckByRequest) (*StruckByResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "StruckBy")
	out := new(StruckByResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) StruckByPaginated(ctx context.Context, in *StruckByPaginatedRequest) (*StruckByPaginatedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "StruckByPaginated")
	out := new(StruckByPaginatedResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) StruckContentPaginated(ctx context.Context, in *StruckContentPaginatedRequest) (*StruckContentPaginatedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "StruckContentPaginated")
	out := new(StruckContentPaginatedResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) GetUserNoticesByUserID(ctx context.Context, in *GetUserNoticesByUserIDRequest) (*GetUserNoticesByUserIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserNoticesByUserID")
	out := new(GetUserNoticesByUserIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAProtobufClient) GetUserNoticeByID(ctx context.Context, in *GetUserNoticeByIDRequest) (*GetUserNoticeByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserNoticeByID")
	out := new(GetUserNoticeByIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ======================
// TwitchDMCA JSON Client
// ======================

type twitchDMCAJSONClient struct {
	client HTTPClient
	urls   [19]string
	opts   twirp.ClientOptions
}

// NewTwitchDMCAJSONClient creates a JSON client that implements the TwitchDMCA interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchDMCAJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchDMCA {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchDMCAPathPrefix
	urls := [19]string{
		prefix + "CreateCopyrightClaim",
		prefix + "SetNoticeContentStatus",
		prefix + "AssignToPrimaryNotice",
		prefix + "SubmitClaimActions",
		prefix + "GetPrimaryNoticesByIssueTime",
		prefix + "GetNoticeContentsByPrimaryNoticeID",
		prefix + "ListStrikesByUserID",
		prefix + "RemoveStrike",
		prefix + "AddUser",
		prefix + "RemoveUser",
		prefix + "GetUser",
		prefix + "IsUserAuthorized",
		prefix + "TakedownContent",
		prefix + "StruckContent",
		prefix + "StruckBy",
		prefix + "StruckByPaginated",
		prefix + "StruckContentPaginated",
		prefix + "GetUserNoticesByUserID",
		prefix + "GetUserNoticeByID",
	}

	return &twitchDMCAJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchDMCAJSONClient) CreateCopyrightClaim(ctx context.Context, in *CreateCopyrightClaimRequest) (*CreateCopyrightClaimResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCopyrightClaim")
	out := new(CreateCopyrightClaimResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) SetNoticeContentStatus(ctx context.Context, in *SetNoticeContentStatusRequest) (*SetNoticeContentStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "SetNoticeContentStatus")
	out := new(SetNoticeContentStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) AssignToPrimaryNotice(ctx context.Context, in *AssignToPrimaryNoticeRequest) (*AssignToPrimaryNoticeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "AssignToPrimaryNotice")
	out := new(AssignToPrimaryNoticeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) SubmitClaimActions(ctx context.Context, in *SubmitClaimActionsRequest) (*SubmitClaimActionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "SubmitClaimActions")
	out := new(SubmitClaimActionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) GetPrimaryNoticesByIssueTime(ctx context.Context, in *GetPrimaryNoticesByIssueTimeRequest) (*GetCopyrightNoticesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetPrimaryNoticesByIssueTime")
	out := new(GetCopyrightNoticesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) GetNoticeContentsByPrimaryNoticeID(ctx context.Context, in *GetNoticeContentsByPrimaryNoticeIDRequest) (*GetNoticeContentsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetNoticeContentsByPrimaryNoticeID")
	out := new(GetNoticeContentsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) ListStrikesByUserID(ctx context.Context, in *ListStrikesByUserIDRequest) (*ListStrikesByUserIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "ListStrikesByUserID")
	out := new(ListStrikesByUserIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) RemoveStrike(ctx context.Context, in *RemoveStrikeRequest) (*Strike, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveStrike")
	out := new(Strike)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) AddUser(ctx context.Context, in *AddUserRequest) (*AddUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "AddUser")
	out := new(AddUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) RemoveUser(ctx context.Context, in *RemoveUserRequest) (*RemoveUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUser")
	out := new(RemoveUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) GetUser(ctx context.Context, in *GetUserRequest) (*GetUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	out := new(GetUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) IsUserAuthorized(ctx context.Context, in *IsUserAuthorizedRequest) (*IsUserAuthorizedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "IsUserAuthorized")
	out := new(IsUserAuthorizedResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) TakedownContent(ctx context.Context, in *TakedownContentRequest) (*TakedownContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "TakedownContent")
	out := new(TakedownContentResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) StruckContent(ctx context.Context, in *StruckContentRequest) (*StruckContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "StruckContent")
	out := new(StruckContentResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) StruckBy(ctx context.Context, in *StruckByRequest) (*StruckByResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "StruckBy")
	out := new(StruckByResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) StruckByPaginated(ctx context.Context, in *StruckByPaginatedRequest) (*StruckByPaginatedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "StruckByPaginated")
	out := new(StruckByPaginatedResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) StruckContentPaginated(ctx context.Context, in *StruckContentPaginatedRequest) (*StruckContentPaginatedResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "StruckContentPaginated")
	out := new(StruckContentPaginatedResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) GetUserNoticesByUserID(ctx context.Context, in *GetUserNoticesByUserIDRequest) (*GetUserNoticesByUserIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserNoticesByUserID")
	out := new(GetUserNoticesByUserIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDMCAJSONClient) GetUserNoticeByID(ctx context.Context, in *GetUserNoticeByIDRequest) (*GetUserNoticeByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserNoticeByID")
	out := new(GetUserNoticeByIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================
// TwitchDMCA Server Handler
// =========================

type twitchDMCAServer struct {
	TwitchDMCA
	hooks *twirp.ServerHooks
}

func NewTwitchDMCAServer(svc TwitchDMCA, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchDMCAServer{
		TwitchDMCA: svc,
		hooks:      hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchDMCAServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchDMCAPathPrefix is used for all URL paths on a twirp TwitchDMCA server.
// Requests are always: POST TwitchDMCAPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchDMCAPathPrefix = "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/"

func (s *twitchDMCAServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdmca")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDMCA")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/CreateCopyrightClaim":
		s.serveCreateCopyrightClaim(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/SetNoticeContentStatus":
		s.serveSetNoticeContentStatus(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/AssignToPrimaryNotice":
		s.serveAssignToPrimaryNotice(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/SubmitClaimActions":
		s.serveSubmitClaimActions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/GetPrimaryNoticesByIssueTime":
		s.serveGetPrimaryNoticesByIssueTime(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/GetNoticeContentsByPrimaryNoticeID":
		s.serveGetNoticeContentsByPrimaryNoticeID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/ListStrikesByUserID":
		s.serveListStrikesByUserID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/RemoveStrike":
		s.serveRemoveStrike(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/AddUser":
		s.serveAddUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/RemoveUser":
		s.serveRemoveUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/GetUser":
		s.serveGetUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/IsUserAuthorized":
		s.serveIsUserAuthorized(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/TakedownContent":
		s.serveTakedownContent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/StruckContent":
		s.serveStruckContent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/StruckBy":
		s.serveStruckBy(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/StruckByPaginated":
		s.serveStruckByPaginated(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/StruckContentPaginated":
		s.serveStruckContentPaginated(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/GetUserNoticesByUserID":
		s.serveGetUserNoticesByUserID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdmca.TwitchDMCA/GetUserNoticeByID":
		s.serveGetUserNoticeByID(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchDMCAServer) serveCreateCopyrightClaim(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCopyrightClaimJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCopyrightClaimProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveCreateCopyrightClaimJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCopyrightClaim")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCopyrightClaimRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCopyrightClaimResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.CreateCopyrightClaim(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCopyrightClaimResponse and nil error while calling CreateCopyrightClaim. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveCreateCopyrightClaimProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCopyrightClaim")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateCopyrightClaimRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCopyrightClaimResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.CreateCopyrightClaim(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCopyrightClaimResponse and nil error while calling CreateCopyrightClaim. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveSetNoticeContentStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetNoticeContentStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetNoticeContentStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveSetNoticeContentStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetNoticeContentStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetNoticeContentStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetNoticeContentStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.SetNoticeContentStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetNoticeContentStatusResponse and nil error while calling SetNoticeContentStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveSetNoticeContentStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetNoticeContentStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetNoticeContentStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetNoticeContentStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.SetNoticeContentStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetNoticeContentStatusResponse and nil error while calling SetNoticeContentStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveAssignToPrimaryNotice(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAssignToPrimaryNoticeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAssignToPrimaryNoticeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveAssignToPrimaryNoticeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AssignToPrimaryNotice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AssignToPrimaryNoticeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AssignToPrimaryNoticeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.AssignToPrimaryNotice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AssignToPrimaryNoticeResponse and nil error while calling AssignToPrimaryNotice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveAssignToPrimaryNoticeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AssignToPrimaryNotice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AssignToPrimaryNoticeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AssignToPrimaryNoticeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.AssignToPrimaryNotice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AssignToPrimaryNoticeResponse and nil error while calling AssignToPrimaryNotice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveSubmitClaimActions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSubmitClaimActionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSubmitClaimActionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveSubmitClaimActionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SubmitClaimActions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SubmitClaimActionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SubmitClaimActionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.SubmitClaimActions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitClaimActionsResponse and nil error while calling SubmitClaimActions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveSubmitClaimActionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SubmitClaimActions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SubmitClaimActionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SubmitClaimActionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.SubmitClaimActions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitClaimActionsResponse and nil error while calling SubmitClaimActions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetPrimaryNoticesByIssueTime(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPrimaryNoticesByIssueTimeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPrimaryNoticesByIssueTimeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveGetPrimaryNoticesByIssueTimeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPrimaryNoticesByIssueTime")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPrimaryNoticesByIssueTimeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCopyrightNoticesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetPrimaryNoticesByIssueTime(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCopyrightNoticesResponse and nil error while calling GetPrimaryNoticesByIssueTime. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetPrimaryNoticesByIssueTimeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPrimaryNoticesByIssueTime")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPrimaryNoticesByIssueTimeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCopyrightNoticesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetPrimaryNoticesByIssueTime(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCopyrightNoticesResponse and nil error while calling GetPrimaryNoticesByIssueTime. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetNoticeContentsByPrimaryNoticeID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetNoticeContentsByPrimaryNoticeIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetNoticeContentsByPrimaryNoticeIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveGetNoticeContentsByPrimaryNoticeIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetNoticeContentsByPrimaryNoticeID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetNoticeContentsByPrimaryNoticeIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetNoticeContentsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetNoticeContentsByPrimaryNoticeID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetNoticeContentsResponse and nil error while calling GetNoticeContentsByPrimaryNoticeID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetNoticeContentsByPrimaryNoticeIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetNoticeContentsByPrimaryNoticeID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetNoticeContentsByPrimaryNoticeIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetNoticeContentsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetNoticeContentsByPrimaryNoticeID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetNoticeContentsResponse and nil error while calling GetNoticeContentsByPrimaryNoticeID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveListStrikesByUserID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStrikesByUserIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStrikesByUserIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveListStrikesByUserIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStrikesByUserID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListStrikesByUserIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStrikesByUserIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.ListStrikesByUserID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStrikesByUserIDResponse and nil error while calling ListStrikesByUserID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveListStrikesByUserIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStrikesByUserID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListStrikesByUserIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStrikesByUserIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.ListStrikesByUserID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStrikesByUserIDResponse and nil error while calling ListStrikesByUserID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveRemoveStrike(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveStrikeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveStrikeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveRemoveStrikeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveStrike")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveStrikeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Strike
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.RemoveStrike(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Strike and nil error while calling RemoveStrike. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveRemoveStrikeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveStrike")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveStrikeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Strike
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.RemoveStrike(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Strike and nil error while calling RemoveStrike. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveAddUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveAddUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.AddUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddUserResponse and nil error while calling AddUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveAddUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.AddUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddUserResponse and nil error while calling AddUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveRemoveUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveRemoveUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.RemoveUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveUserResponse and nil error while calling RemoveUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveRemoveUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.RemoveUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveUserResponse and nil error while calling RemoveUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveGetUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserResponse and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserResponse and nil error while calling GetUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveIsUserAuthorized(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIsUserAuthorizedJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIsUserAuthorizedProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveIsUserAuthorizedJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsUserAuthorized")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IsUserAuthorizedRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsUserAuthorizedResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.IsUserAuthorized(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsUserAuthorizedResponse and nil error while calling IsUserAuthorized. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveIsUserAuthorizedProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IsUserAuthorized")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(IsUserAuthorizedRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IsUserAuthorizedResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.IsUserAuthorized(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IsUserAuthorizedResponse and nil error while calling IsUserAuthorized. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveTakedownContent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveTakedownContentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTakedownContentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveTakedownContentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TakedownContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TakedownContentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TakedownContentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.TakedownContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownContentResponse and nil error while calling TakedownContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveTakedownContentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TakedownContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(TakedownContentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TakedownContentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.TakedownContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownContentResponse and nil error while calling TakedownContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveStruckContent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStruckContentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStruckContentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveStruckContentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StruckContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StruckContentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StruckContentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.StruckContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StruckContentResponse and nil error while calling StruckContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveStruckContentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StruckContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StruckContentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StruckContentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.StruckContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StruckContentResponse and nil error while calling StruckContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveStruckBy(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStruckByJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStruckByProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveStruckByJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StruckBy")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StruckByRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StruckByResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.StruckBy(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StruckByResponse and nil error while calling StruckBy. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveStruckByProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StruckBy")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StruckByRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StruckByResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.StruckBy(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StruckByResponse and nil error while calling StruckBy. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveStruckByPaginated(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStruckByPaginatedJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStruckByPaginatedProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveStruckByPaginatedJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StruckByPaginated")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StruckByPaginatedRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StruckByPaginatedResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.StruckByPaginated(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StruckByPaginatedResponse and nil error while calling StruckByPaginated. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveStruckByPaginatedProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StruckByPaginated")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StruckByPaginatedRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StruckByPaginatedResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.StruckByPaginated(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StruckByPaginatedResponse and nil error while calling StruckByPaginated. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveStruckContentPaginated(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStruckContentPaginatedJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStruckContentPaginatedProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveStruckContentPaginatedJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StruckContentPaginated")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StruckContentPaginatedRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StruckContentPaginatedResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.StruckContentPaginated(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StruckContentPaginatedResponse and nil error while calling StruckContentPaginated. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveStruckContentPaginatedProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StruckContentPaginated")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StruckContentPaginatedRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StruckContentPaginatedResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.StruckContentPaginated(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StruckContentPaginatedResponse and nil error while calling StruckContentPaginated. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetUserNoticesByUserID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserNoticesByUserIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserNoticesByUserIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveGetUserNoticesByUserIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserNoticesByUserID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserNoticesByUserIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserNoticesByUserIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetUserNoticesByUserID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserNoticesByUserIDResponse and nil error while calling GetUserNoticesByUserID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetUserNoticesByUserIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserNoticesByUserID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserNoticesByUserIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserNoticesByUserIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetUserNoticesByUserID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserNoticesByUserIDResponse and nil error while calling GetUserNoticesByUserID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetUserNoticeByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserNoticeByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserNoticeByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDMCAServer) serveGetUserNoticeByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserNoticeByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserNoticeByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserNoticeByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetUserNoticeByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserNoticeByIDResponse and nil error while calling GetUserNoticeByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) serveGetUserNoticeByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserNoticeByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserNoticeByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserNoticeByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDMCA.GetUserNoticeByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserNoticeByIDResponse and nil error while calling GetUserNoticeByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDMCAServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchDMCAServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchDMCAServer) PathPrefix() string {
	return TwitchDMCAPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 3317 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x3b, 0x5d, 0x6f, 0x1b, 0xd7,
	0xb1, 0x5e, 0x7e, 0x73, 0x48, 0x91, 0xcb, 0x23, 0xc9, 0xa6, 0x68, 0x3b, 0x71, 0x36, 0x37, 0xb8,
	0x8e, 0x93, 0x4b, 0x27, 0x4a, 0xee, 0xbd, 0xb1, 0xf3, 0x61, 0x53, 0xd2, 0x5a, 0xd9, 0xd8, 0x22,
	0x75, 0x97, 0xb4, 0x9c, 0xdc, 0x7b, 0x91, 0xcd, 0x9a, 0x7b, 0x2c, 0x6d, 0x45, 0xee, 0x32, 0xbb,
	0x4b, 0x2b, 0x34, 0x90, 0xb6, 0x68, 0xd1, 0x00, 0xfd, 0x42, 0x81, 0xb6, 0x41, 0x0d, 0xf4, 0xa1,
	0x7d, 0xe8, 0x43, 0x81, 0x02, 0xed, 0x7b, 0xff, 0x48, 0x1f, 0x0b, 0x14, 0x7d, 0xe8, 0xcf, 0x28,
	0xce, 0xc7, 0x92, 0xbb, 0x4b, 0x52, 0x5c, 0xaa, 0xf9, 0x7a, 0x11, 0xb8, 0x73, 0xe6, 0xcc, 0x99,
	0x99, 0x33, 0x33, 0x67, 0xce, 0xcc, 0x11, 0x5c, 0xef, 0xda, 0x06, 0xae, 0x7f, 0x6b, 0xe8, 0x7a,
	0xa6, 0x55, 0xf7, 0x1e, 0x5f, 0xd7, 0xfb, 0x4f, 0xac, 0xeb, 0x9d, 0x13, 0xd3, 0xeb, 0x1e, 0xed,
	0xec, 0x6d, 0x37, 0x3a, 0x27, 0xa6, 0x33, 0xb8, 0xee, 0x91, 0xbf, 0xf5, 0x81, 0x63, 0x7b, 0x36,
	0xba, 0xe2, 0xd1, 0xc1, 0xfa, 0xa3, 0x61, 0xcf, 0xb3, 0xad, 0x3a, 0xfe, 0x44, 0xef, 0x0f, 0x7a,
	0xb8, 0xce, 0xa0, 0x46, 0xbf, 0xab, 0xd7, 0x9e, 0x3d, 0xb4, 0xed, 0xc3, 0x1e, 0xbe, 0x4e, 0xf1,
	0x1f, 0x0e, 0x1f, 0x5d, 0xf7, 0xcc, 0x3e, 0x76, 0x3d, 0xbd, 0xcf, 0x49, 0x48, 0xff, 0x10, 0xa0,
	0xac, 0xe2, 0x81, 0xed, 0x78, 0xd8, 0xd8, 0xb6, 0x2d, 0x0f, 0x5b, 0x1e, 0x12, 0x21, 0x39, 0x74,
	0x7a, 0x55, 0xe1, 0x8a, 0x70, 0x35, 0xaf, 0x92, 0x9f, 0xe8, 0x16, 0xa4, 0xbc, 0xd1, 0x00, 0x57,
	0x13, 0x57, 0x84, 0xab, 0xa5, 0xcd, 0x97, 0xea, 0x8b, 0xd6, 0xad, 0xef, 0x61, 0xc3, 0xd4, 0x3b,
	0xa3, 0x01, 0x56, 0xe9, 0x44, 0x54, 0x87, 0x94, 0xa1, 0x7b, 0xb8, 0x9a, 0xbc, 0x22, 0x5c, 0x2d,
	0x6c, 0xd6, 0xea, 0x8c, 0xad, 0xba, 0xcf, 0x56, 0xbd, 0xe3, 0xb3, 0xa5, 0x52, 0x3c, 0xa4, 0x02,
	0x8c, 0x39, 0x75, 0xab, 0xa9, 0x2b, 0xc9, 0xab, 0x85, 0xcd, 0xcd, 0xc5, 0xcb, 0x72, 0x09, 0x26,
	0xd4, 0x02, 0x54, 0xa4, 0xf7, 0x41, 0x8c, 0x8e, 0xa3, 0xe7, 0x61, 0xc5, 0xf5, 0x74, 0xc7, 0xd3,
	0x5c, 0xdc, 0xb5, 0x2d, 0xc3, 0xa5, 0x42, 0x27, 0xd5, 0x22, 0x05, 0xb6, 0x19, 0x0c, 0x3d, 0x0b,
	0x05, 0x6c, 0x19, 0x63, 0x94, 0x04, 0x45, 0x01, 0x6c, 0x19, 0x1c, 0x41, 0xfa, 0x08, 0x2a, 0x4d,
	0xdb, 0x33, 0xbb, 0xd8, 0xa7, 0x3f, 0x1a, 0x60, 0xe9, 0x2e, 0xa4, 0x64, 0x6b, 0xd8, 0x47, 0x05,
	0xc8, 0xde, 0x6f, 0xde, 0x6d, 0xb6, 0x1e, 0x34, 0xc5, 0x73, 0x28, 0x0b, 0xc9, 0x83, 0xd6, 0x8e,
	0x28, 0xa0, 0x1c, 0xa4, 0xb6, 0xef, 0x29, 0xfb, 0x62, 0x02, 0x95, 0x00, 0xee, 0x29, 0x07, 0x72,
	0xbb, 0xa3, 0xca, 0x8d, 0x3d, 0x31, 0x89, 0x56, 0xa1, 0xbc, 0xdf, 0x68, 0x77, 0xb4, 0x00, 0x30,
	0x25, 0x1d, 0xc0, 0x6a, 0x68, 0x85, 0xb6, 0xa7, 0x7b, 0x43, 0x57, 0xba, 0xc5, 0xd7, 0x10, 0xa1,
	0xd8, 0x94, 0xe5, 0x9d, 0xb6, 0xa6, 0xca, 0x07, 0x8a, 0xfc, 0x40, 0x3c, 0x87, 0x8a, 0x90, 0x6b,
	0xec, 0xef, 0xab, 0xad, 0x03, 0x99, 0xac, 0x56, 0x80, 0xac, 0x2a, 0xef, 0xd1, 0x8f, 0x04, 0x02,
	0xc8, 0xec, 0xc8, 0x4d, 0x45, 0xde, 0x11, 0x93, 0xd2, 0x6d, 0xa8, 0x70, 0x8a, 0xdb, 0x3d, 0x73,
	0xc0, 0xa9, 0xbe, 0xc4, 0xa9, 0xe6, 0x20, 0xd5, 0x6c, 0x35, 0x65, 0xf1, 0x1c, 0xe1, 0x71, 0x57,
	0x6e, 0xca, 0x6a, 0xa3, 0xa3, 0x34, 0x77, 0x45, 0x01, 0xe5, 0x21, 0xad, 0xca, 0x8d, 0x9d, 0x0f,
	0xc4, 0x84, 0xb4, 0x0b, 0x1b, 0xed, 0xe1, 0xc3, 0xbe, 0xe9, 0x6d, 0xf7, 0x74, 0xb3, 0xdf, 0xe8,
	0x7a, 0xa6, 0x6d, 0xb9, 0x2a, 0xfe, 0x78, 0x88, 0x5d, 0x0f, 0x5d, 0x83, 0xca, 0xc0, 0x31, 0xfb,
	0xba, 0x33, 0xd2, 0x2c, 0xca, 0xbe, 0x66, 0x1a, 0xdc, 0xae, 0xca, 0x7c, 0x80, 0x89, 0xa5, 0x18,
	0xd2, 0x21, 0xd4, 0x66, 0x11, 0x72, 0x07, 0xb6, 0xe5, 0x62, 0xa4, 0x40, 0x86, 0x51, 0xa0, 0xd3,
	0x0b, 0x9b, 0xaf, 0xc6, 0x31, 0x86, 0xc1, 0xc8, 0x31, 0x0f, 0x8f, 0x3c, 0xb6, 0x84, 0xca, 0x09,
	0x48, 0xdf, 0xcf, 0xc2, 0x4a, 0x48, 0x99, 0xa8, 0x04, 0x89, 0x31, 0x5f, 0x09, 0xd3, 0x40, 0x6f,
	0x42, 0xa1, 0xeb, 0x60, 0xdd, 0xc3, 0x1a, 0x31, 0x1f, 0xba, 0xe1, 0xa7, 0x1b, 0x2d, 0x30, 0x74,
	0x02, 0x40, 0x2a, 0x64, 0x5c, 0xaa, 0x47, 0x6a, 0xec, 0xa5, 0xcd, 0x9b, 0x8b, 0x39, 0x9d, 0xb1,
	0xb5, 0x75, 0xb2, 0x03, 0x2a, 0xa7, 0x84, 0x2e, 0x03, 0x74, 0xd9, 0x28, 0x51, 0x60, 0x8a, 0x32,
	0x9a, 0xe7, 0x10, 0xc5, 0x40, 0xff, 0x07, 0x45, 0x7f, 0x98, 0xba, 0x69, 0x9a, 0x2e, 0xfc, 0xc6,
	0x92, 0x0b, 0x13, 0xab, 0x65, 0xcb, 0x16, 0xba, 0x13, 0xc8, 0xec, 0x3d, 0xcc, 0xcc, 0xdc, 0x43,
	0x54, 0x87, 0x55, 0xe6, 0x25, 0x61, 0xec, 0x2c, 0xc5, 0xae, 0x8c, 0x87, 0xc6, 0xf8, 0x44, 0x2e,
	0xa2, 0x39, 0xdb, 0x21, 0x68, 0x39, 0x2e, 0x17, 0x83, 0x28, 0x06, 0xf1, 0xce, 0xb1, 0x5c, 0xa6,
	0xd7, 0xc3, 0xd5, 0x3c, 0xc5, 0xf0, 0x85, 0xed, 0x10, 0x18, 0xf1, 0x4e, 0x1f, 0x89, 0x44, 0x2d,
	0xa0, 0x28, 0xbe, 0xba, 0xee, 0x3b, 0x3d, 0xd4, 0x80, 0xd2, 0x43, 0xc7, 0xd6, 0x8d, 0xae, 0xee,
	0x7a, 0x6c, 0x43, 0x0b, 0x0b, 0x37, 0x74, 0x65, 0x3c, 0x83, 0xef, 0x69, 0x30, 0x1c, 0x15, 0xbf,
	0x88, 0x70, 0x34, 0x0e, 0x89, 0x2b, 0x31, 0x43, 0xe2, 0x11, 0xac, 0xfa, 0x72, 0x76, 0x7b, 0xe6,
	0x40, 0xe3, 0x46, 0x56, 0x8a, 0xbb, 0xd7, 0x53, 0x7e, 0xce, 0xf6, 0xba, 0xd2, 0x8d, 0xc2, 0xd1,
	0x06, 0xe4, 0xe8, 0x0a, 0x44, 0x9d, 0x65, 0xaa, 0xce, 0x2c, 0xf9, 0x26, 0xba, 0x24, 0xca, 0x26,
	0xee, 0xa9, 0x33, 0x4b, 0x14, 0xb9, 0xb2, 0x39, 0x48, 0x31, 0xd0, 0xbf, 0x43, 0xd9, 0xe7, 0xd2,
	0xc1, 0x7d, 0xfb, 0x31, 0x36, 0xaa, 0x95, 0x2b, 0xc2, 0xd5, 0x9c, 0x5a, 0xe2, 0x60, 0x95, 0x41,
	0xa5, 0x3f, 0x67, 0xe0, 0xe2, 0x36, 0xf5, 0x9a, 0xb1, 0x9f, 0x52, 0xc7, 0xf7, 0x43, 0xc7, 0x6d,
	0xb8, 0xd4, 0xf5, 0x07, 0xb0, 0xa1, 0x9d, 0xd8, 0xce, 0xb1, 0x66, 0x60, 0xb7, 0xeb, 0x98, 0x03,
	0x12, 0x19, 0xb8, 0xb7, 0xd6, 0x02, 0x38, 0x0f, 0x6c, 0xe7, 0x78, 0x67, 0x82, 0x81, 0x2c, 0x58,
	0x9f, 0xa2, 0x10, 0x38, 0xc5, 0x6e, 0x2e, 0x11, 0x41, 0x18, 0xf1, 0x89, 0x83, 0xac, 0x76, 0xa7,
	0x47, 0xd0, 0x2b, 0xb0, 0x36, 0xb5, 0x1e, 0x51, 0x61, 0x92, 0x72, 0x8a, 0x22, 0x53, 0x88, 0x36,
	0x3f, 0x84, 0x8a, 0xc3, 0xcf, 0x5e, 0x8d, 0xab, 0xc7, 0x3f, 0xec, 0x62, 0xc4, 0xb7, 0xc8, 0xb1,
	0xad, 0x8a, 0x4e, 0x18, 0xe0, 0x22, 0x09, 0x8a, 0x0e, 0xee, 0xe9, 0x34, 0x92, 0x1e, 0x99, 0x03,
	0xee, 0xb5, 0x21, 0x18, 0x71, 0x41, 0xfb, 0xc4, 0xc2, 0x8e, 0x66, 0xe9, 0x7d, 0xcc, 0x3d, 0x35,
	0x4f, 0x21, 0x4d, 0xbd, 0x8f, 0xa9, 0x0b, 0xfa, 0x1b, 0x4e, 0x31, 0x72, 0xdc, 0x05, 0x39, 0x90,
	0x22, 0x3d, 0x07, 0xc5, 0xc1, 0x91, 0x6d, 0x61, 0xcd, 0x1a, 0xf6, 0x1f, 0x62, 0x87, 0xbb, 0x69,
	0x81, 0xc2, 0x9a, 0x14, 0x44, 0xe8, 0xe0, 0xbe, 0x6e, 0xf6, 0x34, 0xdd, 0x30, 0x1c, 0xec, 0xba,
	0xdc, 0x4f, 0x8b, 0x14, 0xd8, 0x60, 0x30, 0x54, 0x85, 0x6c, 0xd7, 0x1e, 0x5a, 0x9e, 0x33, 0xa2,
	0x2e, 0x4a, 0xec, 0x8e, 0x7d, 0x22, 0x04, 0xa9, 0xae, 0xe9, 0x8d, 0xaa, 0x45, 0x0a, 0xa6, 0xbf,
	0xd1, 0x0b, 0x50, 0x72, 0x3d, 0x07, 0x63, 0x6f, 0x4c, 0x73, 0x85, 0x8e, 0xae, 0x30, 0xa8, 0x4f,
	0xf4, 0x1a, 0x54, 0x88, 0xab, 0x60, 0xcd, 0x76, 0xb4, 0x81, 0x63, 0x3f, 0x36, 0xad, 0x2e, 0xa6,
	0x5e, 0x93, 0x57, 0xcb, 0x74, 0xa0, 0xe5, 0xec, 0x73, 0x30, 0xb1, 0xfc, 0x27, 0xe6, 0x40, 0x23,
	0x79, 0x98, 0x6f, 0xf9, 0x4f, 0xcc, 0xc1, 0xb6, 0x6d, 0x60, 0x74, 0x09, 0xf2, 0xae, 0x79, 0x68,
	0xe9, 0xde, 0xd0, 0xc1, 0xdc, 0xee, 0x27, 0x00, 0xaa, 0x26, 0x7d, 0xe0, 0x75, 0x8f, 0x74, 0xcd,
	0xb3, 0x8f, 0xb1, 0x45, 0x8d, 0x9e, 0xa8, 0x89, 0x01, 0x3b, 0x04, 0x46, 0xd4, 0xc4, 0xb6, 0x4f,
	0xa3, 0x52, 0x57, 0x11, 0x53, 0x13, 0x83, 0xc9, 0x04, 0x14, 0xf5, 0xaf, 0xd5, 0xa8, 0x7f, 0xbd,
	0x97, 0xca, 0xa5, 0xc5, 0x8c, 0xf4, 0x29, 0x5c, 0x9a, 0xed, 0x3b, 0xfc, 0xb4, 0xa4, 0x1e, 0xac,
	0x9b, 0xfd, 0xc9, 0x71, 0x9b, 0xa5, 0xdf, 0x2c, 0xe4, 0x62, 0xc7, 0xb1, 0x1d, 0x26, 0x64, 0x82,
	0x09, 0x42, 0x21, 0x54, 0x4c, 0xb2, 0x4f, 0x74, 0xb8, 0x8f, 0x5d, 0x57, 0x3f, 0xc4, 0xdc, 0x7a,
	0x8b, 0x14, 0xb8, 0xc7, 0x60, 0xd2, 0x4f, 0x05, 0xa8, 0xdd, 0x33, 0x5d, 0xaf, 0xed, 0x39, 0xe6,
	0x31, 0x76, 0xb7, 0x46, 0xf7, 0x5d, 0xec, 0x28, 0x3b, 0xbe, 0xeb, 0x5e, 0x80, 0xec, 0xd0, 0xc5,
	0xce, 0x64, 0xf1, 0x0c, 0xf9, 0x54, 0x0c, 0x74, 0x00, 0x45, 0xb6, 0x15, 0x8f, 0xcc, 0x9e, 0x87,
	0x1d, 0xee, 0x88, 0xaf, 0x2d, 0x36, 0x75, 0xb6, 0x10, 0x09, 0x4f, 0xf8, 0x0e, 0x9d, 0xaa, 0x16,
	0xdc, 0xc9, 0x87, 0xf4, 0x04, 0x2e, 0xce, 0x64, 0x87, 0x6b, 0x63, 0x2e, 0x3f, 0x5b, 0x90, 0x75,
	0xd9, 0x9c, 0x6a, 0x82, 0x7a, 0xdd, 0xd5, 0xb8, 0xac, 0xa8, 0xfe, 0x44, 0xe9, 0x17, 0x02, 0xac,
	0xb2, 0x98, 0xc6, 0x47, 0xb8, 0x12, 0x36, 0x20, 0xc7, 0xfc, 0x6a, 0xb2, 0x05, 0xf4, 0x5b, 0x31,
	0xd0, 0x45, 0xc8, 0xb3, 0xd9, 0x64, 0x8c, 0xed, 0x40, 0x8e, 0x01, 0xd8, 0xfe, 0xb0, 0xc0, 0x49,
	0x67, 0x32, 0xed, 0xe7, 0x39, 0x44, 0x31, 0x88, 0xd1, 0xd3, 0x0f, 0xbd, 0xa7, 0x39, 0x58, 0x77,
	0x6d, 0x8b, 0x67, 0x03, 0x2b, 0x1c, 0xaa, 0x52, 0xa0, 0xf4, 0xa7, 0x04, 0x64, 0x18, 0x3f, 0x53,
	0xc9, 0xcd, 0x36, 0xa4, 0xa9, 0xee, 0xb8, 0xf6, 0xff, 0x63, 0x29, 0xed, 0xab, 0x6c, 0x2e, 0xba,
	0xc1, 0x0f, 0x6e, 0x6c, 0x68, 0xba, 0x17, 0x23, 0xab, 0xcf, 0x73, 0xec, 0x86, 0x47, 0xa6, 0xe2,
	0x4f, 0x06, 0xa6, 0x83, 0x5d, 0x32, 0x35, 0xb5, 0x78, 0x2a, 0xc7, 0x6e, 0xcc, 0x49, 0x27, 0xd3,
	0x4b, 0xa5, 0x22, 0x99, 0x39, 0xa9, 0x88, 0xa4, 0xc3, 0xea, 0x8c, 0x70, 0x2f, 0xbd, 0x37, 0x2b,
	0x8b, 0xcf, 0x43, 0xfa, 0x40, 0xd9, 0x91, 0x5b, 0xa2, 0x80, 0x10, 0x94, 0x94, 0xbd, 0xc6, 0xae,
	0xac, 0xb5, 0x54, 0x6d, 0xff, 0xdd, 0x56, 0xa7, 0x25, 0x26, 0x08, 0x6e, 0x43, 0xed, 0x3c, 0x68,
	0xa9, 0x77, 0xc5, 0x24, 0xc1, 0xdd, 0xbb, 0xdf, 0x56, 0xb6, 0xc5, 0x94, 0xf4, 0x1b, 0x01, 0x4a,
	0x0d, 0xc3, 0x20, 0xd6, 0xb9, 0xd0, 0x55, 0x9e, 0x23, 0x29, 0x5d, 0x7f, 0xa0, 0x5b, 0x23, 0x16,
	0x76, 0x99, 0x99, 0x14, 0x38, 0x6c, 0x66, 0xd4, 0x4d, 0x4e, 0x47, 0xdd, 0x2a, 0x64, 0xfd, 0xd8,
	0xc8, 0xcc, 0xc4, 0xff, 0x44, 0x6b, 0x90, 0x66, 0x41, 0x88, 0xa9, 0x8f, 0x7d, 0x48, 0x2f, 0x41,
	0x79, 0xcc, 0x20, 0x77, 0x9e, 0x2a, 0x64, 0xdd, 0x61, 0xb7, 0x4b, 0x48, 0x08, 0xf4, 0x20, 0xf7,
	0x3f, 0xa5, 0x97, 0xa1, 0xc2, 0x0c, 0x3f, 0x8e, 0x40, 0x52, 0x1d, 0x50, 0x10, 0x7b, 0x21, 0xf5,
	0x17, 0xa1, 0xb4, 0x8b, 0xbd, 0x58, 0xa4, 0x7f, 0x2b, 0x40, 0x79, 0x8c, 0xbb, 0xc8, 0xe7, 0xbf,
	0x1e, 0xc5, 0x6e, 0xc2, 0x05, 0xc5, 0x25, 0x0c, 0x36, 0x86, 0xde, 0x91, 0xed, 0x98, 0x4f, 0xb0,
	0xb1, 0x50, 0xac, 0xa7, 0x02, 0x54, 0xa7, 0x27, 0x71, 0xf9, 0x4a, 0x90, 0xb0, 0x8f, 0xb9, 0xce,
	0x12, 0xf6, 0x31, 0xa1, 0x72, 0xa4, 0xbb, 0xda, 0xe6, 0x9d, 0x06, 0x95, 0x28, 0xa7, 0x66, 0x8e,
	0x74, 0x77, 0xf3, 0x4e, 0x03, 0xbd, 0x0c, 0x88, 0x0c, 0x3c, 0xc6, 0x8e, 0xf9, 0xc8, 0xc4, 0x06,
	0x3f, 0x7a, 0x92, 0x14, 0x47, 0x3c, 0xd2, 0xdd, 0x03, 0x3e, 0xc0, 0xce, 0x9f, 0x17, 0xa0, 0x64,
	0xba, 0x9a, 0xde, 0xeb, 0xd9, 0x27, 0x3d, 0xd3, 0xf5, 0x30, 0xbb, 0x6c, 0xe4, 0xd4, 0x15, 0xd3,
	0x6d, 0x4c, 0x80, 0xd2, 0x2f, 0x53, 0x70, 0xbe, 0xa3, 0x1f, 0x63, 0xc3, 0x3e, 0xb1, 0xfc, 0xf4,
	0x83, 0x8b, 0x73, 0x11, 0xf2, 0xa6, 0xeb, 0x0e, 0x83, 0x02, 0xe5, 0x18, 0x40, 0x31, 0x90, 0x46,
	0x0e, 0x78, 0x8a, 0xce, 0x03, 0xae, 0xbc, 0x38, 0xfa, 0xcc, 0x5e, 0xc7, 0x4f, 0x67, 0x65, 0x92,
	0x1e, 0xa8, 0x3e, 0xd5, 0xa9, 0xdd, 0x4d, 0x2e, 0xde, 0xdd, 0xd4, 0xa9, 0xbb, 0x9b, 0x9e, 0xb3,
	0xbb, 0x99, 0xc0, 0xee, 0xa2, 0x1a, 0x3f, 0x6e, 0x75, 0xcb, 0xe3, 0x19, 0xd4, 0xf8, 0x9b, 0x64,
	0x2e, 0x24, 0x13, 0xe4, 0x79, 0x13, 0xfd, 0x8d, 0xfa, 0xb0, 0x4e, 0xb7, 0xdc, 0xc5, 0x3d, 0xdc,
	0x0d, 0x24, 0x7f, 0x34, 0x71, 0x2a, 0x6d, 0xde, 0x58, 0xac, 0x14, 0x62, 0x15, 0x6d, 0x3e, 0x3b,
	0x70, 0x7d, 0x53, 0x57, 0x87, 0xd3, 0x03, 0xb5, 0x43, 0x28, 0x06, 0xb5, 0x85, 0x44, 0x48, 0x1e,
	0xe3, 0x91, 0x5f, 0xdf, 0x39, 0xc6, 0x23, 0xd4, 0x80, 0xf4, 0x63, 0xbd, 0x37, 0x3c, 0x53, 0x81,
	0x87, 0xcd, 0xbc, 0x99, 0x78, 0x43, 0x90, 0xfe, 0x9e, 0x80, 0x0b, 0x53, 0xdb, 0xc5, 0x0d, 0xf6,
	0xa3, 0xc9, 0xd6, 0x0b, 0x74, 0xeb, 0xef, 0x9c, 0x61, 0xeb, 0x19, 0xad, 0x39, 0x7b, 0xff, 0x6d,
	0x72, 0x63, 0x60, 0x57, 0x8f, 0xb1, 0x01, 0x93, 0x8c, 0x6f, 0x80, 0x1d, 0xcf, 0xc4, 0x2e, 0xbf,
	0xc6, 0xbf, 0x15, 0xfb, 0xa6, 0x34, 0x36, 0xf8, 0xfd, 0x31, 0x0d, 0x72, 0xdf, 0x98, 0x37, 0xf6,
	0xd5, 0xa9, 0xf9, 0x7b, 0x02, 0xd4, 0xe6, 0xf3, 0x48, 0x4e, 0xbe, 0x23, 0xdd, 0xd0, 0x1e, 0xf6,
	0xb0, 0x65, 0x60, 0x47, 0x9b, 0x68, 0x9d, 0x38, 0x72, 0xe5, 0x48, 0x37, 0xb6, 0xd8, 0x88, 0x5f,
	0xfd, 0x78, 0x1d, 0xce, 0x13, 0xfc, 0x80, 0xd3, 0x6b, 0x24, 0x83, 0xd6, 0xfb, 0x3c, 0x92, 0xac,
	0x1d, 0xe9, 0x46, 0xc0, 0xf9, 0xdb, 0x74, 0x4c, 0xfa, 0x83, 0x00, 0x6b, 0x6d, 0xcf, 0x19, 0x76,
	0x8f, 0x23, 0x01, 0xe0, 0x94, 0xc4, 0xe7, 0x6d, 0x28, 0x9e, 0x98, 0x96, 0x61, 0x9f, 0x68, 0xb4,
	0xbe, 0x16, 0xa3, 0xb0, 0x52, 0x60, 0xf8, 0x6d, 0x82, 0x4e, 0x32, 0x07, 0x3e, 0x1d, 0x5b, 0x46,
	0x9c, 0xa4, 0x83, 0x61, 0xcb, 0x96, 0x21, 0x99, 0xb0, 0x1e, 0x61, 0x96, 0x9b, 0xe5, 0x3e, 0xbd,
	0x44, 0x0c, 0xbb, 0xc7, 0x5a, 0xd8, 0x3a, 0x5f, 0x8c, 0x6d, 0x26, 0xf4, 0xbe, 0x31, 0xa1, 0x2c,
	0xfd, 0x4d, 0x80, 0xcb, 0xa1, 0xb5, 0xf6, 0xf5, 0x43, 0xd3, 0x22, 0xc9, 0xcf, 0x37, 0x59, 0x43,
	0xe8, 0x3c, 0x64, 0xba, 0x43, 0xc7, 0xb5, 0xfd, 0x80, 0xc8, 0xbf, 0x48, 0xc4, 0xeb, 0x99, 0x7d,
	0xd3, 0xa3, 0x91, 0x30, 0xa9, 0xb2, 0x0f, 0xe9, 0x47, 0x02, 0x3c, 0x33, 0x4f, 0xc8, 0x2f, 0x4b,
	0xb3, 0x01, 0x16, 0x13, 0x41, 0x16, 0xa5, 0xdf, 0x0b, 0x50, 0x66, 0xcc, 0x6c, 0x8d, 0x62, 0x1d,
	0x43, 0x5f, 0x9f, 0x1d, 0x1a, 0x20, 0x4e, 0x38, 0xfd, 0xd2, 0x4c, 0xf0, 0xaf, 0x02, 0x54, 0xfd,
	0x65, 0xa6, 0xac, 0xef, 0x9b, 0xa9, 0x99, 0x25, 0xed, 0xef, 0x07, 0x02, 0x6c, 0xcc, 0x90, 0xf0,
	0x2b, 0x37, 0xbd, 0xcf, 0x13, 0x90, 0xf5, 0x71, 0x2e, 0x42, 0x3e, 0x5a, 0xe4, 0xce, 0x59, 0xc1,
	0x4a, 0xe7, 0xa4, 0x82, 0x9b, 0x88, 0x56, 0x70, 0x43, 0x9b, 0x92, 0x8c, 0x6c, 0x0a, 0xef, 0xc7,
	0xa4, 0x26, 0xfd, 0x98, 0x1b, 0x00, 0x74, 0x94, 0x95, 0x33, 0xd3, 0x8b, 0xf5, 0x4c, 0xb1, 0x69,
	0x29, 0xb3, 0x19, 0xa9, 0x15, 0x67, 0x96, 0x3f, 0x8a, 0x42, 0xe5, 0xe1, 0x35, 0x48, 0xb3, 0xda,
	0x2c, 0x4b, 0x7c, 0xd8, 0x87, 0x74, 0x0c, 0x97, 0x1a, 0xae, 0x6b, 0x1e, 0x5a, 0x1d, 0x7b, 0x3f,
	0x78, 0x31, 0x3b, 0x43, 0x63, 0x00, 0x3d, 0x0b, 0x05, 0x9d, 0xd2, 0xc2, 0x81, 0x0b, 0x33, 0xf8,
	0x20, 0xc5, 0x90, 0x3e, 0x85, 0xcb, 0x73, 0x16, 0xe3, 0xf6, 0xf0, 0xff, 0x20, 0x8e, 0xab, 0x6f,
	0xda, 0xbf, 0xda, 0x46, 0x28, 0x77, 0xc3, 0x00, 0x72, 0xad, 0xbb, 0xdc, 0xc6, 0xde, 0x8c, 0x22,
	0x7e, 0x40, 0x5a, 0x2e, 0x65, 0xc0, 0x06, 0xb8, 0xb4, 0x56, 0x70, 0x9a, 0x62, 0x04, 0xda, 0x07,
	0x89, 0x2f, 0xaa, 0x7d, 0x20, 0x7d, 0x02, 0xcf, 0xcc, 0x63, 0x90, 0x6b, 0xe8, 0x00, 0x4a, 0x61,
	0x0e, 0xb9, 0x7e, 0xae, 0x2f, 0xb9, 0xba, 0xba, 0x12, 0x92, 0x47, 0x7a, 0x04, 0x97, 0xf9, 0xcd,
	0x8c, 0xa1, 0xc5, 0xaf, 0x15, 0x8d, 0xfd, 0x3e, 0x11, 0xf0, 0xfb, 0x80, 0x1f, 0x26, 0x43, 0x7e,
	0xf8, 0x54, 0x80, 0x67, 0xe6, 0x2d, 0xc4, 0x45, 0xfc, 0x10, 0x2a, 0x51, 0x23, 0x70, 0x79, 0x5c,
	0x38, 0x83, 0x15, 0x88, 0x11, 0x2b, 0x70, 0xe7, 0x86, 0x88, 0xdb, 0x50, 0x0d, 0x71, 0xb6, 0x35,
	0x9a, 0x48, 0xff, 0x6f, 0x50, 0xa2, 0xd2, 0x47, 0x7d, 0xa0, 0x38, 0x1c, 0xa3, 0x2b, 0x86, 0x64,
	0xc3, 0xc6, 0x0c, 0x0a, 0x5c, 0x2c, 0x15, 0x0a, 0x01, 0x12, 0x67, 0x37, 0x6b, 0x98, 0x2c, 0x29,
	0xfd, 0x45, 0x80, 0xe7, 0x77, 0xb1, 0x17, 0x72, 0x26, 0x77, 0x6b, 0xa4, 0xf8, 0x41, 0xc4, 0x67,
	0x7f, 0x0b, 0xca, 0x93, 0x30, 0xa4, 0x3d, 0x72, 0xec, 0x3e, 0x5f, 0xff, 0xd4, 0xd6, 0xca, 0x38,
	0x16, 0xdd, 0x71, 0xec, 0x3e, 0x7a, 0x07, 0x56, 0x02, 0x34, 0x3c, 0x3b, 0xce, 0x91, 0x33, 0xa6,
	0xd0, 0xb1, 0xe7, 0x59, 0xc4, 0xc4, 0x7e, 0x52, 0xc1, 0x73, 0xe3, 0x73, 0x01, 0x2e, 0xee, 0x62,
	0x2f, 0x22, 0xbc, 0xfb, 0xb5, 0x1b, 0xc9, 0x03, 0x78, 0x71, 0x37, 0xe2, 0xa1, 0xee, 0xd6, 0x28,
	0xb4, 0x01, 0x13, 0xab, 0x59, 0xa6, 0xab, 0x3a, 0xa4, 0xb6, 0x13, 0x26, 0x3c, 0x96, 0xf6, 0x7d,
	0x28, 0x87, 0xbd, 0xde, 0x97, 0x75, 0x69, 0xb7, 0x2f, 0x85, 0xdc, 0xde, 0x95, 0x1a, 0x81, 0x6a,
	0x1a, 0xc3, 0xa4, 0xd5, 0xb4, 0x6b, 0xb3, 0xaa, 0x69, 0x05, 0xc8, 0xee, 0xab, 0xca, 0x5e, 0x43,
	0xfd, 0x80, 0xf5, 0xc5, 0xef, 0xb7, 0x65, 0x55, 0x4c, 0x48, 0xbf, 0x12, 0x60, 0x2d, 0x42, 0x83,
	0x96, 0x20, 0xa5, 0xef, 0xcc, 0x22, 0xb2, 0x0a, 0x65, 0x4e, 0x44, 0xdb, 0x56, 0xe5, 0x46, 0x87,
	0xb6, 0xbd, 0xd7, 0xa1, 0xe2, 0x03, 0x95, 0xa6, 0xdf, 0x1b, 0x4f, 0x20, 0x11, 0x8a, 0x3e, 0x78,
	0xa7, 0xd5, 0x94, 0xc5, 0x24, 0x5a, 0x03, 0xb1, 0x2d, 0x6f, 0xb7, 0x9a, 0x3b, 0x04, 0xd6, 0xd8,
	0xee, 0x28, 0x07, 0xb2, 0x98, 0x42, 0xe7, 0x01, 0x4d, 0xa0, 0x4a, 0x93, 0xc3, 0xd3, 0xd2, 0x67,
	0x79, 0x28, 0x47, 0x38, 0x5b, 0xea, 0x40, 0x9b, 0x53, 0x9a, 0x4c, 0xcc, 0xeb, 0x92, 0x36, 0xf9,
	0xeb, 0x8b, 0xe4, 0xd2, 0x7d, 0xab, 0x89, 0xea, 0xd9, 0x81, 0xc0, 0x1e, 0x63, 0xfc, 0x8f, 0x5f,
	0x01, 0x4e, 0x51, 0x82, 0x6f, 0x2e, 0x4d, 0x90, 0xee, 0x03, 0xa3, 0xc8, 0xeb, 0xc1, 0xe1, 0x46,
	0x6e, 0x3a, 0xda, 0xc8, 0x0d, 0x55, 0xbc, 0x33, 0x91, 0x8a, 0x37, 0x7d, 0x83, 0xc1, 0x06, 0x89,
	0x5f, 0xb3, 0x76, 0x71, 0x4e, 0x2d, 0x72, 0x04, 0x0a, 0x8b, 0x64, 0x3c, 0xb9, 0x65, 0x32, 0x9e,
	0x48, 0x4f, 0x25, 0x3f, 0xd5, 0xb3, 0x9c, 0xea, 0x71, 0xc1, 0x8c, 0x1e, 0xd7, 0xa2, 0x7e, 0x64,
	0xe1, 0xec, 0xfd, 0xc8, 0xe2, 0x57, 0xdb, 0x8f, 0x5c, 0x99, 0xdb, 0x8f, 0x7c, 0x07, 0x2e, 0x8e,
	0x15, 0xc1, 0x6e, 0xa8, 0xa1, 0xf6, 0x21, 0x6b, 0x9a, 0x6d, 0xf8, 0x28, 0x2d, 0x82, 0xa1, 0xce,
	0xef, 0x25, 0x96, 0xa3, 0xbd, 0xc4, 0x68, 0xe5, 0x4d, 0x8c, 0xd1, 0x26, 0xac, 0x9c, 0xde, 0x26,
	0x44, 0xb3, 0xdb, 0x84, 0xab, 0xa7, 0xb6, 0x09, 0xd7, 0x62, 0xb7, 0x09, 0xd7, 0x17, 0xb7, 0x09,
	0xcf, 0x9f, 0xd2, 0x26, 0xbc, 0x10, 0x6d, 0x13, 0x4e, 0x52, 0x59, 0x83, 0x1c, 0x75, 0xd5, 0x50,
	0x2a, 0x6b, 0x74, 0x6c, 0xf4, 0x32, 0xa0, 0xf0, 0xcd, 0x85, 0xee, 0xd8, 0x06, 0xc5, 0x13, 0x43,
	0x57, 0x92, 0xfb, 0x4e, 0xef, 0x9a, 0x06, 0x85, 0x40, 0x6f, 0x06, 0x55, 0x60, 0xa5, 0xdd, 0x51,
	0x95, 0xbb, 0xb2, 0x1f, 0xc2, 0xce, 0x21, 0x04, 0x25, 0x0e, 0x92, 0xdf, 0xdf, 0x57, 0x54, 0x1a,
	0x15, 0x27, 0xb0, 0xc9, 0x9b, 0xa0, 0x75, 0xa8, 0x70, 0xd8, 0xbe, 0xda, 0xda, 0x96, 0xdb, 0x6d,
	0xa5, 0xb9, 0x2b, 0x26, 0xaf, 0x3d, 0x15, 0xa0, 0x32, 0xd5, 0x7b, 0x0b, 0x20, 0xdf, 0x51, 0xee,
	0x75, 0x64, 0x55, 0x6b, 0xdc, 0xbb, 0x27, 0x9e, 0x43, 0x55, 0x58, 0x8b, 0x80, 0x19, 0x17, 0x02,
	0xda, 0x80, 0xf5, 0xf0, 0x88, 0xcf, 0x4c, 0x62, 0x7a, 0xc8, 0xe7, 0x29, 0x89, 0x2e, 0x41, 0x35,
	0x3c, 0x14, 0x60, 0x2d, 0x75, 0xed, 0x15, 0xb8, 0x30, 0xa7, 0x08, 0x4a, 0xce, 0x90, 0x7b, 0x4c,
	0xfc, 0x02, 0x64, 0x9b, 0xad, 0x26, 0xfd, 0x10, 0xae, 0x3d, 0x84, 0xfc, 0xf8, 0x0e, 0x33, 0x7e,
	0x7f, 0x15, 0x78, 0x92, 0x05, 0x90, 0xe1, 0xef, 0xad, 0x12, 0x24, 0xf4, 0xb7, 0x9a, 0xbb, 0x2d,
	0xa5, 0xb9, 0xab, 0x2d, 0x7c, 0x9c, 0x85, 0xf2, 0x90, 0x6e, 0x75, 0xde, 0x95, 0x55, 0x31, 0xbd,
	0xf9, 0xe3, 0x75, 0x80, 0xc9, 0x8b, 0x3d, 0xf4, 0x39, 0x39, 0xc3, 0x66, 0x34, 0x6a, 0xd1, 0xdb,
	0x31, 0x9c, 0x7d, 0xfe, 0xe3, 0x88, 0xda, 0x3b, 0x67, 0x9d, 0xce, 0x0f, 0xfe, 0x5f, 0x0b, 0x70,
	0x7e, 0xf6, 0x8d, 0x00, 0xdd, 0x8a, 0xd1, 0x0f, 0x3c, 0xed, 0xb2, 0x53, 0xbb, 0x7d, 0x76, 0x02,
	0x9c, 0xbb, 0xa7, 0x02, 0xac, 0xcf, 0xbc, 0xd0, 0xa1, 0x18, 0x72, 0x9f, 0x76, 0xed, 0xac, 0xdd,
	0x3a, 0xf3, 0x7c, 0xce, 0xda, 0xcf, 0x04, 0x40, 0xd3, 0xaf, 0xd4, 0x50, 0x8c, 0x23, 0x74, 0xee,
	0x23, 0xb9, 0xda, 0x5b, 0x67, 0x9b, 0xcc, 0x39, 0xfa, 0x9d, 0x00, 0x97, 0x4e, 0xcb, 0xd5, 0x51,
	0x8c, 0x16, 0x4b, 0x8c, 0x5c, 0xbf, 0xf6, 0x76, 0x2c, 0x32, 0x73, 0x13, 0xeb, 0x3f, 0x0a, 0x20,
	0x2d, 0xce, 0x70, 0xd1, 0xdd, 0x58, 0xab, 0xc4, 0xcb, 0x93, 0x6b, 0x6f, 0x9e, 0x81, 0xd8, 0x98,
	0xe1, 0x9f, 0x0b, 0xb0, 0x3a, 0xe3, 0x51, 0x01, 0x8a, 0xb1, 0x5b, 0xf3, 0x9f, 0x46, 0xc4, 0xd1,
	0xe2, 0x69, 0x2f, 0x19, 0x6c, 0x28, 0x06, 0xdf, 0x1a, 0xa0, 0xff, 0x8c, 0xf3, 0x4a, 0x68, 0xea,
	0x6d, 0x42, 0x2d, 0xf6, 0x33, 0x07, 0x64, 0x41, 0x96, 0x37, 0x84, 0xd1, 0x2b, 0x31, 0x7c, 0x27,
	0xd4, 0xdc, 0xae, 0xbd, 0xba, 0xc4, 0x0c, 0x2e, 0xe0, 0x09, 0xc0, 0xa4, 0x4b, 0x8c, 0x5e, 0x8b,
	0x2b, 0x5e, 0x70, 0xd5, 0xd7, 0x97, 0x9b, 0xc4, 0x17, 0xb6, 0x20, 0xcb, 0xef, 0xd8, 0x71, 0x04,
	0x0d, 0x77, 0xa6, 0xe3, 0x08, 0x1a, 0xed, 0x4f, 0xff, 0x50, 0x00, 0x31, 0xda, 0xdc, 0x45, 0x31,
	0x1a, 0x7f, 0x73, 0xba, 0xc8, 0xb5, 0x9b, 0x67, 0x99, 0xca, 0x79, 0xf9, 0x4c, 0x80, 0x72, 0xa4,
	0xd5, 0x86, 0xde, 0x38, 0x6b, 0x63, 0xb6, 0x76, 0xe3, 0xcc, 0x7d, 0x3d, 0xf4, 0x5d, 0x01, 0x56,
	0x42, 0x5d, 0x05, 0xf4, 0x5f, 0xb1, 0x2c, 0x75, 0xaa, 0x09, 0x55, 0xfb, 0xef, 0xa5, 0xe7, 0x71,
	0x16, 0x3e, 0x86, 0x9c, 0x5f, 0x57, 0x46, 0xaf, 0xc6, 0x25, 0x32, 0x6e, 0x3b, 0xd4, 0x36, 0x97,
	0x99, 0xc2, 0x97, 0xfc, 0x09, 0x4b, 0xb2, 0xc2, 0xb5, 0x6c, 0x74, 0x33, 0x3e, 0xa5, 0x68, 0x89,
	0x3f, 0x4e, 0xe0, 0x9b, 0x5f, 0x3c, 0xa7, 0xb9, 0xc1, 0xcc, 0xd6, 0x4e, 0xac, 0xdc, 0xe0, 0xb4,
	0xce, 0x57, 0xac, 0xdc, 0xe0, 0xf4, 0xae, 0x12, 0xe1, 0x6e, 0x76, 0xa1, 0x2f, 0x0e, 0x77, 0xa7,
	0xd6, 0x22, 0xe3, 0x70, 0xb7, 0xa0, 0xc6, 0x48, 0xb6, 0x72, 0xaa, 0x54, 0x17, 0x67, 0x2b, 0xe7,
	0x55, 0x08, 0x63, 0x9e, 0x61, 0xb3, 0x6b, 0x83, 0x5b, 0x2f, 0xfc, 0xef, 0xf3, 0x31, 0xfe, 0xa5,
	0xe4, 0x61, 0x86, 0xde, 0x9f, 0x5f, 0xfb, 0x67, 0x00, 0x00, 0x00, 0xff, 0xff, 0x39, 0x95, 0x4f,
	0xfb, 0x80, 0x32, 0x00, 0x00,
}
