// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchDartRendererTwirp/twirp.proto

/*
Package TwitchDartRendererTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchDartRendererTwirp/twirp.proto
*/
package TwitchDartRendererTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ============================
// TwitchDartRenderer Interface
// ============================

type TwitchDartRenderer interface {
	RenderTemplate(context.Context, *RenderTemplateInput) (*RenderTemplateOutput, error)

	BulkRenderTemplate(context.Context, *BulkRenderTemplateInput) (*BulkRenderTemplateOutput, error)

	RenderPreview(context.Context, *RenderDummyPreviewInput) (*RenderTemplateOutput, error)

	ValidateCustomNotification(context.Context, *ValidateCustomNotificationInput) (*ValidateCustomNotificationOutput, error)
}

// ==================================
// TwitchDartRenderer Protobuf Client
// ==================================

type twitchDartRendererProtobufClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewTwitchDartRendererProtobufClient creates a Protobuf client that implements the TwitchDartRenderer interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchDartRendererProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchDartRenderer {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchDartRendererPathPrefix
	urls := [4]string{
		prefix + "RenderTemplate",
		prefix + "BulkRenderTemplate",
		prefix + "RenderPreview",
		prefix + "ValidateCustomNotification",
	}

	return &twitchDartRendererProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchDartRendererProtobufClient) RenderTemplate(ctx context.Context, in *RenderTemplateInput) (*RenderTemplateOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchdartrenderer")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDartRenderer")
	ctx = ctxsetters.WithMethodName(ctx, "RenderTemplate")
	out := new(RenderTemplateOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDartRendererProtobufClient) BulkRenderTemplate(ctx context.Context, in *BulkRenderTemplateInput) (*BulkRenderTemplateOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchdartrenderer")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDartRenderer")
	ctx = ctxsetters.WithMethodName(ctx, "BulkRenderTemplate")
	out := new(BulkRenderTemplateOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDartRendererProtobufClient) RenderPreview(ctx context.Context, in *RenderDummyPreviewInput) (*RenderTemplateOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchdartrenderer")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDartRenderer")
	ctx = ctxsetters.WithMethodName(ctx, "RenderPreview")
	out := new(RenderTemplateOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDartRendererProtobufClient) ValidateCustomNotification(ctx context.Context, in *ValidateCustomNotificationInput) (*ValidateCustomNotificationOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchdartrenderer")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDartRenderer")
	ctx = ctxsetters.WithMethodName(ctx, "ValidateCustomNotification")
	out := new(ValidateCustomNotificationOutput)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==============================
// TwitchDartRenderer JSON Client
// ==============================

type twitchDartRendererJSONClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewTwitchDartRendererJSONClient creates a JSON client that implements the TwitchDartRenderer interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchDartRendererJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchDartRenderer {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchDartRendererPathPrefix
	urls := [4]string{
		prefix + "RenderTemplate",
		prefix + "BulkRenderTemplate",
		prefix + "RenderPreview",
		prefix + "ValidateCustomNotification",
	}

	return &twitchDartRendererJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchDartRendererJSONClient) RenderTemplate(ctx context.Context, in *RenderTemplateInput) (*RenderTemplateOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchdartrenderer")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDartRenderer")
	ctx = ctxsetters.WithMethodName(ctx, "RenderTemplate")
	out := new(RenderTemplateOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDartRendererJSONClient) BulkRenderTemplate(ctx context.Context, in *BulkRenderTemplateInput) (*BulkRenderTemplateOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchdartrenderer")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDartRenderer")
	ctx = ctxsetters.WithMethodName(ctx, "BulkRenderTemplate")
	out := new(BulkRenderTemplateOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDartRendererJSONClient) RenderPreview(ctx context.Context, in *RenderDummyPreviewInput) (*RenderTemplateOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchdartrenderer")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDartRenderer")
	ctx = ctxsetters.WithMethodName(ctx, "RenderPreview")
	out := new(RenderTemplateOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDartRendererJSONClient) ValidateCustomNotification(ctx context.Context, in *ValidateCustomNotificationInput) (*ValidateCustomNotificationOutput, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchdartrenderer")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDartRenderer")
	ctx = ctxsetters.WithMethodName(ctx, "ValidateCustomNotification")
	out := new(ValidateCustomNotificationOutput)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// TwitchDartRenderer Server Handler
// =================================

type twitchDartRendererServer struct {
	TwitchDartRenderer
	hooks *twirp.ServerHooks
}

func NewTwitchDartRendererServer(svc TwitchDartRenderer, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchDartRendererServer{
		TwitchDartRenderer: svc,
		hooks:              hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchDartRendererServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchDartRendererPathPrefix is used for all URL paths on a twirp TwitchDartRenderer server.
// Requests are always: POST TwitchDartRendererPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchDartRendererPathPrefix = "/twirp/twitch.fulton.twitchdartrenderer.TwitchDartRenderer/"

func (s *twitchDartRendererServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.twitchdartrenderer")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDartRenderer")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.twitchdartrenderer.TwitchDartRenderer/RenderTemplate":
		s.serveRenderTemplate(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchdartrenderer.TwitchDartRenderer/BulkRenderTemplate":
		s.serveBulkRenderTemplate(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchdartrenderer.TwitchDartRenderer/RenderPreview":
		s.serveRenderPreview(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.twitchdartrenderer.TwitchDartRenderer/ValidateCustomNotification":
		s.serveValidateCustomNotification(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchDartRendererServer) serveRenderTemplate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRenderTemplateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRenderTemplateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDartRendererServer) serveRenderTemplateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RenderTemplate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RenderTemplateInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RenderTemplateOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDartRenderer.RenderTemplate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RenderTemplateOutput and nil error while calling RenderTemplate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDartRendererServer) serveRenderTemplateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RenderTemplate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RenderTemplateInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RenderTemplateOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDartRenderer.RenderTemplate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RenderTemplateOutput and nil error while calling RenderTemplate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDartRendererServer) serveBulkRenderTemplate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkRenderTemplateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkRenderTemplateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDartRendererServer) serveBulkRenderTemplateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkRenderTemplate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkRenderTemplateInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkRenderTemplateOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDartRenderer.BulkRenderTemplate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkRenderTemplateOutput and nil error while calling BulkRenderTemplate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDartRendererServer) serveBulkRenderTemplateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkRenderTemplate")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BulkRenderTemplateInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkRenderTemplateOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDartRenderer.BulkRenderTemplate(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkRenderTemplateOutput and nil error while calling BulkRenderTemplate. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDartRendererServer) serveRenderPreview(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRenderPreviewJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRenderPreviewProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDartRendererServer) serveRenderPreviewJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RenderPreview")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RenderDummyPreviewInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RenderTemplateOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDartRenderer.RenderPreview(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RenderTemplateOutput and nil error while calling RenderPreview. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDartRendererServer) serveRenderPreviewProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RenderPreview")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RenderDummyPreviewInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RenderTemplateOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDartRenderer.RenderPreview(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RenderTemplateOutput and nil error while calling RenderPreview. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDartRendererServer) serveValidateCustomNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveValidateCustomNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveValidateCustomNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDartRendererServer) serveValidateCustomNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ValidateCustomNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ValidateCustomNotificationInput)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ValidateCustomNotificationOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDartRenderer.ValidateCustomNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateCustomNotificationOutput and nil error while calling ValidateCustomNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDartRendererServer) serveValidateCustomNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ValidateCustomNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ValidateCustomNotificationInput)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ValidateCustomNotificationOutput
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDartRenderer.ValidateCustomNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateCustomNotificationOutput and nil error while calling ValidateCustomNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDartRendererServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchDartRendererServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchDartRendererServer) PathPrefix() string {
	return TwitchDartRendererPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1740 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0x4f, 0x73, 0x23, 0x47,
	0x15, 0xf7, 0x68, 0x64, 0xfd, 0x79, 0x92, 0x65, 0xb9, 0x13, 0x76, 0x27, 0x02, 0xb2, 0x5e, 0x71,
	0x60, 0xd9, 0x10, 0x6d, 0x70, 0x2a, 0x84, 0x04, 0x28, 0x22, 0xaf, 0x9d, 0x58, 0x8e, 0xbd, 0x16,
	0x23, 0x79, 0x0f, 0x29, 0xaa, 0xa6, 0x46, 0x9a, 0xb6, 0x3d, 0xc9, 0xfc, 0xa3, 0xbb, 0xc7, 0xb6,
	0x72, 0xa1, 0x8a, 0x23, 0xf9, 0x10, 0x1c, 0xf6, 0x4e, 0x71, 0xe0, 0x6b, 0xc0, 0x8d, 0x2a, 0xaa,
	0xf8, 0x0a, 0x7c, 0x04, 0x0e, 0x54, 0xff, 0x19, 0x69, 0xc6, 0x1a, 0x61, 0x49, 0x5b, 0x70, 0xc8,
	0x45, 0xa5, 0xfe, 0x75, 0xbf, 0xd7, 0xaf, 0x5f, 0xbf, 0xf7, 0x7b, 0x6f, 0x1a, 0x3e, 0x1c, 0x87,
	0x0e, 0xee, 0x7c, 0x19, 0x53, 0xe6, 0x06, 0x1d, 0x76, 0xfd, 0xcc, 0xf6, 0xbf, 0x0e, 0x9e, 0x0d,
	0x6f, 0x5c, 0x36, 0xbe, 0x3a, 0xb0, 0x09, 0x33, 0x71, 0xe0, 0x60, 0x82, 0xc9, 0xf0, 0xc6, 0x25,
	0xd1, 0x33, 0xc6, 0x7f, 0x3b, 0x11, 0x09, 0x59, 0x88, 0x76, 0x99, 0x58, 0xd4, 0xb9, 0x88, 0x3d,
	0x16, 0x06, 0x1d, 0x39, 0x72, 0x6c, 0xc2, 0x88, 0x12, 0x69, 0xff, 0x5b, 0x87, 0x37, 0xa4, 0xfc,
	0x10, 0xfb, 0x91, 0x67, 0x33, 0xdc, 0x0b, 0xa2, 0x98, 0xa1, 0x87, 0x50, 0x8e, 0x29, 0x26, 0x96,
	0xeb, 0x18, 0xda, 0xae, 0xf6, 0xa4, 0x6a, 0x96, 0xf8, 0xb0, 0xe7, 0xa0, 0x47, 0x50, 0x63, 0x6a,
	0x25, 0x9f, 0x2c, 0x88, 0x49, 0x48, 0xa0, 0x9e, 0x83, 0x7e, 0x04, 0xcd, 0xe9, 0x82, 0x6b, 0x4c,
	0xa8, 0x1b, 0x06, 0x86, 0xbe, 0xab, 0x3d, 0xd9, 0x34, 0xb7, 0x13, 0xfc, 0xa5, 0x84, 0x11, 0x81,
	0x6d, 0x82, 0x7f, 0x1b, 0xbb, 0x04, 0x3b, 0xd6, 0xb5, 0xed, 0xc5, 0x98, 0x1a, 0xc5, 0x5d, 0xfd,
	0x49, 0x6d, 0xaf, 0xd7, 0xb9, 0xcf, 0xf0, 0x4e, 0x8e, 0xd1, 0x1d, 0x53, 0x29, 0x7b, 0x29, 0x74,
	0x1d, 0x06, 0x8c, 0x4c, 0xcc, 0x06, 0xc9, 0x80, 0xe8, 0x17, 0xd0, 0xa2, 0x98, 0x31, 0x37, 0xb8,
	0xa4, 0x56, 0x10, 0x32, 0xf7, 0xc2, 0x1d, 0xdb, 0xcc, 0x0d, 0x03, 0x8b, 0x4d, 0x22, 0x6c, 0x6c,
	0x8a, 0xe3, 0x18, 0xc9, 0x8a, 0x17, 0xa9, 0x05, 0xc3, 0x49, 0x84, 0xd1, 0x3b, 0xb0, 0x33, 0x2f,
	0x54, 0x12, 0x42, 0xcd, 0xe0, 0xee, 0xe2, 0x07, 0x50, 0xf2, 0xc2, 0xb1, 0xed, 0x61, 0xa3, 0x2c,
	0x5d, 0x28, 0x47, 0xe8, 0xfb, 0x00, 0xc2, 0xb7, 0x5e, 0x78, 0xe9, 0x06, 0x46, 0x45, 0xcc, 0x55,
	0x39, 0x72, 0xc2, 0x01, 0xf4, 0x43, 0xd8, 0xce, 0xec, 0xe1, 0x3a, 0x46, 0x55, 0xac, 0x69, 0xa4,
	0xe1, 0x9e, 0xd3, 0xea, 0xf2, 0xab, 0x9b, 0x3b, 0x31, 0x6a, 0x82, 0xfe, 0x15, 0x9e, 0xa8, 0x6b,
	0xe3, 0x7f, 0xd1, 0x9b, 0xb0, 0x29, 0xdc, 0xab, 0x6e, 0x4b, 0x0e, 0x3e, 0x2e, 0xfc, 0x4c, 0x6b,
	0xff, 0x59, 0x87, 0x37, 0xb3, 0x9e, 0x3c, 0x8b, 0x19, 0xbf, 0xff, 0x1c, 0x23, 0xb4, 0x3c, 0x23,
	0xd0, 0x67, 0xb0, 0x89, 0x7d, 0xdb, 0xf5, 0x84, 0xee, 0xda, 0xde, 0xb3, 0x65, 0x6f, 0x0e, 0x3b,
	0x87, 0x5c, 0xec, 0x68, 0xc3, 0x94, 0xf2, 0xe8, 0x00, 0x8a, 0x51, 0x4c, 0xaf, 0x44, 0xac, 0xd4,
	0xf6, 0x3a, 0xcb, 0xeb, 0xe9, 0xc7, 0xf4, 0xea, 0x68, 0xc3, 0x14, 0xd2, 0xe8, 0x18, 0x4a, 0x61,
	0x40, 0x5d, 0x86, 0x8d, 0xa2, 0xd0, 0xf3, 0xde, 0xf2, 0x7a, 0xce, 0x84, 0xdc, 0xd1, 0x86, 0xa9,
	0x34, 0xa0, 0x2e, 0xe8, 0x83, 0xd3, 0x81, 0x88, 0x89, 0xda, 0xde, 0xbb, 0xcb, 0x2b, 0x1a, 0x9c,
	0x0e, 0x8e, 0x36, 0x4c, 0x2e, 0x8b, 0xba, 0x50, 0x9c, 0x86, 0x48, 0x63, 0x19, 0x1d, 0xcf, 0xaf,
	0xec, 0x20, 0xc0, 0x1e, 0x8f, 0x1f, 0x53, 0x88, 0xee, 0x37, 0xa0, 0x9e, 0x76, 0x79, 0xfb, 0x9b,
	0x02, 0x3c, 0xdc, 0x8f, 0xbd, 0xaf, 0xf2, 0xb2, 0xf6, 0x9a, 0x27, 0x14, 0x87, 0x2d, 0x1e, 0xf5,
	0x98, 0x32, 0x6a, 0x68, 0x22, 0xa1, 0x4e, 0xef, 0xdf, 0x79, 0x81, 0x4e, 0x75, 0x2a, 0x53, 0xe9,
	0x9b, 0x26, 0x55, 0x1a, 0x6c, 0xdd, 0x26, 0x24, 0x92, 0x59, 0x96, 0x13, 0x89, 0x9f, 0xa7, 0x23,
	0xb1, 0xb6, 0xf7, 0xc1, 0x5a, 0x79, 0x9e, 0x0e, 0xe0, 0x3f, 0x14, 0xc0, 0x98, 0xb7, 0x5c, 0x05,
	0x31, 0x03, 0x65, 0xa8, 0x15, 0x0a, 0xe0, 0xb5, 0xbc, 0x21, 0x75, 0x2a, 0x7b, 0xe4, 0x40, 0x79,
	0x63, 0x8b, 0xa4, 0xb1, 0xd6, 0x2d, 0xa0, 0xf9, 0x45, 0x39, 0xbe, 0x38, 0xc9, 0xfa, 0xe2, 0xa7,
	0xab, 0xfa, 0x42, 0xaa, 0x4f, 0x3b, 0xe3, 0x4f, 0x1a, 0x6c, 0x65, 0xb2, 0x0b, 0x19, 0x50, 0xa6,
	0xf1, 0xe8, 0x4b, 0x3c, 0x66, 0x6a, 0xe7, 0x64, 0x88, 0x10, 0x14, 0x47, 0xa1, 0x33, 0x51, 0x94,
	0x20, 0xfe, 0x73, 0x62, 0x8a, 0x3c, 0xdb, 0x0d, 0x2c, 0x31, 0xa3, 0x4b, 0x62, 0x12, 0xc8, 0x3e,
	0x9f, 0xfe, 0x2e, 0x54, 0x2f, 0x48, 0xe8, 0x5b, 0x81, 0xed, 0xcb, 0xf4, 0xaa, 0x9a, 0x15, 0x0e,
	0xbc, 0xb0, 0x7d, 0x8c, 0x1e, 0x43, 0x5d, 0x4c, 0xda, 0x8e, 0x43, 0x30, 0xa5, 0x8a, 0x49, 0x6b,
	0x1c, 0xeb, 0x4a, 0x88, 0xbb, 0x60, 0x34, 0x1e, 0x1b, 0xa5, 0x5d, 0x9d, 0xbb, 0x60, 0x34, 0x1e,
	0xb7, 0xff, 0xae, 0x41, 0x3d, 0x9d, 0xc6, 0xbc, 0xba, 0xd8, 0x1e, 0x26, 0xcc, 0x62, 0x2e, 0xf3,
	0x12, 0xbe, 0x02, 0x01, 0x0d, 0x39, 0xc2, 0x4d, 0x94, 0x0b, 0xd2, 0x26, 0x0a, 0x44, 0x98, 0x38,
	0x02, 0xe4, 0x87, 0x23, 0xd7, 0xc3, 0x96, 0x83, 0x79, 0xb5, 0x14, 0x29, 0xa3, 0xa8, 0xe0, 0xfd,
	0xfb, 0x1d, 0x7c, 0x2a, 0x64, 0x0f, 0x66, 0xa2, 0xe6, 0x8e, 0x7f, 0x17, 0xe2, 0x6e, 0x70, 0x7d,
	0xfb, 0x12, 0x5b, 0x31, 0xf1, 0xd4, 0x31, 0x2b, 0x02, 0x38, 0x27, 0xde, 0x71, 0xb1, 0xa2, 0x35,
	0x0b, 0xed, 0x7f, 0xea, 0xd0, 0xc8, 0xd2, 0x0a, 0xfa, 0x44, 0x31, 0x81, 0x26, 0x98, 0xe0, 0xc7,
	0xf7, 0xdb, 0x22, 0xe5, 0x66, 0x44, 0x90, 0x7b, 0x63, 0x3f, 0x80, 0x2d, 0x76, 0x15, 0xfb, 0xa3,
	0xc0, 0x76, 0x3d, 0x61, 0x8f, 0xf4, 0x48, 0x7d, 0x0a, 0x9e, 0x13, 0xef, 0xff, 0xe2, 0x94, 0xc7,
	0x50, 0x57, 0xa9, 0x46, 0xd9, 0xc4, 0x4b, 0x0a, 0x69, 0x4d, 0x62, 0x03, 0x0e, 0xa1, 0x23, 0x28,
	0xdb, 0x63, 0xbe, 0x98, 0x8a, 0x10, 0x58, 0x8a, 0xe3, 0xa5, 0x13, 0xba, 0x42, 0xcc, 0x4c, 0xc4,
	0xd1, 0xaf, 0x01, 0x22, 0x9b, 0xd8, 0x3e, 0x66, 0x98, 0x50, 0xa3, 0x2c, 0x94, 0xfd, 0x64, 0x59,
	0x65, 0xfd, 0x44, 0xd2, 0x4c, 0x29, 0x41, 0x4f, 0x61, 0x87, 0xd9, 0xe4, 0x12, 0x33, 0x6b, 0x2c,
	0x19, 0x98, 0x57, 0x3c, 0x59, 0x9a, 0xb7, 0xe5, 0x84, 0x62, 0xe6, 0x9e, 0xd3, 0x7e, 0x0c, 0xb5,
	0x14, 0xd5, 0x4f, 0xef, 0x45, 0x9b, 0xdd, 0x4b, 0xfb, 0x0b, 0xd8, 0x99, 0x73, 0x1b, 0x5f, 0x38,
	0x0d, 0x81, 0xaa, 0xba, 0x54, 0x45, 0x0b, 0x85, 0x19, 0x2d, 0x3c, 0x82, 0xda, 0x88, 0x84, 0x37,
	0xbc, 0x41, 0xe0, 0x33, 0xf2, 0x42, 0x41, 0x41, 0x9f, 0xe3, 0x49, 0xfb, 0x23, 0xd8, 0xbe, 0x73,
	0x92, 0x65, 0x4b, 0x7e, 0xfb, 0x95, 0x06, 0xf5, 0xb4, 0x4b, 0x51, 0x03, 0x0a, 0xd3, 0xca, 0x5e,
	0x70, 0x9d, 0xdc, 0x18, 0x4b, 0xcc, 0xd6, 0x53, 0x66, 0xbf, 0x05, 0x15, 0x3f, 0x74, 0x6c, 0xe1,
	0x25, 0xc9, 0x04, 0x65, 0x31, 0xee, 0x39, 0xdc, 0x96, 0x73, 0xf3, 0x44, 0x05, 0x00, 0xff, 0x8b,
	0x3a, 0xf0, 0x46, 0x14, 0x52, 0x66, 0xc9, 0xeb, 0xb3, 0xc6, 0x61, 0xc0, 0x70, 0xc0, 0x54, 0xdb,
	0xb4, 0xc3, 0xa7, 0xa4, 0x35, 0xcf, 0xe5, 0x44, 0xfb, 0x8f, 0x45, 0x78, 0x28, 0x1d, 0x7c, 0x10,
	0xfb, 0xfe, 0xa4, 0x4f, 0xf0, 0xb5, 0x8b, 0x6f, 0x64, 0x85, 0x4b, 0x0a, 0xea, 0xe6, 0xda, 0x05,
	0x75, 0xd6, 0xb1, 0x94, 0x96, 0xed, 0x58, 0x12, 0xc6, 0x5d, 0xd0, 0xb1, 0x94, 0x97, 0xed, 0x58,
	0x12, 0x3d, 0x0b, 0x3a, 0x96, 0xca, 0xb2, 0x1d, 0xcb, 0xb4, 0x02, 0x2c, 0xe8, 0x58, 0xaa, 0xcb,
	0x76, 0x2c, 0x89, 0xa2, 0x54, 0xc7, 0xf2, 0x1b, 0x68, 0x32, 0x62, 0x07, 0xd4, 0x93, 0x7d, 0x9f,
	0x6f, 0x47, 0xd4, 0xa8, 0x0b, 0x7d, 0x4b, 0x64, 0xd8, 0x70, 0x26, 0x79, 0x6a, 0x47, 0xd4, 0xdc,
	0x66, 0x59, 0x00, 0x7d, 0x00, 0x0f, 0x62, 0x8a, 0xad, 0x88, 0xe2, 0xd8, 0x09, 0x45, 0x3b, 0xec,
	0x7e, 0x2d, 0xe9, 0x68, 0x6b, 0x57, 0x7b, 0x52, 0x31, 0xbf, 0x13, 0x53, 0xdc, 0x9f, 0x9b, 0x9c,
	0xeb, 0x81, 0xfe, 0xa1, 0xc3, 0x56, 0xe6, 0x52, 0xe6, 0xca, 0x8f, 0x36, 0x5f, 0x7e, 0x32, 0xe5,
	0xab, 0x70, 0xa7, 0x7c, 0xa5, 0x0a, 0xa5, 0x9e, 0x2d, 0x94, 0x8f, 0xa1, 0x1e, 0xc9, 0x08, 0xb4,
	0x18, 0xbe, 0x65, 0x2a, 0xdc, 0x6b, 0x0a, 0x1b, 0xe2, 0x5b, 0x86, 0xde, 0x06, 0x10, 0xac, 0x47,
	0xaf, 0x30, 0x66, 0x2a, 0xf2, 0x53, 0xc8, 0x34, 0xab, 0x4a, 0x0b, 0x6b, 0x6d, 0x39, 0xa7, 0xd6,
	0x46, 0x04, 0x53, 0xcc, 0x66, 0x3c, 0x54, 0x91, 0x40, 0xcf, 0x41, 0x17, 0xb0, 0xa5, 0x26, 0x2f,
	0x5c, 0xec, 0x39, 0xd4, 0xa8, 0x0a, 0x0a, 0xec, 0xae, 0x18, 0xc9, 0x9d, 0xbe, 0x50, 0xf2, 0xa9,
	0xd0, 0x21, 0x5b, 0x99, 0x7a, 0x94, 0x82, 0x92, 0x82, 0x0d, 0x32, 0x95, 0x47, 0xe3, 0x31, 0x27,
	0x27, 0xb5, 0xb3, 0x30, 0xbb, 0x26, 0x8f, 0x2a, 0x21, 0x6e, 0x77, 0xeb, 0x57, 0xb0, 0x33, 0xa7,
	0x75, 0xa5, 0x2f, 0x12, 0xde, 0x12, 0xa4, 0xf3, 0xe4, 0xdb, 0xd2, 0x12, 0xfc, 0x45, 0x87, 0x46,
	0x36, 0x6f, 0xf3, 0x0a, 0xc7, 0x7c, 0x41, 0x2f, 0xe6, 0x14, 0xf4, 0x4f, 0x32, 0x24, 0xb8, 0x4e,
	0x2f, 0x91, 0xef, 0x94, 0xd2, 0xff, 0xb4, 0x25, 0x28, 0xff, 0xd7, 0x96, 0xa0, 0xf2, 0x7a, 0x2d,
	0xc1, 0xdb, 0x99, 0x96, 0xa0, 0x2a, 0x5a, 0xcc, 0x7b, 0xeb, 0x3b, 0xe4, 0xd6, 0xf7, 0xe3, 0x62,
	0xa5, 0xd0, 0xd4, 0x8f, 0x8b, 0x15, 0xbd, 0x59, 0xe4, 0xb5, 0x3e, 0x45, 0x92, 0xb9, 0xb5, 0xfe,
	0xaf, 0x1a, 0x6c, 0xdf, 0x21, 0x3e, 0x74, 0x06, 0x45, 0xc1, 0x9c, 0xf2, 0x7b, 0xe3, 0xe7, 0x2b,
	0x33, 0x67, 0x87, 0xff, 0xc8, 0x94, 0x14, 0x8a, 0x5a, 0x2e, 0x54, 0xa7, 0x50, 0x4e, 0x3e, 0x7d,
	0x9a, 0xfd, 0x96, 0x78, 0x6f, 0xd5, 0x0d, 0xd3, 0x19, 0xf8, 0x2f, 0x0d, 0x1a, 0xd9, 0x59, 0x74,
	0x01, 0xf5, 0x14, 0x93, 0x27, 0xc7, 0xda, 0x5f, 0x75, 0x97, 0xf4, 0x30, 0x21, 0x9c, 0xb4, 0xde,
	0x16, 0x81, 0x9d, 0xb9, 0x25, 0x39, 0xa7, 0xfd, 0x2c, 0x7b, 0xda, 0xd5, 0x0a, 0x53, 0x8f, 0x61,
	0x3f, 0x7d, 0xdc, 0xf3, 0xcc, 0xed, 0xf1, 0xd9, 0x9c, 0x1d, 0x1f, 0x40, 0x29, 0xba, 0x22, 0x36,
	0x4d, 0xf8, 0x47, 0x8d, 0x78, 0xd9, 0x10, 0xed, 0xcc, 0xed, 0xb4, 0x6c, 0xa8, 0x61, 0x9b, 0xc0,
	0xa3, 0x97, 0xb6, 0xe7, 0x3a, 0x36, 0xc3, 0xcf, 0x63, 0xca, 0x42, 0x3f, 0xfd, 0x96, 0x74, 0xcf,
	0x1b, 0x9b, 0x01, 0x65, 0x1f, 0x53, 0x6a, 0x5f, 0x26, 0xdb, 0x25, 0x43, 0xf4, 0x3d, 0xa8, 0x52,
	0xf7, 0x32, 0xb0, 0x59, 0x4c, 0x92, 0x86, 0x6c, 0x06, 0xb4, 0x7f, 0x09, 0xbb, 0x8b, 0xf7, 0x54,
	0xdf, 0xc4, 0x6f, 0x41, 0xc5, 0xa5, 0xd6, 0x35, 0x5f, 0x26, 0x76, 0xad, 0x98, 0x65, 0x97, 0x0a,
	0xa9, 0xa7, 0x03, 0x80, 0x19, 0x51, 0xa0, 0x06, 0x40, 0x1f, 0x13, 0xea, 0x52, 0xde, 0x93, 0x35,
	0x37, 0x50, 0x15, 0x36, 0x87, 0xa1, 0x4d, 0x59, 0x53, 0x43, 0x0f, 0x00, 0xcd, 0xa6, 0xba, 0x81,
	0x23, 0xf1, 0x02, 0x42, 0xd0, 0xe8, 0x13, 0xf7, 0x9a, 0x6f, 0x6f, 0x7b, 0x5e, 0x18, 0xb3, 0xa6,
	0xfe, 0xf4, 0x43, 0xa8, 0xa5, 0x5a, 0x30, 0xae, 0xe5, 0xf0, 0xb4, 0xdb, 0x3b, 0x69, 0x6e, 0xa0,
	0x0a, 0x14, 0xfb, 0xe7, 0x83, 0xa3, 0xa6, 0x86, 0x00, 0x4a, 0x67, 0x2f, 0x06, 0xbd, 0xe1, 0x61,
	0xb3, 0x80, 0xca, 0xa2, 0x85, 0x69, 0xea, 0x7b, 0x7f, 0x2b, 0x02, 0x9a, 0x7f, 0xe3, 0x44, 0xbf,
	0x4b, 0xbe, 0xac, 0x92, 0xb4, 0x44, 0xeb, 0x3d, 0x22, 0xb4, 0xd6, 0xfc, 0xde, 0x46, 0xdf, 0x68,
	0x80, 0xe6, 0x5f, 0x07, 0xd0, 0x47, 0x6b, 0xbf, 0xb0, 0xb4, 0x3e, 0x5e, 0xff, 0x39, 0x02, 0xfd,
	0x7e, 0xfa, 0xc9, 0xaf, 0xda, 0xe4, 0x65, 0x0c, 0x59, 0xd0, 0x5c, 0xaf, 0xed, 0x92, 0x57, 0x1a,
	0xb4, 0x16, 0x07, 0x1e, 0x5a, 0xa2, 0x2f, 0xb9, 0x27, 0x55, 0x5a, 0xfb, 0xaf, 0xa3, 0x42, 0x5a,
	0xb9, 0xff, 0xee, 0x17, 0xef, 0xac, 0xf0, 0x8e, 0x3e, 0x2a, 0x89, 0x27, 0xf4, 0xf7, 0xff, 0x13,
	0x00, 0x00, 0xff, 0xff, 0xda, 0x3b, 0x02, 0xac, 0x7d, 0x17, 0x00, 0x00,
}
