// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchDropsFulfillmentServiceTwirp/twirp.proto

/*
Package TwitchDropsFulfillmentServiceTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchDropsFulfillmentServiceTwirp/twirp.proto
*/
package TwitchDropsFulfillmentServiceTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =======================================
// TwitchDropsFulfillmentService Interface
// =======================================

type TwitchDropsFulfillmentService interface {
	// FulfillDrop will attempt to take all necessary Actions of the drop associated
	// with the supplied Drop Instance ID.
	FulfillDrop(context.Context, *FulfillDropRequest) (*FulfillDropResponse, error)

	// VerifyClaimEligibility takes a Drop Instance ID and a user TUID
	// and returns states based on whether or not the supplied user is
	// eligible for any Benefits associated with the Drop Actions.
	// (see VerifyClaimEligibilityResponse)
	VerifyClaimEligibility(context.Context, *VerifyClaimEligibilityRequest) (*VerifyClaimEligibilityResponse, error)

	// ClaimRewards will attempt to entitle a user to all Benefits associated
	// with the Drop source of drop_instance_id. If the user is not eligible a
	// corresponding state will be returned (see ClaimRewardsResponse)
	ClaimRewards(context.Context, *ClaimRewardsRequest) (*ClaimRewardsResponse, error)

	// QueueClaimRequest will queue a message in the ClaimRequest queue, later entitling
	// a user to all Benefits associated with the Drop source of drop_instance_id by calling ClaimRewards.
	// If the user is not eligible a corresponding state will be returned (see QueueClaimRequestResponse)
	QueueClaimRequest(context.Context, *QueueClaimRequestRequest) (*QueueClaimRequestResponse, error)

	// Get Entitlements by IDs
	GetEntitlementsByID(context.Context, *GetEntitlementsByIDRequest) (*GetEntitlementsByIDResponse, error)

	// DeleteEntitlements will delete the entitlement from the underlying store
	DeleteEntitlementsByID(context.Context, *DeleteEntitlementsByIDRequest) (*DeleteEntitlementsByIDResponse, error)

	// List entitlements supports several permutations of arguments to query entitlement
	// records.
	ListEntitlementsByTuid(context.Context, *ListEntitlementsByTuidRequest) (*ListEntitlementsByTuidResponse, error)

	ListEntitlementsByTuidGame(context.Context, *ListEntitlementsByTuidGameRequest) (*ListEntitlementsByTuidGameResponse, error)

	ListEntitlementsByTuidOrganization(context.Context, *ListEntitlementsByTuidOrganizationRequest) (*ListEntitlementsByTuidOrganizationResponse, error)

	ListEntitlementsByGame(context.Context, *ListEntitlementsByGameRequest) (*ListEntitlementsByGameResponse, error)

	ListEntitlementsByOrganization(context.Context, *ListEntitlementsByOrganizationRequest) (*ListEntitlementsByOrganizationResponse, error)

	// List Rewards by Tuid supports the Twilight Inventory page and returns consumable data by fetching DMS data from ListEntitlementsByTuid returned GUIDS
	ListRewards(context.Context, *ListRewardsRequest) (*ListRewardsResponse, error)

	// Returns if a given campaign has still claimable items for given user
	HasClaimableItems(context.Context, *HasClaimableItemsRequest) (*HasClaimableItemsResponse, error)

	// UpdateEntitlementStatus allows entitlements to be updated to include
	UpdateEntitlementStatus(context.Context, *UpdateEntitlementStatusRequest) (*UpdateEntitlementStatusResponse, error)

	// List pending transactions will return a list of transactions in the PENDING state for a tuid
	ListPendingTransactionsForUser(context.Context, *ListPendingTransactionsForUserRequest) (*ListPendingTransactionsForUserResponse, error)

	// ////////////////////// PDMS APIs ////////////////////////
	// Deletes all user specific data for given tuid.
	DeleteUserData(context.Context, *DeleteUserDataRequest) (*DeleteUserDataResponse, error)

	// ////////////////////// Drop Claim Reminder Notification APIs ////////////////////////
	// Queues up a claim reminder that triggers a lambda to process it after 5 min
	QueueClaimReminderNotification(context.Context, *QueueClaimReminderNotificationRequest) (*QueueClaimReminderNotificationResponse, error)

	// API called by lambda to process previously queued claim notifications
	ProcessClaimReminderNotification(context.Context, *ProcessClaimReminderNotificationRequest) (*ProcessClaimReminderNotificationResponse, error)
}

// =============================================
// TwitchDropsFulfillmentService Protobuf Client
// =============================================

type twitchDropsFulfillmentServiceProtobufClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewTwitchDropsFulfillmentServiceProtobufClient creates a Protobuf client that implements the TwitchDropsFulfillmentService interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchDropsFulfillmentServiceProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchDropsFulfillmentService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchDropsFulfillmentServicePathPrefix
	urls := [18]string{
		prefix + "FulfillDrop",
		prefix + "VerifyClaimEligibility",
		prefix + "ClaimRewards",
		prefix + "QueueClaimRequest",
		prefix + "GetEntitlementsByID",
		prefix + "DeleteEntitlementsByID",
		prefix + "ListEntitlementsByTuid",
		prefix + "ListEntitlementsByTuidGame",
		prefix + "ListEntitlementsByTuidOrganization",
		prefix + "ListEntitlementsByGame",
		prefix + "ListEntitlementsByOrganization",
		prefix + "ListRewards",
		prefix + "HasClaimableItems",
		prefix + "UpdateEntitlementStatus",
		prefix + "ListPendingTransactionsForUser",
		prefix + "DeleteUserData",
		prefix + "QueueClaimReminderNotification",
		prefix + "ProcessClaimReminderNotification",
	}

	return &twitchDropsFulfillmentServiceProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchDropsFulfillmentServiceProtobufClient) FulfillDrop(ctx context.Context, in *FulfillDropRequest) (*FulfillDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillDrop")
	out := new(FulfillDropResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) VerifyClaimEligibility(ctx context.Context, in *VerifyClaimEligibilityRequest) (*VerifyClaimEligibilityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "VerifyClaimEligibility")
	out := new(VerifyClaimEligibilityResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) ClaimRewards(ctx context.Context, in *ClaimRewardsRequest) (*ClaimRewardsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ClaimRewards")
	out := new(ClaimRewardsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) QueueClaimRequest(ctx context.Context, in *QueueClaimRequestRequest) (*QueueClaimRequestResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "QueueClaimRequest")
	out := new(QueueClaimRequestResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) GetEntitlementsByID(ctx context.Context, in *GetEntitlementsByIDRequest) (*GetEntitlementsByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlementsByID")
	out := new(GetEntitlementsByIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) DeleteEntitlementsByID(ctx context.Context, in *DeleteEntitlementsByIDRequest) (*DeleteEntitlementsByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlementsByID")
	out := new(DeleteEntitlementsByIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) ListEntitlementsByTuid(ctx context.Context, in *ListEntitlementsByTuidRequest) (*ListEntitlementsByTuidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuid")
	out := new(ListEntitlementsByTuidResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) ListEntitlementsByTuidGame(ctx context.Context, in *ListEntitlementsByTuidGameRequest) (*ListEntitlementsByTuidGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuidGame")
	out := new(ListEntitlementsByTuidGameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) ListEntitlementsByTuidOrganization(ctx context.Context, in *ListEntitlementsByTuidOrganizationRequest) (*ListEntitlementsByTuidOrganizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuidOrganization")
	out := new(ListEntitlementsByTuidOrganizationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) ListEntitlementsByGame(ctx context.Context, in *ListEntitlementsByGameRequest) (*ListEntitlementsByGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByGame")
	out := new(ListEntitlementsByGameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) ListEntitlementsByOrganization(ctx context.Context, in *ListEntitlementsByOrganizationRequest) (*ListEntitlementsByOrganizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByOrganization")
	out := new(ListEntitlementsByOrganizationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) ListRewards(ctx context.Context, in *ListRewardsRequest) (*ListRewardsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListRewards")
	out := new(ListRewardsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) HasClaimableItems(ctx context.Context, in *HasClaimableItemsRequest) (*HasClaimableItemsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "HasClaimableItems")
	out := new(HasClaimableItemsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) UpdateEntitlementStatus(ctx context.Context, in *UpdateEntitlementStatusRequest) (*UpdateEntitlementStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEntitlementStatus")
	out := new(UpdateEntitlementStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) ListPendingTransactionsForUser(ctx context.Context, in *ListPendingTransactionsForUserRequest) (*ListPendingTransactionsForUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListPendingTransactionsForUser")
	out := new(ListPendingTransactionsForUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) DeleteUserData(ctx context.Context, in *DeleteUserDataRequest) (*DeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUserData")
	out := new(DeleteUserDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) QueueClaimReminderNotification(ctx context.Context, in *QueueClaimReminderNotificationRequest) (*QueueClaimReminderNotificationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "QueueClaimReminderNotification")
	out := new(QueueClaimReminderNotificationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceProtobufClient) ProcessClaimReminderNotification(ctx context.Context, in *ProcessClaimReminderNotificationRequest) (*ProcessClaimReminderNotificationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ProcessClaimReminderNotification")
	out := new(ProcessClaimReminderNotificationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================================
// TwitchDropsFulfillmentService JSON Client
// =========================================

type twitchDropsFulfillmentServiceJSONClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewTwitchDropsFulfillmentServiceJSONClient creates a JSON client that implements the TwitchDropsFulfillmentService interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchDropsFulfillmentServiceJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchDropsFulfillmentService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchDropsFulfillmentServicePathPrefix
	urls := [18]string{
		prefix + "FulfillDrop",
		prefix + "VerifyClaimEligibility",
		prefix + "ClaimRewards",
		prefix + "QueueClaimRequest",
		prefix + "GetEntitlementsByID",
		prefix + "DeleteEntitlementsByID",
		prefix + "ListEntitlementsByTuid",
		prefix + "ListEntitlementsByTuidGame",
		prefix + "ListEntitlementsByTuidOrganization",
		prefix + "ListEntitlementsByGame",
		prefix + "ListEntitlementsByOrganization",
		prefix + "ListRewards",
		prefix + "HasClaimableItems",
		prefix + "UpdateEntitlementStatus",
		prefix + "ListPendingTransactionsForUser",
		prefix + "DeleteUserData",
		prefix + "QueueClaimReminderNotification",
		prefix + "ProcessClaimReminderNotification",
	}

	return &twitchDropsFulfillmentServiceJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchDropsFulfillmentServiceJSONClient) FulfillDrop(ctx context.Context, in *FulfillDropRequest) (*FulfillDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillDrop")
	out := new(FulfillDropResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) VerifyClaimEligibility(ctx context.Context, in *VerifyClaimEligibilityRequest) (*VerifyClaimEligibilityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "VerifyClaimEligibility")
	out := new(VerifyClaimEligibilityResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) ClaimRewards(ctx context.Context, in *ClaimRewardsRequest) (*ClaimRewardsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ClaimRewards")
	out := new(ClaimRewardsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) QueueClaimRequest(ctx context.Context, in *QueueClaimRequestRequest) (*QueueClaimRequestResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "QueueClaimRequest")
	out := new(QueueClaimRequestResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) GetEntitlementsByID(ctx context.Context, in *GetEntitlementsByIDRequest) (*GetEntitlementsByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlementsByID")
	out := new(GetEntitlementsByIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) DeleteEntitlementsByID(ctx context.Context, in *DeleteEntitlementsByIDRequest) (*DeleteEntitlementsByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlementsByID")
	out := new(DeleteEntitlementsByIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) ListEntitlementsByTuid(ctx context.Context, in *ListEntitlementsByTuidRequest) (*ListEntitlementsByTuidResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuid")
	out := new(ListEntitlementsByTuidResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) ListEntitlementsByTuidGame(ctx context.Context, in *ListEntitlementsByTuidGameRequest) (*ListEntitlementsByTuidGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuidGame")
	out := new(ListEntitlementsByTuidGameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) ListEntitlementsByTuidOrganization(ctx context.Context, in *ListEntitlementsByTuidOrganizationRequest) (*ListEntitlementsByTuidOrganizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuidOrganization")
	out := new(ListEntitlementsByTuidOrganizationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) ListEntitlementsByGame(ctx context.Context, in *ListEntitlementsByGameRequest) (*ListEntitlementsByGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByGame")
	out := new(ListEntitlementsByGameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) ListEntitlementsByOrganization(ctx context.Context, in *ListEntitlementsByOrganizationRequest) (*ListEntitlementsByOrganizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByOrganization")
	out := new(ListEntitlementsByOrganizationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) ListRewards(ctx context.Context, in *ListRewardsRequest) (*ListRewardsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListRewards")
	out := new(ListRewardsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) HasClaimableItems(ctx context.Context, in *HasClaimableItemsRequest) (*HasClaimableItemsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "HasClaimableItems")
	out := new(HasClaimableItemsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) UpdateEntitlementStatus(ctx context.Context, in *UpdateEntitlementStatusRequest) (*UpdateEntitlementStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEntitlementStatus")
	out := new(UpdateEntitlementStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) ListPendingTransactionsForUser(ctx context.Context, in *ListPendingTransactionsForUserRequest) (*ListPendingTransactionsForUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ListPendingTransactionsForUser")
	out := new(ListPendingTransactionsForUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) DeleteUserData(ctx context.Context, in *DeleteUserDataRequest) (*DeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUserData")
	out := new(DeleteUserDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) QueueClaimReminderNotification(ctx context.Context, in *QueueClaimReminderNotificationRequest) (*QueueClaimReminderNotificationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "QueueClaimReminderNotification")
	out := new(QueueClaimReminderNotificationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchDropsFulfillmentServiceJSONClient) ProcessClaimReminderNotification(ctx context.Context, in *ProcessClaimReminderNotificationRequest) (*ProcessClaimReminderNotificationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithMethodName(ctx, "ProcessClaimReminderNotification")
	out := new(ProcessClaimReminderNotificationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================================
// TwitchDropsFulfillmentService Server Handler
// ============================================

type twitchDropsFulfillmentServiceServer struct {
	TwitchDropsFulfillmentService
	hooks *twirp.ServerHooks
}

func NewTwitchDropsFulfillmentServiceServer(svc TwitchDropsFulfillmentService, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchDropsFulfillmentServiceServer{
		TwitchDropsFulfillmentService: svc,
		hooks:                         hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchDropsFulfillmentServiceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchDropsFulfillmentServicePathPrefix is used for all URL paths on a twirp TwitchDropsFulfillmentService server.
// Requests are always: POST TwitchDropsFulfillmentServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchDropsFulfillmentServicePathPrefix = "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/"

func (s *twitchDropsFulfillmentServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitchdropsfulfillmentservice")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchDropsFulfillmentService")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/FulfillDrop":
		s.serveFulfillDrop(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/VerifyClaimEligibility":
		s.serveVerifyClaimEligibility(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/ClaimRewards":
		s.serveClaimRewards(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/QueueClaimRequest":
		s.serveQueueClaimRequest(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/GetEntitlementsByID":
		s.serveGetEntitlementsByID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/DeleteEntitlementsByID":
		s.serveDeleteEntitlementsByID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/ListEntitlementsByTuid":
		s.serveListEntitlementsByTuid(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/ListEntitlementsByTuidGame":
		s.serveListEntitlementsByTuidGame(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/ListEntitlementsByTuidOrganization":
		s.serveListEntitlementsByTuidOrganization(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/ListEntitlementsByGame":
		s.serveListEntitlementsByGame(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/ListEntitlementsByOrganization":
		s.serveListEntitlementsByOrganization(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/ListRewards":
		s.serveListRewards(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/HasClaimableItems":
		s.serveHasClaimableItems(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/UpdateEntitlementStatus":
		s.serveUpdateEntitlementStatus(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/ListPendingTransactionsForUser":
		s.serveListPendingTransactionsForUser(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/DeleteUserData":
		s.serveDeleteUserData(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/QueueClaimReminderNotification":
		s.serveQueueClaimReminderNotification(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitchdropsfulfillmentservice.TwitchDropsFulfillmentService/ProcessClaimReminderNotification":
		s.serveProcessClaimReminderNotification(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveFulfillDrop(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFulfillDropJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillDropProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveFulfillDropJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillDropRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.FulfillDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillDropResponse and nil error while calling FulfillDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveFulfillDropProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillDropRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.FulfillDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillDropResponse and nil error while calling FulfillDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveVerifyClaimEligibility(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveVerifyClaimEligibilityJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveVerifyClaimEligibilityProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveVerifyClaimEligibilityJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "VerifyClaimEligibility")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(VerifyClaimEligibilityRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *VerifyClaimEligibilityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.VerifyClaimEligibility(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VerifyClaimEligibilityResponse and nil error while calling VerifyClaimEligibility. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveVerifyClaimEligibilityProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "VerifyClaimEligibility")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(VerifyClaimEligibilityRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *VerifyClaimEligibilityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.VerifyClaimEligibility(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *VerifyClaimEligibilityResponse and nil error while calling VerifyClaimEligibility. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveClaimRewards(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveClaimRewardsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveClaimRewardsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveClaimRewardsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClaimRewards")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ClaimRewardsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ClaimRewardsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ClaimRewards(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClaimRewardsResponse and nil error while calling ClaimRewards. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveClaimRewardsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClaimRewards")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ClaimRewardsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ClaimRewardsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ClaimRewards(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClaimRewardsResponse and nil error while calling ClaimRewards. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveQueueClaimRequest(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueueClaimRequestJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueueClaimRequestProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveQueueClaimRequestJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueueClaimRequest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueueClaimRequestRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueueClaimRequestResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.QueueClaimRequest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueueClaimRequestResponse and nil error while calling QueueClaimRequest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveQueueClaimRequestProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueueClaimRequest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueueClaimRequestRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueueClaimRequestResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.QueueClaimRequest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueueClaimRequestResponse and nil error while calling QueueClaimRequest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveGetEntitlementsByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEntitlementsByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEntitlementsByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveGetEntitlementsByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlementsByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEntitlementsByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEntitlementsByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.GetEntitlementsByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEntitlementsByIDResponse and nil error while calling GetEntitlementsByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveGetEntitlementsByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlementsByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetEntitlementsByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEntitlementsByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.GetEntitlementsByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEntitlementsByIDResponse and nil error while calling GetEntitlementsByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveDeleteEntitlementsByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteEntitlementsByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteEntitlementsByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveDeleteEntitlementsByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlementsByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteEntitlementsByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteEntitlementsByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.DeleteEntitlementsByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEntitlementsByIDResponse and nil error while calling DeleteEntitlementsByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveDeleteEntitlementsByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlementsByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteEntitlementsByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteEntitlementsByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.DeleteEntitlementsByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEntitlementsByIDResponse and nil error while calling DeleteEntitlementsByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByTuid(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEntitlementsByTuidJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEntitlementsByTuidProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByTuidJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEntitlementsByTuidRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByTuidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByTuid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByTuidResponse and nil error while calling ListEntitlementsByTuid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByTuidProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuid")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEntitlementsByTuidRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByTuidResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByTuid(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByTuidResponse and nil error while calling ListEntitlementsByTuid. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByTuidGame(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEntitlementsByTuidGameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEntitlementsByTuidGameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByTuidGameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuidGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEntitlementsByTuidGameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByTuidGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByTuidGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByTuidGameResponse and nil error while calling ListEntitlementsByTuidGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByTuidGameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuidGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEntitlementsByTuidGameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByTuidGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByTuidGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByTuidGameResponse and nil error while calling ListEntitlementsByTuidGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByTuidOrganization(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEntitlementsByTuidOrganizationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEntitlementsByTuidOrganizationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByTuidOrganizationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuidOrganization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEntitlementsByTuidOrganizationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByTuidOrganizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByTuidOrganization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByTuidOrganizationResponse and nil error while calling ListEntitlementsByTuidOrganization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByTuidOrganizationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByTuidOrganization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEntitlementsByTuidOrganizationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByTuidOrganizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByTuidOrganization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByTuidOrganizationResponse and nil error while calling ListEntitlementsByTuidOrganization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByGame(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEntitlementsByGameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEntitlementsByGameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByGameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEntitlementsByGameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByGameResponse and nil error while calling ListEntitlementsByGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByGameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEntitlementsByGameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByGameResponse and nil error while calling ListEntitlementsByGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByOrganization(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEntitlementsByOrganizationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEntitlementsByOrganizationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByOrganizationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByOrganization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEntitlementsByOrganizationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByOrganizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByOrganization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByOrganizationResponse and nil error while calling ListEntitlementsByOrganization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListEntitlementsByOrganizationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntitlementsByOrganization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEntitlementsByOrganizationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntitlementsByOrganizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListEntitlementsByOrganization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntitlementsByOrganizationResponse and nil error while calling ListEntitlementsByOrganization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListRewards(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListRewardsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListRewardsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveListRewardsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRewards")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListRewardsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListRewardsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListRewards(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRewardsResponse and nil error while calling ListRewards. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListRewardsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRewards")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListRewardsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListRewardsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListRewards(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRewardsResponse and nil error while calling ListRewards. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveHasClaimableItems(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHasClaimableItemsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHasClaimableItemsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveHasClaimableItemsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HasClaimableItems")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HasClaimableItemsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HasClaimableItemsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.HasClaimableItems(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HasClaimableItemsResponse and nil error while calling HasClaimableItems. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveHasClaimableItemsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HasClaimableItems")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HasClaimableItemsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HasClaimableItemsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.HasClaimableItems(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HasClaimableItemsResponse and nil error while calling HasClaimableItems. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveUpdateEntitlementStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateEntitlementStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateEntitlementStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveUpdateEntitlementStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEntitlementStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateEntitlementStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateEntitlementStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.UpdateEntitlementStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateEntitlementStatusResponse and nil error while calling UpdateEntitlementStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveUpdateEntitlementStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEntitlementStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateEntitlementStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateEntitlementStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.UpdateEntitlementStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateEntitlementStatusResponse and nil error while calling UpdateEntitlementStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListPendingTransactionsForUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListPendingTransactionsForUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListPendingTransactionsForUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveListPendingTransactionsForUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPendingTransactionsForUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListPendingTransactionsForUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPendingTransactionsForUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListPendingTransactionsForUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPendingTransactionsForUserResponse and nil error while calling ListPendingTransactionsForUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveListPendingTransactionsForUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPendingTransactionsForUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListPendingTransactionsForUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPendingTransactionsForUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ListPendingTransactionsForUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPendingTransactionsForUserResponse and nil error while calling ListPendingTransactionsForUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveDeleteUserData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteUserDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteUserDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveDeleteUserDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteUserDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.DeleteUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteUserDataResponse and nil error while calling DeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveDeleteUserDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteUserDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.DeleteUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteUserDataResponse and nil error while calling DeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveQueueClaimReminderNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueueClaimReminderNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueueClaimReminderNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveQueueClaimReminderNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueueClaimReminderNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueueClaimReminderNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueueClaimReminderNotificationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.QueueClaimReminderNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueueClaimReminderNotificationResponse and nil error while calling QueueClaimReminderNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveQueueClaimReminderNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueueClaimReminderNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueueClaimReminderNotificationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueueClaimReminderNotificationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.QueueClaimReminderNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueueClaimReminderNotificationResponse and nil error while calling QueueClaimReminderNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveProcessClaimReminderNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveProcessClaimReminderNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveProcessClaimReminderNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchDropsFulfillmentServiceServer) serveProcessClaimReminderNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ProcessClaimReminderNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ProcessClaimReminderNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ProcessClaimReminderNotificationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ProcessClaimReminderNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ProcessClaimReminderNotificationResponse and nil error while calling ProcessClaimReminderNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) serveProcessClaimReminderNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ProcessClaimReminderNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ProcessClaimReminderNotificationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ProcessClaimReminderNotificationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchDropsFulfillmentService.ProcessClaimReminderNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ProcessClaimReminderNotificationResponse and nil error while calling ProcessClaimReminderNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchDropsFulfillmentServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchDropsFulfillmentServiceServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchDropsFulfillmentServiceServer) PathPrefix() string {
	return TwitchDropsFulfillmentServicePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2640 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x5b, 0xcf, 0x6f, 0xdb, 0xc8,
	0xf5, 0x5f, 0xea, 0x87, 0x2d, 0x3f, 0xf9, 0x87, 0x3c, 0x4e, 0x1c, 0x45, 0x89, 0x1d, 0x87, 0xdf,
	0x6f, 0x12, 0xd7, 0x28, 0x94, 0xd4, 0x1b, 0xa4, 0x9b, 0x0d, 0xd0, 0x5d, 0x59, 0xa2, 0x63, 0x36,
	0xb2, 0xec, 0x52, 0x52, 0x7e, 0x6d, 0x77, 0x09, 0x5a, 0x1c, 0x2b, 0xdc, 0x50, 0xa4, 0x43, 0x52,
	0xc9, 0x3a, 0xb7, 0xa2, 0xc0, 0xf6, 0x10, 0xa0, 0x40, 0xb1, 0x2d, 0xd0, 0x5e, 0x8a, 0x45, 0x5b,
	0x14, 0x68, 0x8f, 0x3d, 0xf5, 0x5a, 0xa0, 0x3d, 0x16, 0xe8, 0xa1, 0x97, 0xf6, 0x52, 0x14, 0xd8,
	0xfe, 0x0d, 0x45, 0x81, 0x2d, 0x50, 0x70, 0x38, 0x94, 0x86, 0x16, 0x29, 0x3b, 0xb4, 0x1c, 0x18,
	0xd8, 0x4b, 0x22, 0xce, 0x7b, 0xf3, 0x7e, 0x7e, 0xe6, 0xcd, 0xbc, 0x21, 0x0d, 0x6b, 0x2d, 0x53,
	0xc5, 0xc5, 0x8f, 0xbb, 0xb6, 0xa3, 0x19, 0x45, 0xe7, 0xf9, 0x75, 0xa5, 0xf3, 0xd2, 0xb8, 0xde,
	0x78, 0xa1, 0x39, 0xad, 0x27, 0x15, 0xcb, 0xdc, 0xb3, 0xd7, 0xbb, 0xfa, 0xae, 0xa6, 0xeb, 0x1d,
	0x6c, 0x38, 0x75, 0x6c, 0x3d, 0xd7, 0x5a, 0xb8, 0xf1, 0x42, 0xb3, 0xf6, 0xae, 0x3b, 0xee, 0xbf,
	0xc5, 0x3d, 0xcb, 0x74, 0x4c, 0xf4, 0xb6, 0x43, 0xf8, 0x8b, 0xbb, 0x5d, 0xdd, 0x31, 0x8d, 0x22,
	0xfe, 0x44, 0xe9, 0xec, 0xe9, 0xb8, 0xe8, 0x8d, 0xaa, 0xae, 0x94, 0xdd, 0xbe, 0x14, 0xdb, 0x93,
	0x52, 0xb8, 0xd4, 0x36, 0xcd, 0xb6, 0x8e, 0xaf, 0x13, 0x11, 0x3b, 0xdd, 0xdd, 0xeb, 0x8e, 0xd6,
	0xc1, 0xb6, 0xa3, 0x74, 0xa8, 0xd4, 0xc2, 0x9d, 0x30, 0xcb, 0x88, 0x4d, 0x9b, 0x8a, 0xa1, 0xb4,
	0xf1, 0x30, 0x93, 0x0a, 0x37, 0xa2, 0x27, 0x9b, 0x2a, 0xd6, 0xed, 0x81, 0x19, 0xfc, 0xb7, 0x00,
	0x51, 0x5f, 0x5d, 0x36, 0x09, 0x3f, 0xeb, 0x62, 0xdb, 0x41, 0xcb, 0x90, 0x73, 0x1d, 0x90, 0x35,
	0xc3, 0x76, 0x14, 0xa3, 0x85, 0x65, 0x4d, 0xcd, 0x73, 0x4b, 0xdc, 0xf2, 0x84, 0x34, 0xed, 0x8e,
	0x8b, 0x74, 0x58, 0x54, 0xf9, 0xf7, 0x60, 0x2e, 0x30, 0xdf, 0xde, 0x33, 0x0d, 0x1b, 0xbf, 0x86,
	0x80, 0xcf, 0x53, 0x30, 0x26, 0xe1, 0x17, 0x8a, 0xa5, 0xa2, 0x79, 0x48, 0x19, 0x4a, 0x07, 0x7b,
	0x8c, 0x6b, 0x89, 0x3c, 0x27, 0x91, 0x67, 0xf4, 0xff, 0x90, 0x55, 0xb1, 0xdd, 0xb2, 0xb4, 0x3d,
	0x47, 0x33, 0x8d, 0x7c, 0xa2, 0x47, 0x66, 0x87, 0xd1, 0x0a, 0xcc, 0x68, 0x1d, 0xa5, 0x8d, 0x65,
	0xc5, 0xb6, 0xb1, 0x23, 0x77, 0x2d, 0x3d, 0x9f, 0xec, 0x71, 0x4e, 0x11, 0x52, 0xc9, 0xa5, 0x34,
	0x2d, 0x1d, 0x21, 0x48, 0x68, 0x6a, 0x3e, 0xd5, 0x23, 0x27, 0x34, 0x15, 0x2d, 0x40, 0xc6, 0x7c,
	0x61, 0x60, 0xcb, 0x35, 0x35, 0xdd, 0xa3, 0x8c, 0x93, 0x31, 0x51, 0x45, 0x97, 0x01, 0x3c, 0x32,
	0x31, 0x71, 0xac, 0xc7, 0x30, 0x41, 0x46, 0x6b, 0xae, 0x9d, 0x3a, 0x4c, 0x2a, 0xcf, 0x15, 0x4d,
	0x57, 0x76, 0x34, 0x5d, 0x73, 0xf6, 0xf3, 0xe3, 0x4b, 0xdc, 0xf2, 0xf4, 0xea, 0x46, 0x31, 0x06,
	0x4e, 0x8a, 0x5e, 0x48, 0x8a, 0x25, 0x46, 0x9e, 0x14, 0x90, 0x8e, 0x2e, 0xc0, 0x78, 0x5b, 0xe9,
	0x90, 0xc8, 0x66, 0x7a, 0xd6, 0x8c, 0xb9, 0x43, 0xa2, 0x8a, 0x2e, 0xc1, 0x44, 0x4b, 0xd7, 0xb0,
	0xe1, 0xb8, 0xe4, 0x89, 0x1e, 0x39, 0xe3, 0x0d, 0x8a, 0x2a, 0x5a, 0x85, 0x39, 0x32, 0xbb, 0x65,
	0x1a, 0x06, 0x6e, 0xb9, 0x01, 0x24, 0x11, 0x83, 0x1e, 0xeb, 0xac, 0x4b, 0x2e, 0xf7, 0xa8, 0x6e,
	0xd4, 0x6e, 0xc2, 0x98, 0x45, 0xcc, 0xca, 0x67, 0x97, 0xb8, 0xe5, 0xec, 0xea, 0x45, 0xdf, 0x33,
	0xe2, 0x44, 0xb1, 0x43, 0x20, 0x56, 0x5c, 0xc3, 0x06, 0xde, 0xd5, 0x1c, 0x89, 0xf2, 0xf2, 0xef,
	0xc3, 0x24, 0xeb, 0x05, 0x9a, 0x06, 0x78, 0xf8, 0xf0, 0xa1, 0xdc, 0xac, 0x35, 0xeb, 0x42, 0x25,
	0xf7, 0x16, 0x9a, 0x82, 0x89, 0xd2, 0xfd, 0x92, 0x58, 0x2d, 0xad, 0x55, 0x85, 0x1c, 0x87, 0x66,
	0x61, 0xaa, 0x2a, 0x6e, 0x8a, 0x0d, 0x59, 0x12, 0x4a, 0xe5, 0x0d, 0xa1, 0x92, 0x4b, 0xf0, 0x3f,
	0x49, 0x02, 0x34, 0x6d, 0x6c, 0x51, 0x98, 0x5c, 0x06, 0xd8, 0xf1, 0x74, 0xf4, 0x50, 0xe5, 0x65,
	0x82, 0x8e, 0x8a, 0x2a, 0xfa, 0x3f, 0xc8, 0x7a, 0xda, 0xbd, 0x6c, 0xf5, 0x11, 0x03, 0xde, 0x30,
	0x49, 0xd7, 0x65, 0x98, 0xa4, 0x4c, 0x2d, 0xb3, 0x6b, 0x38, 0x04, 0x2d, 0x69, 0x89, 0x4e, 0x2c,
	0xbb, 0x43, 0x68, 0x0d, 0x66, 0x74, 0xc5, 0x76, 0x64, 0x85, 0xb0, 0xb9, 0x4b, 0x95, 0x80, 0x26,
	0xbb, 0x5a, 0x28, 0x7a, 0xeb, 0xb8, 0xe8, 0xaf, 0xe3, 0x62, 0xc3, 0x5f, 0xc7, 0xd2, 0x94, 0x3b,
	0xa5, 0xe4, 0xce, 0x70, 0xc7, 0xd8, 0x3c, 0xa5, 0x07, 0xf2, 0x14, 0x02, 0xda, 0xb1, 0x28, 0xd0,
	0xde, 0x82, 0xb3, 0x16, 0x7e, 0xd6, 0xd5, 0x2c, 0xac, 0xca, 0x4a, 0x8b, 0xd8, 0x2c, 0xeb, 0x9a,
	0xf1, 0x94, 0xe0, 0xcc, 0x9b, 0x31, 0xe7, 0x33, 0x94, 0x3c, 0x7a, 0x55, 0x33, 0x9e, 0xba, 0x7e,
	0x6a, 0xb6, 0x9f, 0x68, 0xec, 0xa1, 0x25, 0x23, 0x65, 0x35, 0xbb, 0xec, 0x0f, 0x31, 0x99, 0x9d,
	0x78, 0x8d, 0xcc, 0x2e, 0x03, 0xaa, 0x6a, 0xb6, 0xe3, 0xa5, 0xc5, 0xf6, 0x6b, 0x07, 0x82, 0x94,
	0xd3, 0xed, 0x2d, 0x77, 0xf2, 0x9b, 0xdf, 0x83, 0xb9, 0x00, 0x27, 0xad, 0x12, 0x8f, 0x60, 0xdc,
	0x13, 0x65, 0xe7, 0xb9, 0xa5, 0xe4, 0x72, 0x76, 0xf5, 0xbd, 0x58, 0x6b, 0xa5, 0x8f, 0x0d, 0xc9,
	0x97, 0xc7, 0xff, 0x29, 0x0d, 0xf9, 0x0d, 0xc5, 0x2e, 0xeb, 0x8a, 0xd6, 0x51, 0x76, 0x74, 0x2c,
	0x3a, 0xb8, 0x33, 0xcc, 0x44, 0xf4, 0x29, 0x07, 0x33, 0x4a, 0xcb, 0xd1, 0x9e, 0xe3, 0xb2, 0xd2,
	0xd9, 0x53, 0xb4, 0xb6, 0x61, 0xe7, 0x13, 0xc4, 0xa8, 0xef, 0xc6, 0x32, 0x2a, 0x4a, 0x79, 0xb1,
	0x14, 0x50, 0x22, 0x1d, 0x54, 0x5a, 0x78, 0x95, 0x82, 0xe9, 0x20, 0x0f, 0x5a, 0x04, 0x68, 0xd1,
	0xdf, 0x62, 0x85, 0x5a, 0xcd, 0x8c, 0xa0, 0xef, 0x71, 0x90, 0xf1, 0xca, 0xea, 0xae, 0x49, 0x8d,
	0xc6, 0x27, 0x69, 0x74, 0xb1, 0x42, 0x95, 0x49, 0x3d, 0xb5, 0x85, 0xbf, 0x26, 0x20, 0xe3, 0x0f,
	0xa3, 0x79, 0x18, 0x23, 0x04, 0xdf, 0x58, 0xfa, 0x84, 0x3e, 0xe3, 0x20, 0xeb, 0xaf, 0xd2, 0xbe,
	0xad, 0xcf, 0xde, 0x88, 0xad, 0x3e, 0x7c, 0x89, 0xdd, 0xac, 0x15, 0x85, 0x9f, 0x71, 0x90, 0x65,
	0x88, 0xe8, 0x22, 0xf4, 0x4a, 0x89, 0xef, 0x40, 0x7f, 0x00, 0xdd, 0x84, 0xb3, 0xba, 0xd9, 0x52,
	0x74, 0xc1, 0x70, 0x34, 0x47, 0x27, 0xfb, 0x71, 0x55, 0xeb, 0x68, 0x0e, 0xa9, 0x32, 0x69, 0x29,
	0x9c, 0x88, 0x6e, 0xc1, 0x7c, 0x5b, 0x37, 0x77, 0x42, 0xa6, 0x79, 0x65, 0x27, 0x82, 0xca, 0xff,
	0x9b, 0x83, 0xf3, 0x21, 0x9e, 0xd2, 0x05, 0xf4, 0x19, 0x07, 0xb3, 0x4f, 0x0e, 0x52, 0xe9, 0x5a,
	0x1a, 0x19, 0x02, 0x3c, 0x5d, 0x83, 0x14, 0xc1, 0x70, 0xac, 0x7d, 0x69, 0x50, 0x7f, 0xa1, 0x02,
	0xf3, 0xe1, 0xcc, 0x28, 0x07, 0xc9, 0xa7, 0x78, 0x9f, 0xc6, 0xd4, 0xfd, 0x89, 0xce, 0x40, 0xfa,
	0xb9, 0xa2, 0x77, 0xbd, 0x1a, 0x9d, 0x91, 0xbc, 0x87, 0x77, 0x13, 0xef, 0x70, 0xfc, 0x87, 0xb0,
	0x70, 0x1f, 0x5b, 0xda, 0xee, 0x3e, 0x11, 0x24, 0xe8, 0x5a, 0x5b, 0xa3, 0xfb, 0xe0, 0x90, 0x55,
	0x1c, 0x76, 0xee, 0x48, 0x84, 0x9e, 0x3b, 0xbe, 0x48, 0xc2, 0x62, 0x94, 0xfc, 0xd7, 0x3d, 0xc4,
	0xa0, 0x8f, 0x60, 0xcc, 0x76, 0x14, 0xa7, 0x6b, 0x13, 0x65, 0xd3, 0xab, 0xeb, 0xb1, 0x62, 0xcf,
	0xd8, 0x50, 0x27, 0xd2, 0x24, 0x2a, 0x15, 0x35, 0xfb, 0x85, 0x32, 0x49, 0x92, 0x7b, 0xe7, 0x18,
	0x87, 0x8a, 0x5e, 0x91, 0x74, 0xa1, 0xdc, 0x72, 0x9d, 0xaf, 0xe3, 0x96, 0x69, 0xb8, 0x75, 0xb9,
	0xa3, 0x68, 0x86, 0x66, 0xb4, 0xc9, 0x26, 0x97, 0x94, 0xc2, 0x89, 0xe8, 0x01, 0x8c, 0xdb, 0xdd,
	0x4e, 0x47, 0xb1, 0xf6, 0xc9, 0x86, 0x96, 0x5d, 0xbd, 0x1d, 0x61, 0x0c, 0x31, 0xa3, 0xd3, 0x3b,
	0xb5, 0xfa, 0x56, 0xb8, 0x0b, 0xb2, 0xee, 0x09, 0xf0, 0x8e, 0x58, 0x54, 0x1a, 0xba, 0x0d, 0x19,
	0xbf, 0xa8, 0x91, 0x5d, 0x30, 0xbb, 0xba, 0x10, 0xba, 0x0f, 0xf5, 0x6a, 0x67, 0x8f, 0x1d, 0x9d,
	0x83, 0x71, 0x2f, 0x55, 0xaa, 0xb7, 0x1b, 0xd2, 0x8a, 0xa3, 0xf2, 0x75, 0x98, 0x23, 0xf9, 0x3d,
	0x7c, 0x93, 0x7a, 0x0d, 0xec, 0xfc, 0x3d, 0x09, 0x67, 0x82, 0x52, 0xbf, 0x2a, 0x88, 0x61, 0x72,
	0x9f, 0x1a, 0x69, 0xee, 0x6f, 0xc2, 0x7c, 0xd7, 0xc6, 0x56, 0xef, 0x60, 0xd3, 0x3f, 0xae, 0xa4,
	0x49, 0x61, 0x38, 0xe3, 0x52, 0xe9, 0xa9, 0xa6, 0x7f, 0x6e, 0x61, 0x11, 0x33, 0x1e, 0x1b, 0x31,
	0x99, 0x00, 0x62, 0x1e, 0x42, 0xfe, 0x3b, 0x5d, 0xdc, 0xc5, 0x34, 0xc1, 0x04, 0x2f, 0xa3, 0x81,
	0xcd, 0xa7, 0x49, 0x38, 0x1f, 0x22, 0xfa, 0xab, 0x53, 0x6d, 0xa2, 0x52, 0x9c, 0x3a, 0x62, 0x8a,
	0xd3, 0xb1, 0x53, 0x3c, 0x16, 0x48, 0xf1, 0xab, 0x14, 0x64, 0x99, 0x9d, 0x16, 0x5d, 0x81, 0x69,
	0xdc, 0x7f, 0xec, 0x07, 0x7e, 0x8a, 0x19, 0x15, 0x55, 0x56, 0x5e, 0x82, 0x95, 0x17, 0x9a, 0xba,
	0x64, 0x68, 0xea, 0xae, 0xc2, 0x4c, 0x4b, 0x71, 0x14, 0xdd, 0x6c, 0xcb, 0x9a, 0x83, 0x3b, 0xb2,
	0xdf, 0x85, 0x4a, 0x53, 0x74, 0xd8, 0xdd, 0x2c, 0x45, 0x15, 0x7d, 0x03, 0xce, 0x06, 0xf8, 0x82,
	0x9d, 0xa9, 0x84, 0x18, 0xee, 0x2d, 0xda, 0xa0, 0x9e, 0xeb, 0xf7, 0x19, 0xd4, 0x5b, 0xda, 0x63,
	0xf8, 0xa0, 0x1d, 0x67, 0x40, 0xfb, 0x4d, 0x98, 0xb0, 0x1d, 0xc5, 0x72, 0x6c, 0x59, 0x71, 0x08,
	0xfe, 0x87, 0xb7, 0x34, 0x19, 0x8f, 0xb9, 0xe4, 0xa0, 0x4b, 0x90, 0xf5, 0xe3, 0xdb, 0x6b, 0x2d,
	0x99, 0xb3, 0xa8, 0x8a, 0xba, 0x80, 0x18, 0x2c, 0xc8, 0x14, 0xa8, 0x70, 0x0c, 0xa0, 0xb2, 0x77,
	0x31, 0x1e, 0x50, 0x67, 0x77, 0x0f, 0x0e, 0xa1, 0xdb, 0x00, 0xdd, 0x3d, 0x55, 0x71, 0xdc, 0xde,
	0xc8, 0xa1, 0xfd, 0xe9, 0x30, 0x8f, 0x26, 0x28, 0x77, 0xc9, 0xe1, 0xff, 0x92, 0x84, 0x6c, 0xc3,
	0x52, 0x0c, 0x5b, 0x21, 0x9d, 0xae, 0x1b, 0x48, 0x82, 0xd3, 0x1e, 0x0c, 0xc6, 0xdc, 0xc7, 0xd1,
	0xe4, 0xff, 0x03, 0x48, 0xbb, 0x11, 0xf1, 0xda, 0xc8, 0xe9, 0x55, 0x21, 0x56, 0x40, 0x18, 0x63,
	0x5d, 0xef, 0xb1, 0xe4, 0xc9, 0x74, 0x43, 0x8f, 0xfb, 0x8b, 0xda, 0x0f, 0x7d, 0x7a, 0xa4, 0x35,
	0x62, 0x16, 0x1f, 0x1c, 0x62, 0xcb, 0xc5, 0xd8, 0x08, 0xcb, 0xc5, 0xbb, 0x00, 0xf8, 0x93, 0x3d,
	0xcd, 0x52, 0xc8, 0xa5, 0xcf, 0xf8, 0xa1, 0x19, 0x65, 0xb8, 0x79, 0x01, 0x0a, 0x77, 0xb1, 0xc3,
	0x2c, 0x71, 0x7b, 0x6d, 0x5f, 0xac, 0xf8, 0x55, 0xfc, 0x1a, 0xcc, 0x04, 0x97, 0xbb, 0x77, 0x64,
	0x9e, 0x90, 0xa6, 0x03, 0xeb, 0xdd, 0xe6, 0xbf, 0xcf, 0xc1, 0x85, 0x50, 0x39, 0xb4, 0x64, 0xab,
	0x30, 0xc9, 0xcc, 0xf0, 0x0f, 0xde, 0xef, 0xc7, 0x0b, 0x75, 0x5f, 0x90, 0x14, 0x90, 0xca, 0xff,
	0x8a, 0x83, 0x73, 0x6e, 0xf7, 0xcc, 0x9a, 0x31, 0x6c, 0x43, 0x62, 0x0a, 0x41, 0x22, 0x50, 0x08,
	0xae, 0xc1, 0x8c, 0x69, 0xb5, 0x15, 0x43, 0x7b, 0x49, 0xa2, 0xc4, 0xa0, 0x94, 0x1d, 0x16, 0x55,
	0xb7, 0x7d, 0x6b, 0x75, 0x2d, 0xdb, 0xb4, 0x68, 0x71, 0xa2, 0x4f, 0xe8, 0x02, 0x4c, 0xec, 0x29,
	0x6d, 0x2c, 0xdb, 0xda, 0x4b, 0x4c, 0x70, 0x95, 0x96, 0x32, 0xee, 0x40, 0x5d, 0x7b, 0x89, 0xf9,
	0x9f, 0x72, 0x90, 0x1f, 0x34, 0xf3, 0x4d, 0x46, 0x8a, 0xb1, 0x3b, 0xc1, 0xda, 0xcd, 0x3f, 0x81,
	0x85, 0x83, 0x96, 0xad, 0xed, 0x37, 0xba, 0x9a, 0x3a, 0x2c, 0x8c, 0x11, 0xc2, 0x82, 0x41, 0x48,
	0x1e, 0x08, 0xc2, 0xcf, 0x39, 0x58, 0x8c, 0x52, 0x75, 0x2a, 0x42, 0xf1, 0x25, 0x07, 0x97, 0xc3,
	0x0d, 0xbc, 0xab, 0x74, 0x70, 0x2c, 0x58, 0xf5, 0x55, 0x25, 0xa3, 0x03, 0x95, 0x0a, 0x06, 0x2a,
	0x62, 0x9b, 0x48, 0x9f, 0xf0, 0x36, 0xc1, 0xff, 0x82, 0x03, 0x7e, 0x98, 0xfb, 0xa7, 0x22, 0x47,
	0x77, 0xe0, 0x8a, 0x6b, 0xe3, 0x36, 0x36, 0x54, 0xcd, 0x68, 0x33, 0xd5, 0xde, 0x5e, 0x37, 0x2d,
	0xef, 0xb2, 0x2b, 0xfa, 0xaa, 0xed, 0x87, 0x1c, 0x5c, 0x3d, 0x6c, 0x76, 0xdf, 0x4b, 0x87, 0x21,
	0x1f, 0xcb, 0x4b, 0x46, 0x8f, 0x14, 0x90, 0xca, 0xff, 0x38, 0x01, 0x5f, 0x0b, 0x0f, 0xf9, 0x16,
	0x53, 0x75, 0x86, 0x21, 0x2f, 0xa4, 0x6e, 0x25, 0x0e, 0xa9, 0x5b, 0xa7, 0x1f, 0x89, 0xbf, 0xe5,
	0x60, 0xe5, 0x28, 0x61, 0x39, 0x15, 0x88, 0xfc, 0x82, 0x0b, 0xab, 0xa0, 0x6c, 0xc5, 0x60, 0xaa,
	0x03, 0x17, 0x51, 0x1d, 0x8e, 0x5e, 0x46, 0x23, 0x72, 0x92, 0x3a, 0xe9, 0x9c, 0x84, 0x57, 0xef,
	0x53, 0x54, 0x19, 0xbe, 0xe4, 0xbc, 0xd2, 0x10, 0x34, 0x30, 0x6c, 0x1d, 0x85, 0xac, 0x19, 0xee,
	0x90, 0x35, 0x73, 0xfa, 0xf3, 0xf3, 0x6b, 0x5a, 0xdb, 0x86, 0xb9, 0x7f, 0x2a, 0xf2, 0xf4, 0x5f,
	0x0e, 0x16, 0x9b, 0xa4, 0xc1, 0x60, 0xe6, 0x52, 0xbf, 0x5e, 0x37, 0x41, 0x21, 0xa7, 0xd5, 0x44,
	0xd8, 0x69, 0x35, 0x22, 0x29, 0xc9, 0x93, 0xee, 0xbc, 0xfc, 0x8a, 0x9d, 0x62, 0x36, 0xa1, 0x1f,
	0x24, 0xe0, 0x5c, 0x84, 0xff, 0xe8, 0x29, 0xa4, 0x5a, 0xa6, 0xea, 0xbd, 0xe5, 0x9d, 0x5e, 0x7d,
	0x10, 0xef, 0x8d, 0x4f, 0xb8, 0xec, 0xa2, 0xf7, 0x5f, 0xd9, 0x54, 0xb1, 0x44, 0x94, 0xa0, 0x1c,
	0x24, 0xfb, 0x01, 0x73, 0x7f, 0xf2, 0x1d, 0x80, 0x3e, 0xd7, 0xc0, 0xcb, 0xc8, 0x2c, 0x8c, 0xd7,
	0x9b, 0xe5, 0xb2, 0x50, 0xaf, 0xe7, 0x38, 0x34, 0x05, 0x13, 0xb5, 0xad, 0x86, 0xbc, 0xbe, 0xd5,
	0xac, 0x55, 0x72, 0x09, 0x94, 0x83, 0xc9, 0x66, 0xad, 0xd4, 0x6c, 0x6c, 0x6c, 0x49, 0xe2, 0x63,
	0xa1, 0x92, 0x4b, 0xba, 0xb3, 0xc5, 0xda, 0xfd, 0x52, 0x55, 0xac, 0xc8, 0x62, 0x25, 0x97, 0x42,
	0xb3, 0x30, 0xd5, 0xdc, 0xae, 0x94, 0x1a, 0x82, 0xbc, 0x5e, 0x12, 0xab, 0x42, 0x25, 0x97, 0xe6,
	0x5f, 0x71, 0x70, 0x29, 0x12, 0x09, 0x14, 0xab, 0x4f, 0x20, 0xe3, 0x25, 0x0b, 0xfb, 0x38, 0xad,
	0x8e, 0x32, 0x2a, 0x52, 0x4f, 0x3a, 0xbf, 0x01, 0x0b, 0x15, 0xac, 0xe3, 0x00, 0x53, 0xbc, 0xd6,
	0x68, 0x09, 0x16, 0xa3, 0x24, 0x79, 0x5e, 0xf1, 0x1f, 0xc3, 0x15, 0xf6, 0xb2, 0xab, 0xa3, 0x19,
	0x2a, 0xb6, 0x6a, 0xa6, 0xa3, 0xed, 0x6a, 0xad, 0x40, 0xa9, 0x8a, 0xec, 0xb7, 0x8f, 0x7e, 0xb3,
	0xb6, 0x0c, 0x57, 0x0f, 0xd3, 0x45, 0xad, 0xd2, 0xe1, 0xda, 0xb6, 0x65, 0xb6, 0xb0, 0x6d, 0xbf,
	0x09, 0xbb, 0x56, 0x60, 0xf9, 0x70, 0x6d, 0xd4, 0xb2, 0x1b, 0x70, 0xd6, 0x8b, 0xa8, 0x7b, 0x46,
	0xab, 0x28, 0x8e, 0x72, 0x98, 0x1d, 0x7c, 0x1e, 0xe6, 0x0f, 0xce, 0xf0, 0x64, 0xad, 0xfc, 0x87,
	0x83, 0xd9, 0x81, 0xde, 0x1d, 0x5d, 0x86, 0x05, 0xa1, 0x2a, 0xde, 0x15, 0xd7, 0xc4, 0xaa, 0xd8,
	0x78, 0x24, 0xd7, 0x1b, 0xa5, 0x46, 0xb3, 0x2e, 0x07, 0xf0, 0x7f, 0x1e, 0xce, 0x86, 0xb0, 0x6c,
	0xdd, 0xcb, 0x71, 0x68, 0x11, 0x0a, 0x21, 0x24, 0xf2, 0xae, 0x5e, 0x70, 0x97, 0xc7, 0x0d, 0xf8,
	0x7a, 0x08, 0x5d, 0xa8, 0x35, 0xc4, 0x46, 0x55, 0xd8, 0x14, 0x6a, 0x0d, 0x39, 0xf8, 0x5e, 0x3f,
	0x89, 0x6e, 0xc2, 0x8d, 0x90, 0x19, 0x15, 0x69, 0x6b, 0x5b, 0x16, 0x6b, 0xf5, 0x46, 0xa9, 0x56,
	0x16, 0xe4, 0x52, 0x55, 0x12, 0x4a, 0x95, 0x47, 0x72, 0xb9, 0x5a, 0x12, 0x37, 0x05, 0x77, 0x91,
	0x85, 0xdb, 0x21, 0x3c, 0xdc, 0x16, 0x25, 0x77, 0xc5, 0xad, 0xfc, 0x88, 0x83, 0xdc, 0xc1, 0x1b,
	0x12, 0xb4, 0x00, 0xe7, 0x1b, 0x52, 0xa9, 0x56, 0x2f, 0x95, 0x1b, 0xe2, 0x56, 0x8d, 0x4c, 0x12,
	0xe4, 0x66, 0xed, 0x5e, 0x6d, 0xeb, 0x41, 0x2d, 0xf7, 0x96, 0x2b, 0x73, 0x90, 0xec, 0x69, 0x21,
	0x1f, 0x25, 0x84, 0x4e, 0xdf, 0x16, 0x6a, 0x15, 0xb1, 0x76, 0x37, 0x97, 0x40, 0x97, 0xe0, 0xc2,
	0x20, 0xb9, 0xbc, 0xb5, 0xb9, 0x5d, 0x15, 0xdc, 0xd8, 0x24, 0x57, 0xf6, 0x61, 0x76, 0xa0, 0x96,
	0x22, 0x1e, 0x16, 0xd7, 0x9b, 0xd5, 0x75, 0xb1, 0x5a, 0x25, 0xd1, 0xa1, 0x8e, 0x34, 0x6b, 0xf5,
	0x6d, 0xa1, 0x2c, 0xae, 0x8b, 0x24, 0x1f, 0x8b, 0x50, 0x08, 0xe1, 0xf1, 0x83, 0xc1, 0xa1, 0x25,
	0xb8, 0x18, 0x42, 0xa7, 0x43, 0x6e, 0x5a, 0x56, 0xff, 0x79, 0x01, 0x16, 0x86, 0x7e, 0xd8, 0x84,
	0x3e, 0xe7, 0x20, 0xcb, 0x7c, 0xc3, 0x83, 0xee, 0x1e, 0x67, 0xaf, 0x60, 0xbe, 0x22, 0x2a, 0x6c,
	0x1c, 0x5f, 0x10, 0xad, 0x90, 0x7f, 0xe0, 0x60, 0x3e, 0xfc, 0x65, 0x1d, 0x92, 0x62, 0x29, 0x19,
	0xfa, 0x66, 0xb1, 0x50, 0x1f, 0xa9, 0x4c, 0xea, 0xc3, 0x2f, 0x39, 0x98, 0x64, 0x5f, 0x1a, 0xa1,
	0x78, 0xe1, 0x09, 0x79, 0x9b, 0x55, 0x10, 0x47, 0x20, 0x89, 0x5a, 0xf9, 0x3b, 0x0e, 0x66, 0x07,
	0xde, 0x51, 0xa0, 0xcd, 0x58, 0x0a, 0xa2, 0x5e, 0xa3, 0x14, 0x6a, 0xa3, 0x12, 0x47, 0x8d, 0xfe,
	0x3d, 0x07, 0x73, 0x21, 0xf7, 0x74, 0x68, 0x2b, 0x96, 0x9e, 0xe8, 0x9b, 0xc3, 0xc2, 0xf6, 0xe8,
	0x04, 0x32, 0xc8, 0x0e, 0xdf, 0x48, 0x63, 0x22, 0x7b, 0xe8, 0xfe, 0x1e, 0x13, 0xd9, 0xc3, 0x77,
	0x7a, 0xe2, 0x43, 0x78, 0x2b, 0x1b, 0xd3, 0x87, 0xa1, 0x97, 0x75, 0x31, 0x7d, 0x38, 0xe4, 0x56,
	0xee, 0xcf, 0x1c, 0x14, 0xa2, 0x2f, 0x86, 0xd0, 0xfd, 0x11, 0xea, 0x64, 0xda, 0xe6, 0xc2, 0x83,
	0x91, 0xcb, 0xa5, 0xfe, 0xfc, 0x2b, 0xf2, 0xa2, 0x8b, 0x6d, 0x97, 0xd0, 0x47, 0x23, 0xd4, 0x1f,
	0xd2, 0x86, 0x16, 0xe4, 0x13, 0x93, 0x3f, 0x14, 0x7b, 0x24, 0x67, 0xa3, 0xc2, 0x1e, 0x9b, 0xaf,
	0xfa, 0x48, 0x65, 0x52, 0x1f, 0xfe, 0x16, 0x7a, 0xed, 0x10, 0xc8, 0xd3, 0xe3, 0x11, 0xe9, 0x0d,
	0xcb, 0xd1, 0x07, 0x27, 0x22, 0x9b, 0xfa, 0xe6, 0x1e, 0x2e, 0x98, 0x4f, 0xff, 0x62, 0x1e, 0x2e,
	0x06, 0x3f, 0x33, 0x8c, 0x79, 0xb8, 0x08, 0xfb, 0x0a, 0xd1, 0xdd, 0xf2, 0x06, 0xbe, 0x57, 0x8a,
	0xb9, 0xe5, 0x45, 0x7d, 0x94, 0x16, 0x73, 0xcb, 0x8b, 0xfe, 0xf2, 0xeb, 0x8f, 0x5c, 0x74, 0x87,
	0x5d, 0x1f, 0x69, 0xf7, 0x48, 0x1d, 0x68, 0x8c, 0x56, 0xe8, 0x01, 0xe8, 0x47, 0xdf, 0x56, 0x1f,
	0x03, 0xfa, 0x87, 0x5e, 0xa0, 0x1f, 0x03, 0xfa, 0x47, 0xb8, 0x5e, 0xff, 0x0d, 0x07, 0xd3, 0xc1,
	0xfe, 0x0c, 0x7d, 0xfb, 0x18, 0xdb, 0xef, 0x81, 0xb6, 0xb0, 0x70, 0x6f, 0x24, 0xb2, 0x98, 0x3c,
	0x0c, 0xef, 0xa0, 0x63, 0xe6, 0xe1, 0x48, 0x57, 0x00, 0x31, 0xf3, 0x70, 0xb4, 0x96, 0x1f, 0xfd,
	0x83, 0x83, 0xa5, 0xc3, 0xba, 0x70, 0x14, 0xef, 0x23, 0xdf, 0x23, 0x5e, 0x25, 0x14, 0x3e, 0x3c,
	0x21, 0xe9, 0x9e, 0x87, 0x6b, 0xef, 0x3c, 0xbe, 0x15, 0xef, 0xef, 0x59, 0x76, 0xc6, 0xc8, 0x8b,
	0xf4, 0xb7, 0xff, 0x17, 0x00, 0x00, 0xff, 0xff, 0x8f, 0x11, 0xd9, 0x68, 0x10, 0x33, 0x00, 0x00,
}
