// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/DropsMetadataServiceTwirp/twirp.proto

/*
Package TwitchDropsMetadataServiceTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/DropsMetadataServiceTwirp/twirp.proto
*/
package TwitchDropsMetadataServiceTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ==============================
// DropsMetadataService Interface
// ==============================

type DropsMetadataService interface {
	// Called by DevConsole: Apis to create and update a campaign and its fields
	CreateCampaign(context.Context, *CreateCampaignRequest) (*CreateCampaignResponse, error)

	UpdateCampaignSummary(context.Context, *UpdateCampaignSummaryRequest) (*UpdateCampaignSummaryResponse, error)

	SetCampaignAccess(context.Context, *SetCampaignAccessRequest) (*SetCampaignAccessResponse, error)

	SyncCampaignGame(context.Context, *SyncCampaignGameRequest) (*SyncCampaignGameResponse, error)

	TransitionCampaignState(context.Context, *TransitionCampaignStateRequest) (*TransitionCampaignStateResponse, error)

	// Called by DevConsole: Apis to fetch campaigns by owner or id
	ListCampaignsByOwner(context.Context, *ListCampaignsByOwnerRequest) (*ListCampaignsByOwnerResponse, error)

	GetCampaignsByIDs(context.Context, *GetCampaignsByIDsRequest) (*GetCampaignsByIDsResponse, error)

	GetCampaignDetailsByIDs(context.Context, *GetCampaignDetailsByIDsRequest) (*GetCampaignDetailsByIDsResponse, error)

	// Called by Twilight: Streamer Dashboard when expanding a given campaign from the list of campaigns returned by ListEnabledCampaignsByChannel.
	// Called by Twilight: Viewer Inventory Dashboard "Active and upcoming campaigns"-tab when expanding a given campaign from the list of campaigns returned by ListEnabledCampaignsByUser.
	// GetCampaignWithUserMetadata returns the full Campaign for a given campaignID personal settings of the requesting user.
	GetCampaignWithUserMetadata(context.Context, *GetCampaignWithUserMetadataRequest) (*GetCampaignWithUserMetadataResponse, error)

	// Called by Twilight: Viewer Inventory Dashboard "Active and upcoming campaigns"-tab
	// ListActiveCampaignsByUser returns all enabled (upcoming, active, and expired) Campaigns for a given user.
	// This is primarily used to show viewers what campaigns are currently running, which ones are upcoming, and which ones recently expired.
	ListEnabledCampaignsByUser(context.Context, *ListEnabledCampaignsByUserRequest) (*ListEnabledCampaignsByUserResponse, error)

	// Called by Progresso: Used to compute what drops are available to bank time against.
	// This will return all enabled (upcoming, active and expired up to a week) Campaigns for a given game.
	ListEnabledCampaignsByGame(context.Context, *ListEnabledCampaignsByGameRequest) (*ListEnabledCampaignsByGameResponse, error)

	// Called by Twilight: Streamer Dashboard
	// ListEnabledCampaignsByChannel returns all enabled (upcoming, active, and expired) Campaigns for a given channel.
	// This is primarily used to show streamers what campaigns are currently running, which ones are upcoming, and which ones recently expired.
	// The channel ID is validated against various whitelists and then returns all drops which that channel
	// is and will be eligible to participate in at this given moment.
	ListEnabledCampaignsByChannel(context.Context, *ListEnabledCampaignsByChannelRequest) (*ListEnabledCampaignsByChannelResponse, error)

	// Called by Twilight: Channel Highlight
	// Returns a list of active Campaigns on a given channel streaming given game. The channel ID is validated
	// against various whitelists to ensure that that specific channel is eligible for the campaign currently
	// active for game ID.
	ListAvailableCampaignsByChannel(context.Context, *ListAvailableCampaignsByChannelRequest) (*ListAvailableCampaignsByChannelResponse, error)

	// Called by other services: Pulling campaigns for which a user has progress on given drops.
	// Returns Full Campaigns given DropIDs are part of.
	ListCampaignsByDropIDs(context.Context, *ListCampaignsByDropIDsRequest) (*ListCampaignsByDropIDsResponse, error)

	// Called by Twilight: Inventory's way of pulling campaigns for which a user has progress on given drops.
	// Returns Full Campaigns given DropIDs are part of.
	ListClaimableCampaignsByDropIDs(context.Context, *ListClaimableCampaignsByDropIDsRequest) (*ListClaimableCampaignsByDropIDsResponse, error)

	// Called by DevConsole: Apis to delete campaigns and its fields
	DeleteCampaign(context.Context, *DeleteCampaignRequest) (*DeleteCampaignResponse, error)

	// Called by DevConsole
	// Apis to create and update a drop and its fields
	CreateNewDropForCampaign(context.Context, *CreateNewDropForCampaignRequest) (*CreateNewDropForCampaignResponse, error)

	UpdateDrop(context.Context, *UpdateDropRequest) (*UpdateDropResponse, error)

	UpdateDropType(context.Context, *UpdateDropTypeRequest) (*UpdateDropTypeResponse, error)

	SetBenefitsOnDrop(context.Context, *SetBenefitsOnDropRequest) (*SetBenefitsOnDropResponse, error)

	UpdateBenefitOnDrop(context.Context, *UpdateBenefitOnDropRequest) (*UpdateBenefitOnDropResponse, error)

	BulkUpdateDropPrecondition(context.Context, *BulkUpdateDropPreconditionRequest) (*BulkUpdateDropPreconditionResponse, error)

	// Called by DevConsole
	GetDropsByIDs(context.Context, *GetDropsByIDsRequest) (*GetDropsByIDsResponse, error)

	// Called by DRE/Progresso
	// ListActiveDropByType returns the active Drops with metadata of given Type
	ListActiveDropsByType(context.Context, *ListActiveDropsByTypeRequest) (*ListActiveDropsByTypeResponse, error)

	// Called by DevConsole
	// Apis to delete drop and its fields
	DeleteDrop(context.Context, *DeleteDropRequest) (*DeleteDropResponse, error)

	// Called by DevConsole to upload image assets.
	CreateUpload(context.Context, *CreateUploadRequest) (*CreateUploadResponse, error)

	// GetOptOutStatusesByChannelID takes a list of channel IDs and returns a list of all the channels in the supplied
	// list which are opted out of the Drops program
	GetOptOutStatusesByChannelIDs(context.Context, *GetOptOutStatusesByChannelIDsRequest) (*GetOptOutStatusesByChannelIDsResponse, error)

	// SetChannelOptOutStatus is used for setting a channel as opt-opt out or removing from opt-out list
	SetChannelOptOutStatus(context.Context, *SetChannelOptOutStatusRequest) (*SetChannelOptOutStatusResponse, error)

	// Called by DevConsole: Update record of client-ID for game-id
	SetClientIDForGame(context.Context, *SetClientIDForGameRequest) (*SetClientIDForGameResponse, error)

	GetGamesByIDs(context.Context, *GetGamesByIDsRequest) (*GetGamesByIDsResponse, error)

	// ////////////////////// PDMS APIs ////////////////////////
	// Deletes all user specific data for given tuid.
	DeleteUserData(context.Context, *DeleteUserDataRequest) (*DeleteUserDataResponse, error)

	// Accesses all user specific data for given tuid.
	AccessUserData(context.Context, *AccessUserDataRequest) (*AccessUserDataResponse, error)

	// ////////////////////// Progresso APIs ////////////////////////
	// Returns all ACTIVE, TEST and recently EXPIRED Campaign info for Progresso.
	// Intended to be highly cacheable in Progresso for performance.
	GetCampaignsEligibleForProgress(context.Context, *GetCampaignsEligibleForProgressRequest) (*GetCampaignsEligibleForProgressResponse, error)

	// Returns Drops for the given Campaigns, filtering them for a user and channel.
	FilterCampaignsForMWEvent(context.Context, *FilterCampaignsForMWEventRequest) (*FilterCampaignsForMWEventResponse, error)
}

// ====================================
// DropsMetadataService Protobuf Client
// ====================================

type dropsMetadataServiceProtobufClient struct {
	client HTTPClient
	urls   [34]string
	opts   twirp.ClientOptions
}

// NewDropsMetadataServiceProtobufClient creates a Protobuf client that implements the DropsMetadataService interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewDropsMetadataServiceProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) DropsMetadataService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + DropsMetadataServicePathPrefix
	urls := [34]string{
		prefix + "CreateCampaign",
		prefix + "UpdateCampaignSummary",
		prefix + "SetCampaignAccess",
		prefix + "SyncCampaignGame",
		prefix + "TransitionCampaignState",
		prefix + "ListCampaignsByOwner",
		prefix + "GetCampaignsByIDs",
		prefix + "GetCampaignDetailsByIDs",
		prefix + "GetCampaignWithUserMetadata",
		prefix + "ListEnabledCampaignsByUser",
		prefix + "ListEnabledCampaignsByGame",
		prefix + "ListEnabledCampaignsByChannel",
		prefix + "ListAvailableCampaignsByChannel",
		prefix + "ListCampaignsByDropIDs",
		prefix + "ListClaimableCampaignsByDropIDs",
		prefix + "DeleteCampaign",
		prefix + "CreateNewDropForCampaign",
		prefix + "UpdateDrop",
		prefix + "UpdateDropType",
		prefix + "SetBenefitsOnDrop",
		prefix + "UpdateBenefitOnDrop",
		prefix + "BulkUpdateDropPrecondition",
		prefix + "GetDropsByIDs",
		prefix + "ListActiveDropsByType",
		prefix + "DeleteDrop",
		prefix + "CreateUpload",
		prefix + "GetOptOutStatusesByChannelIDs",
		prefix + "SetChannelOptOutStatus",
		prefix + "SetClientIDForGame",
		prefix + "GetGamesByIDs",
		prefix + "DeleteUserData",
		prefix + "AccessUserData",
		prefix + "GetCampaignsEligibleForProgress",
		prefix + "FilterCampaignsForMWEvent",
	}

	return &dropsMetadataServiceProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *dropsMetadataServiceProtobufClient) CreateCampaign(ctx context.Context, in *CreateCampaignRequest) (*CreateCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCampaign")
	out := new(CreateCampaignResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) UpdateCampaignSummary(ctx context.Context, in *UpdateCampaignSummaryRequest) (*UpdateCampaignSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaignSummary")
	out := new(UpdateCampaignSummaryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) SetCampaignAccess(ctx context.Context, in *SetCampaignAccessRequest) (*SetCampaignAccessResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SetCampaignAccess")
	out := new(SetCampaignAccessResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) SyncCampaignGame(ctx context.Context, in *SyncCampaignGameRequest) (*SyncCampaignGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SyncCampaignGame")
	out := new(SyncCampaignGameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) TransitionCampaignState(ctx context.Context, in *TransitionCampaignStateRequest) (*TransitionCampaignStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "TransitionCampaignState")
	out := new(TransitionCampaignStateResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) ListCampaignsByOwner(ctx context.Context, in *ListCampaignsByOwnerRequest) (*ListCampaignsByOwnerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListCampaignsByOwner")
	out := new(ListCampaignsByOwnerResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) GetCampaignsByIDs(ctx context.Context, in *GetCampaignsByIDsRequest) (*GetCampaignsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsByIDs")
	out := new(GetCampaignsByIDsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) GetCampaignDetailsByIDs(ctx context.Context, in *GetCampaignDetailsByIDsRequest) (*GetCampaignDetailsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignDetailsByIDs")
	out := new(GetCampaignDetailsByIDsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) GetCampaignWithUserMetadata(ctx context.Context, in *GetCampaignWithUserMetadataRequest) (*GetCampaignWithUserMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignWithUserMetadata")
	out := new(GetCampaignWithUserMetadataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) ListEnabledCampaignsByUser(ctx context.Context, in *ListEnabledCampaignsByUserRequest) (*ListEnabledCampaignsByUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByUser")
	out := new(ListEnabledCampaignsByUserResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) ListEnabledCampaignsByGame(ctx context.Context, in *ListEnabledCampaignsByGameRequest) (*ListEnabledCampaignsByGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByGame")
	out := new(ListEnabledCampaignsByGameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) ListEnabledCampaignsByChannel(ctx context.Context, in *ListEnabledCampaignsByChannelRequest) (*ListEnabledCampaignsByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByChannel")
	out := new(ListEnabledCampaignsByChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) ListAvailableCampaignsByChannel(ctx context.Context, in *ListAvailableCampaignsByChannelRequest) (*ListAvailableCampaignsByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListAvailableCampaignsByChannel")
	out := new(ListAvailableCampaignsByChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) ListCampaignsByDropIDs(ctx context.Context, in *ListCampaignsByDropIDsRequest) (*ListCampaignsByDropIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListCampaignsByDropIDs")
	out := new(ListCampaignsByDropIDsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) ListClaimableCampaignsByDropIDs(ctx context.Context, in *ListClaimableCampaignsByDropIDsRequest) (*ListClaimableCampaignsByDropIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListClaimableCampaignsByDropIDs")
	out := new(ListClaimableCampaignsByDropIDsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) DeleteCampaign(ctx context.Context, in *DeleteCampaignRequest) (*DeleteCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCampaign")
	out := new(DeleteCampaignResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) CreateNewDropForCampaign(ctx context.Context, in *CreateNewDropForCampaignRequest) (*CreateNewDropForCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateNewDropForCampaign")
	out := new(CreateNewDropForCampaignResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) UpdateDrop(ctx context.Context, in *UpdateDropRequest) (*UpdateDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDrop")
	out := new(UpdateDropResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) UpdateDropType(ctx context.Context, in *UpdateDropTypeRequest) (*UpdateDropTypeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDropType")
	out := new(UpdateDropTypeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) SetBenefitsOnDrop(ctx context.Context, in *SetBenefitsOnDropRequest) (*SetBenefitsOnDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SetBenefitsOnDrop")
	out := new(SetBenefitsOnDropResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) UpdateBenefitOnDrop(ctx context.Context, in *UpdateBenefitOnDropRequest) (*UpdateBenefitOnDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateBenefitOnDrop")
	out := new(UpdateBenefitOnDropResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) BulkUpdateDropPrecondition(ctx context.Context, in *BulkUpdateDropPreconditionRequest) (*BulkUpdateDropPreconditionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "BulkUpdateDropPrecondition")
	out := new(BulkUpdateDropPreconditionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[21], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) GetDropsByIDs(ctx context.Context, in *GetDropsByIDsRequest) (*GetDropsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDropsByIDs")
	out := new(GetDropsByIDsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[22], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) ListActiveDropsByType(ctx context.Context, in *ListActiveDropsByTypeRequest) (*ListActiveDropsByTypeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByType")
	out := new(ListActiveDropsByTypeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[23], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) DeleteDrop(ctx context.Context, in *DeleteDropRequest) (*DeleteDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDrop")
	out := new(DeleteDropResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[24], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) CreateUpload(ctx context.Context, in *CreateUploadRequest) (*CreateUploadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateUpload")
	out := new(CreateUploadResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[25], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) GetOptOutStatusesByChannelIDs(ctx context.Context, in *GetOptOutStatusesByChannelIDsRequest) (*GetOptOutStatusesByChannelIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetOptOutStatusesByChannelIDs")
	out := new(GetOptOutStatusesByChannelIDsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[26], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) SetChannelOptOutStatus(ctx context.Context, in *SetChannelOptOutStatusRequest) (*SetChannelOptOutStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelOptOutStatus")
	out := new(SetChannelOptOutStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[27], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) SetClientIDForGame(ctx context.Context, in *SetClientIDForGameRequest) (*SetClientIDForGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SetClientIDForGame")
	out := new(SetClientIDForGameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[28], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) GetGamesByIDs(ctx context.Context, in *GetGamesByIDsRequest) (*GetGamesByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByIDs")
	out := new(GetGamesByIDsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[29], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) DeleteUserData(ctx context.Context, in *DeleteUserDataRequest) (*DeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUserData")
	out := new(DeleteUserDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[30], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) AccessUserData(ctx context.Context, in *AccessUserDataRequest) (*AccessUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "AccessUserData")
	out := new(AccessUserDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[31], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) GetCampaignsEligibleForProgress(ctx context.Context, in *GetCampaignsEligibleForProgressRequest) (*GetCampaignsEligibleForProgressResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsEligibleForProgress")
	out := new(GetCampaignsEligibleForProgressResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[32], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceProtobufClient) FilterCampaignsForMWEvent(ctx context.Context, in *FilterCampaignsForMWEventRequest) (*FilterCampaignsForMWEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "FilterCampaignsForMWEvent")
	out := new(FilterCampaignsForMWEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[33], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ================================
// DropsMetadataService JSON Client
// ================================

type dropsMetadataServiceJSONClient struct {
	client HTTPClient
	urls   [34]string
	opts   twirp.ClientOptions
}

// NewDropsMetadataServiceJSONClient creates a JSON client that implements the DropsMetadataService interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewDropsMetadataServiceJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) DropsMetadataService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + DropsMetadataServicePathPrefix
	urls := [34]string{
		prefix + "CreateCampaign",
		prefix + "UpdateCampaignSummary",
		prefix + "SetCampaignAccess",
		prefix + "SyncCampaignGame",
		prefix + "TransitionCampaignState",
		prefix + "ListCampaignsByOwner",
		prefix + "GetCampaignsByIDs",
		prefix + "GetCampaignDetailsByIDs",
		prefix + "GetCampaignWithUserMetadata",
		prefix + "ListEnabledCampaignsByUser",
		prefix + "ListEnabledCampaignsByGame",
		prefix + "ListEnabledCampaignsByChannel",
		prefix + "ListAvailableCampaignsByChannel",
		prefix + "ListCampaignsByDropIDs",
		prefix + "ListClaimableCampaignsByDropIDs",
		prefix + "DeleteCampaign",
		prefix + "CreateNewDropForCampaign",
		prefix + "UpdateDrop",
		prefix + "UpdateDropType",
		prefix + "SetBenefitsOnDrop",
		prefix + "UpdateBenefitOnDrop",
		prefix + "BulkUpdateDropPrecondition",
		prefix + "GetDropsByIDs",
		prefix + "ListActiveDropsByType",
		prefix + "DeleteDrop",
		prefix + "CreateUpload",
		prefix + "GetOptOutStatusesByChannelIDs",
		prefix + "SetChannelOptOutStatus",
		prefix + "SetClientIDForGame",
		prefix + "GetGamesByIDs",
		prefix + "DeleteUserData",
		prefix + "AccessUserData",
		prefix + "GetCampaignsEligibleForProgress",
		prefix + "FilterCampaignsForMWEvent",
	}

	return &dropsMetadataServiceJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *dropsMetadataServiceJSONClient) CreateCampaign(ctx context.Context, in *CreateCampaignRequest) (*CreateCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCampaign")
	out := new(CreateCampaignResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) UpdateCampaignSummary(ctx context.Context, in *UpdateCampaignSummaryRequest) (*UpdateCampaignSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaignSummary")
	out := new(UpdateCampaignSummaryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) SetCampaignAccess(ctx context.Context, in *SetCampaignAccessRequest) (*SetCampaignAccessResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SetCampaignAccess")
	out := new(SetCampaignAccessResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) SyncCampaignGame(ctx context.Context, in *SyncCampaignGameRequest) (*SyncCampaignGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SyncCampaignGame")
	out := new(SyncCampaignGameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) TransitionCampaignState(ctx context.Context, in *TransitionCampaignStateRequest) (*TransitionCampaignStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "TransitionCampaignState")
	out := new(TransitionCampaignStateResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) ListCampaignsByOwner(ctx context.Context, in *ListCampaignsByOwnerRequest) (*ListCampaignsByOwnerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListCampaignsByOwner")
	out := new(ListCampaignsByOwnerResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) GetCampaignsByIDs(ctx context.Context, in *GetCampaignsByIDsRequest) (*GetCampaignsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsByIDs")
	out := new(GetCampaignsByIDsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) GetCampaignDetailsByIDs(ctx context.Context, in *GetCampaignDetailsByIDsRequest) (*GetCampaignDetailsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignDetailsByIDs")
	out := new(GetCampaignDetailsByIDsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) GetCampaignWithUserMetadata(ctx context.Context, in *GetCampaignWithUserMetadataRequest) (*GetCampaignWithUserMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignWithUserMetadata")
	out := new(GetCampaignWithUserMetadataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) ListEnabledCampaignsByUser(ctx context.Context, in *ListEnabledCampaignsByUserRequest) (*ListEnabledCampaignsByUserResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByUser")
	out := new(ListEnabledCampaignsByUserResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) ListEnabledCampaignsByGame(ctx context.Context, in *ListEnabledCampaignsByGameRequest) (*ListEnabledCampaignsByGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByGame")
	out := new(ListEnabledCampaignsByGameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) ListEnabledCampaignsByChannel(ctx context.Context, in *ListEnabledCampaignsByChannelRequest) (*ListEnabledCampaignsByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByChannel")
	out := new(ListEnabledCampaignsByChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) ListAvailableCampaignsByChannel(ctx context.Context, in *ListAvailableCampaignsByChannelRequest) (*ListAvailableCampaignsByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListAvailableCampaignsByChannel")
	out := new(ListAvailableCampaignsByChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) ListCampaignsByDropIDs(ctx context.Context, in *ListCampaignsByDropIDsRequest) (*ListCampaignsByDropIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListCampaignsByDropIDs")
	out := new(ListCampaignsByDropIDsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) ListClaimableCampaignsByDropIDs(ctx context.Context, in *ListClaimableCampaignsByDropIDsRequest) (*ListClaimableCampaignsByDropIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListClaimableCampaignsByDropIDs")
	out := new(ListClaimableCampaignsByDropIDsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) DeleteCampaign(ctx context.Context, in *DeleteCampaignRequest) (*DeleteCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCampaign")
	out := new(DeleteCampaignResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) CreateNewDropForCampaign(ctx context.Context, in *CreateNewDropForCampaignRequest) (*CreateNewDropForCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateNewDropForCampaign")
	out := new(CreateNewDropForCampaignResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) UpdateDrop(ctx context.Context, in *UpdateDropRequest) (*UpdateDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDrop")
	out := new(UpdateDropResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) UpdateDropType(ctx context.Context, in *UpdateDropTypeRequest) (*UpdateDropTypeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDropType")
	out := new(UpdateDropTypeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) SetBenefitsOnDrop(ctx context.Context, in *SetBenefitsOnDropRequest) (*SetBenefitsOnDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SetBenefitsOnDrop")
	out := new(SetBenefitsOnDropResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) UpdateBenefitOnDrop(ctx context.Context, in *UpdateBenefitOnDropRequest) (*UpdateBenefitOnDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateBenefitOnDrop")
	out := new(UpdateBenefitOnDropResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) BulkUpdateDropPrecondition(ctx context.Context, in *BulkUpdateDropPreconditionRequest) (*BulkUpdateDropPreconditionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "BulkUpdateDropPrecondition")
	out := new(BulkUpdateDropPreconditionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[21], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) GetDropsByIDs(ctx context.Context, in *GetDropsByIDsRequest) (*GetDropsByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDropsByIDs")
	out := new(GetDropsByIDsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[22], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) ListActiveDropsByType(ctx context.Context, in *ListActiveDropsByTypeRequest) (*ListActiveDropsByTypeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByType")
	out := new(ListActiveDropsByTypeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[23], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) DeleteDrop(ctx context.Context, in *DeleteDropRequest) (*DeleteDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDrop")
	out := new(DeleteDropResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[24], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) CreateUpload(ctx context.Context, in *CreateUploadRequest) (*CreateUploadResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "CreateUpload")
	out := new(CreateUploadResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[25], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) GetOptOutStatusesByChannelIDs(ctx context.Context, in *GetOptOutStatusesByChannelIDsRequest) (*GetOptOutStatusesByChannelIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetOptOutStatusesByChannelIDs")
	out := new(GetOptOutStatusesByChannelIDsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[26], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) SetChannelOptOutStatus(ctx context.Context, in *SetChannelOptOutStatusRequest) (*SetChannelOptOutStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelOptOutStatus")
	out := new(SetChannelOptOutStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[27], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) SetClientIDForGame(ctx context.Context, in *SetClientIDForGameRequest) (*SetClientIDForGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "SetClientIDForGame")
	out := new(SetClientIDForGameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[28], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) GetGamesByIDs(ctx context.Context, in *GetGamesByIDsRequest) (*GetGamesByIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByIDs")
	out := new(GetGamesByIDsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[29], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) DeleteUserData(ctx context.Context, in *DeleteUserDataRequest) (*DeleteUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUserData")
	out := new(DeleteUserDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[30], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) AccessUserData(ctx context.Context, in *AccessUserDataRequest) (*AccessUserDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "AccessUserData")
	out := new(AccessUserDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[31], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) GetCampaignsEligibleForProgress(ctx context.Context, in *GetCampaignsEligibleForProgressRequest) (*GetCampaignsEligibleForProgressResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsEligibleForProgress")
	out := new(GetCampaignsEligibleForProgressResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[32], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsMetadataServiceJSONClient) FilterCampaignsForMWEvent(ctx context.Context, in *FilterCampaignsForMWEventRequest) (*FilterCampaignsForMWEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithMethodName(ctx, "FilterCampaignsForMWEvent")
	out := new(FilterCampaignsForMWEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[33], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===================================
// DropsMetadataService Server Handler
// ===================================

type dropsMetadataServiceServer struct {
	DropsMetadataService
	hooks *twirp.ServerHooks
}

func NewDropsMetadataServiceServer(svc DropsMetadataService, hooks *twirp.ServerHooks) TwirpServer {
	return &dropsMetadataServiceServer{
		DropsMetadataService: svc,
		hooks:                hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *dropsMetadataServiceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// DropsMetadataServicePathPrefix is used for all URL paths on a twirp DropsMetadataService server.
// Requests are always: POST DropsMetadataServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const DropsMetadataServicePathPrefix = "/twirp/twitch.drops.metadata.DropsMetadataService/"

func (s *dropsMetadataServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.drops.metadata")
	ctx = ctxsetters.WithServiceName(ctx, "DropsMetadataService")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.drops.metadata.DropsMetadataService/CreateCampaign":
		s.serveCreateCampaign(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/UpdateCampaignSummary":
		s.serveUpdateCampaignSummary(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/SetCampaignAccess":
		s.serveSetCampaignAccess(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/SyncCampaignGame":
		s.serveSyncCampaignGame(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/TransitionCampaignState":
		s.serveTransitionCampaignState(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/ListCampaignsByOwner":
		s.serveListCampaignsByOwner(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/GetCampaignsByIDs":
		s.serveGetCampaignsByIDs(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/GetCampaignDetailsByIDs":
		s.serveGetCampaignDetailsByIDs(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/GetCampaignWithUserMetadata":
		s.serveGetCampaignWithUserMetadata(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/ListEnabledCampaignsByUser":
		s.serveListEnabledCampaignsByUser(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/ListEnabledCampaignsByGame":
		s.serveListEnabledCampaignsByGame(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/ListEnabledCampaignsByChannel":
		s.serveListEnabledCampaignsByChannel(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/ListAvailableCampaignsByChannel":
		s.serveListAvailableCampaignsByChannel(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/ListCampaignsByDropIDs":
		s.serveListCampaignsByDropIDs(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/ListClaimableCampaignsByDropIDs":
		s.serveListClaimableCampaignsByDropIDs(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/DeleteCampaign":
		s.serveDeleteCampaign(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/CreateNewDropForCampaign":
		s.serveCreateNewDropForCampaign(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/UpdateDrop":
		s.serveUpdateDrop(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/UpdateDropType":
		s.serveUpdateDropType(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/SetBenefitsOnDrop":
		s.serveSetBenefitsOnDrop(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/UpdateBenefitOnDrop":
		s.serveUpdateBenefitOnDrop(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/BulkUpdateDropPrecondition":
		s.serveBulkUpdateDropPrecondition(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/GetDropsByIDs":
		s.serveGetDropsByIDs(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/ListActiveDropsByType":
		s.serveListActiveDropsByType(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/DeleteDrop":
		s.serveDeleteDrop(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/CreateUpload":
		s.serveCreateUpload(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/GetOptOutStatusesByChannelIDs":
		s.serveGetOptOutStatusesByChannelIDs(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/SetChannelOptOutStatus":
		s.serveSetChannelOptOutStatus(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/SetClientIDForGame":
		s.serveSetClientIDForGame(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/GetGamesByIDs":
		s.serveGetGamesByIDs(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/DeleteUserData":
		s.serveDeleteUserData(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/AccessUserData":
		s.serveAccessUserData(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/GetCampaignsEligibleForProgress":
		s.serveGetCampaignsEligibleForProgress(ctx, resp, req)
		return
	case "/twirp/twitch.drops.metadata.DropsMetadataService/FilterCampaignsForMWEvent":
		s.serveFilterCampaignsForMWEvent(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *dropsMetadataServiceServer) serveCreateCampaign(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCampaignJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCampaignProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveCreateCampaignJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCampaignRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.CreateCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCampaignResponse and nil error while calling CreateCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveCreateCampaignProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateCampaignRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.CreateCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCampaignResponse and nil error while calling CreateCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveUpdateCampaignSummary(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCampaignSummaryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCampaignSummaryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveUpdateCampaignSummaryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaignSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCampaignSummaryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateCampaignSummaryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.UpdateCampaignSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCampaignSummaryResponse and nil error while calling UpdateCampaignSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveUpdateCampaignSummaryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaignSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateCampaignSummaryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateCampaignSummaryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.UpdateCampaignSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCampaignSummaryResponse and nil error while calling UpdateCampaignSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSetCampaignAccess(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetCampaignAccessJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetCampaignAccessProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveSetCampaignAccessJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetCampaignAccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetCampaignAccessRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetCampaignAccessResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SetCampaignAccess(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetCampaignAccessResponse and nil error while calling SetCampaignAccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSetCampaignAccessProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetCampaignAccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetCampaignAccessRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetCampaignAccessResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SetCampaignAccess(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetCampaignAccessResponse and nil error while calling SetCampaignAccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSyncCampaignGame(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSyncCampaignGameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSyncCampaignGameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveSyncCampaignGameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SyncCampaignGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SyncCampaignGameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SyncCampaignGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SyncCampaignGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SyncCampaignGameResponse and nil error while calling SyncCampaignGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSyncCampaignGameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SyncCampaignGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SyncCampaignGameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SyncCampaignGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SyncCampaignGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SyncCampaignGameResponse and nil error while calling SyncCampaignGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveTransitionCampaignState(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveTransitionCampaignStateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTransitionCampaignStateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveTransitionCampaignStateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TransitionCampaignState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TransitionCampaignStateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TransitionCampaignStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.TransitionCampaignState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TransitionCampaignStateResponse and nil error while calling TransitionCampaignState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveTransitionCampaignStateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TransitionCampaignState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(TransitionCampaignStateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TransitionCampaignStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.TransitionCampaignState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TransitionCampaignStateResponse and nil error while calling TransitionCampaignState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListCampaignsByOwner(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCampaignsByOwnerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCampaignsByOwnerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveListCampaignsByOwnerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCampaignsByOwner")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListCampaignsByOwnerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListCampaignsByOwnerResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListCampaignsByOwner(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCampaignsByOwnerResponse and nil error while calling ListCampaignsByOwner. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListCampaignsByOwnerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCampaignsByOwner")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListCampaignsByOwnerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListCampaignsByOwnerResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListCampaignsByOwner(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCampaignsByOwnerResponse and nil error while calling ListCampaignsByOwner. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetCampaignsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCampaignsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCampaignsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveGetCampaignsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCampaignsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignsByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetCampaignsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignsByIDsResponse and nil error while calling GetCampaignsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetCampaignsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCampaignsByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignsByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetCampaignsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignsByIDsResponse and nil error while calling GetCampaignsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetCampaignDetailsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCampaignDetailsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCampaignDetailsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveGetCampaignDetailsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignDetailsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCampaignDetailsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignDetailsByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetCampaignDetailsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignDetailsByIDsResponse and nil error while calling GetCampaignDetailsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetCampaignDetailsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignDetailsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCampaignDetailsByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignDetailsByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetCampaignDetailsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignDetailsByIDsResponse and nil error while calling GetCampaignDetailsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetCampaignWithUserMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCampaignWithUserMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCampaignWithUserMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveGetCampaignWithUserMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignWithUserMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCampaignWithUserMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignWithUserMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetCampaignWithUserMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignWithUserMetadataResponse and nil error while calling GetCampaignWithUserMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetCampaignWithUserMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignWithUserMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCampaignWithUserMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignWithUserMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetCampaignWithUserMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignWithUserMetadataResponse and nil error while calling GetCampaignWithUserMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListEnabledCampaignsByUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEnabledCampaignsByUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEnabledCampaignsByUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveListEnabledCampaignsByUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEnabledCampaignsByUserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEnabledCampaignsByUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListEnabledCampaignsByUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEnabledCampaignsByUserResponse and nil error while calling ListEnabledCampaignsByUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListEnabledCampaignsByUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEnabledCampaignsByUserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEnabledCampaignsByUserResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListEnabledCampaignsByUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEnabledCampaignsByUserResponse and nil error while calling ListEnabledCampaignsByUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListEnabledCampaignsByGame(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEnabledCampaignsByGameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEnabledCampaignsByGameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveListEnabledCampaignsByGameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEnabledCampaignsByGameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEnabledCampaignsByGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListEnabledCampaignsByGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEnabledCampaignsByGameResponse and nil error while calling ListEnabledCampaignsByGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListEnabledCampaignsByGameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEnabledCampaignsByGameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEnabledCampaignsByGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListEnabledCampaignsByGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEnabledCampaignsByGameResponse and nil error while calling ListEnabledCampaignsByGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListEnabledCampaignsByChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEnabledCampaignsByChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEnabledCampaignsByChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveListEnabledCampaignsByChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEnabledCampaignsByChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEnabledCampaignsByChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListEnabledCampaignsByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEnabledCampaignsByChannelResponse and nil error while calling ListEnabledCampaignsByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListEnabledCampaignsByChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEnabledCampaignsByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEnabledCampaignsByChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEnabledCampaignsByChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListEnabledCampaignsByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEnabledCampaignsByChannelResponse and nil error while calling ListEnabledCampaignsByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListAvailableCampaignsByChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListAvailableCampaignsByChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListAvailableCampaignsByChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveListAvailableCampaignsByChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAvailableCampaignsByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListAvailableCampaignsByChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListAvailableCampaignsByChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListAvailableCampaignsByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAvailableCampaignsByChannelResponse and nil error while calling ListAvailableCampaignsByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListAvailableCampaignsByChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAvailableCampaignsByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListAvailableCampaignsByChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListAvailableCampaignsByChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListAvailableCampaignsByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAvailableCampaignsByChannelResponse and nil error while calling ListAvailableCampaignsByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListCampaignsByDropIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCampaignsByDropIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCampaignsByDropIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveListCampaignsByDropIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCampaignsByDropIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListCampaignsByDropIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListCampaignsByDropIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListCampaignsByDropIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCampaignsByDropIDsResponse and nil error while calling ListCampaignsByDropIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListCampaignsByDropIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCampaignsByDropIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListCampaignsByDropIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListCampaignsByDropIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListCampaignsByDropIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCampaignsByDropIDsResponse and nil error while calling ListCampaignsByDropIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListClaimableCampaignsByDropIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListClaimableCampaignsByDropIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListClaimableCampaignsByDropIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveListClaimableCampaignsByDropIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListClaimableCampaignsByDropIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListClaimableCampaignsByDropIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListClaimableCampaignsByDropIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListClaimableCampaignsByDropIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListClaimableCampaignsByDropIDsResponse and nil error while calling ListClaimableCampaignsByDropIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListClaimableCampaignsByDropIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListClaimableCampaignsByDropIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListClaimableCampaignsByDropIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListClaimableCampaignsByDropIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListClaimableCampaignsByDropIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListClaimableCampaignsByDropIDsResponse and nil error while calling ListClaimableCampaignsByDropIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveDeleteCampaign(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteCampaignJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteCampaignProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveDeleteCampaignJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteCampaignRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.DeleteCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteCampaignResponse and nil error while calling DeleteCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveDeleteCampaignProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteCampaignRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.DeleteCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteCampaignResponse and nil error while calling DeleteCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveCreateNewDropForCampaign(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateNewDropForCampaignJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateNewDropForCampaignProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveCreateNewDropForCampaignJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateNewDropForCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateNewDropForCampaignRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateNewDropForCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.CreateNewDropForCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateNewDropForCampaignResponse and nil error while calling CreateNewDropForCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveCreateNewDropForCampaignProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateNewDropForCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateNewDropForCampaignRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateNewDropForCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.CreateNewDropForCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateNewDropForCampaignResponse and nil error while calling CreateNewDropForCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveUpdateDrop(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateDropJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateDropProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveUpdateDropJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateDropRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.UpdateDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateDropResponse and nil error while calling UpdateDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveUpdateDropProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateDropRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.UpdateDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateDropResponse and nil error while calling UpdateDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveUpdateDropType(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateDropTypeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateDropTypeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveUpdateDropTypeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDropType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateDropTypeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateDropTypeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.UpdateDropType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateDropTypeResponse and nil error while calling UpdateDropType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveUpdateDropTypeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDropType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateDropTypeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateDropTypeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.UpdateDropType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateDropTypeResponse and nil error while calling UpdateDropType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSetBenefitsOnDrop(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetBenefitsOnDropJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetBenefitsOnDropProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveSetBenefitsOnDropJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetBenefitsOnDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetBenefitsOnDropRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetBenefitsOnDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SetBenefitsOnDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetBenefitsOnDropResponse and nil error while calling SetBenefitsOnDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSetBenefitsOnDropProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetBenefitsOnDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetBenefitsOnDropRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetBenefitsOnDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SetBenefitsOnDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetBenefitsOnDropResponse and nil error while calling SetBenefitsOnDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveUpdateBenefitOnDrop(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateBenefitOnDropJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateBenefitOnDropProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveUpdateBenefitOnDropJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateBenefitOnDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateBenefitOnDropRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateBenefitOnDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.UpdateBenefitOnDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateBenefitOnDropResponse and nil error while calling UpdateBenefitOnDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveUpdateBenefitOnDropProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateBenefitOnDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateBenefitOnDropRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateBenefitOnDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.UpdateBenefitOnDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateBenefitOnDropResponse and nil error while calling UpdateBenefitOnDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveBulkUpdateDropPrecondition(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkUpdateDropPreconditionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkUpdateDropPreconditionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveBulkUpdateDropPreconditionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkUpdateDropPrecondition")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkUpdateDropPreconditionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkUpdateDropPreconditionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.BulkUpdateDropPrecondition(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkUpdateDropPreconditionResponse and nil error while calling BulkUpdateDropPrecondition. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveBulkUpdateDropPreconditionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkUpdateDropPrecondition")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BulkUpdateDropPreconditionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BulkUpdateDropPreconditionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.BulkUpdateDropPrecondition(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkUpdateDropPreconditionResponse and nil error while calling BulkUpdateDropPrecondition. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetDropsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetDropsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetDropsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveGetDropsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDropsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetDropsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropsByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetDropsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropsByIDsResponse and nil error while calling GetDropsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetDropsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDropsByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetDropsByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropsByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetDropsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropsByIDsResponse and nil error while calling GetDropsByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListActiveDropsByType(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListActiveDropsByTypeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListActiveDropsByTypeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveListActiveDropsByTypeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListActiveDropsByTypeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropsByTypeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListActiveDropsByType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropsByTypeResponse and nil error while calling ListActiveDropsByType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveListActiveDropsByTypeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByType")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListActiveDropsByTypeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropsByTypeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.ListActiveDropsByType(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropsByTypeResponse and nil error while calling ListActiveDropsByType. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveDeleteDrop(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteDropJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteDropProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveDeleteDropJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteDropRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.DeleteDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteDropResponse and nil error while calling DeleteDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveDeleteDropProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteDropRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.DeleteDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteDropResponse and nil error while calling DeleteDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveCreateUpload(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateUploadJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateUploadProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveCreateUploadJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateUpload")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateUploadRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateUploadResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.CreateUpload(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateUploadResponse and nil error while calling CreateUpload. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveCreateUploadProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateUpload")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateUploadRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateUploadResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.CreateUpload(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateUploadResponse and nil error while calling CreateUpload. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetOptOutStatusesByChannelIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetOptOutStatusesByChannelIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetOptOutStatusesByChannelIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveGetOptOutStatusesByChannelIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOptOutStatusesByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetOptOutStatusesByChannelIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOptOutStatusesByChannelIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetOptOutStatusesByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOptOutStatusesByChannelIDsResponse and nil error while calling GetOptOutStatusesByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetOptOutStatusesByChannelIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOptOutStatusesByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetOptOutStatusesByChannelIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOptOutStatusesByChannelIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetOptOutStatusesByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOptOutStatusesByChannelIDsResponse and nil error while calling GetOptOutStatusesByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSetChannelOptOutStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetChannelOptOutStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetChannelOptOutStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveSetChannelOptOutStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelOptOutStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetChannelOptOutStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetChannelOptOutStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SetChannelOptOutStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetChannelOptOutStatusResponse and nil error while calling SetChannelOptOutStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSetChannelOptOutStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelOptOutStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetChannelOptOutStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetChannelOptOutStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SetChannelOptOutStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetChannelOptOutStatusResponse and nil error while calling SetChannelOptOutStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSetClientIDForGame(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetClientIDForGameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetClientIDForGameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveSetClientIDForGameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetClientIDForGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetClientIDForGameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetClientIDForGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SetClientIDForGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetClientIDForGameResponse and nil error while calling SetClientIDForGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveSetClientIDForGameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetClientIDForGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetClientIDForGameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetClientIDForGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.SetClientIDForGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetClientIDForGameResponse and nil error while calling SetClientIDForGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetGamesByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetGamesByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGamesByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveGetGamesByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetGamesByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetGamesByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetGamesByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGamesByIDsResponse and nil error while calling GetGamesByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetGamesByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGamesByIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetGamesByIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetGamesByIDsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetGamesByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGamesByIDsResponse and nil error while calling GetGamesByIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveDeleteUserData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteUserDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteUserDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveDeleteUserDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteUserDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.DeleteUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteUserDataResponse and nil error while calling DeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveDeleteUserDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteUserDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.DeleteUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteUserDataResponse and nil error while calling DeleteUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveAccessUserData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAccessUserDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAccessUserDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveAccessUserDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AccessUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AccessUserDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AccessUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.AccessUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AccessUserDataResponse and nil error while calling AccessUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveAccessUserDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AccessUserData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AccessUserDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AccessUserDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.AccessUserData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AccessUserDataResponse and nil error while calling AccessUserData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetCampaignsEligibleForProgress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCampaignsEligibleForProgressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCampaignsEligibleForProgressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveGetCampaignsEligibleForProgressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsEligibleForProgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCampaignsEligibleForProgressRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignsEligibleForProgressResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetCampaignsEligibleForProgress(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignsEligibleForProgressResponse and nil error while calling GetCampaignsEligibleForProgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveGetCampaignsEligibleForProgressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsEligibleForProgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCampaignsEligibleForProgressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignsEligibleForProgressResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.GetCampaignsEligibleForProgress(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignsEligibleForProgressResponse and nil error while calling GetCampaignsEligibleForProgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveFilterCampaignsForMWEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFilterCampaignsForMWEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFilterCampaignsForMWEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsMetadataServiceServer) serveFilterCampaignsForMWEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FilterCampaignsForMWEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilterCampaignsForMWEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FilterCampaignsForMWEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.FilterCampaignsForMWEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FilterCampaignsForMWEventResponse and nil error while calling FilterCampaignsForMWEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) serveFilterCampaignsForMWEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FilterCampaignsForMWEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FilterCampaignsForMWEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FilterCampaignsForMWEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsMetadataService.FilterCampaignsForMWEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FilterCampaignsForMWEventResponse and nil error while calling FilterCampaignsForMWEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsMetadataServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *dropsMetadataServiceServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *dropsMetadataServiceServer) PathPrefix() string {
	return DropsMetadataServicePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2965 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5b, 0x4b, 0x6f, 0x1c, 0xc7,
	0x11, 0xf6, 0x2c, 0xb9, 0x7c, 0x14, 0x25, 0x86, 0x6a, 0x91, 0xd4, 0x72, 0x64, 0x3e, 0x34, 0x7e,
	0x29, 0x7e, 0x2c, 0x25, 0xca, 0x2f, 0xca, 0x79, 0x80, 0x8f, 0x25, 0xbd, 0x11, 0x1f, 0xf2, 0x72,
	0x69, 0x21, 0x72, 0x8c, 0xf5, 0x68, 0xa7, 0xc5, 0x1d, 0x71, 0x77, 0x66, 0x3d, 0xd3, 0x4b, 0x81,
	0x86, 0x03, 0x23, 0x0e, 0x04, 0x04, 0x48, 0x60, 0x20, 0x40, 0x80, 0x00, 0x39, 0xe5, 0x90, 0x43,
	0x8e, 0xb9, 0x04, 0x39, 0xe4, 0x96, 0x4b, 0x7e, 0x42, 0x90, 0x7b, 0x7e, 0x45, 0x4e, 0x41, 0xf7,
	0xf4, 0x3c, 0xb7, 0x7b, 0x76, 0x86, 0x8f, 0x5c, 0x04, 0x6e, 0x77, 0x55, 0x57, 0x75, 0x55, 0x75,
	0x75, 0xf5, 0x57, 0x23, 0x58, 0x6d, 0xda, 0x06, 0x2e, 0x3f, 0xeb, 0xb9, 0xc4, 0xb4, 0xca, 0xe4,
	0x64, 0x59, 0xef, 0x7c, 0x65, 0x2d, 0x6f, 0x3a, 0x76, 0xd7, 0xdd, 0xc5, 0x44, 0x37, 0x74, 0xa2,
	0x1f, 0x60, 0xe7, 0xc4, 0x6c, 0xe2, 0xfa, 0x73, 0xd3, 0xe9, 0x2e, 0x13, 0xfa, 0x6f, 0xb9, 0xeb,
	0xd8, 0xc4, 0x46, 0x33, 0xe4, 0xb9, 0x49, 0x9a, 0xad, 0xb2, 0x41, 0xa9, 0xcb, 0x1d, 0x4e, 0xae,
	0xde, 0x91, 0xaf, 0x68, 0x1b, 0xb8, 0xed, 0xf6, 0x2d, 0xa4, 0xfd, 0x66, 0x08, 0x66, 0x36, 0x1c,
	0xac, 0x13, 0xbc, 0xa1, 0x77, 0xba, 0xba, 0x79, 0x64, 0xd5, 0xf0, 0x97, 0x3d, 0xec, 0x12, 0x74,
	0x1b, 0xa6, 0xf4, 0x66, 0xd3, 0xee, 0x59, 0xa4, 0xd1, 0x36, 0xad, 0xe3, 0x46, 0xcf, 0x69, 0x97,
	0x94, 0x25, 0xe5, 0xf6, 0x78, 0x6d, 0x92, 0x8f, 0xef, 0x98, 0xd6, 0xf1, 0xa1, 0xd3, 0x46, 0x4b,
	0x30, 0x61, 0x60, 0xb7, 0xe9, 0x98, 0x5d, 0x62, 0xda, 0x56, 0xa9, 0xc0, 0x88, 0xa2, 0x43, 0x68,
	0x91, 0x52, 0x10, 0xdd, 0x6c, 0xbb, 0x6c, 0x99, 0x21, 0x46, 0x01, 0x7c, 0x88, 0x2e, 0x31, 0x07,
	0x63, 0xd8, 0x32, 0x1a, 0x86, 0x4e, 0x70, 0x69, 0x78, 0x49, 0xb9, 0x3d, 0x54, 0x1b, 0xc5, 0x96,
	0xb1, 0xa9, 0x13, 0x8c, 0xe6, 0x01, 0x5c, 0xa2, 0x3b, 0xc4, 0x9b, 0x2c, 0xb2, 0xc9, 0x71, 0x36,
	0xc2, 0xa6, 0x6f, 0xc0, 0xe8, 0x91, 0xde, 0xc1, 0x0d, 0xd3, 0x28, 0x8d, 0xb0, 0x65, 0x47, 0xe8,
	0xcf, 0xaa, 0x81, 0x10, 0x0c, 0x5b, 0x7a, 0x07, 0x97, 0x46, 0xd9, 0x28, 0xfb, 0x9b, 0x8a, 0xb1,
	0x9f, 0x5b, 0xd8, 0xa1, 0xd4, 0x63, 0x6c, 0x7c, 0x94, 0xfd, 0xae, 0x1a, 0xe8, 0x6d, 0x40, 0x8e,
	0xb7, 0x73, 0xd3, 0x3a, 0x6a, 0xf4, 0x5c, 0x8f, 0x68, 0x9c, 0x11, 0x4d, 0x85, 0x33, 0x87, 0x2e,
	0xa3, 0xfe, 0x14, 0xae, 0x36, 0xb9, 0xbd, 0x1a, 0xe4, 0xb4, 0x8b, 0x4b, 0xb0, 0xa4, 0xdc, 0x9e,
	0x5c, 0xb9, 0x5b, 0x8e, 0xfb, 0x85, 0x19, 0xbd, 0xec, 0x5b, 0x76, 0xd3, 0xdb, 0x6f, 0xf0, 0xbb,
	0x7e, 0xda, 0xc5, 0xb5, 0x2b, 0xcd, 0xc8, 0x2f, 0xed, 0x00, 0x66, 0x93, 0xde, 0x70, 0xbb, 0xb6,
	0xe5, 0x62, 0xb4, 0x0a, 0x63, 0x3e, 0x25, 0x73, 0xc3, 0xc4, 0xca, 0x7c, 0xaa, 0xb0, 0x5a, 0x40,
	0xae, 0xfd, 0x75, 0x18, 0x5e, 0x3e, 0xec, 0x1a, 0x91, 0x55, 0x0f, 0x7a, 0x9d, 0x8e, 0xee, 0x9c,
	0xe6, 0x77, 0xf5, 0x22, 0x4c, 0x04, 0xfb, 0x36, 0x0d, 0xee, 0x6a, 0xf0, 0x87, 0xaa, 0x46, 0x32,
	0x16, 0x86, 0x06, 0xc6, 0xc2, 0x70, 0x6a, 0x2c, 0x14, 0xd3, 0x62, 0x61, 0x24, 0x25, 0x16, 0x46,
	0x85, 0xb1, 0x30, 0x26, 0x89, 0x85, 0xf1, 0x2c, 0xb1, 0x00, 0x92, 0x58, 0x78, 0x96, 0x8c, 0x85,
	0x09, 0x16, 0x0b, 0x95, 0xb2, 0xf0, 0x8c, 0x96, 0xd3, 0x3c, 0x11, 0x0b, 0x8d, 0xaa, 0xd5, 0xed,
	0x91, 0x44, 0x7c, 0x1c, 0xc3, 0xb5, 0x3e, 0x12, 0x34, 0x07, 0x33, 0x1b, 0x6b, 0xbb, 0x0f, 0xd7,
	0xaa, 0xdb, 0x7b, 0x8d, 0xfa, 0x4f, 0x1f, 0x56, 0x1a, 0x87, 0x7b, 0x0f, 0xf6, 0xf6, 0x1f, 0xed,
	0x4d, 0xbd, 0xd4, 0x3f, 0xb5, 0x59, 0xd9, 0x5a, 0x3b, 0xdc, 0xa9, 0x4f, 0x29, 0x68, 0x09, 0x5e,
	0x8e, 0x4f, 0xed, 0xae, 0xed, 0x1d, 0xae, 0xed, 0x34, 0xea, 0xb5, 0xea, 0xf6, 0x76, 0xa5, 0x36,
	0x55, 0xd0, 0x1e, 0xc3, 0xbc, 0x44, 0xd9, 0xf3, 0xc7, 0xe4, 0xdf, 0x14, 0x28, 0x1d, 0x60, 0xe2,
	0xcf, 0xac, 0x35, 0x9b, 0xd8, 0x75, 0xfd, 0x78, 0x4c, 0x44, 0x99, 0xd2, 0x17, 0x65, 0x3b, 0xf0,
	0xbd, 0x80, 0x40, 0x67, 0xac, 0x2c, 0x14, 0x27, 0x56, 0x5e, 0x49, 0x95, 0xcf, 0xa5, 0x4c, 0x36,
	0x63, 0xbf, 0x25, 0xee, 0x1e, 0x12, 0xbb, 0x5b, 0xfb, 0x14, 0xe6, 0x04, 0x8a, 0x9f, 0xdf, 0x22,
	0x2d, 0xb8, 0x71, 0x70, 0x6a, 0x35, 0xfd, 0x99, 0x6d, 0xbd, 0x83, 0x33, 0xdb, 0x43, 0xbc, 0x83,
	0x82, 0x64, 0x07, 0x87, 0x50, 0xea, 0x97, 0x74, 0xfe, 0x0d, 0xfc, 0xbe, 0x00, 0x0b, 0x75, 0x47,
	0xb7, 0x5c, 0x93, 0x9e, 0xf3, 0x20, 0x66, 0x88, 0x4e, 0xb2, 0x6f, 0xe4, 0x18, 0xae, 0x93, 0x60,
	0x89, 0x86, 0x4b, 0x79, 0x1b, 0xc4, 0x66, 0x3b, 0x99, 0x5c, 0xf9, 0x48, 0x72, 0xa2, 0xd2, 0x85,
	0x96, 0xbd, 0x1f, 0xd7, 0xc2, 0x75, 0xd9, 0x40, 0xdd, 0xce, 0xe9, 0xf7, 0x55, 0x28, 0x32, 0x46,
	0x34, 0x01, 0xa3, 0xe1, 0x01, 0xbb, 0x02, 0x63, 0x9b, 0xd5, 0x83, 0xb5, 0xf5, 0x9d, 0xca, 0xe6,
	0x94, 0x82, 0xc6, 0x60, 0xb8, 0x5e, 0x39, 0xa8, 0x4f, 0x15, 0x28, 0x51, 0x65, 0xcf, 0x1b, 0x1e,
	0xd2, 0x7e, 0x06, 0x8b, 0x52, 0x1d, 0xcf, 0x6f, 0xf7, 0xa7, 0x70, 0x73, 0xc7, 0x74, 0x83, 0x88,
	0x74, 0xd7, 0x4f, 0xf7, 0x69, 0x1e, 0xf3, 0x6d, 0x1e, 0xcd, 0x73, 0x4a, 0x96, 0x3c, 0x27, 0x0b,
	0x9b, 0xcf, 0xe0, 0x65, 0xb1, 0x1c, 0xbe, 0x85, 0x8f, 0x60, 0xdc, 0xd7, 0xc9, 0x2d, 0x29, 0x4b,
	0x43, 0x83, 0xf7, 0x10, 0xd2, 0x6b, 0xc7, 0x50, 0xda, 0xc6, 0xd1, 0xb5, 0xab, 0x9b, 0x41, 0x3a,
	0xb8, 0x05, 0x57, 0x22, 0x51, 0xe3, 0xad, 0x3d, 0x5e, 0x9b, 0x08, 0xc3, 0xc6, 0xcd, 0xb9, 0x93,
	0x7f, 0x29, 0x30, 0x27, 0x90, 0xc6, 0xf7, 0xf1, 0x79, 0xff, 0x3e, 0x7e, 0x2c, 0x89, 0x3c, 0xe9,
	0x22, 0xc1, 0x1e, 0xdd, 0x8a, 0x45, 0x9c, 0xd3, 0xc8, 0x4e, 0xd5, 0xcf, 0x60, 0x32, 0x3e, 0x89,
	0xa6, 0x60, 0xe8, 0x18, 0x9f, 0x72, 0xe7, 0xd0, 0x3f, 0xd1, 0x3d, 0x28, 0x9e, 0xe8, 0xed, 0x1e,
	0xe6, 0x59, 0x6d, 0x80, 0x19, 0x3d, 0xda, 0xfb, 0x85, 0x0f, 0x15, 0xcd, 0x05, 0x2d, 0xa2, 0xd3,
	0x23, 0x93, 0xb4, 0xe8, 0x96, 0xfd, 0x72, 0xf2, 0x92, 0xf2, 0xc9, 0xdf, 0x0b, 0xf0, 0x4a, 0xaa,
	0xd4, 0x73, 0xc7, 0x38, 0x7a, 0xa1, 0xc0, 0x2c, 0x53, 0x23, 0xd0, 0xdb, 0xf7, 0x01, 0x37, 0xd1,
	0xfe, 0x60, 0x0f, 0xc9, 0xf4, 0x2a, 0xd3, 0x41, 0x9f, 0x28, 0x98, 0x9c, 0xee, 0x09, 0x46, 0xd5,
	0x4f, 0x60, 0x5a, 0x44, 0x8d, 0x56, 0x61, 0xce, 0x74, 0x3d, 0x43, 0xf9, 0x95, 0x54, 0xd3, 0xb6,
	0x2c, 0xdc, 0x24, 0xd8, 0xb3, 0xef, 0x58, 0x6d, 0xd6, 0x74, 0x29, 0xeb, 0x9a, 0x37, 0xbd, 0xe1,
	0xcf, 0x6a, 0x9f, 0xc0, 0x2d, 0x7a, 0xac, 0x2a, 0x96, 0xfe, 0xa4, 0x8d, 0x8d, 0x48, 0x38, 0x51,
	0x6a, 0xdf, 0x63, 0x62, 0x87, 0x28, 0x12, 0x87, 0xb4, 0x40, 0x4b, 0x5b, 0x92, 0xbb, 0x63, 0xbd,
	0x3f, 0xce, 0x5f, 0xcd, 0x52, 0xbf, 0x46, 0x8f, 0x6d, 0x1d, 0x5e, 0x15, 0x4b, 0xda, 0x68, 0xe9,
	0x96, 0x85, 0xdb, 0x67, 0xd3, 0xff, 0x18, 0x5e, 0x1b, 0xb0, 0xea, 0x05, 0x6e, 0xe1, 0x3b, 0x05,
	0x5e, 0xa7, 0xd2, 0xd6, 0x4e, 0x74, 0xb3, 0x4d, 0x05, 0xca, 0x77, 0x31, 0x0f, 0xd0, 0xf4, 0x46,
	0x42, 0xed, 0xc7, 0xf9, 0x48, 0xde, 0x53, 0x13, 0x2d, 0x56, 0x87, 0xa2, 0xc5, 0xaa, 0xf6, 0x14,
	0xde, 0x18, 0xa8, 0xcf, 0x45, 0xa4, 0xdc, 0xbf, 0x14, 0x60, 0x3e, 0x91, 0xd0, 0xe9, 0x53, 0x31,
	0x92, 0x78, 0x73, 0x79, 0x0d, 0xcd, 0xc3, 0x18, 0x95, 0xc9, 0x52, 0x74, 0x81, 0xa6, 0xe8, 0xf5,
	0x42, 0x49, 0xa9, 0x8d, 0xd2, 0x31, 0x9a, 0xa2, 0xbf, 0x86, 0x69, 0x7f, 0xba, 0xd1, 0x6c, 0xeb,
	0x66, 0xa7, 0xc1, 0x0e, 0x42, 0x69, 0x88, 0xa9, 0xfd, 0x40, 0x72, 0x7e, 0x53, 0x15, 0x2c, 0x6f,
	0x7a, 0x6b, 0x6f, 0xd0, 0xe5, 0x36, 0xe8, 0x6a, 0x5e, 0xb6, 0xbd, 0x66, 0x24, 0xc7, 0xd5, 0x4d,
	0x98, 0x15, 0x13, 0x0b, 0xb2, 0xef, 0x74, 0x34, 0xfb, 0x16, 0xa3, 0xe9, 0xf5, 0x73, 0x58, 0x90,
	0x29, 0x74, 0x11, 0x1e, 0xf9, 0x53, 0xc1, 0x0b, 0x45, 0xa6, 0x62, 0xc2, 0xf5, 0xe7, 0x72, 0xcd,
	0x0b, 0x45, 0x62, 0xfc, 0x02, 0xd3, 0xb0, 0x9e, 0x66, 0xfc, 0x81, 0xba, 0xfc, 0xdf, 0xbd, 0xc0,
	0x0f, 0x48, 0xaa, 0x66, 0x17, 0xe1, 0x8e, 0xa7, 0x30, 0xb3, 0x89, 0xdb, 0xb8, 0x1f, 0x1a, 0xb9,
	0xe0, 0xfb, 0xb3, 0x04, 0xb3, 0x49, 0x39, 0x9e, 0xfa, 0xda, 0x97, 0xb0, 0x10, 0xb9, 0xc0, 0x78,
	0xf2, 0xba, 0xdc, 0xda, 0xe8, 0x97, 0x05, 0x58, 0x94, 0xca, 0xe4, 0x56, 0x3d, 0x81, 0xa9, 0x40,
	0x28, 0x7f, 0xb8, 0x73, 0xe3, 0x3e, 0x18, 0x7c, 0x0d, 0x8b, 0x56, 0x4c, 0xe6, 0x67, 0x2f, 0x80,
	0x82, 0x37, 0x1e, 0x1f, 0x55, 0x5b, 0x30, 0x2d, 0x22, 0x14, 0x04, 0xcf, 0xfd, 0x78, 0x01, 0x95,
	0xed, 0x52, 0x88, 0x84, 0xd8, 0x7f, 0x15, 0x58, 0xf4, 0x80, 0x98, 0x3d, 0xfc, 0x9c, 0x06, 0xd5,
	0x96, 0xed, 0xe4, 0x8e, 0x82, 0x28, 0x90, 0x51, 0x88, 0x03, 0x19, 0x3e, 0x20, 0x31, 0x14, 0x01,
	0x24, 0xe2, 0xe0, 0xc6, 0x70, 0x12, 0xdc, 0xb8, 0x0f, 0xe3, 0xec, 0x08, 0x33, 0x88, 0xa1, 0xc8,
	0x1e, 0x44, 0xe2, 0x50, 0xa6, 0xea, 0x32, 0x68, 0x89, 0xa5, 0x63, 0xfa, 0x97, 0x24, 0x04, 0x46,
	0x24, 0x21, 0x70, 0x02, 0x4b, 0xf2, 0xbd, 0x9f, 0xbf, 0x96, 0xbb, 0x01, 0xa3, 0x3c, 0x17, 0xf1,
	0x20, 0x1c, 0xf1, 0x12, 0x85, 0xf6, 0x67, 0x05, 0xae, 0x79, 0x80, 0x03, 0x95, 0xea, 0x9b, 0x39,
	0x42, 0xae, 0x44, 0xc9, 0x2f, 0xd8, 0xbc, 0x62, 0x13, 0x15, 0xa5, 0x15, 0x16, 0x8a, 0x6a, 0x7a,
	0x89, 0x46, 0x79, 0x31, 0x0c, 0x33, 0xa1, 0x28, 0xe6, 0xd7, 0x41, 0x86, 0xc1, 0x50, 0x22, 0x66,
	0x07, 0x37, 0x9e, 0xe8, 0x2e, 0x36, 0x58, 0xbc, 0x24, 0xab, 0xe5, 0x37, 0x85, 0x6a, 0xd5, 0xcd,
	0x0e, 0x5e, 0xa7, 0x3c, 0x54, 0x8a, 0x5f, 0xda, 0x7e, 0xfc, 0x52, 0x6d, 0x86, 0x88, 0x26, 0x50,
	0x0b, 0xe6, 0xf0, 0x09, 0xb6, 0x88, 0x50, 0xce, 0x10, 0x93, 0xf3, 0x96, 0x50, 0x4e, 0x85, 0x72,
	0x89, 0x04, 0xcd, 0x62, 0xe1, 0x0c, 0xfa, 0x85, 0x02, 0x5a, 0x47, 0xb7, 0x7a, 0x7a, 0xbb, 0x41,
	0x1c, 0xf3, 0xe8, 0x08, 0x3b, 0x42, 0x99, 0x45, 0x26, 0xf3, 0x9e, 0x50, 0xe6, 0x2e, 0x63, 0xaf,
	0x7b, 0xdc, 0x22, 0xd9, 0x0b, 0x9d, 0x54, 0x0a, 0x49, 0x7c, 0x0c, 0x4b, 0x2e, 0xdc, 0xd8, 0x61,
	0x1d, 0xc9, 0x75, 0x58, 0xd7, 0xa7, 0x01, 0x05, 0xbc, 0xc1, 0xe6, 0xb4, 0x36, 0xcc, 0x26, 0xc3,
	0xe0, 0x12, 0xa3, 0xee, 0x5b, 0x0f, 0x9e, 0x5b, 0xc7, 0x16, 0x7e, 0x6a, 0x12, 0x77, 0xdf, 0xca,
	0x74, 0x22, 0x17, 0x61, 0xe2, 0x89, 0xc7, 0x11, 0x16, 0x81, 0x35, 0xe0, 0x43, 0xf2, 0xab, 0x48,
	0x86, 0xb8, 0xd8, 0x0c, 0x69, 0x4b, 0xea, 0x70, 0x89, 0xbb, 0xfe, 0xa7, 0x02, 0xaa, 0x67, 0x64,
	0x2e, 0x34, 0xe3, 0xbe, 0xe7, 0x01, 0xc2, 0x7d, 0xf3, 0x35, 0xc7, 0x83, 0x6d, 0xa3, 0x0d, 0x58,
	0x60, 0x7c, 0x3e, 0x0d, 0xb6, 0x88, 0x49, 0xda, 0xb8, 0x83, 0x19, 0xde, 0xde, 0x31, 0x09, 0xb3,
	0x40, 0xb1, 0x76, 0x93, 0x52, 0x71, 0xc9, 0x95, 0x90, 0x66, 0x87, 0x92, 0xe4, 0x8b, 0x3f, 0xed,
	0x4b, 0xb8, 0x29, 0xdc, 0xc8, 0x25, 0x1a, 0xef, 0xdf, 0x05, 0xb8, 0xb5, 0xde, 0x6b, 0x1f, 0x87,
	0x51, 0xfa, 0xd0, 0xc1, 0x4d, 0xdb, 0x32, 0x18, 0xea, 0x95, 0xf9, 0xd2, 0xfc, 0x56, 0x81, 0x59,
	0x26, 0xa0, 0x1b, 0xe1, 0x6e, 0xb4, 0x4d, 0xd7, 0x2f, 0x56, 0x77, 0x24, 0x25, 0xc6, 0x40, 0xd9,
	0xe5, 0xe4, 0xf8, 0xae, 0xde, 0xad, 0xb1, 0xb2, 0x38, 0x3a, 0x48, 0x2b, 0xcb, 0x7c, 0x71, 0xaa,
	0x7e, 0x01, 0xd7, 0x05, 0x4b, 0xcb, 0xc3, 0xe5, 0x0e, 0x2f, 0xc6, 0x63, 0x3b, 0x0c, 0xec, 0x89,
	0x92, 0x1a, 0x55, 0x0d, 0xad, 0x01, 0x5a, 0xda, 0xf6, 0xce, 0x8f, 0x21, 0x36, 0x60, 0x7a, 0x1b,
	0x13, 0xd6, 0x29, 0x8c, 0x95, 0x97, 0x73, 0x91, 0x37, 0x9d, 0x57, 0x5a, 0x06, 0xef, 0xb9, 0x9c,
	0x18, 0x91, 0x02, 0x33, 0x09, 0x09, 0x5c, 0xeb, 0x5d, 0x28, 0x32, 0xed, 0x78, 0x05, 0xf9, 0x81,
	0xbc, 0x82, 0xec, 0x67, 0x66, 0x2e, 0xe5, 0xd5, 0xa2, 0xb7, 0x8a, 0x7a, 0x00, 0x10, 0x0e, 0x0a,
	0x2a, 0xc3, 0xe5, 0x78, 0x65, 0x38, 0x27, 0xcd, 0xca, 0xd1, 0x72, 0xf0, 0xb1, 0x07, 0x7d, 0xae,
	0x35, 0x89, 0x79, 0x82, 0xb9, 0x1a, 0xd1, 0xab, 0x38, 0x96, 0xee, 0x95, 0x5c, 0xe9, 0x5e, 0x7b,
	0xe8, 0xbd, 0xc2, 0x05, 0x6b, 0x73, 0x03, 0x2d, 0xc7, 0x0d, 0x94, 0xa6, 0x31, 0x1b, 0xd2, 0x1e,
	0xc3, 0x35, 0xef, 0x3d, 0x91, 0x29, 0x79, 0xe5, 0xf3, 0xe3, 0x17, 0x80, 0xa2, 0x6b, 0x73, 0x15,
	0x7f, 0x02, 0x5a, 0xf0, 0xbc, 0x7c, 0x6e, 0x92, 0x56, 0xc3, 0xc1, 0x1d, 0xfb, 0x04, 0x1b, 0xb1,
	0x10, 0xe7, 0x01, 0xb4, 0xc0, 0x03, 0xe8, 0x91, 0x49, 0x5a, 0x35, 0x8f, 0x2c, 0x1a, 0xcd, 0xda,
	0x36, 0xbc, 0xba, 0x8d, 0xc9, 0x7e, 0x97, 0xec, 0xf7, 0xc8, 0x01, 0xd1, 0x49, 0xcf, 0xc5, 0x21,
	0xf2, 0x11, 0x09, 0x4d, 0x9a, 0x49, 0x02, 0x30, 0xc6, 0x8f, 0x4e, 0x08, 0xd0, 0x18, 0x6a, 0x86,
	0xd7, 0x06, 0x2c, 0xc4, 0xb5, 0xbf, 0x0b, 0x33, 0x76, 0x97, 0x60, 0xa3, 0x61, 0xf7, 0x48, 0xa3,
	0x7f, 0x4d, 0xc4, 0x26, 0xf7, 0x7b, 0x64, 0x23, 0x5c, 0xfb, 0x09, 0xcc, 0x1f, 0x60, 0x7f, 0x20,
	0x2a, 0x22, 0x23, 0x54, 0xa4, 0xc1, 0x55, 0xbb, 0x4b, 0x98, 0x40, 0xd6, 0xe4, 0x60, 0xf6, 0x1e,
	0xab, 0x4d, 0xd8, 0xc1, 0x52, 0x58, 0x5b, 0x82, 0x05, 0x99, 0x0c, 0xfe, 0x3c, 0xfc, 0xc6, 0x6b,
	0x45, 0xb5, 0x4d, 0x6c, 0x91, 0xea, 0xe6, 0x96, 0xed, 0x44, 0x9b, 0x46, 0x37, 0x61, 0xbc, 0xc9,
	0x66, 0x42, 0x05, 0xc6, 0xbc, 0x81, 0x38, 0xf8, 0x54, 0x88, 0x75, 0x4a, 0xf3, 0xdd, 0xd0, 0x0f,
	0x40, 0x15, 0x29, 0xc0, 0xed, 0xfa, 0x0e, 0x0c, 0xd3, 0x55, 0x79, 0x2e, 0x12, 0xc7, 0x2d, 0x63,
	0x60, 0x64, 0xda, 0x3f, 0x0a, 0x70, 0xdd, 0x7b, 0x77, 0x1c, 0x76, 0xdb, 0xb6, 0x6e, 0xf8, 0x1b,
	0xd9, 0x82, 0xa2, 0xdb, 0xb4, 0x83, 0x83, 0x75, 0x47, 0x92, 0x20, 0x04, 0xac, 0xe5, 0x03, 0xca,
	0x57, 0xf3, 0xd8, 0xe9, 0x53, 0xd9, 0xc1, 0x4f, 0xb1, 0x83, 0xad, 0x66, 0x64, 0xe3, 0x13, 0xc1,
	0x58, 0xd5, 0xf0, 0x48, 0x5c, 0xf3, 0x2b, 0xdc, 0x78, 0x6e, 0x1a, 0xa4, 0xc5, 0xef, 0xe5, 0x09,
	0x6f, 0xec, 0x11, 0x1d, 0x42, 0xaf, 0xc0, 0x55, 0x4e, 0xd2, 0xc2, 0xe6, 0x51, 0x8b, 0xb0, 0x2b,
	0xb8, 0x58, 0xe3, 0x7c, 0x1f, 0xb3, 0xb1, 0x7c, 0x8f, 0x89, 0x58, 0x87, 0x66, 0x24, 0xd6, 0xa1,
	0xd1, 0x96, 0xa1, 0xc8, 0xf6, 0x10, 0x6f, 0x3a, 0x4d, 0xc0, 0xe8, 0x7a, 0x65, 0xaf, 0xb2, 0x55,
	0xad, 0x4f, 0x29, 0xe8, 0x0a, 0x8c, 0xf9, 0x7d, 0xdc, 0xa9, 0x82, 0x56, 0x83, 0xe9, 0xb8, 0x21,
	0xb8, 0x2f, 0x6e, 0xc2, 0x78, 0x8f, 0x8d, 0x44, 0xa2, 0xc1, 0x1b, 0xf0, 0xea, 0x17, 0x3e, 0xd9,
	0x73, 0xda, 0x7e, 0xfd, 0xe2, 0x8d, 0x1c, 0x3a, 0x6d, 0xed, 0x2e, 0xbb, 0x1c, 0xa8, 0xa7, 0xfa,
	0x2e, 0x07, 0x1e, 0x44, 0xc1, 0xe5, 0xe0, 0x45, 0x91, 0xeb, 0xa7, 0xfb, 0x28, 0x4f, 0x98, 0xee,
	0x29, 0x51, 0x86, 0x74, 0xdf, 0xcf, 0xcc, 0xa2, 0xc5, 0x4f, 0xf7, 0x6c, 0x15, 0x9a, 0xee, 0xc3,
	0xc1, 0xb3, 0xa6, 0x7b, 0x16, 0x84, 0x91, 0x74, 0xff, 0x4c, 0x06, 0xc9, 0x47, 0xcf, 0x57, 0x3e,
	0x04, 0x4e, 0x76, 0xe0, 0x34, 0x5d, 0x86, 0xd5, 0xc7, 0x8e, 0xd2, 0xb9, 0x70, 0xac, 0x3b, 0x3e,
	0x8e, 0x45, 0x75, 0xd9, 0x8c, 0xf4, 0x81, 0x6e, 0xc0, 0x68, 0x5c, 0xef, 0x91, 0x5e, 0x02, 0x91,
	0x0a, 0x39, 0x78, 0xca, 0xb9, 0x03, 0x33, 0x5e, 0xcb, 0x3b, 0xf3, 0x5a, 0xdb, 0x30, 0x9b, 0xe4,
	0xe0, 0x9b, 0x9a, 0x83, 0xb1, 0x96, 0xee, 0x36, 0xd8, 0xdb, 0xcd, 0xeb, 0x91, 0x8c, 0xb6, 0x74,
	0x97, 0x92, 0xd0, 0x07, 0x7c, 0xf0, 0x5c, 0x1d, 0xaf, 0xb1, 0xbf, 0xb5, 0xdb, 0xf0, 0x7a, 0xb4,
	0xdf, 0x56, 0x69, 0x9b, 0x47, 0xe6, 0x93, 0x36, 0xde, 0xb2, 0x9d, 0x87, 0x8e, 0x7d, 0xe4, 0x84,
	0xdf, 0x0f, 0x68, 0x1d, 0x78, 0x63, 0x20, 0xe5, 0x05, 0x76, 0x10, 0x7e, 0x0e, 0x4b, 0x5b, 0x66,
	0x9b, 0x84, 0x6d, 0x21, 0x77, 0xcb, 0x76, 0x76, 0x1f, 0xb1, 0x67, 0xee, 0x20, 0xf3, 0x24, 0x2e,
	0x8a, 0x42, 0xf2, 0xa2, 0x48, 0xe2, 0x7b, 0xc3, 0x7d, 0xf8, 0x9e, 0xf6, 0x05, 0xdc, 0x4a, 0x11,
	0x7f, 0x01, 0x01, 0xb4, 0xf2, 0x1f, 0x0d, 0xa6, 0x45, 0xdf, 0xa5, 0xa1, 0x0e, 0x4c, 0xc6, 0x3f,
	0x57, 0x42, 0x6f, 0xa7, 0x66, 0xe7, 0x04, 0x84, 0xa6, 0xbe, 0x93, 0x91, 0x9a, 0x6f, 0xe2, 0x5b,
	0xc5, 0xc7, 0x42, 0x12, 0x5f, 0xa4, 0xa0, 0x7b, 0x67, 0xf8, 0xd8, 0x46, 0x7d, 0x37, 0x1f, 0x53,
	0x00, 0x7e, 0x5e, 0xeb, 0xfb, 0xfe, 0x03, 0x2d, 0x4b, 0x96, 0x92, 0x7d, 0xe2, 0xa2, 0xde, 0xc9,
	0xce, 0xc0, 0xe5, 0xba, 0x30, 0x95, 0xfc, 0x6a, 0x03, 0x95, 0x65, 0xab, 0x88, 0x3f, 0x24, 0x51,
	0x97, 0x33, 0xd3, 0x73, 0xa1, 0xbf, 0x52, 0xe0, 0x86, 0xe4, 0xd3, 0x05, 0xf4, 0xde, 0x99, 0x3e,
	0xc7, 0x50, 0xdf, 0xcf, 0xcb, 0xc6, 0x55, 0xf9, 0x06, 0xa6, 0x45, 0x9f, 0x1f, 0xa0, 0x95, 0x6c,
	0x9d, 0xa3, 0xe8, 0x37, 0x11, 0xea, 0xbd, 0x5c, 0x3c, 0xa1, 0xe3, 0xfb, 0xfa, 0xfd, 0x52, 0xc7,
	0xcb, 0x3e, 0x66, 0x90, 0x3a, 0x5e, 0xfe, 0x3d, 0x02, 0xf5, 0x81, 0x04, 0x3f, 0x97, 0xfa, 0x20,
	0xbd, 0x6b, 0x20, 0xf5, 0xc1, 0x20, 0xe0, 0xff, 0x77, 0x0a, 0xdc, 0x4c, 0xe9, 0xa8, 0xa3, 0xd5,
	0xb3, 0x74, 0xe1, 0x3d, 0x95, 0xee, 0x9f, 0xbd, 0x81, 0x8f, 0x7e, 0xab, 0x80, 0x2a, 0x6f, 0x78,
	0xa3, 0x0f, 0x53, 0xbc, 0x9d, 0xda, 0x76, 0x57, 0x57, 0xcf, 0xc0, 0x39, 0x50, 0x27, 0x76, 0x72,
	0xf3, 0xe9, 0x14, 0x3d, 0xc3, 0xab, 0x67, 0xe0, 0xe4, 0x3a, 0xfd, 0x41, 0xf1, 0xde, 0x9a, 0xd2,
	0xc6, 0x3a, 0xfa, 0x28, 0xd7, 0xe2, 0xf1, 0xf6, 0xb8, 0xfa, 0x83, 0xb3, 0x31, 0x73, 0xe5, 0xfe,
	0xa8, 0xc0, 0xe2, 0x80, 0xbe, 0x37, 0xfa, 0x61, 0x8a, 0x84, 0xc1, 0xfd, 0x7b, 0xf5, 0x47, 0x67,
	0x65, 0xe7, 0x2a, 0xbe, 0x50, 0x60, 0x56, 0xdc, 0xff, 0x45, 0xef, 0x9e, 0xa5, 0x7f, 0xad, 0xbe,
	0x97, 0x93, 0x2b, 0x61, 0xaa, 0x94, 0x0e, 0x68, 0xaa, 0xa9, 0x06, 0xf7, 0x74, 0x53, 0x4d, 0x95,
	0xa5, 0xf1, 0xda, 0x81, 0xc9, 0x78, 0x4f, 0x53, 0x5a, 0x19, 0x08, 0x5b, 0xac, 0xd2, 0xca, 0x40,
	0xdc, 0x28, 0x45, 0xbf, 0x56, 0xa0, 0x24, 0xeb, 0x59, 0xa1, 0xf7, 0x53, 0xab, 0x0c, 0x69, 0x83,
	0x4f, 0xfd, 0x20, 0x37, 0x1f, 0xd7, 0x46, 0x07, 0x08, 0xa1, 0x3a, 0x74, 0x3b, 0xb5, 0xcc, 0x88,
	0x60, 0x34, 0xea, 0xf7, 0x33, 0x50, 0x86, 0xf6, 0x8d, 0xb7, 0x03, 0xa4, 0xf6, 0x15, 0x36, 0x8f,
	0xa4, 0xf6, 0x95, 0xf4, 0x18, 0xbc, 0xa2, 0x27, 0x0e, 0xc5, 0xa7, 0x15, 0x3d, 0xc2, 0xc6, 0x41,
	0x5a, 0xd1, 0x23, 0x41, 0xf9, 0xbf, 0x86, 0xeb, 0x02, 0x1c, 0x1b, 0xdd, 0x4d, 0xd5, 0x5e, 0x04,
	0xde, 0xab, 0x2b, 0x79, 0x58, 0x22, 0x39, 0x5c, 0x8e, 0xbb, 0x4a, 0x73, 0xf8, 0x40, 0x24, 0x5a,
	0x9a, 0xc3, 0x33, 0x80, 0xbc, 0xcf, 0xe0, 0x6a, 0x0c, 0x0a, 0x45, 0x6f, 0x65, 0x03, 0x4c, 0x3d,
	0xc1, 0x6f, 0xe7, 0x41, 0x57, 0x59, 0xbd, 0x2d, 0xc4, 0x26, 0x51, 0x5a, 0x01, 0x25, 0x43, 0x49,
	0xd5, 0x77, 0xf3, 0x31, 0x85, 0x87, 0x29, 0x44, 0x1c, 0xa5, 0x87, 0xa9, 0x0f, 0xf0, 0x94, 0x1e,
	0x26, 0x01, 0x7c, 0x79, 0x04, 0x57, 0xa2, 0xa0, 0x09, 0x7a, 0x33, 0x3b, 0xc4, 0xa4, 0xbe, 0x95,
	0x89, 0x36, 0x72, 0x01, 0xa7, 0x62, 0x92, 0xd2, 0x0b, 0x38, 0x0b, 0x24, 0x2a, 0xbd, 0x80, 0xb3,
	0xc1, 0xa0, 0xf4, 0x76, 0x13, 0x03, 0x8e, 0xd2, 0xdb, 0x2d, 0x15, 0x03, 0x95, 0xde, 0x6e, 0xe9,
	0xa8, 0x26, 0x3a, 0x05, 0xd4, 0x0f, 0x2a, 0xa2, 0xb4, 0x07, 0x93, 0x10, 0x00, 0x55, 0xef, 0xe6,
	0xe0, 0x88, 0x1d, 0xae, 0x10, 0x78, 0x4a, 0x3b, 0x5c, 0x7d, 0x78, 0x58, 0xda, 0xe1, 0x12, 0x00,
	0x61, 0xc1, 0x0d, 0xe9, 0xe3, 0x22, 0x03, 0x6e, 0xc8, 0x04, 0xe0, 0x32, 0xe0, 0x86, 0xec, 0x03,
	0x5b, 0x3a, 0x30, 0x19, 0x87, 0x61, 0xa4, 0xe2, 0x84, 0xf8, 0x8e, 0x54, 0x9c, 0x04, 0xdb, 0xa1,
	0x25, 0xca, 0x00, 0x0c, 0x46, 0x5a, 0xa2, 0x64, 0x43, 0x79, 0xa4, 0x25, 0x4a, 0x56, 0xe8, 0xe7,
	0x3b, 0x05, 0xe6, 0xa4, 0xc0, 0x09, 0x92, 0x5d, 0xfe, 0x83, 0x90, 0x1e, 0xf5, 0xc3, 0xfc, 0x8c,
	0x9e, 0x42, 0xeb, 0xef, 0x3d, 0xbe, 0x27, 0xfa, 0xff, 0x7b, 0x75, 0xb6, 0x9c, 0xf4, 0xff, 0x05,
	0x3e, 0x19, 0x61, 0xff, 0x93, 0xef, 0xde, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x37, 0x79, 0x34,
	0x4f, 0x4f, 0x38, 0x00, 0x00,
}
