// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchE2IngestHTTPLambdaTwirp/twirp.proto

/*
Package TwitchE2IngestHTTPLambdaTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchE2IngestHTTPLambdaTwirp/twirp.proto
*/
package TwitchE2IngestHTTPLambdaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ============================
// TwitchE2IngestHTTP Interface
// ============================

type TwitchE2IngestHTTP interface {
	// Publish accepts full state data from a client and broadcasts it for each broadcaster specified.
	Publish(context.Context, *PublishRequest) (*PublishResponse, error)

	// GetClients lists the clients that are allowlisted to publish data for a given game.
	GetClients(context.Context, *GetClientsRequest) (*GetClientsResponse, error)

	// CreateAllowlistEntry adds the <game, client> pair to the allowlist, allowing the client to publish data for the game.
	CreateAllowlistEntry(context.Context, *CreateAllowlistEntryRequest) (*CreateAllowlistEntryResponse, error)

	// UpdateAllowlistEntry updates the entry for the <game, client> pair.
	UpdateAllowlistEntry(context.Context, *UpdateAllowlistEntryRequest) (*UpdateAllowlistEntryResponse, error)

	// DeleteAllowlistEntry removes the <game, client> pair from the allowlist.
	DeleteAllowlistEntry(context.Context, *DeleteAllowlistEntryRequest) (*DeleteAllowlistEntryResponse, error)

	// ListEntriesByOrg lists all the allowlist entries for an organization.
	ListEntriesByOrg(context.Context, *ListEntriesByOrgRequest) (*ListEntriesByOrgResponse, error)

	// ListEntries returns a paginated list of allowlist entries.
	ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error)

	// ListPages returns page data, which should be used to paginate through allowlist entries.
	ListPages(context.Context, *ListPagesRequest) (*ListPagesResponse, error)
}

// ==================================
// TwitchE2IngestHTTP Protobuf Client
// ==================================

type twitchE2IngestHTTPProtobufClient struct {
	client HTTPClient
	urls   [8]string
	opts   twirp.ClientOptions
}

// NewTwitchE2IngestHTTPProtobufClient creates a Protobuf client that implements the TwitchE2IngestHTTP interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchE2IngestHTTPProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchE2IngestHTTP {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchE2IngestHTTPPathPrefix
	urls := [8]string{
		prefix + "Publish",
		prefix + "GetClients",
		prefix + "CreateAllowlistEntry",
		prefix + "UpdateAllowlistEntry",
		prefix + "DeleteAllowlistEntry",
		prefix + "ListEntriesByOrg",
		prefix + "ListEntries",
		prefix + "ListPages",
	}

	return &twitchE2IngestHTTPProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchE2IngestHTTPProtobufClient) Publish(ctx context.Context, in *PublishRequest) (*PublishResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "Publish")
	out := new(PublishResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPProtobufClient) GetClients(ctx context.Context, in *GetClientsRequest) (*GetClientsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "GetClients")
	out := new(GetClientsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPProtobufClient) CreateAllowlistEntry(ctx context.Context, in *CreateAllowlistEntryRequest) (*CreateAllowlistEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAllowlistEntry")
	out := new(CreateAllowlistEntryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPProtobufClient) UpdateAllowlistEntry(ctx context.Context, in *UpdateAllowlistEntryRequest) (*UpdateAllowlistEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAllowlistEntry")
	out := new(UpdateAllowlistEntryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPProtobufClient) DeleteAllowlistEntry(ctx context.Context, in *DeleteAllowlistEntryRequest) (*DeleteAllowlistEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllowlistEntry")
	out := new(DeleteAllowlistEntryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPProtobufClient) ListEntriesByOrg(ctx context.Context, in *ListEntriesByOrgRequest) (*ListEntriesByOrgResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntriesByOrg")
	out := new(ListEntriesByOrgResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPProtobufClient) ListEntries(ctx context.Context, in *ListEntriesRequest) (*ListEntriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntries")
	out := new(ListEntriesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPProtobufClient) ListPages(ctx context.Context, in *ListPagesRequest) (*ListPagesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "ListPages")
	out := new(ListPagesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==============================
// TwitchE2IngestHTTP JSON Client
// ==============================

type twitchE2IngestHTTPJSONClient struct {
	client HTTPClient
	urls   [8]string
	opts   twirp.ClientOptions
}

// NewTwitchE2IngestHTTPJSONClient creates a JSON client that implements the TwitchE2IngestHTTP interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchE2IngestHTTPJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchE2IngestHTTP {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchE2IngestHTTPPathPrefix
	urls := [8]string{
		prefix + "Publish",
		prefix + "GetClients",
		prefix + "CreateAllowlistEntry",
		prefix + "UpdateAllowlistEntry",
		prefix + "DeleteAllowlistEntry",
		prefix + "ListEntriesByOrg",
		prefix + "ListEntries",
		prefix + "ListPages",
	}

	return &twitchE2IngestHTTPJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchE2IngestHTTPJSONClient) Publish(ctx context.Context, in *PublishRequest) (*PublishResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "Publish")
	out := new(PublishResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPJSONClient) GetClients(ctx context.Context, in *GetClientsRequest) (*GetClientsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "GetClients")
	out := new(GetClientsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPJSONClient) CreateAllowlistEntry(ctx context.Context, in *CreateAllowlistEntryRequest) (*CreateAllowlistEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateAllowlistEntry")
	out := new(CreateAllowlistEntryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPJSONClient) UpdateAllowlistEntry(ctx context.Context, in *UpdateAllowlistEntryRequest) (*UpdateAllowlistEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAllowlistEntry")
	out := new(UpdateAllowlistEntryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPJSONClient) DeleteAllowlistEntry(ctx context.Context, in *DeleteAllowlistEntryRequest) (*DeleteAllowlistEntryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllowlistEntry")
	out := new(DeleteAllowlistEntryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPJSONClient) ListEntriesByOrg(ctx context.Context, in *ListEntriesByOrgRequest) (*ListEntriesByOrgResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntriesByOrg")
	out := new(ListEntriesByOrgResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPJSONClient) ListEntries(ctx context.Context, in *ListEntriesRequest) (*ListEntriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "ListEntries")
	out := new(ListEntriesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchE2IngestHTTPJSONClient) ListPages(ctx context.Context, in *ListPagesRequest) (*ListPagesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithMethodName(ctx, "ListPages")
	out := new(ListPagesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// TwitchE2IngestHTTP Server Handler
// =================================

type twitchE2IngestHTTPServer struct {
	TwitchE2IngestHTTP
	hooks *twirp.ServerHooks
}

func NewTwitchE2IngestHTTPServer(svc TwitchE2IngestHTTP, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchE2IngestHTTPServer{
		TwitchE2IngestHTTP: svc,
		hooks:              hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchE2IngestHTTPServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchE2IngestHTTPPathPrefix is used for all URL paths on a twirp TwitchE2IngestHTTP server.
// Requests are always: POST TwitchE2IngestHTTPPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchE2IngestHTTPPathPrefix = "/twirp/twitch.fulton.example.twitche2ingesthttp.TwitchE2IngestHTTP/"

func (s *twitchE2IngestHTTPServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.twitche2ingesthttp")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchE2IngestHTTP")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.twitche2ingesthttp.TwitchE2IngestHTTP/Publish":
		s.servePublish(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitche2ingesthttp.TwitchE2IngestHTTP/GetClients":
		s.serveGetClients(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitche2ingesthttp.TwitchE2IngestHTTP/CreateAllowlistEntry":
		s.serveCreateAllowlistEntry(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitche2ingesthttp.TwitchE2IngestHTTP/UpdateAllowlistEntry":
		s.serveUpdateAllowlistEntry(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitche2ingesthttp.TwitchE2IngestHTTP/DeleteAllowlistEntry":
		s.serveDeleteAllowlistEntry(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitche2ingesthttp.TwitchE2IngestHTTP/ListEntriesByOrg":
		s.serveListEntriesByOrg(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitche2ingesthttp.TwitchE2IngestHTTP/ListEntries":
		s.serveListEntries(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.twitche2ingesthttp.TwitchE2IngestHTTP/ListPages":
		s.serveListPages(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchE2IngestHTTPServer) servePublish(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublishJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublishProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchE2IngestHTTPServer) servePublishJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Publish")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PublishRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PublishResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.Publish(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublishResponse and nil error while calling Publish. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) servePublishProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Publish")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PublishRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PublishResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.Publish(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PublishResponse and nil error while calling Publish. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveGetClients(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetClientsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetClientsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchE2IngestHTTPServer) serveGetClientsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetClients")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetClientsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetClientsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.GetClients(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetClientsResponse and nil error while calling GetClients. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveGetClientsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetClients")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetClientsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetClientsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.GetClients(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetClientsResponse and nil error while calling GetClients. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveCreateAllowlistEntry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateAllowlistEntryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateAllowlistEntryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchE2IngestHTTPServer) serveCreateAllowlistEntryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAllowlistEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateAllowlistEntryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateAllowlistEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.CreateAllowlistEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAllowlistEntryResponse and nil error while calling CreateAllowlistEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveCreateAllowlistEntryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateAllowlistEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateAllowlistEntryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateAllowlistEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.CreateAllowlistEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateAllowlistEntryResponse and nil error while calling CreateAllowlistEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveUpdateAllowlistEntry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateAllowlistEntryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateAllowlistEntryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchE2IngestHTTPServer) serveUpdateAllowlistEntryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAllowlistEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateAllowlistEntryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateAllowlistEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.UpdateAllowlistEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAllowlistEntryResponse and nil error while calling UpdateAllowlistEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveUpdateAllowlistEntryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAllowlistEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateAllowlistEntryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateAllowlistEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.UpdateAllowlistEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAllowlistEntryResponse and nil error while calling UpdateAllowlistEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveDeleteAllowlistEntry(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteAllowlistEntryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteAllowlistEntryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchE2IngestHTTPServer) serveDeleteAllowlistEntryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllowlistEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteAllowlistEntryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteAllowlistEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.DeleteAllowlistEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAllowlistEntryResponse and nil error while calling DeleteAllowlistEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveDeleteAllowlistEntryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllowlistEntry")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteAllowlistEntryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteAllowlistEntryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.DeleteAllowlistEntry(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAllowlistEntryResponse and nil error while calling DeleteAllowlistEntry. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveListEntriesByOrg(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEntriesByOrgJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEntriesByOrgProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchE2IngestHTTPServer) serveListEntriesByOrgJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntriesByOrg")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEntriesByOrgRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntriesByOrgResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.ListEntriesByOrg(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntriesByOrgResponse and nil error while calling ListEntriesByOrg. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveListEntriesByOrgProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntriesByOrg")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEntriesByOrgRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntriesByOrgResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.ListEntriesByOrg(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntriesByOrgResponse and nil error while calling ListEntriesByOrg. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveListEntries(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListEntriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListEntriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchE2IngestHTTPServer) serveListEntriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListEntriesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.ListEntries(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntriesResponse and nil error while calling ListEntries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveListEntriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListEntries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListEntriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListEntriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.ListEntries(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListEntriesResponse and nil error while calling ListEntries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveListPages(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListPagesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListPagesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchE2IngestHTTPServer) serveListPagesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPages")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListPagesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPagesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.ListPages(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPagesResponse and nil error while calling ListPages. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) serveListPagesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPages")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListPagesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPagesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchE2IngestHTTP.ListPages(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPagesResponse and nil error while calling ListPages. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchE2IngestHTTPServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchE2IngestHTTPServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchE2IngestHTTPServer) PathPrefix() string {
	return TwitchE2IngestHTTPPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1163 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0x4d, 0x73, 0xdb, 0x44,
	0x18, 0x46, 0x76, 0xfc, 0xa1, 0x37, 0xd4, 0x75, 0x96, 0x0e, 0x15, 0x76, 0x80, 0x8c, 0x0e, 0x10,
	0x38, 0x28, 0xad, 0x7b, 0xa1, 0xa4, 0x9d, 0xc1, 0x89, 0xd3, 0xe0, 0x7e, 0x38, 0x46, 0x76, 0x80,
	0xe1, 0x62, 0xd6, 0xd6, 0xc6, 0x11, 0x23, 0xaf, 0x8c, 0x76, 0xdd, 0x90, 0x1c, 0x38, 0x75, 0x06,
	0x86, 0x3b, 0x33, 0xf0, 0x03, 0xf8, 0x0d, 0xdc, 0xb8, 0xc1, 0x3f, 0xe0, 0xca, 0x6f, 0x61, 0xf6,
	0x43, 0x8e, 0xec, 0x98, 0xd4, 0x76, 0xd2, 0x0b, 0x97, 0x8c, 0xf6, 0xdd, 0xdd, 0x67, 0x9f, 0xf7,
	0x79, 0xa5, 0x7d, 0x1f, 0x07, 0x1e, 0xf6, 0x42, 0x8f, 0x38, 0xdf, 0x8c, 0x18, 0xf7, 0xa9, 0xc3,
	0x9f, 0x6f, 0xe1, 0xc1, 0x19, 0xdd, 0x6a, 0x9f, 0xf8, 0xbc, 0x77, 0xbc, 0x57, 0xa9, 0xd3, 0x3e,
	0x61, 0xfc, 0xd3, 0x76, 0xbb, 0xf9, 0x14, 0x0f, 0xba, 0x1e, 0x6e, 0x9f, 0xf8, 0xd1, 0x70, 0x8b,
	0x8b, 0xbf, 0xce, 0x30, 0x0a, 0x79, 0x88, 0x36, 0xb9, 0x5c, 0xea, 0x1c, 0x8d, 0x02, 0x1e, 0x52,
	0x87, 0x7c, 0x87, 0x07, 0xc3, 0x80, 0x38, 0x2a, 0x4a, 0x2a, 0xbe, 0x04, 0x38, 0xe6, 0x7c, 0x58,
	0x7a, 0xb7, 0x1f, 0x86, 0xfd, 0x80, 0x6c, 0xc9, 0x7d, 0xdd, 0xd1, 0xd1, 0x16, 0xf7, 0x07, 0x84,
	0x71, 0x3c, 0xd0, 0x50, 0xf6, 0x3f, 0x06, 0x14, 0x9a, 0xa3, 0x6e, 0xe0, 0xb3, 0x63, 0x97, 0x7c,
	0x3b, 0x22, 0x8c, 0xa3, 0xf7, 0xa0, 0xd0, 0x8d, 0x42, 0xec, 0xf5, 0x30, 0xe3, 0x24, 0xaa, 0xd7,
	0x98, 0x65, 0x6c, 0xa4, 0x37, 0x4d, 0x77, 0x2a, 0x8a, 0x4a, 0x90, 0xef, 0x05, 0x3e, 0xa1, 0xbc,
	0x5e, 0xb3, 0x52, 0x1b, 0xc6, 0xa6, 0xe9, 0x8e, 0xc7, 0x08, 0xc1, 0x8a, 0x87, 0x39, 0xb6, 0xd2,
	0x32, 0x2e, 0x9f, 0xd1, 0x2d, 0xc8, 0x78, 0xa4, 0x3b, 0xea, 0x5b, 0x2b, 0x1b, 0xc6, 0x66, 0xde,
	0x55, 0x03, 0x54, 0x84, 0x34, 0xa1, 0xcf, 0xad, 0x8c, 0x5c, 0x28, 0x1e, 0xd1, 0x9b, 0x90, 0xed,
	0xe3, 0x01, 0xa9, 0xd7, 0xac, 0xac, 0x0c, 0xea, 0x11, 0x5a, 0x07, 0x93, 0x11, 0xc6, 0xfc, 0x90,
	0xd6, 0x6b, 0x56, 0x4e, 0x4e, 0x9d, 0x07, 0xc4, 0xae, 0x11, 0x13, 0xc4, 0xac, 0xbc, 0xda, 0xa5,
	0x46, 0xf6, 0x1a, 0xdc, 0x1c, 0xe7, 0xc7, 0x86, 0x21, 0x65, 0xc4, 0xa6, 0xb0, 0xb6, 0x4f, 0xf8,
	0xae, 0xe4, 0xca, 0xe2, 0xac, 0x6f, 0x43, 0x4e, 0x9c, 0xd3, 0xf1, 0x3d, 0xcb, 0x48, 0x1c, 0xeb,
	0x89, 0x09, 0x01, 0x25, 0x26, 0x52, 0x09, 0x64, 0x0f, 0xbd, 0x0f, 0x37, 0xc3, 0xa8, 0x8f, 0xa9,
	0x7f, 0x86, 0xb9, 0x1f, 0x52, 0xb1, 0x40, 0xa5, 0x5b, 0x48, 0x86, 0xeb, 0x9e, 0xfd, 0x35, 0xa0,
	0xe4, 0x79, 0x8a, 0x05, 0x7a, 0x0c, 0x39, 0x25, 0x97, 0xd2, 0x77, 0xb5, 0x72, 0xc7, 0x99, 0xb7,
	0xac, 0x8e, 0xc2, 0x72, 0x63, 0x00, 0xfb, 0xf7, 0x14, 0x94, 0x77, 0x23, 0x82, 0x39, 0xa9, 0x06,
	0x41, 0x78, 0x12, 0xf8, 0x8c, 0xef, 0x51, 0x1e, 0x9d, 0xbe, 0x34, 0xb9, 0x32, 0x98, 0x0a, 0xe3,
	0x3c, 0xbd, 0xb8, 0x88, 0xf3, 0x27, 0x88, 0x9e, 0x40, 0x6e, 0x18, 0x85, 0xde, 0xa8, 0xc7, 0x65,
	0x6d, 0x0b, 0x95, 0xbb, 0xf3, 0xa7, 0xd2, 0x54, 0x1b, 0xdd, 0x18, 0x01, 0xbd, 0x0d, 0xd0, 0x93,
	0xa9, 0x78, 0x9d, 0xee, 0xa9, 0x7e, 0x2f, 0x4c, 0x1d, 0xd9, 0x39, 0x45, 0xcf, 0x20, 0xaf, 0x57,
	0x32, 0x2b, 0xbb, 0x91, 0x5e, 0xee, 0xb0, 0x31, 0x84, 0x4d, 0x61, 0x7d, 0xb6, 0x70, 0xba, 0x4a,
	0x0d, 0xc8, 0x10, 0x11, 0x90, 0xba, 0xad, 0x56, 0x3e, 0x9a, 0xff, 0xac, 0x29, 0x40, 0x05, 0x63,
	0xff, 0x92, 0x82, 0xf2, 0xe1, 0xd0, 0xfb, 0x5f, 0x54, 0x2a, 0x59, 0x8a, 0xcc, 0xb5, 0x94, 0x62,
	0xb6, 0x32, 0xaf, 0xa8, 0x14, 0x2d, 0x28, 0xd7, 0x48, 0x40, 0xae, 0xb5, 0x12, 0xf6, 0x3b, 0xb0,
	0x3e, 0x1b, 0x54, 0xdf, 0x3d, 0x3b, 0x70, 0xfb, 0xa9, 0x0e, 0xfa, 0x84, 0xed, 0x9c, 0x1e, 0x44,
	0xfd, 0xf8, 0xc0, 0x19, 0x45, 0x34, 0x66, 0xde, 0x27, 0x14, 0xac, 0x8b, 0x18, 0x5a, 0x24, 0x17,
	0x72, 0x44, 0xc5, 0xf5, 0xad, 0xb2, 0xbc, 0x4c, 0x31, 0x90, 0xfd, 0xa7, 0x01, 0x6b, 0x89, 0x03,
	0x1f, 0xf9, 0x01, 0x27, 0x11, 0x7a, 0x0b, 0xf2, 0x5a, 0x9f, 0xb8, 0x41, 0xe4, 0x94, 0x40, 0x4c,
	0x7e, 0xc2, 0xb1, 0x42, 0xcc, 0x4a, 0xc9, 0x49, 0x33, 0x96, 0x88, 0xa1, 0x0f, 0xa0, 0x38, 0x95,
	0x28, 0xb3, 0xd2, 0x72, 0xd1, 0xcd, 0xc9, 0x4c, 0xd9, 0xb5, 0xbe, 0xaf, 0xf6, 0xcf, 0x06, 0xa0,
	0x44, 0x1e, 0xb1, 0xee, 0xb7, 0x20, 0x73, 0xe4, 0x47, 0x8c, 0x4b, 0xb5, 0x33, 0xae, 0x1a, 0x88,
	0x28, 0x3e, 0xe2, 0x24, 0xd2, 0x15, 0x56, 0x03, 0xd4, 0x82, 0xec, 0x91, 0x4c, 0x5f, 0x7e, 0x5f,
	0xab, 0x95, 0xed, 0xf9, 0xe9, 0x5c, 0x50, 0xd0, 0xd5, 0x50, 0xf6, 0x8f, 0x06, 0xbc, 0x31, 0xc1,
	0xeb, 0xd5, 0xd5, 0x52, 0x94, 0x86, 0x50, 0xaf, 0xd3, 0x1b, 0x45, 0x2c, 0x8c, 0x73, 0x33, 0x09,
	0xf5, 0x76, 0x65, 0xc0, 0x7e, 0x61, 0x40, 0x51, 0x50, 0x69, 0xe2, 0xfe, 0xb9, 0x40, 0x65, 0x30,
	0x87, 0xb8, 0x4f, 0x3a, 0xcc, 0x3f, 0x23, 0x5a, 0xa4, 0xbc, 0x08, 0xb4, 0xfc, 0x33, 0x92, 0x50,
	0x24, 0x75, 0x7d, 0x8a, 0xfc, 0xa1, 0xdf, 0x38, 0x4d, 0x43, 0xeb, 0xf1, 0x39, 0x64, 0xc4, 0xb1,
	0xb1, 0x1a, 0x9f, 0x2c, 0x76, 0xd2, 0x04, 0x96, 0x23, 0x46, 0xae, 0x82, 0x13, 0xa5, 0xe6, 0x21,
	0xc7, 0x81, 0xcc, 0x20, 0xed, 0xaa, 0x41, 0x69, 0x1b, 0x56, 0xc4, 0xa2, 0x29, 0xc5, 0x8c, 0x29,
	0xc5, 0xc4, 0xe6, 0x5e, 0x38, 0xa2, 0x3c, 0xde, 0x2c, 0x07, 0x76, 0x0b, 0xb2, 0xaa, 0x47, 0xa3,
	0x02, 0xa4, 0xc6, 0x1f, 0x72, 0xca, 0xf7, 0xd0, 0xfd, 0xf3, 0xf6, 0x86, 0xb9, 0xd6, 0xac, 0xe4,
	0x28, 0x9b, 0xe6, 0xc4, 0x36, 0xcd, 0x69, 0xc7, 0x36, 0x6d, 0xdc, 0xfa, 0xaa, 0xdc, 0xbe, 0x03,
	0xf9, 0x16, 0x65, 0xed, 0x70, 0xe8, 0xf7, 0x84, 0x6d, 0xc2, 0x11, 0xd5, 0xb8, 0xe2, 0x51, 0x58,
	0x2e, 0x8a, 0x07, 0x44, 0xd7, 0x54, 0x3e, 0xdb, 0x7f, 0xa7, 0xa1, 0x30, 0xf9, 0x26, 0x2c, 0xd9,
	0x60, 0x26, 0x59, 0xa7, 0x17, 0x60, 0x8d, 0x3e, 0x03, 0x60, 0x94, 0x75, 0xb8, 0xa0, 0xcd, 0xac,
	0x15, 0x59, 0xba, 0xca, 0xfc, 0xa5, 0x8b, 0x33, 0x76, 0x4d, 0xa6, 0x9f, 0xd8, 0xac, 0x9b, 0x32,
	0xf3, 0xb2, 0x76, 0x97, 0xbd, 0x66, 0x63, 0x92, 0x9b, 0x36, 0x26, 0x65, 0x30, 0xa5, 0xb0, 0xb2,
	0x08, 0xca, 0x83, 0xca, 0x0b, 0xb2, 0x81, 0x07, 0x64, 0xa2, 0x55, 0x9a, 0x57, 0x6e, 0x95, 0x1f,
	0x3e, 0x86, 0x9c, 0x0e, 0xa2, 0x55, 0xc8, 0x1d, 0x36, 0x9e, 0x34, 0x0e, 0xbe, 0x68, 0x14, 0x5f,
	0x43, 0x6b, 0x70, 0xa3, 0xe6, 0x1e, 0x34, 0x3b, 0xbb, 0xd5, 0x67, 0xcd, 0x6a, 0x7d, 0xbf, 0x51,
	0x34, 0x50, 0x11, 0x5e, 0xaf, 0x1e, 0xb6, 0x0f, 0x3a, 0xed, 0xea, 0xfe, 0x7e, 0xbd, 0xb1, 0x5f,
	0x4c, 0xa1, 0x1b, 0x60, 0xee, 0x7d, 0xd9, 0xde, 0x6b, 0xb4, 0xea, 0x07, 0x8d, 0x62, 0xba, 0xf2,
	0x97, 0x09, 0xe8, 0xe2, 0x4f, 0x0f, 0xf4, 0x3d, 0xe4, 0xb4, 0x6f, 0x46, 0x0b, 0x5c, 0x3b, 0x93,
	0x3f, 0x25, 0x4a, 0xf7, 0x97, 0xd8, 0xa9, 0x3f, 0xf6, 0x1f, 0x0c, 0x80, 0x73, 0xd7, 0x8c, 0x16,
	0xb8, 0x56, 0x2e, 0x78, 0xfb, 0xd2, 0x83, 0xe5, 0x36, 0x6b, 0x26, 0xbf, 0x19, 0x70, 0x6b, 0x96,
	0x47, 0x44, 0x7b, 0x0b, 0x18, 0xf6, 0xff, 0x36, 0xe7, 0xa5, 0x47, 0x57, 0x85, 0x49, 0xf0, 0x9c,
	0x65, 0xa0, 0x16, 0xe1, 0x79, 0x89, 0x35, 0x5d, 0x84, 0xe7, 0xa5, 0x3e, 0x4e, 0xf0, 0x9c, 0xe5,
	0x91, 0x16, 0xe1, 0x79, 0x89, 0x71, 0x5b, 0x84, 0xe7, 0x65, 0x56, 0x0d, 0xfd, 0xaa, 0x7b, 0x61,
	0xd2, 0x67, 0xa1, 0xea, 0x52, 0xed, 0x2d, 0xe9, 0xf3, 0x4a, 0x3b, 0x57, 0x81, 0xd0, 0xdc, 0x7e,
	0x32, 0x60, 0x35, 0x31, 0x89, 0x1e, 0x2c, 0x85, 0x19, 0x33, 0x7a, 0xb8, 0xe4, 0x6e, 0x4d, 0xe6,
	0x85, 0x01, 0xe6, 0xb8, 0xc3, 0xa2, 0x8f, 0x97, 0x6a, 0xcb, 0x8a, 0xc8, 0xf6, 0x15, 0x5a, 0xfa,
	0xce, 0xbd, 0xaf, 0xee, 0x2e, 0xfc, 0x6f, 0x95, 0x6e, 0x56, 0x36, 0xaf, 0x7b, 0xff, 0x06, 0x00,
	0x00, 0xff, 0xff, 0x58, 0xb1, 0x5e, 0x0d, 0x92, 0x11, 0x00, 0x00,
}
