package main

import (
	"context"
	"testing"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
	serviceapi "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	uuid "github.com/satori/go.uuid"
	"github.com/stretchr/testify/assert"
)

func TestIntegrationAddVerificationRequest(t *testing.T) {
	ctx := context.Background()
	client := protoClient(t)

	out, err := client.AddVerificationRequest(ctx, &serviceapi.AddVerificationRequestInput{
		Namespace:         namespace,
		Key:               uuid.NewV4().String(),
		Email:             email,
		Locale:            "en",
		Purpose:           "purpose",
		ShouldIncludeCode: false,
	})
	assert.NoError(t, err)
	assert.Equal(t, models.StatusPendingString, out.VerificationRequest.Status)
	assert.Len(t, out.VerificationRequest.VerificationCode, 0)

	getOut, err := client.GetVerificationRequest(ctx, &serviceapi.GetVerificationRequestInput{
		Namespace: out.VerificationRequest.Namespace,
		Key:       out.VerificationRequest.Key,
		Email:     out.VerificationRequest.Email,
	})
	assert.NoError(t, err)
	assert.Equal(t, out.VerificationRequest, getOut.VerificationRequest)

	opaqueOut, err := client.GetVerificationRequestByOpaqueID(ctx, &serviceapi.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: out.VerificationRequest.OpaqueID,
	})
	assert.NoError(t, err)
	assert.Equal(t, out.VerificationRequest, opaqueOut.VerificationRequest)
}
