package main

import (
	"context"
	"testing"

	serviceapi "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	uuid "github.com/satori/go.uuid"
	"github.com/stretchr/testify/require"
	"github.com/twitchtv/twirp"
)

func TestIntegrationDeleteVerificationRequestsByKey(t *testing.T) {
	ctx := context.Background()
	client := protoClient(t)

	existsKey := uuid.NewV4().String()
	deletedKey := uuid.NewV4().String()

	createRequestWithKey(t, existsKey)
	createRequestWithKey(t, deletedKey)
	createRequestWithKey(t, deletedKey)

	var err error

	_, err = client.DeleteVerificationRequestsByKey(ctx,
		&serviceapi.DeleteVerificationRequestsByKeyInput{
			Key: deletedKey,
		},
	)
	require.NoError(t, err)

	_, err = client.GetVerificationRequest(ctx,
		&serviceapi.GetVerificationRequestInput{
			Namespace: namespace,
			Key:       existsKey,
			Email:     email,
		},
	)
	require.NoError(t, err)

	_, err = client.GetVerificationRequest(ctx,
		&serviceapi.GetVerificationRequestInput{
			Namespace: namespace,
			Key:       deletedKey,
			Email:     email,
		},
	)
	requireTwirpErr(t, err, twirp.NotFound)

	_, err = client.DeleteVerificationRequestsByKey(ctx,
		&serviceapi.DeleteVerificationRequestsByKeyInput{
			Key: deletedKey,
		},
	)
	require.NoError(t, err)
}
