package main

import (
	"context"
	"testing"

	serviceapi "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	uuid "github.com/satori/go.uuid"
	"github.com/stretchr/testify/require"
)

func TestIntegrationListVerificationRequestsByKey(t *testing.T) {
	ctx := context.Background()
	client := protoClient(t)

	k1 := uuid.NewV4().String()
	k2 := uuid.NewV4().String()

	createRequestWithNamespaceAndKey(t, uuid.NewV4().String(), k1)
	createRequestWithNamespaceAndKey(t, uuid.NewV4().String(), k1)
	createRequestWithKey(t, k2)

	out, err := client.ListVerificationRequestsByKey(ctx,
		&serviceapi.ListVerificationRequestsByKeyInput{
			Key: k1,
		},
	)
	require.NoError(t, err)
	require.Len(t, out.VerificationRequests, 2)
}
