package main

import (
	"context"
	"testing"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"

	serviceapi "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	uuid "github.com/satori/go.uuid"
	"github.com/stretchr/testify/require"
	"github.com/twitchtv/twirp"
)

func TestIntegrationRejectCode(t *testing.T) {
	ctx := context.Background()
	client := protoClient(t)

	key := uuid.NewV4().String()
	n1 := uuid.NewV4().String()
	n2 := uuid.NewV4().String()
	n3 := uuid.NewV4().String()

	r1 := createRequestWithNamespaceAndKey(t, n1, key)
	r2 := createRequestWithNamespaceAndKey(t, n2, key)
	r3 := createRequestWithNamespaceAndKey(t, n3, key)

	_, err := client.Reject(ctx, &serviceapi.RejectInput{
		Email: email,
	})
	require.NoError(t, err)

	// All verification statuses should be rejected
	opaqueOut1, err := client.GetVerificationRequestByOpaqueID(ctx, &serviceapi.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: r1.OpaqueID,
	})
	require.NoError(t, err)
	require.Equal(t, models.StatusRejectedString, opaqueOut1.VerificationRequest.Status)

	opaqueOut2, err := client.GetVerificationRequestByOpaqueID(ctx, &serviceapi.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: r2.OpaqueID,
	})
	require.NoError(t, err)
	require.Equal(t, models.StatusRejectedString, opaqueOut2.VerificationRequest.Status)

	opaqueOut3, err := client.GetVerificationRequestByOpaqueID(ctx, &serviceapi.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: r3.OpaqueID,
	})
	require.NoError(t, err)
	require.Equal(t, models.StatusRejectedString, opaqueOut3.VerificationRequest.Status)

	_, err = client.RegenerateCode(ctx, &serviceapi.RegenerateCodeInput{
		Namespace: n1,
		Key:       key,
		Email:     email,
	})
	requireTwirpErr(t, err, twirp.FailedPrecondition)
}
