package main

import (
	"context"
	"testing"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
	serviceapi "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	uuid "github.com/satori/go.uuid"
	"github.com/stretchr/testify/require"
	"github.com/twitchtv/twirp"
)

func TestIntegrationUnrejectCode(t *testing.T) {
	ctx := context.Background()
	client := protoClient(t)

	key := uuid.NewV4().String()
	n1 := uuid.NewV4().String()
	n2 := uuid.NewV4().String()

	r1 := createRequestWithNamespaceAndKey(t, n1, key)
	r2 := createRequestWithNamespaceAndKey(t, n2, key)

	var err error

	_, err = client.Reject(ctx, &serviceapi.RejectInput{
		Email: email,
	})
	require.NoError(t, err)

	_, err = client.Unreject(ctx, &serviceapi.UnrejectInput{
		Namespace: n1,
		Key:       key,
		Email:     email,
	})
	require.NoError(t, err)

	// only the unrejected request is pending
	opaqueOut1, err := client.GetVerificationRequestByOpaqueID(ctx, &serviceapi.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: r1.OpaqueID,
	})
	require.NoError(t, err)
	require.Equal(t, models.StatusPendingString, opaqueOut1.VerificationRequest.Status)

	opaqueOut2, err := client.GetVerificationRequestByOpaqueID(ctx, &serviceapi.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: r2.OpaqueID,
	})
	require.NoError(t, err)
	require.Equal(t, models.StatusRejectedString, opaqueOut2.VerificationRequest.Status)

	// Cannot unreject a pending request

	_, err = client.Unreject(ctx, &serviceapi.UnrejectInput{
		Namespace: n1,
		Key:       key,
		Email:     email,
	})
	requireTwirpErr(t, err, twirp.FailedPrecondition)
}
