package main

import (
	"context"
	"testing"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
	serviceapi "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	uuid "github.com/satori/go.uuid"
	"github.com/stretchr/testify/require"
	"github.com/twitchtv/twirp"
)

func TestIntegrationVerify(t *testing.T) {
	ctx := context.Background()
	client := protoClient(t)

	namespace := uuid.NewV4().String()
	key := uuid.NewV4().String()

	req := createRequestWithNamespaceAndKey(t, namespace, key)

	verifyOut, err := client.Verify(ctx, &serviceapi.VerifyInput{
		OpaqueId: req.OpaqueID,
	})
	require.NoError(t, err)
	require.Equal(t, req.Namespace, verifyOut.VerificationRequest.Namespace)
	require.Equal(t, req.Email, verifyOut.VerificationRequest.Email)
	require.Equal(t, req.Key, verifyOut.VerificationRequest.Key)

	opaqueOut1, err := client.GetVerificationRequestByOpaqueID(ctx, &serviceapi.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: req.OpaqueID,
	})
	require.NoError(t, err)
	require.Equal(t, models.StatusVerifiedString, opaqueOut1.VerificationRequest.Status)

	_, err = client.AddVerificationRequest(ctx,
		&serviceapi.AddVerificationRequestInput{
			Namespace:         namespace,
			Key:               key,
			Email:             email,
			Locale:            "en",
			Purpose:           "purpose",
			ShouldIncludeCode: true,
		},
	)
	requireTwirpErr(t, err, twirp.AlreadyExists)
}

func TestIntegrationVerifyNotFound(t *testing.T) {

	ctx := context.Background()
	client := protoClient(t)

	_, err := client.Verify(ctx, &serviceapi.VerifyInput{
		OpaqueId: uuid.NewV4().String(),
	})
	requireTwirpErr(t, err, twirp.NotFound)
}
