#!/bin/bash
set -x
NEEDS_REBOOT="false"
GRUB_PATH=/boot/grub/grub.conf
if [ -e /etc/default/grub] ; then
  GRUB_PATH=/etc/default/grub
fi
# Update clock source to tsc if possible
CLOCKSOURCE_PATH=/sys/devices/system/clocksource/clocksource0
CURRENT_CLOCKSOURCE=`cat ${CLOCKSOURCE_PATH}/current_clocksource`
if [ "${CURRENT_CLOCKSOURCE}" != 'tsc' ] ; then
  grep tsc ${CLOCKSOURCE_PATH}/available_clocksource > /dev/null
  if [ $? -eq 0 ] ; then
    echo "Updating current clocksource from ${CURRENT_CLOCKSOURCE} to tsc"
    echo tsc > ${CLOCKSOURCE_PATH}/current_clocksource
    sed -e 's/^\(kernel.*\)/\1 xen_nopvspin=1 clocksource=tsc/' -i ${GRUB_PATH}
    if [ "${GRUB_PATH}" = "/etc/default/grub" ] ; then
      grub2-mkconfig -o /boot/grub2/grub.cfg
    fi
  fi
fi
echo 'Clock Source: ' `cat ${CLOCKSOURCE_PATH}/current_clocksource`
# Limit deeper idle CPU states to reduce latency
grep max_cstate ${GRUB_PATH} > /dev/null
if [ $? -eq 0 ] ; then
  echo 'Limited sleep states: true'
else
  echo 'Enabling limited sleep states for kernel'
  sed -e 's/^\(kernel.*\)/\1 intel_idle.max_cstate=1/' -i ${GRUB_PATH}
  if [ "${GRUB_PATH}" = "/etc/default/grub" ] ; then
    grub2-mkconfig -o /boot/grub2/grub.cfg
  fi
  NEEDS_REBOOT="true"
fi
# Verify enhanced networking is enabled
ethtool -i eth0 | grep -E "driver: (ixgbevf|ena)$" > /dev/null
if [ $? -eq 0 ] ; then
  echo 'Enhanced Networking: true'
else
  echo 'Enhanced Networking: false'
fi
# Set reboot file to enable final rebooting if needed
if [ "${NEEDS_REBOOT}" = "true" ] ; then
  touch /etc/reboot-needed
fi
