package models_test

import (
	"bytes"
	"testing"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
	"github.com/stretchr/testify/assert"
)

func TestMakeOpaqueID(t *testing.T) {
	opaqueID1, err := models.MakeOpaqueID()
	assert.NoError(t, err)
	assert.Len(t, opaqueID1, models.OpaqueIDLength)
	assert.True(t, charsAreValid(opaqueID1, models.ValidOpaqueIDChars))

	opaqueID2, err := models.MakeOpaqueID()
	assert.NoError(t, err)
	assert.Len(t, opaqueID2, models.OpaqueIDLength)
	assert.True(t, charsAreValid(opaqueID2, models.ValidOpaqueIDChars))

	assert.NotEqual(t, opaqueID1, opaqueID2)
}

func TestMakeVerificationCode(t *testing.T) {
	code1, err := models.MakeVerificationCode()
	assert.NoError(t, err)
	assert.Len(t, code1, models.VerificationCodeLength)
	assert.True(t, charsAreValid(code1, models.ValidVerificationCodeChars))

	code2, err := models.MakeVerificationCode()
	assert.NoError(t, err)
	assert.Len(t, code2, models.VerificationCodeLength)
	assert.True(t, charsAreValid(code2, models.ValidVerificationCodeChars))

	assert.NotEqual(t, code1, code2)
}

// Helpers
func charsAreValid(out string, validChars []byte) bool {
	for _, b := range []byte(out) {
		if bytes.IndexByte(validChars, b) == -1 {
			return false
		}
	}

	return true
}
