package server

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	"github.com/pkg/errors"

	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/twitchtv/twirp"
)

func (s *TwitchEmailValidatorServiceServer) AddVerificationRequest(ctx context.Context, req *evs.AddVerificationRequestInput) (*evs.AddVerificationRequestOutput, error) {
	if req.GetNamespace() == "" {
		return nil, twirp.RequiredArgumentError("namespace")
	}
	if req.GetEmail() == "" {
		return nil, twirp.RequiredArgumentError("email")
	}
	if req.GetKey() == "" {
		return nil, twirp.RequiredArgumentError("key")
	}
	if req.GetPurpose() == "" {
		return nil, twirp.RequiredArgumentError("purpose")
	}

	request, err := s.Clients.DS.CreateVerificationRequest(ctx, req.GetNamespace(), req.GetKey(), req.GetEmail(), req.GetLocale(), req.GetShouldIncludeCode())
	if err != nil {
		return nil, getTwirpError(err)
	}

	s.publishVerificationRequest(request, req.GetPurpose())

	verificationRequest, err := converter.OutputVerificationRequest(request)
	if err != nil {
		return nil, twirp.InternalErrorWith(errors.Wrap(err, "converting verification request"))
	}

	return &evs.AddVerificationRequestOutput{VerificationRequest: verificationRequest}, nil
}
