package converter

import (
	"fmt"
	"time"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/golang/protobuf/ptypes"
	"github.com/pkg/errors"
)

func OutputVerificationRequest(input *models.VerificationRequest) (*evs.VerificationRequestDocument, error) {
	status, err := OutputVerificationStatus(input.Status)
	if err != nil {
		return nil, errors.Wrap(err, "converting status")
	}

	modifiedAt, err := ptypes.TimestampProto(time.Time(input.Modified))
	if err != nil {
		return nil, errors.Wrap(err, "converting modified time")
	}

	return &evs.VerificationRequestDocument{
		Namespace:        input.Namespace,
		Key:              input.Key,
		Email:            input.Email,
		OpaqueID:         input.OpaqueID,
		Status:           status,
		Modified:         modifiedAt,
		Locale:           input.Locale,
		VerificationCode: input.VerificationCode,
	}, nil
}

func OutputVerificationStatus(input models.VerificationStatus) (string, error) {
	switch input {
	case models.StatusPending:
		return models.StatusPendingString, nil
	case models.StatusVerified:
		return models.StatusVerifiedString, nil
	case models.StatusRejected:
		return models.StatusRejectedString, nil
	}

	return "", errors.New(fmt.Sprintf("unknown status %d", input))
}
