package converter_test

import (
	"testing"
	"time"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
	"github.com/golang/protobuf/ptypes"
	"github.com/stretchr/testify/suite"
)

type ConverterSuite struct {
	suite.Suite
}

func TestConverterSuite(t *testing.T) {
	suite.Run(t, new(ConverterSuite))
}

func (s *ConverterSuite) TestConvertVerificationRequest() {
	req := testutils.NewVerificationRequest()
	out, err := converter.OutputVerificationRequest(req)
	s.Require().NoError(err)

	expectedModifiedAt, err := ptypes.TimestampProto(time.Time(req.Modified))
	s.Require().NoError(err)
	s.Require().Equal(expectedModifiedAt.Seconds, req.Modified.Unix())

	status, err := converter.OutputVerificationStatus(req.Status)
	s.Require().NoError(err)
	s.Require().Equal(status, out.Status)

	s.Require().Equal(req.Namespace, out.Namespace)
	s.Require().Equal(req.Key, out.Key)
	s.Require().Equal(req.Email, out.Email)
	s.Require().Equal(req.OpaqueID, out.OpaqueID)
	s.Require().Equal(req.Locale, out.Locale)
	s.Require().Equal(req.VerificationCode, out.VerificationCode)

}
