package server

import (
	"context"

	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/twitchtv/twirp"
)

func (s *TwitchEmailValidatorServiceServer) DeleteVerificationRequestsByKey(ctx context.Context, input *evs.DeleteVerificationRequestsByKeyInput) (*evs.DeleteVerificationRequestsByKeyOutput, error) {
	if input.GetKey() == "" {
		return nil, twirp.RequiredArgumentError("key")
	}

	err := s.Clients.DS.DeleteVerificationRequestsByKey(ctx, input.GetKey())
	if err != nil {
		return nil, getTwirpError(err)
	}

	return &evs.DeleteVerificationRequestsByKeyOutput{}, nil
}
