package server_test

import (
	"context"
	"errors"

	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func (s *ServerSuite) TestDeleteVerificationRequestsByKeySuccess() {
	key := testutils.RandStr(10)

	s.Mocks.DS.On("DeleteVerificationRequestsByKey", mock.Anything, key).Return(nil).Once()

	_, err := s.service.DeleteVerificationRequestsByKey(context.Background(), &evs.DeleteVerificationRequestsByKeyInput{
		Key: key,
	})
	s.Require().NoError(err)
	s.AssertExpectations()
}

func (s *ServerSuite) TestDeleteVerificationRequestsByKeyInvalid() {
	input := &evs.DeleteVerificationRequestsByKeyInput{}

	_, err := s.service.DeleteVerificationRequestsByKey(context.Background(), input)
	s.Require().Error(err)
	s.AssertExpectations()

	twerr := err.(twirp.Error)
	s.Require().Equal(twirp.InvalidArgument, twerr.Code())
}

func (s *ServerSuite) TestDeleteVerificationRequestsByKeyDeleteError() {
	key := testutils.RandStr(10)

	s.Mocks.DS.On("DeleteVerificationRequestsByKey", mock.Anything, key).Return(errors.New("can't sorry")).Once()

	_, err := s.service.DeleteVerificationRequestsByKey(context.Background(), &evs.DeleteVerificationRequestsByKeyInput{
		Key: key,
	})

	s.Require().Error(err)
	s.AssertExpectations()
}
