package server

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/twitchtv/twirp"
)

func (s *TwitchEmailValidatorServiceServer) GetVerificationRequestByOpaqueID(ctx context.Context, req *evs.GetVerificationRequestByOpaqueIDInput) (*evs.GetVerificationRequestByOpaqueIDOutput, error) {
	if req.GetOpaqueId() == "" {
		return nil, twirp.RequiredArgumentError("opaque_id")
	}

	request, err := s.Clients.DS.VerificationRequestByOpaqueID(ctx, req.GetOpaqueId())
	if err != nil {
		return nil, getTwirpError(err)
	}

	verificationRequest, err := converter.OutputVerificationRequest(request)
	if err != nil {
		return nil, twirp.InternalErrorWith(errors.Wrap(err, "converting verification request"))
	}

	return &evs.GetVerificationRequestByOpaqueIDOutput{VerificationRequest: verificationRequest}, nil
}
