package server_test

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func (s *ServerSuite) TestGetVerificationRequestByOpaqueIDSuccess() {
	opaqueID := testutils.RandStr(10)

	req := testutils.NewVerificationRequest()

	expectedVerificationRequest, err := converter.OutputVerificationRequest(req)
	s.Require().NoError(err)

	s.Mocks.DS.On("VerificationRequestByOpaqueID", mock.Anything, opaqueID).Return(req, nil).Once()
	out, err := s.service.GetVerificationRequestByOpaqueID(context.Background(), &evs.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: opaqueID,
	})
	s.Require().NoError(err)
	s.Require().Equal(expectedVerificationRequest, out.VerificationRequest)
	s.AssertExpectations()
}

func (s *ServerSuite) TestGetVerificationRequestByOpaqueIDInvalid() {
	_, err := s.service.GetVerificationRequestByOpaqueID(context.Background(), &evs.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: "",
	})
	s.Require().Error(err)
	s.AssertExpectations()

	twerr := err.(twirp.Error)
	s.Require().Equal(twirp.InvalidArgument, twerr.Code())
}

func (s *ServerSuite) TestGetVerifcationRequestByOpaqueIDError() {
	opaqueID := testutils.RandStr(10)
	s.Mocks.DS.On("VerificationRequestByOpaqueID", mock.Anything, opaqueID).Return(nil, errors.New("o no")).Once()

	_, err := s.service.GetVerificationRequestByOpaqueID(context.Background(), &evs.GetVerificationRequestByOpaqueIDInput{
		OpaqueId: opaqueID,
	})
	s.Require().Error(err)
}
