package server

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/twitchtv/twirp"
)

func (s *TwitchEmailValidatorServiceServer) GetVerificationRequest(ctx context.Context, req *evs.GetVerificationRequestInput) (*evs.GetVerificationRequestOutput, error) {
	if req.GetNamespace() == "" {
		return nil, twirp.RequiredArgumentError("namespace")
	}
	if req.GetEmail() == "" {
		return nil, twirp.RequiredArgumentError("email")
	}
	if req.GetKey() == "" {
		return nil, twirp.RequiredArgumentError("key")
	}

	request, err := s.Clients.DS.VerificationRequest(ctx, req.GetNamespace(), req.GetKey(), req.GetEmail())
	if err != nil {
		return nil, getTwirpError(err)
	}

	verificationRequest, err := converter.OutputVerificationRequest(request)
	if err != nil {
		return nil, twirp.InternalErrorWith(errors.Wrap(err, "converting verification request"))
	}

	return &evs.GetVerificationRequestOutput{VerificationRequest: verificationRequest}, nil
}
