package server_test

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func (s *ServerSuite) TestGetVerificationRequestSuccess() {
	namespace := testutils.RandStr(10)
	key := testutils.RandStr(10)
	email := testutils.RandStr(10)
	req := testutils.NewVerificationRequest()

	expectedVerificationRequest, err := converter.OutputVerificationRequest(req)
	s.Require().NoError(err)

	s.Mocks.DS.On("VerificationRequest", mock.Anything, namespace, key, email).Return(req, nil).Once()
	out, err := s.service.GetVerificationRequest(context.Background(), &evs.GetVerificationRequestInput{
		Namespace: namespace,
		Key:       key,
		Email:     email,
	})
	s.Require().NoError(err)
	s.Require().Equal(expectedVerificationRequest, out.VerificationRequest)
	s.AssertExpectations()
}

func (s *ServerSuite) TestGetVerificationRequestInvalid() {
	tests := []struct {
		mut func(input *evs.GetVerificationRequestInput)
	}{
		{func(input *evs.GetVerificationRequestInput) {
			input.Namespace = ""
		}},
		{func(input *evs.GetVerificationRequestInput) {
			input.Key = ""
		}},
		{func(input *evs.GetVerificationRequestInput) {
			input.Email = ""
		}},
	}

	for _, tt := range tests {
		input := &evs.GetVerificationRequestInput{
			Namespace: testutils.RandStr(10),
			Key:       testutils.RandStr(10),
			Email:     testutils.RandStr(10),
		}
		tt.mut(input)

		_, err := s.service.GetVerificationRequest(context.Background(), input)
		s.Require().Error(err)
		s.AssertExpectations()

		twerr := err.(twirp.Error)
		s.Require().Equal(twirp.InvalidArgument, twerr.Code())
	}
}

func (s *ServerSuite) TestGetVerifcationRequestError() {
	namespace := testutils.RandStr(10)
	key := testutils.RandStr(10)
	email := testutils.RandStr(10)
	s.Mocks.DS.On("VerificationRequest", mock.Anything, namespace, key, email).Return(nil, errors.New("o no")).Once()

	_, err := s.service.GetVerificationRequest(context.Background(), &evs.GetVerificationRequestInput{
		Namespace: namespace,
		Key:       key,
		Email:     email,
	})
	s.Require().Error(err)
}
