package server

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/models"
	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/twitchtv/twirp"
)

func (s *TwitchEmailValidatorServiceServer) ListVerificationRequestsByKey(ctx context.Context, input *evs.ListVerificationRequestsByKeyInput) (*evs.ListVerificationRequestsByKeyOutput, error) {
	if input.GetKey() == "" {
		return nil, twirp.RequiredArgumentError("key")
	}

	listOut, err := s.Clients.DS.ListVerificationRequestsByKey(ctx, input.GetKey(), models.ListVerificationsParams{
		ContinuationToken: input.GetContinuationToken(),
		Limit:             uint(input.GetLimit()),
	})
	if err != nil {
		return nil, getTwirpError(err)
	}

	verificationRequests := make([]*evs.VerificationRequestDocument, 0, len(listOut.VerificationRequests))
	for _, item := range listOut.VerificationRequests {
		verificationRequest, err := converter.OutputVerificationRequest(&item)
		if err != nil {
			return nil, twirp.InternalErrorWith(errors.Wrap(err, "converting verification request"))
		}
		verificationRequests = append(verificationRequests, verificationRequest)
	}

	return &evs.ListVerificationRequestsByKeyOutput{
		VerificationRequests: verificationRequests,
		ContinuationToken:    listOut.ContinuationToken,
	}, nil
}
