package server

import (
	"context"

	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/twitchtv/twirp"
)

func (s *TwitchEmailValidatorServiceServer) NotMe(ctx context.Context, req *evs.NotMeInput) (*evs.NotMeOutput, error) {
	if req.GetOpaqueId() == "" {
		return nil, twirp.RequiredArgumentError("opaque_id")
	}
	if req.GetEmail() == "" {
		return nil, twirp.RequiredArgumentError("email")
	}

	err := s.Clients.DS.NotMe(ctx, req.GetEmail(), req.GetOpaqueId())
	if err != nil {
		return nil, getTwirpError(err)
	}

	return &evs.NotMeOutput{}, nil
}
