package server_test

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func (s *ServerSuite) TestNotMeSuccess() {
	opaqueID := testutils.RandStr(10)
	email := testutils.RandStr(10)

	s.mockNotMeSuccess(email, opaqueID)

	_, err := s.service.NotMe(context.Background(), &evs.NotMeInput{OpaqueId: opaqueID, Email: email})
	s.Require().NoError(err)
	s.AssertExpectations()
}

func (s *ServerSuite) TestNotMeInvalid() {
	tests := []struct {
		mut func(input *evs.NotMeInput)
	}{
		{func(input *evs.NotMeInput) {
			input.OpaqueId = ""
		}},
		{func(input *evs.NotMeInput) {
			input.Email = ""
		}},
	}

	for _, tt := range tests {
		input := &evs.NotMeInput{
			OpaqueId: testutils.RandStr(10),
			Email:    testutils.RandStr(10),
		}
		tt.mut(input)

		_, err := s.service.NotMe(context.Background(), input)
		s.Require().Error(err)
		s.AssertExpectations()

		twerr := err.(twirp.Error)
		s.Require().Equal(twirp.InvalidArgument, twerr.Code())
	}
}

func (s *ServerSuite) TestNotMeError() {
	opaqueID := testutils.RandStr(10)
	email := testutils.RandStr(10)
	s.mockNotMeError(email, opaqueID, errors.New("o no"))

	_, err := s.service.NotMe(context.Background(), &evs.NotMeInput{OpaqueId: opaqueID, Email: email})
	s.Require().Error(err)
}

func (s *ServerSuite) mockNotMeSuccess(email, opaqueID string) {
	s.Mocks.DS.On("NotMe", mock.Anything, email, opaqueID).Return(nil).Once()
}

func (s *ServerSuite) mockNotMeError(email, opaqueID string, err error) {
	s.Mocks.DS.On("NotMe", mock.Anything, email, opaqueID).Return(err).Once()
}
