package server

import (
	"context"

	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/twitchtv/twirp"
)

func (s *TwitchEmailValidatorServiceServer) Reject(ctx context.Context, req *evs.RejectInput) (*evs.RejectOutput, error) {
	if req.GetEmail() == "" {
		return nil, twirp.RequiredArgumentError("email")
	}

	err := s.Clients.DS.Reject(ctx, req.GetEmail())
	if err != nil {
		return nil, getTwirpError(err)
	}

	return &evs.RejectOutput{}, nil
}
