package server_test

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func (s *ServerSuite) TestRejectSuccess() {
	email := testutils.RandStr(10)

	s.Mocks.DS.On("Reject", mock.Anything, email).Return(nil).Once()
	_, err := s.service.Reject(context.Background(), &evs.RejectInput{
		Email: email,
	})
	s.Require().NoError(err)
	s.AssertExpectations()
}

func (s *ServerSuite) TestRejectInvalid() {
	_, err := s.service.Reject(context.Background(), &evs.RejectInput{
		Email: "",
	})
	s.Require().Error(err)
	s.AssertExpectations()

	twerr := err.(twirp.Error)
	s.Require().Equal(twirp.InvalidArgument, twerr.Code())
}

func (s *ServerSuite) TestRejectError() {
	email := testutils.RandStr(10)
	s.Mocks.DS.On("Reject", mock.Anything, email).Return(errors.New("o no")).Once()

	_, err := s.service.Reject(context.Background(), &evs.RejectInput{
		Email: email,
	})
	s.Require().Error(err)
}
