package server_test

import (
	"testing"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"

	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
	"github.com/stretchr/testify/suite"
)

type ServerSuite struct {
	suite.Suite
	*testutils.Mocks
	service *server.TwitchEmailValidatorServiceServer
}

func (s *ServerSuite) SetupTest() {
	mocks := &testutils.Mocks{}
	mocks.Init()
	s.Mocks = mocks

	service, err := server.NewServer(telemetry.SampleReporter{}, testutils.LoggerStub{}, *mocks.Clients())
	s.Require().NoError(err)
	s.service = service
}

func (s *ServerSuite) AssertExpectations() {
	s.Mocks.AssertExpectations(s.T())
}

func TestServerSuite(t *testing.T) {
	suite.Run(t, new(ServerSuite))
}
