package server

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/twitchtv/twirp"
)

func (s *TwitchEmailValidatorServiceServer) Unreject(ctx context.Context, req *evs.UnrejectInput) (*evs.UnrejectOutput, error) {
	if req.GetEmail() == "" {
		return nil, twirp.NewError(twirp.InvalidArgument, "missing required field 'email'")
	}
	if req.GetNamespace() == "" {
		return nil, twirp.NewError(twirp.InvalidArgument, "missing required field 'namespace'")
	}
	if req.GetKey() == "" {
		return nil, twirp.NewError(twirp.InvalidArgument, "missing required field 'key'")
	}

	request, err := s.Clients.DS.Unreject(ctx, req.GetNamespace(), req.GetKey(), req.GetEmail())
	if err != nil {
		return nil, getTwirpError(err)
	}

	verificationRequest, err := converter.OutputVerificationRequest(request)
	if err != nil {
		return nil, twirp.InternalErrorWith(errors.Wrap(err, "converting verification request"))
	}

	return &evs.UnrejectOutput{VerificationRequest: verificationRequest}, nil
}
