package server

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/twitchtv/twirp"
)

func (s *TwitchEmailValidatorServiceServer) Verify(ctx context.Context, req *evs.VerifyInput) (*evs.VerifyOutput, error) {
	if req.GetOpaqueId() == "" {
		return nil, twirp.RequiredArgumentError("namespace")
	}

	request, err := s.Clients.DS.Verify(ctx, req.GetOpaqueId())
	if err != nil {
		return nil, getTwirpError(err)
	}

	verificationRequest, err := converter.OutputVerificationRequest(request)
	if err != nil {
		return nil, twirp.InternalErrorWith(errors.Wrap(err, "converting verification request"))
	}

	s.publishVerificationSuccess(request)

	return &evs.VerifyOutput{VerificationRequest: verificationRequest}, nil
}
