package server_test

import (
	"context"

	"code.justin.tv/amzn/TwitchEmailValidatorService/server/converter"
	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
	evs "code.justin.tv/amzn/TwitchEmailValidatorServiceTwirp"
	"github.com/pkg/errors"
	"github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func (s *ServerSuite) TestVerifySuccess() {
	opaqueID := testutils.RandStr(10)

	req := testutils.NewVerificationRequest()

	expectedVerificationRequest, err := converter.OutputVerificationRequest(req)
	s.Require().NoError(err)

	s.Mocks.DS.On("Verify", mock.Anything, opaqueID).Return(req, nil).Once()
	s.Mocks.SuccessPublisher.On(
		"PublishVerificationSuccess", mock.Anything, req.Namespace, req.Key, req.Email, req.Locale,
	).Return(nil).Once()
	out, err := s.service.Verify(context.Background(), &evs.VerifyInput{
		OpaqueId: opaqueID,
	})
	s.Require().NoError(err)
	s.Require().Equal(expectedVerificationRequest, out.VerificationRequest)
	s.AssertExpectations()
}

func (s *ServerSuite) TestVerifyInvalid() {
	_, err := s.service.Verify(context.Background(), &evs.VerifyInput{
		OpaqueId: "",
	})
	s.Require().Error(err)
	s.AssertExpectations()

	twerr := err.(twirp.Error)
	s.Require().Equal(twirp.InvalidArgument, twerr.Code())
}

func (s *ServerSuite) TestVerifyError() {
	opaqueID := testutils.RandStr(10)
	s.Mocks.DS.On("Verify", mock.Anything, opaqueID).Return(nil, errors.New("o no")).Once()

	_, err := s.service.Verify(context.Background(), &evs.VerifyInput{
		OpaqueId: opaqueID,
	})
	s.Require().Error(err)
}
