package storage_test

import (
	"context"

	datasource "code.justin.tv/amzn/TwitchEmailValidatorService/storage"
	"code.justin.tv/amzn/TwitchEmailValidatorService/testutils"
)

func (s *VerifierSuite) TestDeleteVerificationRequestsByKeySuccess() {
	key := testutils.RandStr(5)
	compoundKeys := testutils.RandStringSlice(5)

	s.MockDynamoDBQueryByKeySuccess(key, compoundKeys)
	s.MockDynamoDBDeleteItemSuccess(len(compoundKeys))

	err := s.Verifier.DeleteVerificationRequestsByKey(context.Background(), key)
	s.Require().NoError(err)

	s.AssertExpectations()
}

func (s *VerifierSuite) TestDeleteVerificationRequestsByKeySuccessNoRecords() {
	key := testutils.RandStr(5)

	s.MockDynamoDBQueryByKeySuccess(key, []string{})

	err := s.Verifier.DeleteVerificationRequestsByKey(context.Background(), key)
	s.Require().NoError(err)

	s.AssertExpectations()
}

func (s *VerifierSuite) TestDeleteVerificationRequestsByKeyNoKeyFail() {
	err := s.Verifier.DeleteVerificationRequestsByKey(context.Background(), "")
	s.Require().Error(err)
	s.isError(datasource.ErrNeedKey, err)

	s.AssertExpectations()
}

func (s *VerifierSuite) TestDeleteVerificationRequestsByKeyQueryErrorFail() {
	key := testutils.RandStr(5)

	s.MockDynamoDBQueryByKeyFail(key)

	err := s.Verifier.DeleteVerificationRequestsByKey(context.Background(), key)
	s.Require().Error(err)
	s.isError(AWSError, err)

	s.AssertExpectations()
}

func (s *VerifierSuite) TestDeleteVerificationRequestsByKeyPartialDeleteFail() {
	key := testutils.RandStr(5)
	compoundKeys := testutils.RandStringSlice(5)

	s.MockDynamoDBQueryByKeySuccess(key, compoundKeys)
	s.MockDynamoDBDeleteItemSuccess(len(compoundKeys) - 1)
	s.MockDynamoDBDeleteItemFail()

	err := s.Verifier.DeleteVerificationRequestsByKey(context.Background(), key)
	s.Require().Error(err)
	s.isError(AWSError, err)

	s.AssertExpectations()
}
