package storage

import "errors"

var (
	// ErrNeedDynamo is returned with a nil dynamodbiface.DynamoDBAPI is passed in
	// as the database.
	ErrNeedDynamo = errors.New("DynamoDB instance required")

	// ErrNeedTable is returned when attempting to create a new RegistryStore
	// with an empty table
	ErrNeedTable = errors.New("Empty table is invalid")

	// ErrNeedUserWrapper is returned when attempting to create a new Datasource
	// with a nil UserWrapper
	ErrNeedUserWrapper = errors.New("UserWrapper instance required")

	// ErrNeedNamespace is returned when a caller provides an empty namespace string
	ErrNeedNamespace = errors.New("Empty namespace is invalid")

	// ErrNeedKey is returned when a caller provides an empty key string
	ErrNeedKey = errors.New("Empty key is invalid")

	// ErrNeedEmail is returned when a caller provides an empty email string
	ErrNeedEmail = errors.New("Empty email is invalid")

	// ErrNeedOpaqueID is returned when a caller provides an empty opaque ID string
	ErrNeedOpaqueID = errors.New("Empty opaque ID is invalid")

	// ErrNeedVerificationCode is returned when a caller provides an empty verification code string
	ErrNeedVerificationCode = errors.New("Empty verification code is invalid")

	// ErrBadVerificationCode is returned when a caller provides an invalid verification code
	ErrBadVerificationCode = errors.New("Verification code is invalid")

	// ErrValidationAlreadySuccessful is returned when trying to regenerate the code for an already-verified contact.
	ErrValidationAlreadySuccessful = errors.New("Validation was already successful")

	// ErrValidationAlreadyRejected when trying to delete a request or regenerate the code for a contact that has been rejected.
	ErrValidationAlreadyRejected = errors.New("Validation has already been rejected")

	// ErrValidationNotRejected is returned when trying to unreject a validation that is not rejected.
	ErrValidationNotRejected = errors.New("Validation is not rejected")

	// ErrNeedVerificationCode is returned when a caller provides an invalid verification code and has exceeded the attempt limit
	ErrBadVerificationCodeMaxAttempts = errors.New("Verification code is invalid and will be regenerated")

	// ErrVerificationRequestWithoutCode is returned when trying to verify a code when none exists
	ErrVerificationRequestWithoutCode = errors.New("No existing verification code found")

	// ErrEmailNotFound is returned when the requested email
	// wasn't found in the database
	ErrEmailNotFound = errors.New("Email not found")

	// ErrValidationAlreadyExists is returned when attempting to create a new
	// email validation, but that email is already validated or rejected
	ErrValidationAlreadyExists = errors.New("Email validation result already exists")

	// ErrValidationNotFound is returned when the requested email validation
	// request wasn't found in the database
	ErrValidationNotFound = errors.New("Email validation request not found")

	// ErrMultipleValidationsFound is returned when a request that expected to find only
	// one validation request actually found more than one.
	ErrMultipleValidationsFound = errors.New("More than one validation request found")
)
